/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.Povrat;
import rs.petcom.master.dal.person.Person;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class PovratControllerTrgovina
implements ControlledScreen {
    ScreensController controller;
    rs.petcom.master.dal.Object sviObjekti = new rs.petcom.master.dal.Object(-1, "Svi objekti");
    Department svaOdeljenja = new Department(-1, "Sva odeljenja");
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private TableView<Povrat> table;
    @FXML
    private TableColumn<Povrat, Integer> tcBroj;
    @FXML
    private TableColumn<Povrat, Date> tcDate;
    @FXML
    private TableColumn<Povrat, Person> tcPerson;
    @FXML
    private TableColumn<Povrat, String> tcNapomena;
    @FXML
    private Button btnNew;
    @FXML
    private Button btnEdit;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnExport;
    @FXML
    private Button btnDelete;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbObject.getItems().add((Object)this.sviObjekti);
        for (rs.petcom.master.dal.Object o : rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((Object)o);
        }
        if (this.cbObject.getItems().size() == 2) {
            this.cbObject.getSelectionModel().select(1);
        } else {
            this.cbObject.getSelectionModel().select((Object)this.sviObjekti);
        }
        this.dpDateFrom.setValue((Object)LocalDate.now());
        this.dpDateTo.setValue((Object)LocalDate.now());
        this.loadDocumentList();
    }

    public void setParameter(Object parameter) {
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<rs.petcom.master.dal.Object>(){

            public void changed(ObservableValue<? extends rs.petcom.master.dal.Object> observable, rs.petcom.master.dal.Object oldValue, rs.petcom.master.dal.Object newValue) {
                PovratControllerTrgovina.this.loadDepartment();
            }
        });
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                PovratControllerTrgovina.this.loadDocumentList();
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Povrat>(){

            public void changed(ObservableValue<? extends Povrat> observable, Povrat oldValue, Povrat newValue) {
                if (newValue == null) {
                    PovratControllerTrgovina.this.btnDelete.setDisable(true);
                    PovratControllerTrgovina.this.btnPrint.setDisable(true);
                    PovratControllerTrgovina.this.btnEdit.setDisable(true);
                    PovratControllerTrgovina.this.btnExport.setDisable(true);
                } else {
                    PovratControllerTrgovina.this.btnDelete.setDisable(false);
                    PovratControllerTrgovina.this.btnPrint.setDisable(false);
                    PovratControllerTrgovina.this.btnEdit.setDisable(false);
                    PovratControllerTrgovina.this.btnExport.setDisable(false);
                }
            }
        });
        this.tcBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcPerson.setCellValueFactory((Callback)new PropertyValueFactory("dobavljac"));
        this.tcDate.setCellFactory(column -> new TableCell<Povrat, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcNapomena.setCellValueFactory((Callback)new PropertyValueFactory("Comment"));
    }

    @FXML
    public void actionNew(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        if (this.cbDepartment.getSelectionModel().getSelectedItem() != null) {
            Povrat povrat = new Povrat();
            povrat.setDocumentID(-1L);
            povrat.setNumber(Document.getNextNumber((int)9, (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (ScreensController)this.controller, (LocalDate)LocalDate.now()));
            povrat.setDobavljac(null);
            povrat.setDate(new Date());
            povrat.setDeliveryDate(new Date());
            povrat.setPaymentDate(new Date());
            povrat.setDepartmentID(((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
            povrat.setComment("");
            hm.put("povrat", povrat);
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            hm.put("object", this.cbObject.getSelectionModel().getSelectedItem());
            int result = this.controller.showModalDialog("Povrat - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_POVRAT_DETAILES_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocumentList();
            } else if (result == ScreensController.MODAL_RESULT_OK_NEW) {
                this.loadDocumentList();
                this.actionNew(event);
            }
        } else {
            this.controller.alert("Obave\u0161tenje", "Izaberite odeljenje", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionEdit(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("povrat", this.table.getSelectionModel().getSelectedItem());
            hm.put("object", this.cbObject.getSelectionModel().getSelectedItem());
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            int result = this.controller.showModalDialog("Povrat - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_POVRAT_DETAILES_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocumentList();
            } else if (result == ScreensController.MODAL_RESULT_OK_NEW) {
                this.loadDocumentList();
                this.actionNew(event);
            }
        }
    }

    @FXML
    public void actionPrint(ActionEvent event) {
        String reportFileName = "rs/petcom/backoffice/jasper/PrijemnicaTrgovinaNew.jasper";
        HashMap<String, Object> hm = new HashMap<String, Object>();
        Document document = Document.getByID((long)((Povrat)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        for (Images images : Images.getImagesList((ScreensController)this.controller)) {
            if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", rs.petcom.master.dal.Object.get((Connection)this.controller.getSettings().getConnection()));
        hm.put("person", Person.getByCode((String)"1", (Connection)this.controller.getSettings().getConnection()));
        hm.put("documentId", document.getDocumentID());
        hm.put("document", document);
        hm.put("prijemnica", false);
        hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
        hm.put("dobavljac", Person.getById((long)document.getPersonID(), (ScreensController)this.controller));
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Povrat", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        try {
            if (this.table.getSelectionModel().getSelectedItem() != null) {
                for (DocumentDetails dd : DocumentDetails.getList((long)((Povrat)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection())) {
                    dd.delete(this.controller.getSettings().getConnection());
                }
                ((Povrat)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
                this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
            }
        }
        catch (SQLException e) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("title", "Brisanje povratnice nije mogu\u0107e!");
            hm.put("text", "\nPoruka o gre\u0161ci:\n\n" + e.getLocalizedMessage());
            this.controller.showModalDialog("Brisanje povratnice nije mogu\u0107e!", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        }
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((rs.petcom.master.dal.Object)((rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((Object)d);
        }
        if (this.cbDepartment.getItems().size() == 1) {
            this.cbDepartment.getSelectionModel().select(0);
        }
    }

    @FXML
    private void loadDocumentList() {
        this.table.getItems().clear();
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
                this.table.setItems(Povrat.getList((Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue())), (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (ScreensController)this.controller));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    private void actionExport() {
        Povrat povrat = (Povrat)this.table.getSelectionModel().getSelectedItem();
        Department d = (Department)this.cbDepartment.getSelectionModel().getSelectedItem();
        povrat.setDepartmentID(d.getDepartmentID());
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Export Prijemnice");
        fileChooser.setInitialFileName("Prijemnica-" + d.getCode() + "-" + povrat.getNumber() + ".xml");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("XML files (*.xml)", new String[]{"*.xml"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            try {
                if (file.getAbsolutePath().toUpperCase().endsWith(".XML")) {
                    povrat.exportToXml(file.getAbsolutePath(), this.controller.getSettings().getConnection());
                } else {
                    povrat.exportToXml(file.getAbsolutePath() + ".xml", this.controller.getSettings().getConnection());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }
}

