/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import rs.petcom.backoffice.gui.AutoCompleteComboBoxListenerPopis;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Popis;
import rs.petcom.master.dal.document.PopisDetailes;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductGroup;
import rs.petcom.master.dal.product.ProductGroupDetaile;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class PopisRadniDetailesControllerTrgovina
implements DialogController {
    ScreensController controller;
    rs.petcom.master.dal.Object sviObjekti = new rs.petcom.master.dal.Object(-1, "Svi objekti");
    Department svaOdeljenja = new Department(-1, "Sva odeljenja");
    int modalResult;
    Popis p;
    PopisDetailes selectedPopisDetailes;
    Department department;
    AutoCompleteComboBoxListenerPopis<Product> cbProductAutoComplete;
    ObservableList<PopisDetailes> listPopisDetailes = FXCollections.observableArrayList();
    ObservableList<PopisDetailes> listaPrethodnihPopisa;
    ArrayList<Product> productList;
    ArrayList<PopisDetailes> deletePopisDetailes = new ArrayList();
    static int BROJ;
    @FXML
    private BorderPane rootPane;
    @FXML
    private GridPane gridPaneTop;
    @FXML
    private TextField tfQuantity;
    @FXML
    private DateTimePicker dpDateFrom;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private ComboBox<String> cbSabiranjeArtikla;
    @FXML
    private ComboBox<ProductGroup> cbVrstaSravnjenja;
    @FXML
    private TableView<PopisDetailes> table;
    @FXML
    private TableColumn<PopisDetailes, LocalDateTime> tcDate;
    @FXML
    private TableColumn<PopisDetailes, Long> tcBroj;
    @FXML
    private TableColumn<PopisDetailes, String> tcBarcode;
    @FXML
    private TableColumn<PopisDetailes, String> tcProductName;
    @FXML
    private TableColumn<PopisDetailes, Double> tcPocetnoStanje;
    @FXML
    private TableColumn<PopisDetailes, Double> tcUlazi;
    @FXML
    private TableColumn<PopisDetailes, Double> tcIzlazi;
    @FXML
    private TableColumn<PopisDetailes, Double> tcProdaja;
    @FXML
    private TableColumn<PopisDetailes, Double> tcStanje;
    @FXML
    private TableColumn<Object, Double> tcPopisanaKolicina;
    @FXML
    private TableColumn<PopisDetailes, Double> tcCena;
    @FXML
    private TableColumn<PopisDetailes, Double> tcRazlikaKol;
    @FXML
    private TableColumn<PopisDetailes, Double> tcRazlikaFin;
    @FXML
    private TableColumn<PopisDetailes, String> tcUser;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnClose;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAddInventory;

    public void setParameter(HashMap<String, Object> parameter) {
        this.p = (Popis)parameter.get("popis");
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.department = (Department)parameter.get("department");
        this.listaPrethodnihPopisa = (ObservableList)parameter.get("listaPrethodnihPopisa");
        this.dpDateFrom.setValue((Object)LocalDate.now());
        this.productList = Product.getListByDepartment((int)this.department.getDepartmentID(), (Connection)this.controller.getSettings().getConnection());
        this.cbProduct.setItems(FXCollections.observableArrayList(this.productList));
        this.cbProductAutoComplete = new AutoCompleteComboBoxListenerPopis(this.cbProduct, this.tfQuantity, ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE);
        PopisDetailes.createTempTable((Connection)this.controller.getSettings().getConnection());
        ((Stage)this.rootPane.getScene().getWindow()).setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                PopisDetailes.emptyTempTable((int)PopisRadniDetailesControllerTrgovina.this.department.getDepartmentID(), (int)21, (Connection)PopisRadniDetailesControllerTrgovina.this.controller.getSettings().getConnection());
            }
        });
        if (this.listaPrethodnihPopisa != null && this.listaPrethodnihPopisa.size() > 0) {
            try {
                for (PopisDetailes popisDetailes : this.listaPrethodnihPopisa) {
                    popisDetailes.refreshPopis(this.department, this.controller);
                    this.listPopisDetailes.add((Object)popisDetailes);
                }
            }
            catch (NullPointerException | SQLException e) {
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no \u010ditanje iz baze " + e.getMessage(), this.rootPane.getScene().getWindow());
            }
            this.refreshTable();
        }
        if (this.p.getDocumentID() > 0L) {
            this.listPopisDetailes = PopisDetailes.getlist((Popis)this.p, (ScreensController)this.controller);
            for (int i = 0; i < this.listPopisDetailes.size(); ++i) {
                try {
                    ((PopisDetailes)this.listPopisDetailes.get(i)).insertIntoTemp(21, this.controller.getSettings().getConnection());
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            this.refreshTable();
        }
        this.cbSabiranjeArtikla.setItems(FXCollections.observableArrayList((Object[])new String[]{"Sabiranje artikla: Ne", "Sabiranje artikla: Da"}));
        this.cbVrstaSravnjenja.setItems(ProductGroup.getList((int)2, (Connection)this.controller.getSettings().getConnection()));
        this.setFalseFocusTraversable();
        this.cbProduct.requestFocus();
    }

    public void initialize() {
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PopisDetailes>(){

            public void changed(ObservableValue<? extends PopisDetailes> observable, PopisDetailes oldValue, PopisDetailes newValue) {
                if (newValue == null) {
                    PopisRadniDetailesControllerTrgovina.this.btnDelete.setDisable(true);
                } else {
                    PopisRadniDetailesControllerTrgovina.this.btnDelete.setDisable(false);
                }
                PopisRadniDetailesControllerTrgovina.this.selectedPopisDetailes = (PopisDetailes)PopisRadniDetailesControllerTrgovina.this.table.getSelectionModel().getSelectedItem();
            }
        });
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(2, true);
        this.tcBroj.setCellValueFactory((Callback)new PropertyValueFactory("Broj"));
        this.tcBroj.setCellFactory(column -> new TableCell<PopisDetailes, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item + ".");
                }
            }
        });
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("dateTime"));
        Settings.makeHeaderWrappable(this.tcDate);
        this.tcDate.setCellFactory(column -> new TableCell<PopisDetailes, LocalDateTime>(){

            protected void updateItem(LocalDateTime item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.format(Settings.getLocalDateTimeFromatter()));
                }
            }
        });
        this.tcBarcode.setCellValueFactory((Callback)new PropertyValueFactory("Barcode"));
        Settings.makeHeaderWrappable(this.tcBarcode);
        this.tcProductName.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcPocetnoStanje.setCellValueFactory((Callback)new PropertyValueFactory("PocetnoStanje"));
        Settings.makeHeaderWrappable(this.tcPocetnoStanje);
        this.tcPocetnoStanje.setCellFactory(this.getCallBack(3));
        this.tcUlazi.setCellValueFactory((Callback)new PropertyValueFactory("Ulazi"));
        this.tcUlazi.setCellFactory(this.getCallBack(3));
        this.tcIzlazi.setCellValueFactory((Callback)new PropertyValueFactory("Izlazi"));
        this.tcIzlazi.setCellFactory(this.getCallBack(3));
        this.tcProdaja.setCellValueFactory((Callback)new PropertyValueFactory("Prodaja"));
        this.tcProdaja.setCellFactory(this.getCallBack(3));
        this.tcStanje.setCellValueFactory((Callback)new PropertyValueFactory("Stanje"));
        this.tcStanje.setCellFactory(this.getCallBack(3));
        this.tcPopisanaKolicina.setCellValueFactory((Callback)new PropertyValueFactory("PopisanaKolicina"));
        this.tcPopisanaKolicina.setCellFactory((Callback)cellFactory);
        Settings.makeHeaderWrappable(this.tcPopisanaKolicina);
        this.tcPopisanaKolicina.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                PopisDetailes pd = (PopisDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow());
                pd.setPopisanaKolicina(Double.parseDouble(t.getNewValue() + ""));
                pd.setRazlikaKolicina(pd.getPopisanaKolicina() - pd.getStanje());
                pd.setRazlikaFinansije(pd.getRazlikaKolicina() * pd.getCena());
                pd.updateTemp(PopisRadniDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                t.getTableColumn().getTableView().refresh();
            }
        });
        this.tcCena.setCellValueFactory((Callback)new PropertyValueFactory("Cena"));
        this.tcCena.setCellFactory(this.getCallBack(2));
        this.tcRazlikaKol.setCellValueFactory((Callback)new PropertyValueFactory("RazlikaKolicina"));
        this.tcRazlikaKol.setCellFactory(this.getCallBack(3));
        Settings.makeHeaderWrappable(this.tcRazlikaKol);
        this.tcRazlikaFin.setCellValueFactory((Callback)new PropertyValueFactory("RazlikaFinansije"));
        this.tcRazlikaFin.setCellFactory(this.getCallBack(2));
        Settings.makeHeaderWrappable(this.tcRazlikaFin);
        this.tfQuantity.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    event.consume();
                    PopisRadniDetailesControllerTrgovina.this.actionAddInventory();
                    PopisRadniDetailesControllerTrgovina.this.cbProduct.requestFocus();
                }
            }
        });
        this.tcUser.setCellValueFactory((Callback)new PropertyValueFactory("UserName"));
        Settings.makeHeaderWrappable(this.tcUser);
    }

    @FXML
    public void productGroupChange() {
        this.addProductGroup(((ProductGroup)this.cbVrstaSravnjenja.getSelectionModel().getSelectedItem()).getProductGroupID());
    }

    @FXML
    public void actionSave(ActionEvent event) {
        try {
            if (this.p.getDocumentID() > 0L) {
                this.p.update(21, this.controller);
                for (int j = 0; j < this.deletePopisDetailes.size(); ++j) {
                    if (this.deletePopisDetailes.get(j).getPopisDetailesID() <= 0L) continue;
                    this.deletePopisDetailes.get(j).delete(this.controller.getSettings().getConnection());
                }
                for (int i = 0; i < this.listPopisDetailes.size(); ++i) {
                    if (((PopisDetailes)this.listPopisDetailes.get(i)).getPopisDetailesID() > 0L) {
                        ((PopisDetailes)this.listPopisDetailes.get(i)).update(this.controller);
                        continue;
                    }
                    ((PopisDetailes)this.listPopisDetailes.get(i)).setDocumentID(this.p.getDocumentID());
                    ((PopisDetailes)this.listPopisDetailes.get(i)).insert(this.controller);
                }
            } else {
                this.p.insert(21, this.controller);
                for (PopisDetailes popisDetailes : this.listPopisDetailes) {
                    popisDetailes.setDocumentID(this.p.getDocumentID());
                    popisDetailes.insert(this.controller);
                }
            }
            PopisDetailes.emptyTempTable((int)this.department.getDepartmentID(), (int)21, (Connection)this.controller.getSettings().getConnection());
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
        catch (SQLException e) {
            this.controller.alert("Obavestenje", "Neuspe\u0161no dodavanje/a\u017euriranje popisa", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionAddInventory() {
        block7: {
            Product selectedProduct = null;
            int selectedProductIndexCB = this.cbProductAutoComplete.isItemSelected();
            if (selectedProductIndexCB >= 0) {
                selectedProduct = this.productList.get(selectedProductIndexCB);
                try {
                    selectedProduct.getCurrentPrice(1L, this.controller.getSettings().getConnection());
                    PopisDetailes popisDetailes = new PopisDetailes();
                    popisDetailes.setUserID(this.controller.getUser().getUserID());
                    popisDetailes.setDateTime(LocalDateTime.now());
                    popisDetailes.setDepartmentID(this.department.getDepartmentID());
                    popisDetailes.setProductID(selectedProduct.getProductID());
                    popisDetailes.setPopisanaKolicina(Double.parseDouble(this.tfQuantity.getText()));
                    popisDetailes.refreshPopis(this.department, this.controller);
                    if (this.cbSabiranjeArtikla.getSelectionModel().getSelectedIndex() <= 0) {
                        this.listPopisDetailes.add((Object)popisDetailes);
                        break block7;
                    }
                    if (this.cbSabiranjeArtikla.getSelectionModel().getSelectedIndex() != 1) break block7;
                    int index = -1;
                    for (int i = 0; i < this.listPopisDetailes.size(); ++i) {
                        if (((PopisDetailes)this.listPopisDetailes.get(i)).getProductID() != selectedProduct.getProductID()) continue;
                        index = i;
                    }
                    if (index < 0) {
                        this.listPopisDetailes.add((Object)popisDetailes);
                        popisDetailes.insertIntoTemp(21, this.controller.getSettings().getConnection());
                        break block7;
                    }
                    popisDetailes.setPopisanaKolicina(popisDetailes.getPopisanaKolicina() + ((PopisDetailes)this.listPopisDetailes.get(index)).getPopisanaKolicina());
                    popisDetailes.setDateTime(LocalDateTime.now());
                    popisDetailes.refreshPopis(this.department, this.controller);
                    this.listPopisDetailes.set(index, (Object)popisDetailes);
                    popisDetailes.updateTemp(this.controller.getSettings().getConnection());
                }
                catch (NumberFormatException | SQLException e) {
                    this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no dodavanje: " + e.getMessage(), this.rootPane.getScene().getWindow());
                }
            } else {
                this.controller.alert("Obave\u0161tenje", "Morate odabrati artikal.", this.rootPane.getScene().getWindow());
            }
        }
        this.refreshTable();
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            for (int i = 0; i < this.listPopisDetailes.size(); ++i) {
                if (((PopisDetailes)this.listPopisDetailes.get(i)).getBroj() != this.selectedPopisDetailes.getBroj()) continue;
                this.selectedPopisDetailes.deleteFromTemp(this.controller.getSettings().getConnection());
                this.deletePopisDetailes.add(this.selectedPopisDetailes);
                this.listPopisDetailes.remove(i);
            }
        }
        this.refreshTable();
    }

    @FXML
    public void actionClose(ActionEvent event) {
        PopisDetailes.emptyTempTable((int)this.department.getDepartmentID(), (int)21, (Connection)this.controller.getSettings().getConnection());
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void refreshTable() {
        this.tfQuantity.setText("");
        this.cbProduct.getSelectionModel().clearSelection();
        this.cbProduct.getEditor().setText("");
        BROJ = 1;
        for (int i = 0; i < this.listPopisDetailes.size(); ++i) {
            ((PopisDetailes)this.listPopisDetailes.get(i)).setBroj((long)BROJ++);
        }
        this.table.setItems(this.listPopisDetailes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FXML
    private void loadDocumentList() {
        this.table.getItems().clear();
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() <= 0) return;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void addProductGroup(int productGroupID) {
        for (Product product : ProductGroupDetaile.getProductList((int)productGroupID, (Connection)this.controller.getSettings().getConnection())) {
            try {
                product.getCurrentPrice(1L, this.controller.getSettings().getConnection());
                PopisDetailes popisDetailes = new PopisDetailes();
                popisDetailes.setUserID(this.controller.getUser().getUserID());
                popisDetailes.setDateTime(LocalDateTime.now());
                popisDetailes.setDepartmentID(this.department.getDepartmentID());
                popisDetailes.setProductID(product.getProductID());
                popisDetailes.setPopisanaKolicina(0.0);
                popisDetailes.refreshPopis(this.department, this.controller);
                if (this.cbSabiranjeArtikla.getSelectionModel().getSelectedIndex() <= 0) {
                    this.listPopisDetailes.add((Object)popisDetailes);
                } else if (this.cbSabiranjeArtikla.getSelectionModel().getSelectedIndex() == 1) {
                    int index = -1;
                    for (int i = 0; i < this.listPopisDetailes.size(); ++i) {
                        if (((PopisDetailes)this.listPopisDetailes.get(i)).getProductID() != product.getProductID()) continue;
                        index = i;
                    }
                    if (index < 0) {
                        this.listPopisDetailes.add((Object)popisDetailes);
                    } else {
                        popisDetailes.setPopisanaKolicina(popisDetailes.getPopisanaKolicina() + ((PopisDetailes)this.listPopisDetailes.get(index)).getPopisanaKolicina());
                        popisDetailes.setDateTime(LocalDateTime.now());
                        popisDetailes.refreshPopis(this.department, this.controller);
                        this.listPopisDetailes.set(index, (Object)popisDetailes);
                    }
                }
                popisDetailes.insertIntoTemp(21, this.controller.getSettings().getConnection());
            }
            catch (NumberFormatException | SQLException e) {
                this.controller.alert("Obavestenje", "Neuspesno dodavanje: " + e.getMessage(), this.rootPane.getScene().getWindow());
            }
        }
        this.refreshTable();
    }

    public Callback<TableColumn<PopisDetailes, Double>, TableCell<PopisDetailes, Double>> getCallBack(final int numberOfDigits) {
        return new Callback<TableColumn<PopisDetailes, Double>, TableCell<PopisDetailes, Double>>(){

            public TableCell<PopisDetailes, Double> call(TableColumn<PopisDetailes, Double> param) {
                return new TableCell<PopisDetailes, Double>(){

                    protected void updateItem(Double item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(Settings.getNumberFormat((int)numberOfDigits, (boolean)true).format(item));
                        }
                    }
                };
            }
        };
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void setFalseFocusTraversable() {
        this.dpDateFrom.setFocusTraversable(false);
        this.table.setFocusTraversable(false);
        this.btnDelete.setFocusTraversable(false);
        this.btnSave.setFocusTraversable(false);
        this.btnClose.setFocusTraversable(false);
        this.btnAddInventory.setFocusTraversable(false);
    }
}

