/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.CsvImport;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Popis;
import rs.petcom.master.dal.document.PopisDetailes;
import rs.petcom.master.dal.product.Product;

public class PopisDetailesControllerTrgovina
implements DialogController {
    ScreensController controller;
    int modalResult;
    LocalDate documentDate;
    Popis p;
    PopisDetailes selectedPopisDetailes;
    Department department;
    ObservableList<PopisDetailes> listPopisDetailes = FXCollections.observableArrayList();
    ObservableList<PopisDetailes> listaPrethodnihPopisa;
    ObservableList<Product> stockList = FXCollections.observableArrayList();
    ArrayList<Product> productList;
    ArrayList<PopisDetailes> deletePopisDetailes = new ArrayList();
    ObservableList<PopisDetailes> data;
    @FXML
    private GridPane gpContainer;
    @FXML
    private GridPane gridPaneTop;
    @FXML
    private ListView<Product> list;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfQuantityForTable;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfFilterTable;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private TableView<PopisDetailes> table;
    @FXML
    private TableColumn<PopisDetailes, String> tcBarcode;
    @FXML
    private TableColumn<PopisDetailes, String> tcProductName;
    @FXML
    private TableColumn<PopisDetailes, Double> tcStanje;
    @FXML
    private TableColumn<PopisDetailes, Double> tcCena;
    @FXML
    private TableColumn<PopisDetailes, Double> tcRazlikaKol;
    @FXML
    private TableColumn<PopisDetailes, Double> tcRazlikaFin;
    @FXML
    private TableColumn<PopisDetailes, Double> tcTotal;
    @FXML
    private TableColumn<Object, Double> tcPopisanaKolicina;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnClose;
    @FXML
    private Button btnDelete;
    @FXML
    private ComboBox<String> cbFilter;

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.documentDate = (LocalDate)parameter.get("documentDate");
        this.stockList = Product.getNewProductStockList((ScreensController)this.controller, (LocalDate)this.documentDate);
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.tcStanje.setVisible(true);
        this.tcRazlikaKol.setVisible(true);
        this.tcRazlikaFin.setVisible(true);
        this.department = (Department)parameter.get("department");
        this.p = (Popis)parameter.get("popis");
        if (this.p.getDocumentID() == -1L) {
            this.listaPrethodnihPopisa = (ObservableList)parameter.get("listaPrethodnihPopisa");
            this.setInitialDatePicker();
        } else {
            this.dpDateFrom.setValue((Object)Settings.fromDate((Date)this.p.getDate()));
            this.dpDateFrom.setEditable(false);
            this.dpDateFrom.setDisable(true);
            this.listaPrethodnihPopisa = PopisDetailes.getlist((Popis)this.p, (ScreensController)this.controller);
        }
        this.tfFilter.requestFocus();
        this.cbFilter.getItems().addAll((Object[])new String[]{ScreensController.FILTER_ALL, ScreensController.FILTER_CODE, ScreensController.FILTER_BARCODE, ScreensController.FILTER_NAZIV});
        this.cbFilter.getSelectionModel().selectFirst();
        this.tfFilter.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.DOWN & PopisDetailesControllerTrgovina.this.list != null && !PopisDetailesControllerTrgovina.this.list.getItems().isEmpty()) {
                    PopisDetailesControllerTrgovina.this.list.requestFocus();
                    PopisDetailesControllerTrgovina.this.list.getSelectionModel().select(0);
                }
                if (event.getCode() == KeyCode.ENTER) {
                    Product product = Product.getByBarcode((String)PopisDetailesControllerTrgovina.this.tfFilter.getText(), (Connection)PopisDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                    if (product == null) {
                        product = Product.getByCode((String)PopisDetailesControllerTrgovina.this.tfFilter.getText(), (Connection)PopisDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                    }
                    if (product == null) {
                        PopisDetailesControllerTrgovina.this.controller.alert("Obave\u0161tenje", "Artikal sa zadatim barkodom ili kodom nije pronadjen ", PopisDetailesControllerTrgovina.this.rootPane.getScene().getWindow());
                        PopisDetailesControllerTrgovina.this.tfFilter.setText("");
                    } else {
                        product.getCurrentPrice(1L, PopisDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                        PopisDetailes popisDetailes = new PopisDetailes();
                        popisDetailes.setUserID(PopisDetailesControllerTrgovina.this.controller.getUser().getUserID());
                        try {
                            popisDetailes.setDateTime(Settings.LocalDateTimefromDate((Date)WorkDay.getStartForDepByDate((int)PopisDetailesControllerTrgovina.this.department.getDepartmentID(), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)PopisDetailesControllerTrgovina.this.dpDateFrom.getValue())), (Connection)PopisDetailesControllerTrgovina.this.controller.getSettings().getConnection()).getDateFrom()));
                        }
                        catch (NullPointerException e) {
                            popisDetailes.setDateTime(Settings.LocalDateTimefromDate((Date)Settings.fromLocalDate((LocalDate)((LocalDate)PopisDetailesControllerTrgovina.this.dpDateFrom.getValue()))));
                        }
                        popisDetailes.setDepartmentID(PopisDetailesControllerTrgovina.this.department.getDepartmentID());
                        popisDetailes.setProductID(product.getProductID());
                        popisDetailes.setProductName(product.getName());
                        popisDetailes.setBarcode(product.getBarcodeLast());
                        popisDetailes.setStanje(PopisDetailesControllerTrgovina.this.getStock(product));
                        if (PopisDetailesControllerTrgovina.this.p.getDocumentID() > 0L || PopisDetailesControllerTrgovina.this.p.getDocumentID() == -1L) {
                            boolean dodaj = false;
                            for (PopisDetailes pdDetailes : PopisDetailesControllerTrgovina.this.table.getItems()) {
                                if (pdDetailes.getProductID() != product.getProductID()) continue;
                                dodaj = true;
                                PopisDetailesControllerTrgovina.this.table.getSelectionModel().select((Object)pdDetailes);
                                break;
                            }
                            if (!dodaj) {
                                PopisDetailesControllerTrgovina.this.listPopisDetailes.add((Object)popisDetailes);
                                PopisDetailesControllerTrgovina.this.table.setItems(PopisDetailesControllerTrgovina.this.listPopisDetailes);
                                PopisDetailesControllerTrgovina.this.table.getSelectionModel().select((Object)popisDetailes);
                            }
                        } else {
                            PopisDetailesControllerTrgovina.this.listPopisDetailes.add((Object)popisDetailes);
                            PopisDetailesControllerTrgovina.this.table.setItems(PopisDetailesControllerTrgovina.this.listPopisDetailes);
                            PopisDetailesControllerTrgovina.this.table.getSelectionModel().select((Object)popisDetailes);
                        }
                        PopisDetailesControllerTrgovina.this.tfQuantity.requestFocus();
                        popisDetailes.setPopisanaKolicina(0.0);
                        PopisDetailesControllerTrgovina.this.gpContainer.setVisible(false);
                    }
                }
            }
        });
        this.tfQuantity.setOnKeyPressed(keyValue -> {
            switch (keyValue.getCode()) {
                case UP: {
                    this.table.getSelectionModel().select(this.table.getSelectionModel().getSelectedIndex() - 1);
                    break;
                }
                case DOWN: {
                    this.table.getSelectionModel().select(this.table.getSelectionModel().getSelectedIndex() + 1);
                    break;
                }
                case ENTER: {
                    if (this.table.getSelectionModel().getSelectedItem() == null) break;
                    if (((PopisDetailes)this.table.getSelectionModel().getSelectedItem()).getPopisanaKolicina() == 0.0) {
                        this.editQuantity(this.tfQuantity.getText());
                        this.refreshTable();
                        this.refreshPopis(this.department);
                    } else {
                        double zbirnakol = ((PopisDetailes)this.table.getSelectionModel().getSelectedItem()).getPopisanaKolicina() + Double.parseDouble(this.tfQuantity.getText());
                        this.editQuantity(String.valueOf(zbirnakol));
                        this.refreshTable();
                        this.refreshPopis(this.department);
                    }
                    if (this.p.getDocumentID() < 0L || this.p.getDocumentID() == -1L) {
                        PopisDetailes pDetailes = PopisDetailes.getProductFromTempTable((Long)((PopisDetailes)this.table.getSelectionModel().getSelectedItem()).getProductID(), (ScreensController)this.controller);
                        if (pDetailes != null) {
                            double kolicina = 0.0;
                            for (PopisDetailes pp : this.table.getItems()) {
                                if (pDetailes.getProductID() != pp.getProductID()) continue;
                                kolicina += pp.getPopisanaKolicina();
                            }
                            pDetailes.setPopisanaKolicina(kolicina);
                            pDetailes.updateTemp(this.controller.getSettings().getConnection());
                        } else {
                            try {
                                ((PopisDetailes)this.table.getSelectionModel().getSelectedItem()).insertIntoTemp(5, this.controller.getSettings().getConnection());
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    this.tfQuantity.setText("");
                    this.tfFilter.setText("");
                    this.tfFilter.requestFocus();
                    break;
                }
            }
        });
        this.table.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER & PopisDetailesControllerTrgovina.this.table.getSelectionModel().getSelectedItem() != null) {
                    PopisDetailesControllerTrgovina.this.tfQuantity.setVisible(false);
                    PopisDetailesControllerTrgovina.this.tfQuantityForTable.setVisible(true);
                    PopisDetailesControllerTrgovina.this.tfQuantityForTable.requestFocus();
                }
            }
        });
        this.tfQuantityForTable.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                System.out.println("nemoj ovde please");
            }
        });
        if (this.listaPrethodnihPopisa != null && !this.listaPrethodnihPopisa.isEmpty()) {
            try {
                for (PopisDetailes popisDetailes : this.listaPrethodnihPopisa) {
                    popisDetailes.refreshPopis(this.department, this.controller);
                    this.listPopisDetailes.add((Object)popisDetailes);
                }
            }
            catch (NullPointerException | SQLException e) {
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no \u010ditanje iz baze " + e.getMessage(), this.rootPane.getScene().getWindow());
            }
            this.refreshTablePrethodni();
        }
        this.filter();
    }

    private ListView<Product> populateFilterList(String filterText) {
        this.gpContainer.getChildren().clear();
        this.list = new ListView();
        ObservableList listFromDb = Product.getListByDepartmentAndFilter((String)filterText, (int)this.department.getDepartmentID(), (String)((String)this.cbFilter.getSelectionModel().getSelectedItem()), (ScreensController)this.controller);
        if (listFromDb.isEmpty()) {
            this.gpContainer.setVisible(false);
            return this.list;
        }
        this.list.getItems().addAll((Collection)listFromDb);
        this.gpContainer.setVisible(true);
        this.list.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){
            MultipleSelectionModel<Product> selected;
            {
                this.selected = PopisDetailesControllerTrgovina.this.list.getSelectionModel();
            }

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    Product product = (Product)PopisDetailesControllerTrgovina.this.list.getSelectionModel().getSelectedItem();
                    product.getCurrentPrice(1L, PopisDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                    PopisDetailes popisDetailes = new PopisDetailes();
                    popisDetailes.setUserID(PopisDetailesControllerTrgovina.this.controller.getUser().getUserID());
                    try {
                        popisDetailes.setDateTime(Settings.LocalDateTimefromDate((Date)WorkDay.getStartForDepByDate((int)PopisDetailesControllerTrgovina.this.department.getDepartmentID(), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)PopisDetailesControllerTrgovina.this.dpDateFrom.getValue())), (Connection)PopisDetailesControllerTrgovina.this.controller.getSettings().getConnection()).getDateFrom()));
                    }
                    catch (NullPointerException e) {
                        popisDetailes.setDateTime(Settings.LocalDateTimefromDate((Date)Settings.fromLocalDate((LocalDate)((LocalDate)PopisDetailesControllerTrgovina.this.dpDateFrom.getValue()))));
                    }
                    popisDetailes.setDepartmentID(PopisDetailesControllerTrgovina.this.department.getDepartmentID());
                    popisDetailes.setProductID(product.getProductID());
                    if (PopisDetailesControllerTrgovina.this.p.getDocumentID() > 0L) {
                        boolean dodaj = false;
                        for (PopisDetailes pdDetailes : PopisDetailesControllerTrgovina.this.table.getItems()) {
                            if (pdDetailes.getProductID() != product.getProductID()) continue;
                            dodaj = true;
                            PopisDetailesControllerTrgovina.this.table.getSelectionModel().select((Object)pdDetailes);
                            break;
                        }
                        if (!dodaj) {
                            PopisDetailesControllerTrgovina.this.listPopisDetailes.add((Object)popisDetailes);
                            PopisDetailesControllerTrgovina.this.table.setItems(PopisDetailesControllerTrgovina.this.listPopisDetailes);
                            PopisDetailesControllerTrgovina.this.table.getSelectionModel().select((Object)popisDetailes);
                        }
                    } else {
                        PopisDetailesControllerTrgovina.this.listPopisDetailes.add((Object)popisDetailes);
                        PopisDetailesControllerTrgovina.this.table.setItems(PopisDetailesControllerTrgovina.this.listPopisDetailes);
                        PopisDetailesControllerTrgovina.this.table.getSelectionModel().select((Object)popisDetailes);
                    }
                    PopisDetailesControllerTrgovina.this.tfQuantity.requestFocus();
                    for (Product p : PopisDetailesControllerTrgovina.this.stockList) {
                        if (p.getProductID() != product.getProductID()) continue;
                        popisDetailes.setStanje(p.getStock());
                    }
                    popisDetailes.setPopisanaKolicina(0.0);
                    PopisDetailesControllerTrgovina.this.gpContainer.setVisible(false);
                    try {
                        popisDetailes.refreshPopis(PopisDetailesControllerTrgovina.this.department, PopisDetailesControllerTrgovina.this.controller);
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    if (event.getCode() == KeyCode.UP & this.selected.getSelectedIndex() == 0) {
                        PopisDetailesControllerTrgovina.this.tfFilter.requestFocus();
                    }
                    PopisDetailesControllerTrgovina.this.tfFilter.setText("");
                }
            }
        });
        return this.list;
    }

    private void editQuantity(String number) {
        try {
            ((PopisDetailes)this.table.getSelectionModel().getSelectedItem()).setPopisanaKolicina(Double.parseDouble(number));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            ((PopisDetailes)this.table.getSelectionModel().getSelectedItem()).setPopisanaKolicina(0.0);
        }
        this.table.refresh();
    }

    public void initialize() {
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PopisDetailes>(){

            public void changed(ObservableValue<? extends PopisDetailes> observable, PopisDetailes oldValue, PopisDetailes newValue) {
                if (newValue == null) {
                    PopisDetailesControllerTrgovina.this.btnDelete.setDisable(true);
                } else {
                    PopisDetailesControllerTrgovina.this.btnDelete.setDisable(false);
                }
                PopisDetailesControllerTrgovina.this.selectedPopisDetailes = (PopisDetailes)PopisDetailesControllerTrgovina.this.table.getSelectionModel().getSelectedItem();
            }
        });
        this.tcBarcode.setCellValueFactory((Callback)new PropertyValueFactory("Barcode"));
        this.tcProductName.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcStanje.setCellValueFactory((Callback)new PropertyValueFactory("Stanje"));
        this.tcPopisanaKolicina.setCellValueFactory((Callback)new PropertyValueFactory("PopisanaKolicina"));
        this.tcPopisanaKolicina.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                PopisDetailes pd = (PopisDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow());
                pd.setPopisanaKolicina(Double.parseDouble(t.getNewValue() + ""));
                pd.setRazlikaKolicina(pd.getPopisanaKolicina() - pd.getStanje());
                pd.setRazlikaFinansije(pd.getRazlikaKolicina() * pd.getCena());
                pd.updateTemp(PopisDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                t.getTableColumn().getTableView().refresh();
            }
        });
        this.tcCena.setCellValueFactory((Callback)new PropertyValueFactory("Cena"));
        this.tcCena.setCellFactory(this.getCallBack(2));
        this.tcRazlikaKol.setCellValueFactory((Callback)new PropertyValueFactory("RazlikaKolicina"));
        this.tcRazlikaFin.setCellValueFactory((Callback)new PropertyValueFactory("RazlikaFinansije"));
        this.tcRazlikaFin.setCellFactory(this.getCallBack(2));
        this.tcTotal.setCellValueFactory((Callback)new PropertyValueFactory("Total"));
        this.tcTotal.setCellFactory(this.getCallBack(2));
    }

    @FXML
    public void importAction() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import pocetno stanje");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje detalja u toku.", this.rootPane.getScene().getWindow());
            final ArrayList unexistedProducts = new ArrayList();
            Task<Void> loadingCsvTask = new Task<Void>(){

                protected Void call() throws Exception {
                    String line = "";
                    String[] colNames = null;
                    int colQuantity = -1;
                    int colBarcode = -1;
                    int counterRow = 0;
                    try {
                        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        while ((line = bf.readLine()) != null) {
                            colNames = line.split(";");
                            if (counterRow == 0) {
                                for (int i = 0; i < colNames.length; ++i) {
                                    for (CsvImport csvImport : CsvImport.getList((ScreensController)PopisDetailesControllerTrgovina.this.controller, (long)4L)) {
                                        if (csvImport.getCsvName().equals("Kolicina") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                            colQuantity = i;
                                        }
                                        if (!csvImport.getCsvName().equals("Bar Kod") || !colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) continue;
                                        colBarcode = i;
                                    }
                                }
                            } else {
                                Product product = Product.getByBarcode((String)colNames[colBarcode], (Connection)PopisDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                                if (product == null) {
                                    System.out.println(colNames[colBarcode] + ";" + colNames[colQuantity]);
                                    product = Product.getByID((long)Long.parseLong(colNames[colBarcode]), (ScreensController)PopisDetailesControllerTrgovina.this.controller);
                                }
                                if (product != null) {
                                    product.getCurrentPriceBeforeDatePrijemnica(Settings.fromLocalDate((LocalDate)((LocalDate)PopisDetailesControllerTrgovina.this.dpDateFrom.getValue())), 1L, PopisDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                                    PopisDetailes popisDetailes = new PopisDetailes();
                                    popisDetailes.setUserID(PopisDetailesControllerTrgovina.this.controller.getUser().getUserID());
                                    try {
                                        popisDetailes.setDateTime(Settings.LocalDateTimefromDate((Date)WorkDay.getStartForDepByDate((int)PopisDetailesControllerTrgovina.this.department.getDepartmentID(), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)PopisDetailesControllerTrgovina.this.dpDateFrom.getValue())), (Connection)PopisDetailesControllerTrgovina.this.controller.getSettings().getConnection()).getDateFrom()));
                                    }
                                    catch (NullPointerException e) {
                                        popisDetailes.setDateTime(Settings.LocalDateTimefromDate((Date)Settings.fromLocalDate((LocalDate)((LocalDate)PopisDetailesControllerTrgovina.this.dpDateFrom.getValue()))));
                                    }
                                    popisDetailes.setDepartmentID(PopisDetailesControllerTrgovina.this.department.getDepartmentID());
                                    popisDetailes.setProductID(product.getProductID());
                                    popisDetailes.setStanje(PopisDetailesControllerTrgovina.this.getStock(product));
                                    try {
                                        popisDetailes.setPopisanaKolicina(Double.parseDouble(colNames[colQuantity]));
                                        try {
                                            popisDetailes.refreshPopis(PopisDetailesControllerTrgovina.this.department, PopisDetailesControllerTrgovina.this.controller);
                                        }
                                        catch (SQLException ex) {
                                            ex.printStackTrace();
                                        }
                                        PopisDetailesControllerTrgovina.this.listPopisDetailes.add((Object)popisDetailes);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                } else {
                                    System.out.println();
                                    unexistedProducts.add(colNames[colBarcode] + " " + counterRow);
                                }
                            }
                            ++counterRow;
                        }
                        bf.close();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            loadingCsvTask.setOnSucceeded(eventValue -> {
                taskUpdateStage.hide();
                this.table.setItems(this.listPopisDetailes);
                if (unexistedProducts.size() > 0) {
                    this.controller.alert("Nepostoje\u0107i artikli", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
                }
            });
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        }
    }

    @FXML
    public void actionSave(ActionEvent event) {
        try {
            if (this.p.getDocumentID() > 0L) {
                this.p.update(5, this.controller);
                for (int j = 0; j < this.deletePopisDetailes.size(); ++j) {
                    if (this.deletePopisDetailes.get(j).getPopisDetailesID() <= 0L) continue;
                    this.deletePopisDetailes.get(j).delete(this.controller.getSettings().getConnection());
                }
                for (int i = 0; i < this.table.getItems().size(); ++i) {
                    if (((PopisDetailes)this.table.getItems().get(i)).getPopisDetailesID() > 0L) {
                        ((PopisDetailes)this.table.getItems().get(i)).update(this.controller);
                        continue;
                    }
                    ((PopisDetailes)this.table.getItems().get(i)).setDocumentID(this.p.getDocumentID());
                    ((PopisDetailes)this.table.getItems().get(i)).insert(this.controller);
                }
            } else {
                try {
                    this.p.setDate(WorkDay.getFromDbByDate((LocalDate)((LocalDate)this.dpDateFrom.getValue()), (Connection)this.controller.getSettings().getConnection()).getDate());
                }
                catch (NullPointerException e) {
                    this.p.setDate(new Date());
                }
                this.p.insert(5, this.controller);
                ObservableList listTempTable = PopisDetailes.getListFromTempTable((int)this.department.getDepartmentID(), (boolean)true, (ScreensController)this.controller);
                if (listTempTable.isEmpty()) {
                    for (PopisDetailes popisDetailes : this.table.getItems()) {
                        popisDetailes.setDocumentID(this.p.getDocumentID());
                        popisDetailes.insert(this.controller);
                    }
                } else {
                    for (PopisDetailes popisDetailes : listTempTable) {
                        popisDetailes.setDocumentID(this.p.getDocumentID());
                        popisDetailes.insert(this.controller);
                    }
                }
            }
            PopisDetailes.emptyTempTable((int)this.department.getDepartmentID(), (int)5, (Connection)this.controller.getSettings().getConnection());
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
        catch (SQLException e) {
            this.controller.alert("Obavestenje", "Neuspesno dodavanje/azuriranje popisa", this.rootPane.getScene().getWindow());
            Log.writeLog((User)this.controller.getUser(), (String)"Neuspe\u0161an unos popisa", (Connection)this.controller.getSettings().getConnection());
        }
        PopisDetailes.dropTempTable((Connection)this.controller.getSettings().getConnection());
        Log.writeLog((User)this.controller.getUser(), (String)"Sa\u010duvano popis", (Connection)this.controller.getSettings().getConnection());
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            for (int i = 0; i < this.listPopisDetailes.size(); ++i) {
                if (((PopisDetailes)this.listPopisDetailes.get(i)).getProductID() != this.selectedPopisDetailes.getProductID()) continue;
                this.selectedPopisDetailes.deleteFromTemp(this.controller.getSettings().getConnection());
                this.deletePopisDetailes.add(this.selectedPopisDetailes);
                this.listPopisDetailes.remove(i);
            }
        }
        this.refreshTable();
        Log.writeLog((User)this.controller.getUser(), (String)"Obrisana stavka", (Connection)this.controller.getSettings().getConnection());
    }

    @FXML
    public void actionClose(ActionEvent event) {
        PopisDetailes.emptyTempTable((int)this.department.getDepartmentID(), (int)5, (Connection)this.controller.getSettings().getConnection());
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void actionCloseWithSave() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void actionNewProduct() {
        HashMap<String, ScreensController> hm2 = new HashMap<String, ScreensController>();
        hm2.put("controller", this.controller);
        this.controller.showModalDialog("Dodavanje artikla", ScreensController.DIALOG_BACKOFFICE_ADD_PRODUCT, hm2, this.rootPane.getScene().getWindow());
    }

    private void refreshTable() {
        this.tfQuantity.setText("");
        this.table.refresh();
    }

    private void refreshTablePrethodni() {
        this.table.setItems(this.listPopisDetailes);
    }

    private void refreshPopis(Department department) {
        try {
            for (int i = 0; i < this.table.getItems().size(); ++i) {
                try {
                    ((PopisDetailes)this.table.getItems().get(i)).setDateTime(Settings.LocalDateTimefromDate((Date)WorkDay.getStartForDepByDate((int)department.getDepartmentID(), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())), (Connection)this.controller.getSettings().getConnection()).getDateFrom()));
                }
                catch (NullPointerException e) {
                    ((PopisDetailes)this.table.getItems().get(i)).setDateTime(Settings.LocalDateTimefromDate((Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue()))));
                }
                ((PopisDetailes)this.table.getItems().get(i)).refreshPopis(department, this.controller);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.table.refresh();
    }

    public Callback<TableColumn<PopisDetailes, Double>, TableCell<PopisDetailes, Double>> getCallBack(final int numberOfDigits) {
        return new Callback<TableColumn<PopisDetailes, Double>, TableCell<PopisDetailes, Double>>(){

            public TableCell<PopisDetailes, Double> call(TableColumn<PopisDetailes, Double> param) {
                return new TableCell<PopisDetailes, Double>(){

                    protected void updateItem(Double item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(Settings.getNumberFormat((int)numberOfDigits, (boolean)true).format(item));
                        }
                    }
                };
            }
        };
    }

    private void filter() {
        this.data = this.table.getItems();
        FilteredList filteredData = new FilteredList(this.data, p -> true);
        this.tfFilterTable.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(opd -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            if (opd.getBarcode().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return opd.getProductName().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
        this.table.setItems((ObservableList)sortedData);
    }

    private void setInitialDatePicker() {
        this.dpDateFrom.setValue((Object)this.documentDate);
        this.dpDateFrom.setEditable(false);
        this.dpDateFrom.setDisable(true);
    }

    private double getStock(Product product) {
        for (Product p : this.stockList) {
            if (p.getProductID() != product.getProductID()) continue;
            return p.getStock();
        }
        return 0.0;
    }
}

