/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.Popis;
import rs.petcom.master.dal.document.PopisDetailes;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.product.Product;
import rs.petcom.print.JRPrintPreviewPane;

public class PopisControllerTrgovina
implements ControlledScreen {
    ScreensController controller;
    Object sviObjekti = new Object(-1, "Svi objekti");
    Department svaOdeljenja = new Department(-1, "Sva odeljenja");
    Popis selectedPopis;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private TableView<Popis> table;
    @FXML
    private TableColumn<Popis, Integer> tcBroj;
    @FXML
    private TableColumn<Popis, Date> tcDate;
    @FXML
    private TableColumn<Popis, String> tcNapomena;
    @FXML
    private Button btnNew;
    @FXML
    private Button btnEdit;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnSravnjenje;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnPocetnoStanje;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbObject.getItems().add((java.lang.Object)this.sviObjekti);
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((java.lang.Object)o);
        }
        if (this.cbObject.getItems().size() == 2) {
            this.cbObject.getSelectionModel().select(1);
        } else {
            this.cbObject.getSelectionModel().select((java.lang.Object)this.sviObjekti);
        }
        this.dpDateFrom.setValue((java.lang.Object)Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDate()));
        this.dpDateTo.setValue((java.lang.Object)Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDate()));
        this.loadDocumentList();
    }

    public void setParameter(java.lang.Object parameter) {
        this.btnPocetnoStanje.setDisable(false);
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                PopisControllerTrgovina.this.loadDepartment();
            }
        });
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                PopisControllerTrgovina.this.loadDocumentList();
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Popis>(){

            public void changed(ObservableValue<? extends Popis> observable, Popis oldValue, Popis newValue) {
                if (newValue == null) {
                    PopisControllerTrgovina.this.btnDelete.setDisable(true);
                    PopisControllerTrgovina.this.btnEdit.setDisable(true);
                    PopisControllerTrgovina.this.btnSravnjenje.setDisable(true);
                    PopisControllerTrgovina.this.btnPrint.setDisable(true);
                    PopisControllerTrgovina.this.btnPocetnoStanje.setDisable(true);
                } else {
                    PopisControllerTrgovina.this.btnPrint.setDisable(false);
                    PopisControllerTrgovina.this.btnSravnjenje.setDisable(false);
                    PopisControllerTrgovina.this.btnDelete.setDisable(false);
                    PopisControllerTrgovina.this.btnEdit.setDisable(false);
                    PopisControllerTrgovina.this.btnPocetnoStanje.setDisable(false);
                }
                PopisControllerTrgovina.this.selectedPopis = newValue;
            }
        });
        this.tcBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDate.setCellFactory(column -> new TableCell<Popis, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcNapomena.setCellValueFactory((Callback)new PropertyValueFactory("Note"));
    }

    @FXML
    public void actionNew(ActionEvent event) {
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("controller", this.controller);
        hm.put("title", "Prethodni popis");
        hm.put("text", "Da li \u017eelite da nastavite od prethodnog puta?");
        PopisDetailes.createTempTable((Connection)this.controller.getSettings().getConnection());
        ((Stage)this.rootPane.getScene().getWindow()).setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
            }
        });
        ObservableList listaPrethodnihPopisa = null;
        try {
            listaPrethodnihPopisa = PopisDetailes.getListFromTempTable((int)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), (boolean)false, (ScreensController)this.controller);
            if (listaPrethodnihPopisa.size() > 0) {
                int resultPopis = this.controller.showModalDialog("Prethodni popis naglo prekinut.", ScreensController.DIALOG_YES_NO, hm, this.rootPane.getScene().getWindow());
                if (resultPopis == ScreensController.MODAL_RESULT_YES) {
                    hm.put("listaPrethodnihPopisa", listaPrethodnihPopisa);
                } else {
                    PopisDetailes.emptyTempTable((int)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), (int)5, (Connection)this.controller.getSettings().getConnection());
                }
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        catch (NullPointerException e) {
            this.controller.alert("Obavestenje", "Morate odaberati odeljenje:" + e.getMessage(), this.rootPane.getScene().getWindow());
            e.printStackTrace();
        }
        try {
            Popis p = new Popis();
            p.setDocumentID(-1L);
            p.setNumber(Document.getNextNumber((int)5, (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (ScreensController)this.controller, (LocalDate)((LocalDate)this.dpDateFrom.getValue())));
            p.setDepartmentID(((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
            hm.put("popis", p);
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            hm.put("object", this.cbObject.getSelectionModel().getSelectedItem());
            hm.put("message", "Izaberite datum na koji zelite da unesete dokument");
            int res = this.controller.showModalDialog("Izbor datuma popisa", ScreensController.SCREEN_BACKOFFICE_FIXED_DATE, hm, this.rootPane.getScene().getWindow());
            if (res == ScreensController.MODAL_RESULT_CANCEL) {
                return;
            }
            int result = this.controller.showModalDialog("Popis - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_POPIS_DETAILES, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                Log.writeLog((User)this.controller.getUser(), (String)"Unos novog popisa", (Connection)this.controller.getSettings().getConnection());
                this.loadDocumentList();
            }
        }
        catch (NullPointerException e) {
            this.controller.alert("Obavestenje", "Morate odaberati odeljenje:" + e.getMessage(), this.rootPane.getScene().getWindow());
            e.printStackTrace();
        }
    }

    @FXML
    public void actionEdit(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            hm.put("popis", this.table.getSelectionModel().getSelectedItem());
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            LocalDate documentDate = Settings.fromDate((Date)((Popis)this.table.getSelectionModel().getSelectedItem()).getDate());
            hm.put("documentDate", documentDate);
            int result = this.controller.showModalDialog("Popis - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_POPIS_DETAILES, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocumentList();
            } else if (result == ScreensController.MODAL_RESULT_OK_NEW) {
                Log.writeLog((User)this.controller.getUser(), (String)"Izmena popisa", (Connection)this.controller.getSettings().getConnection());
                this.loadDocumentList();
                this.actionNew(event);
            }
        }
    }

    @FXML
    public void actionPocetnoStanje(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            ObservableList list = DocumentDetails.getObeservableList((long)((Popis)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
            this.selectedPopis.setNote("Pocetno stanje po popisu");
            this.selectedPopis.update(11, this.controller);
            for (Product product : Product.getPocetnoStanjeList((ScreensController)this.controller)) {
                for (DocumentDetails documentDetails : list) {
                    if (product.getProductID() == documentDetails.getProductID()) continue;
                }
            }
            Log.writeLog((User)this.controller.getUser(), (String)"Kreirano po\u010detno stanje od popisa", (Connection)this.controller.getSettings().getConnection());
        }
        this.table.getSelectionModel().clearSelection();
        this.loadDocumentList();
    }

    @FXML
    public void actionSravnjenje(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            try {
                Document dSravnjenje = Document.getByID((long)((Popis)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
                dSravnjenje.setDocumentTypeID(16);
                dSravnjenje.update(this.controller);
                ObservableList popisDetailes = DocumentDetails.getObeservableList((long)dSravnjenje.getDocumentID(), (Connection)this.controller.getSettings().getConnection());
                for (DocumentDetails pDetailes : popisDetailes) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(dSravnjenje.getDate());
                    cal.add(12, -5);
                    Date oneMinuteBack = cal.getTime();
                    double newStock = pDetailes.getQuantity() - Product.getNewReceivingReportByProductId((String)String.valueOf(pDetailes.getProductID()), (ScreensController)this.controller, (int)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), (LocalDate)Settings.fromDate((Date)oneMinuteBack));
                    pDetailes.setQuantity(newStock);
                    pDetailes.update(this.controller);
                }
                this.controller.alert("Obave\u0161tenje", "Uspe\u0161no sravnjenje", this.rootPane.getScene().getWindow());
            }
            catch (SQLException e) {
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no sravnjenje: " + e.getMessage(), this.rootPane.getScene().getWindow());
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        try {
            System.out.println(((Popis)this.table.getSelectionModel().getSelectedItem()).getDocumentID());
            ((Popis)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
            Log.writeLog((User)this.controller.getUser(), (String)"Brisanje popisa", (Connection)this.controller.getSettings().getConnection());
            this.loadDocumentList();
        }
        catch (SQLException e) {
            e.printStackTrace();
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("title", "Brisanje popisa nije mogu\u0107e!");
            hm.put("text", "\nPoruka o gre\u0161ci:\n\n" + e.getLocalizedMessage());
            this.controller.showModalDialog("Brisanje popisa nije mogu\u0107e!", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionPrint(ActionEvent event) {
        int result = this.controller.yesNoDialog("Pitanje", "Da li zelite samo osnovni popis?", this.rootPane.getScene().getWindow());
        String reportFileName = result == 1 ? "rs/petcom/backoffice/jasper/PopisOsnovni.jasper" : "rs/petcom/backoffice/jasper/Popis.jasper";
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList((ScreensController)this.controller)) {
            if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("address", Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()));
        hm.put("objekat", Object.get((Connection)this.controller.getSettings().getConnection()));
        Document document = Document.getByID((long)((Popis)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        hm.put("documentId", document.getDocumentID());
        hm.put("document", document);
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPane printViewPane = new JRPrintPreviewPane(jprint);
            printViewPane.setController(this.controller);
            HashMap<String, JRPrintPreviewPane> hm2 = new HashMap<String, JRPrintPreviewPane>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Popis", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void actionPraznaLista() {
        String reportFileName = "rs/petcom/backoffice/jasper/PopisPraznaLista.jasper";
        HashMap<String, BufferedImage> hm = new HashMap<String, BufferedImage>();
        for (Images images : Images.getImagesList((ScreensController)this.controller)) {
            if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (!images.getName().equals("memorandum")) continue;
                try {
                    hm.put("memorandum", ImageIO.read(images.getImage()));
                    hm.put("logo", null);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", (BufferedImage)Object.get((Connection)this.controller.getSettings().getConnection()));
        hm.put("address", (BufferedImage)Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()));
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPane printViewPane = new JRPrintPreviewPane(jprint);
            printViewPane.setController(this.controller);
            HashMap<String, JRPrintPreviewPane> hm2 = new HashMap<String, JRPrintPreviewPane>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Popis prazna lista", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void actionExcel() {
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((Object)((Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)d);
        }
        if (this.cbDepartment.getItems().size() == 1) {
            this.cbDepartment.getSelectionModel().select(0);
        }
    }

    @FXML
    private void loadDocumentList() {
        this.table.getItems().clear();
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
                this.table.setItems(Popis.getList((Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue())), (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (int)5, (Connection)this.controller.getSettings().getConnection()));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

