/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.backoffice.gui.ComboBoxCellFactory;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.CsvImport;
import rs.petcom.master.dal.CsvImportType;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.Otpis;
import rs.petcom.master.dal.document.OtpisDetailes;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class OtpisDetailesControllerTrgovina
implements DialogController {
    ScreensController controller;
    Otpis otpis;
    int modalResult;
    ArrayList<OtpisDetailes> deletedItems;
    ObservableList<OtpisDetailes> otpisDetailsList;
    ArrayList<Product> productList;
    Object objekat;
    Department department;
    AutoCompleteCBWithoutProducts<Product> cbProductAutoComplete;
    Product selectedProduct;
    OtpisDetailes od;
    ComboBoxCellFactory cbCellFactory;
    CsvImportType csvImportType;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfSellPrice;
    @FXML
    private TextField tfPlace;
    @FXML
    private TextField tfNumber;
    @FXML
    private TextField tfFilter;
    @FXML
    private DateTimePicker dpDate;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private ComboBox<String> cbFilter;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnRemove;
    @FXML
    private Button btnSacuvaj;
    @FXML
    private Button btnOdustani;
    @FXML
    private Button btnImportXml;
    @FXML
    private Button btnSacuvajNovo;
    @FXML
    private Button btnNoviProizvod;
    @FXML
    private TextArea tfNapomena;
    @FXML
    private TableView<OtpisDetailes> tableOtpisDetails;
    @FXML
    private TableColumn<java.lang.Object, Product> tcProduct;
    @FXML
    private TableColumn<java.lang.Object, Double> tcQuantity;
    @FXML
    private TableColumn<java.lang.Object, Double> tcPriceWithoutVatAndDiscount;
    @FXML
    private TableColumn<java.lang.Object, Double> tcPriceWithVatAndDiscount;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumWithoutPDV;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumWithPDV;
    @FXML
    private TableColumn<java.lang.Object, Double> tcCurrentPriceSumWithoutPDV;
    @FXML
    private TableColumn<java.lang.Object, Double> tcCurrentPriceSumWithPDV;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSellPrice;

    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        this.deletedItems = new ArrayList();
        this.btnRemove.setDisable(false);
        this.controller = (ScreensController)parameter.get("controller");
        this.lastDocumentLockDate = (LocalDate)parameter.get("lastDocumentLockDate");
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.csvImportType = (CsvImportType)parameter.get("csvImportType");
        this.cbFilter.getItems().addAll((java.lang.Object[])new String[]{ScreensController.FILTER_ALL, ScreensController.FILTER_CODE, ScreensController.FILTER_BARCODE});
        this.cbFilter.getSelectionModel().selectFirst();
        this.cbFilter.setOnAction(actionEvent -> {
            this.cbProductAutoComplete.setFilterType((String)this.cbFilter.getSelectionModel().getSelectedItem());
            this.cbCellFactory.setFilterType((String)this.cbFilter.getSelectionModel().getSelectedItem());
        });
        this.objekat = (Object)parameter.get("object");
        this.department = (Department)parameter.get("department");
        this.otpis = (Otpis)parameter.get("otpis");
        this.dpDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.otpis.getDate()));
        this.dpDate.valueProperty().addListener((observable, oldDate, newDate) -> {
            if (this.documentLockIsActive && (newDate.isEqual(this.lastDocumentLockDate) || newDate.isBefore(this.lastDocumentLockDate))) {
                this.dpDate.setValue((java.lang.Object)this.lastDocumentLockDate.plusDays(1L));
                this.controller.alert("Upozorenje", "Ne mo\u017eete izabrati datum za koji su zaklju\u010dani dokumenti ", this.rootPane.getScene().getWindow());
            }
            this.tfNumber.setText(String.valueOf(Document.getNextNumber((int)7, (Department)this.department, (ScreensController)this.controller, (LocalDate)((LocalDate)this.dpDate.getValue()))));
        });
        this.tfNapomena.setText(this.otpis.getComment());
        this.tfPlace.setText(this.objekat.getName());
        this.tfNumber.setText("" + this.otpis.getNumber());
        if (this.otpis.getDocumentID() > 0L && LocalDateTime.now().getDayOfYear() > Settings.LocalDateTimefromDate((Date)this.otpis.getDate()).getDayOfYear()) {
            this.tcSellPrice.setEditable(false);
        }
        this.od = new OtpisDetailes();
        this.productList = new ArrayList();
        this.cbCellFactory = new ComboBoxCellFactory((ObservableList<Product>)FXCollections.observableArrayList(this.productList), this.controller, this.department, ScreensController.FILTER_ALL);
        this.tcProduct.setCellValueFactory((Callback)new PropertyValueFactory("product"));
        this.tcProduct.setCellFactory((Callback)this.cbCellFactory);
        this.tcProduct.setOnEditCommit(cellEditEvent -> {
            Product selectedTableProduct = (Product)cellEditEvent.getNewValue();
            OtpisDetailes selectedTableOtpis = (OtpisDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTableProduct.getCurrentPrice((long)this.department.getDepartmentID(), this.controller.getSettings().getConnection());
            selectedTableProduct.getNabavnaCenaOtpis(this.controller.getSettings().getConnection());
            selectedTableOtpis.setProduct(selectedTableProduct);
            selectedTableOtpis.setVat(selectedTableProduct.getVatValue3());
            selectedTableOtpis.setPurchasePriceWithoutVat(selectedTableProduct.getNabavnaCena());
            selectedTableOtpis.setPurchasePriceWithVat(selectedTableProduct.getNabavnaCena() + selectedTableProduct.getNabavnaCena() * selectedTableProduct.getVatValue3());
            try {
                selectedTableOtpis.setQuantity(Double.parseDouble(this.tfQuantity.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            selectedTableOtpis.setPurchasePriceWithoutVatSum(selectedTableOtpis.getQuantity() * selectedTableOtpis.getPurchasePriceWithoutVat());
            selectedTableOtpis.setPurchasePriceWithVatSum(selectedTableOtpis.getQuantity() * selectedTableOtpis.getPurchasePriceWithVat());
            selectedTableOtpis.setCurrentPrice(selectedTableProduct.getPrice());
            selectedTableOtpis.setCurrentPriceSumWithoutPDV(selectedTableOtpis.getQuantity() * (selectedTableProduct.getPrice() - selectedTableProduct.getPrice() * selectedTableProduct.getVatValue3()));
            selectedTableOtpis.setCurrentPriceSumWithPDV(selectedTableOtpis.getQuantity() * selectedTableProduct.getPrice());
            cellEditEvent.getTableColumn().getTableView().refresh();
        });
        this.cbProduct.valueProperty().addListener((ov, oldValue, newValue) -> {
            this.selectedProduct = (Product)this.cbProduct.getSelectionModel().getSelectedItem();
            try {
                this.selectedProduct.getCurrentPrice((long)this.department.getDepartmentID(), this.controller.getSettings().getConnection());
                this.selectedProduct.getNabavnaCenaOtpis(this.controller.getSettings().getConnection());
                this.od.setProduct(this.selectedProduct);
                this.od.setVat(this.selectedProduct.getVatValue3());
                this.od.setPurchasePriceWithVat(this.selectedProduct.getNabavnaCena());
                this.od.setPurchasePriceWithoutVat(this.round2Decimals(this.selectedProduct.getNabavnaCenaBezPopusta()));
                try {
                    this.od.setQuantity(Double.parseDouble(this.tfQuantity.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.selectedProduct.getPrice()));
                this.od.setPurchasePriceWithoutVatSum(this.round2Decimals(this.od.getQuantity() * this.od.getPurchasePriceWithoutVat()));
                this.od.setPurchasePriceWithVatSum(this.round2Decimals(this.od.getQuantity() * this.od.getPurchasePriceWithVat()));
                this.od.setCurrentPrice(this.selectedProduct.getPrice());
                this.od.setCurrentPriceSumWithoutPDV(this.round2Decimals(this.od.getQuantity() * (this.selectedProduct.getPrice() - this.selectedProduct.getPrice() * this.od.getVat())));
                this.od.setCurrentPriceSumWithPDV(this.od.getQuantity() * this.selectedProduct.getPrice());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.cbProductAutoComplete = new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, this.department.getDepartmentID(), ScreensController.FILTER_ALL, this.tfQuantity);
        this.otpisDetailsList = OtpisDetailes.getlist((Otpis)this.otpis, (ScreensController)this.controller);
        for (OtpisDetailes otpisDetailes : this.otpisDetailsList) {
            this.tableOtpisDetails.getItems().add((java.lang.Object)otpisDetailes);
        }
        this.tfQuantity.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfQuantity.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfQuantity.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && OtpisDetailesControllerTrgovina.this.tfQuantity.getText().equals("")) {
                    event.consume();
                    OtpisDetailesControllerTrgovina.this.cbProduct.requestFocus();
                }
            }
        });
        this.tfQuantity.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                this.tfQuantity.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.od.getQuantity()) + "");
            }
        });
        this.tfQuantity.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.length() > 0) {
                    if (newValue.substring(newValue.length() - 1).equals(".")) {
                        this.tfQuantity.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                    }
                    if (this.tfQuantity.isFocused()) {
                        this.od.setQuantity(Settings.getNumberFormat((int)8, (boolean)true).parse((String)newValue).doubleValue());
                    }
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfSellPrice.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfSellPrice.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfSellPrice.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
                if (this.tfSellPrice.isFocused()) {
                    this.od.setCurrentPrice(Settings.getNumberFormat((int)2, (boolean)true).parse((String)newValue).doubleValue());
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfSellPrice.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.od.getCurrentPrice()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfSellPrice.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.TAB)) {
                this.cbProduct.requestFocus();
                this.actionAddOtpisDetails(null);
                keyEvent.consume();
            }
        });
        this.deletedItems.clear();
        this.tfNapomena.setText(this.otpis.getComment());
        this.tfNapomena.setFocusTraversable(false);
        this.btnSacuvaj.setFocusTraversable(false);
        this.dpDate.setFocusTraversable(false);
        this.btnOdustani.setFocusTraversable(false);
        this.btnAdd.setFocusTraversable(false);
        this.btnRemove.setFocusTraversable(false);
        this.btnImportXml.setFocusTraversable(false);
        this.btnSacuvajNovo.setFocusTraversable(false);
        this.btnNoviProizvod.setFocusTraversable(false);
        this.tableOtpisDetails.setFocusTraversable(false);
    }

    public HashMap<String, java.lang.Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        Platform.runLater(() -> this.btnSacuvaj.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnSacuvaj.fire()));
        Platform.runLater(() -> this.btnSacuvajNovo.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnSacuvajNovo.fire()));
        Platform.runLater(() -> this.btnNoviProizvod.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnNoviProizvod.fire()));
        this.tfFilter.textProperty().addListener((obs, oldValue, newValue) -> this.loadDetails());
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(2, true);
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit(cellEditEvent -> {
            OtpisDetailes selectedTableOtpis = (OtpisDetailes)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTableOtpis.setQuantity(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTableOtpis.setPurchasePriceWithoutVatSum(this.round2Decimals(selectedTableOtpis.getQuantity() * selectedTableOtpis.getPurchasePriceWithoutVat()));
            selectedTableOtpis.setPurchasePriceWithVatSum(this.round2Decimals(selectedTableOtpis.getQuantity() * selectedTableOtpis.getPurchasePriceWithVat()));
            selectedTableOtpis.setCurrentPriceSumWithoutPDV(this.round2Decimals(selectedTableOtpis.getQuantity() * (selectedTableOtpis.getCurrentPrice() - selectedTableOtpis.getCurrentPrice() * selectedTableOtpis.getProduct().getVatValue3())));
            selectedTableOtpis.setCurrentPriceSumWithPDV(this.round2Decimals(selectedTableOtpis.getQuantity() * selectedTableOtpis.getCurrentPrice()));
            cellEditEvent.getTableColumn().getTableView().refresh();
        });
        this.makeHeaderWrappable(this.tcQuantity);
        this.tcPriceWithoutVatAndDiscount.setCellValueFactory((Callback)new PropertyValueFactory("purchasePriceWithoutVat"));
        this.makeHeaderWrappable(this.tcPriceWithoutVatAndDiscount);
        this.tcPriceWithVatAndDiscount.setCellValueFactory((Callback)new PropertyValueFactory("purchasePriceWithVat"));
        this.makeHeaderWrappable(this.tcPriceWithVatAndDiscount);
        this.tcSumWithoutPDV.setCellValueFactory((Callback)new PropertyValueFactory("purchasePriceWithoutVatSum"));
        this.makeHeaderWrappable(this.tcSumWithoutPDV);
        this.tcSumWithPDV.setCellValueFactory((Callback)new PropertyValueFactory("purchasePriceWithVatSum"));
        this.makeHeaderWrappable(this.tcSumWithPDV);
        this.tcCurrentPriceSumWithoutPDV.setCellValueFactory((Callback)new PropertyValueFactory("currentPriceSumWithoutPDV"));
        this.makeHeaderWrappable(this.tcCurrentPriceSumWithoutPDV);
        this.tcCurrentPriceSumWithPDV.setCellValueFactory((Callback)new PropertyValueFactory("currentPriceSumWithPDV"));
        this.makeHeaderWrappable(this.tcCurrentPriceSumWithPDV);
        this.tcSellPrice.setCellValueFactory((Callback)new PropertyValueFactory("currentPrice"));
        this.makeHeaderWrappable(this.tcSellPrice);
        Settings.makeHeaderWrappable(this.tcSellPrice);
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void actionSave(ActionEvent event) {
        try {
            int i;
            this.controller.getSettings().getConnection().setAutoCommit(false);
            this.otpis.setDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dpDate.getDateTimeValue()));
            this.otpis.setComment(this.tfNapomena.getText());
            if (this.otpis.getDocumentID() > 0L) {
                this.otpis.update(this.controller);
            } else {
                this.otpis.insert(this.controller);
            }
            for (i = 0; i < this.deletedItems.size(); ++i) {
                if (this.deletedItems.get(i).getDocumentDetailsID() > 0L) {
                    this.deletedItems.get(i).delete(this.controller.getSettings().getConnection());
                    continue;
                }
                this.deletedItems.remove(i);
            }
            for (i = 0; i < this.tableOtpisDetails.getItems().size(); ++i) {
                OtpisDetailes tableItem = (OtpisDetailes)this.tableOtpisDetails.getItems().get(i);
                if (tableItem.getDocumentDetailsID() > 0L) {
                    if (tableItem.getProduct() == null) continue;
                    tableItem.update(this.controller);
                    continue;
                }
                if (tableItem.getProduct() == null) continue;
                tableItem.setDocumentID(this.otpis.getDocumentID());
                Long id = tableItem.insert(this.controller);
                tableItem.setDocumentDetailsID(id.longValue());
            }
            this.controller.getSettings().getConnection().commit();
            if ((Button)event.getSource() == this.btnSacuvajNovo) {
                this.modalResult = ScreensController.MODAL_RESULT_OK_NEW;
                ((Stage)this.rootPane.getScene().getWindow()).close();
            } else {
                this.modalResult = ScreensController.MODAL_RESULT_OK;
                ((Stage)this.rootPane.getScene().getWindow()).close();
            }
        }
        catch (SQLException e) {
            try {
                this.controller.getSettings().getConnection().rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        finally {
            try {
                this.controller.getSettings().getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void actionAdd(ActionEvent event) {
    }

    public void actionAddOtpisDetails(ActionEvent event) {
        OtpisDetailes otpisDetails = new OtpisDetailes();
        otpisDetails.setDocumentDetailsID(-1L);
        otpisDetails.setProduct(this.od.getProduct());
        try {
            this.od.setQuantity(Double.parseDouble(this.tfQuantity.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.selectedProduct.getPrice()));
        this.od.setPurchasePriceWithoutVatSum(this.round2Decimals(this.od.getQuantity() * this.od.getPurchasePriceWithoutVat()));
        this.od.setPurchasePriceWithVatSum(this.round2Decimals(this.od.getQuantity() * this.od.getPurchasePriceWithVat()));
        this.od.setCurrentPrice(this.selectedProduct.getPrice());
        this.od.setVat(this.selectedProduct.getVatValue3());
        this.od.setCurrentPriceSumWithoutPDV(this.round2Decimals(this.od.getQuantity() * (this.selectedProduct.getPrice() - this.selectedProduct.getPrice() * this.od.getVat())));
        this.od.setCurrentPriceSumWithPDV(this.od.getQuantity() * this.selectedProduct.getPrice());
        otpisDetails.setQuantity(this.od.getQuantity());
        otpisDetails.setPurchasePriceWithoutVat(this.round2Decimals(this.od.getPurchasePriceWithoutVat()));
        otpisDetails.setPurchasePriceWithVat(this.round2Decimals(this.od.getPurchasePriceWithVat()));
        otpisDetails.setPurchasePriceWithoutVatSum(this.round2Decimals(this.od.getPurchasePriceWithoutVatSum()));
        otpisDetails.setPurchasePriceWithVatSum(this.round2Decimals(this.od.getPurchasePriceWithVatSum()));
        otpisDetails.setCurrentPrice(this.od.getCurrentPrice());
        otpisDetails.setCurrentPriceSumWithoutPDV(this.round2Decimals(this.od.getCurrentPriceSumWithoutPDV()));
        otpisDetails.setCurrentPriceSumWithPDV(this.round2Decimals(this.od.getCurrentPriceSumWithPDV()));
        otpisDetails.setVat(this.od.getVat());
        this.otpisDetailsList.add((java.lang.Object)otpisDetails);
        this.tfFilter.setText("");
        this.loadDetails();
        this.od = new OtpisDetailes();
        this.cbProduct.getSelectionModel().clearSelection();
        this.tfQuantity.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
    }

    @FXML
    public void actionNewProduct(ActionEvent event) {
        if (this.department != null) {
            HashMap<String, ScreensController> hm2 = new HashMap<String, ScreensController>();
            hm2.put("controller", this.controller);
            int result = this.controller.showModalDialog("Dodavanje artikla", ScreensController.DIALOG_BACKOFFICE_ADD_PRODUCT, hm2, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                // empty if block
            }
        }
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.tableOtpisDetails.getSelectionModel().getSelectedItem() != null) {
            this.deletedItems.add((OtpisDetailes)this.tableOtpisDetails.getSelectionModel().getSelectedItem());
            this.otpisDetailsList.remove(this.tableOtpisDetails.getSelectionModel().getSelectedItem());
            this.tableOtpisDetails.getItems().remove(this.tableOtpisDetails.getSelectionModel().getSelectedItem());
        }
        this.tfFilter.setText("");
        this.loadDetails();
    }

    private void loadDetails() {
        this.tableOtpisDetails.getItems().clear();
        for (int i = 0; i < this.otpisDetailsList.size(); ++i) {
            if (((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_ALL)) {
                if (!(((OtpisDetailes)this.otpisDetailsList.get(i)).getProduct().getName().toLowerCase().contains(this.tfFilter.getText().toLowerCase()) || ((OtpisDetailes)this.otpisDetailsList.get(i)).getProduct().getBarcodeLast() != null && ((OtpisDetailes)this.otpisDetailsList.get(i)).getProduct().getBarcodeLast().contains(this.tfFilter.getText()) || ((OtpisDetailes)this.otpisDetailsList.get(i)).getProduct().getCode() != null && ((OtpisDetailes)this.otpisDetailsList.get(i)).getProduct().getCode().toLowerCase().contains(this.tfFilter.getText().toLowerCase())) && !this.tfFilter.getText().equals("")) continue;
                this.tableOtpisDetails.getItems().add(this.otpisDetailsList.get(i));
                continue;
            }
            if (((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_BARCODE)) {
                if ((((OtpisDetailes)this.otpisDetailsList.get(i)).getProduct().getBarcodeLast() == null || !((OtpisDetailes)this.otpisDetailsList.get(i)).getProduct().getBarcodeLast().equals(this.tfFilter.getText())) && !this.tfFilter.getText().equals("")) continue;
                this.tableOtpisDetails.getItems().add(this.otpisDetailsList.get(i));
                continue;
            }
            if (!((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_CODE) || (((OtpisDetailes)this.otpisDetailsList.get(i)).getProduct().getCode() == null || !((OtpisDetailes)this.otpisDetailsList.get(i)).getProduct().getCode().toLowerCase().equals(this.tfFilter.getText().toLowerCase())) && !this.tfFilter.getText().equals("")) continue;
            this.tableOtpisDetails.getItems().add(this.otpisDetailsList.get(i));
        }
    }

    @FXML
    private void actionImport() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import otpisa");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((java.lang.Object)extFilter);
        final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje detalja u toku...", this.rootPane.getScene().getWindow());
            ArrayList unexistedProducts = new ArrayList();
            Task<Void> loadingCsvTask = new Task<Void>(){

                protected Void call() throws Exception {
                    String line = "";
                    String[] colNames = null;
                    int colQuantity = -1;
                    int colBarcode = -1;
                    int counterRow = 0;
                    try {
                        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        while ((line = bf.readLine()) != null) {
                            colNames = line.split(";");
                            if (counterRow == 0) {
                                for (int i = 0; i < colNames.length; ++i) {
                                    for (CsvImport csvImport : CsvImport.getList((ScreensController)OtpisDetailesControllerTrgovina.this.controller, (long)OtpisDetailesControllerTrgovina.this.csvImportType.getImportCsvTypeId())) {
                                        if (csvImport.getCsvName().equals("Kolicina") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                            colQuantity = i;
                                        }
                                        if (!csvImport.getCsvName().equals("Bar Kod") || !colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) continue;
                                        colBarcode = i;
                                    }
                                }
                            } else {
                                Product p = Product.getByBarcode((String)colNames[colBarcode], (Connection)OtpisDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                                OtpisDetailes otpisDetails = new OtpisDetailes();
                                otpisDetails.setDocumentDetailsID(-1L);
                                otpisDetails.setProduct(p);
                                int quantity = Integer.parseInt(colNames[colQuantity]);
                                if (quantity != 0) {
                                    otpisDetails.setQuantity((double)quantity);
                                    p.getCurrentPriceBeforeDatePrijemnica(Settings.fromLocalDate((LocalDate)((LocalDate)OtpisDetailesControllerTrgovina.this.dpDate.getValue())), (long)OtpisDetailesControllerTrgovina.this.department.getDepartmentID(), OtpisDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                                    p.getNabavnaCenaOtpis(OtpisDetailesControllerTrgovina.this.controller.getSettings().getConnection());
                                    otpisDetails.setPurchasePriceWithVat(OtpisDetailesControllerTrgovina.this.round2Decimals(p.getNabavnaCena()));
                                    otpisDetails.setPurchasePriceWithoutVat(OtpisDetailesControllerTrgovina.this.round2Decimals(p.getNabavnaCenaBezPopusta()));
                                    otpisDetails.setCurrentPrice(p.getPrice());
                                    otpisDetails.setVat(p.getVatValue3());
                                    otpisDetails.setPurchasePriceWithoutVatSum(OtpisDetailesControllerTrgovina.this.round2Decimals(otpisDetails.getQuantity() * otpisDetails.getPurchasePriceWithoutVat()));
                                    otpisDetails.setPurchasePriceWithVatSum(OtpisDetailesControllerTrgovina.this.round2Decimals(otpisDetails.getQuantity() * otpisDetails.getPurchasePriceWithVat()));
                                    otpisDetails.setCurrentPriceSumWithoutPDV(OtpisDetailesControllerTrgovina.this.round2Decimals(otpisDetails.getQuantity() * otpisDetails.getCurrentPrice()));
                                    otpisDetails.setCurrentPriceSumWithPDV(OtpisDetailesControllerTrgovina.this.round2Decimals(otpisDetails.getQuantity() * (otpisDetails.getCurrentPrice() - otpisDetails.getCurrentPrice() * otpisDetails.getVat())));
                                    OtpisDetailesControllerTrgovina.this.otpisDetailsList.add((java.lang.Object)otpisDetails);
                                }
                            }
                            ++counterRow;
                        }
                        bf.close();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            loadingCsvTask.setOnSucceeded(eventValue -> {
                taskUpdateStage.hide();
                this.loadDetails();
                if (unexistedProducts.size() > 0) {
                    this.controller.alert("Nepostoje\u0107i artikli", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
                }
            });
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        }
    }

    private void makeHeaderWrappable(TableColumn<java.lang.Object, Double> col) {
        Label label = new Label(col.getText());
        label.setWrapText(true);
        label.setAlignment(Pos.TOP_LEFT);
        label.setTextAlignment(TextAlignment.LEFT);
        StackPane stack = new StackPane();
        stack.getChildren().add((java.lang.Object)label);
        stack.prefWidthProperty().bind((ObservableValue)col.widthProperty().subtract(1));
        label.prefWidthProperty().bind((ObservableValue)stack.prefWidthProperty());
        col.setGraphic((Node)stack);
    }

    private double round2Decimals(double x) {
        return (double)Math.round(x * 100.0) / 100.0;
    }
}

