/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.backoffice.controller.document.DocumentLocker;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.CsvImportType;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.Otpis;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class OtpisController
implements ControlledScreen {
    ScreensController controller;
    private DocumentLocker docLocker;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;
    Object sviObjekti = new Object(-1, "Svi objekti");
    Department svaOdeljenja = new Department(-1, "Sva odeljenja");
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private TableView<Otpis> table;
    @FXML
    private TableColumn<Otpis, Integer> tcBroj;
    @FXML
    private TableColumn<Otpis, Date> tcDate;
    @FXML
    private TableColumn<Otpis, String> tcNapomena;
    @FXML
    private TableColumn<Otpis, String> tcZakljucan;
    @FXML
    private Button btnNew;
    @FXML
    private Button btnEdit;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnExport;
    @FXML
    private Button btnDelete;
    @FXML
    private Label lblZakljucaniDokumentiUpozorenje;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbObject.getItems().add((java.lang.Object)this.sviObjekti);
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((java.lang.Object)o);
        }
        if (this.cbObject.getItems().size() == 2) {
            this.cbObject.getSelectionModel().select(1);
        } else {
            this.cbObject.getSelectionModel().select((java.lang.Object)this.sviObjekti);
        }
        this.dpDateFrom.setValue((java.lang.Object)LocalDate.now());
        this.dpDateTo.setValue((java.lang.Object)LocalDate.now());
        this.loadDocumentList();
    }

    public void setParameter(java.lang.Object parameter) {
        this.docLocker = new DocumentLocker(this.controller);
        this.lastDocumentLockDate = this.docLocker.getLastLockedDocumentDate();
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                OtpisController.this.loadDepartment();
            }
        });
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                OtpisController.this.loadDocumentList();
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Otpis>(){

            public void changed(ObservableValue<? extends Otpis> observable, Otpis oldValue, Otpis newValue) {
                if (newValue == null) {
                    OtpisController.this.btnDelete.setDisable(true);
                    OtpisController.this.btnPrint.setDisable(true);
                    OtpisController.this.btnEdit.setDisable(true);
                    OtpisController.this.btnExport.setDisable(true);
                } else if (OtpisController.this.documentLockIsActive && newValue.isLocked()) {
                    OtpisController.this.btnDelete.setDisable(true);
                    OtpisController.this.btnPrint.setDisable(false);
                    OtpisController.this.btnEdit.setDisable(true);
                    OtpisController.this.lblZakljucaniDokumentiUpozorenje.setVisible(true);
                } else {
                    OtpisController.this.btnDelete.setDisable(false);
                    OtpisController.this.btnPrint.setDisable(false);
                    OtpisController.this.btnEdit.setDisable(false);
                    OtpisController.this.btnExport.setDisable(false);
                    OtpisController.this.lblZakljucaniDokumentiUpozorenje.setVisible(false);
                }
            }
        });
        this.tcBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDate.setCellFactory(column -> new TableCell<Otpis, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcNapomena.setCellValueFactory((Callback)new PropertyValueFactory("Comment"));
        this.tcZakljucan.setCellValueFactory(cellValue -> {
            boolean isLocked = ((Otpis)cellValue.getValue()).isLocked();
            String locked = isLocked ? "DA" : "NE";
            return new ReadOnlyStringWrapper(locked);
        });
    }

    @FXML
    public void actionNew(ActionEvent event) {
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("controller", this.controller);
        if (this.cbDepartment.getSelectionModel().getSelectedItem() != null) {
            Otpis otpis = new Otpis();
            otpis.setDocumentID(-1L);
            otpis.setNumber(Document.getNextNumber((int)7, (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (ScreensController)this.controller, (LocalDate)((LocalDate)this.dpDateFrom.getValue())));
            otpis.setDate(new Date());
            otpis.setDepartmentID(((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
            otpis.setComment("");
            hm.put("otpis", otpis);
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            hm.put("object", this.cbObject.getSelectionModel().getSelectedItem());
            hm.put("csvImportType", CsvImportType.getByName((ScreensController)this.controller, (String)"Otpis"));
            hm.put("lastDocumentLockDate", this.lastDocumentLockDate);
            int result = this.controller.showModalDialog("Otpis - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_OTPIS_DETAILES_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocumentList();
            } else if (result == ScreensController.MODAL_RESULT_OK_NEW) {
                Log.writeLog((User)this.controller.getUser(), (String)"Unos novog otpisa", (Connection)this.controller.getSettings().getConnection());
                this.loadDocumentList();
                this.actionNew(event);
            }
        } else {
            this.controller.alert("Obave\u0161tenje", "Izaberite odeljenje", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionEdit(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            hm.put("otpis", this.table.getSelectionModel().getSelectedItem());
            hm.put("object", this.cbObject.getSelectionModel().getSelectedItem());
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            int result = this.controller.showModalDialog("Povrat - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_OTPIS_DETAILES_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocumentList();
                Log.writeLog((User)this.controller.getUser(), (String)"Izmena otpisa", (Connection)this.controller.getSettings().getConnection());
            } else if (result == ScreensController.MODAL_RESULT_OK_NEW) {
                this.loadDocumentList();
                this.actionNew(event);
            }
        }
    }

    @FXML
    public void actionPrint(ActionEvent event) {
        String reportFileName = "rs/petcom/backoffice/jasper/OtpisTrgovina.jasper";
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        Document document = Document.getByID((long)((Otpis)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        for (Images images : Images.getImagesList((ScreensController)this.controller)) {
            if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", Object.get((Connection)this.controller.getSettings().getConnection()));
        hm.put("address", Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()));
        hm.put("documentId", document.getDocumentID());
        hm.put("document", document);
        hm.put("prijemnica", false);
        hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
        hm.put("dobavljac", Person.getById((long)document.getPersonID(), (ScreensController)this.controller));
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Povrat", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        try {
            if (this.table.getSelectionModel().getSelectedItem() != null) {
                for (DocumentDetails dd : DocumentDetails.getList((long)((Otpis)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection())) {
                    dd.delete(this.controller.getSettings().getConnection());
                }
                ((Otpis)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
                this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
                Log.writeLog((User)this.controller.getUser(), (String)"Brisanje otpisa", (Connection)this.controller.getSettings().getConnection());
            }
        }
        catch (SQLException e) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("title", "Brisanje povratnice nije mogu\u0107e!");
            hm.put("text", "\nPoruka o gre\u0161ci:\n\n" + e.getLocalizedMessage());
            this.controller.showModalDialog("Brisanje otpisa nije mogu\u0107e!", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        }
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((Object)((Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)d);
        }
        if (this.cbDepartment.getItems().size() == 1) {
            this.cbDepartment.getSelectionModel().select(0);
        }
    }

    @FXML
    private void loadDocumentList() {
        this.table.getItems().clear();
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
                this.table.setItems(Otpis.getList((Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue())), (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection()));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    private void actionExport() {
        Otpis otpis = (Otpis)this.table.getSelectionModel().getSelectedItem();
        Department d = (Department)this.cbDepartment.getSelectionModel().getSelectedItem();
        otpis.setDepartmentID(d.getDepartmentID());
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Export Otpis");
        fileChooser.setInitialFileName("Otpis-" + d.getCode() + "-" + otpis.getNumber() + ".xml");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("XML files (*.xml)", new String[]{"*.xml"});
        fileChooser.getExtensionFilters().add((java.lang.Object)extFilter);
        File file = fileChooser.showSaveDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            try {
                if (file.getAbsolutePath().toUpperCase().endsWith(".XML")) {
                    otpis.exportToXml(file.getAbsolutePath(), this.controller.getSettings().getConnection());
                } else {
                    otpis.exportToXml(file.getAbsolutePath() + ".xml", this.controller.getSettings().getConnection());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }
}

