/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.controller.trgovina.Nivelacija;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.person.Address;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class NivelacijaControllerTrgovina
implements ControlledScreen {
    ScreensController controller;
    Object sviObjekti = new Object(-1, "Svi objekti");
    Department svaOdeljenja = new Department(-1, "Sva odeljenja");
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private TableView<Nivelacija> table;
    @FXML
    private TableColumn<Nivelacija, Integer> tcBroj;
    @FXML
    private TableColumn<Nivelacija, Date> tcDate;
    @FXML
    private TableColumn<Nivelacija, String> tcStatus;
    @FXML
    private TableColumn<Nivelacija, String> tcNapomena;
    @FXML
    private TableColumn<Nivelacija, String> tcProdajnoMesto;
    @FXML
    private Button btnPrint;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbObject.getItems().add((java.lang.Object)this.sviObjekti);
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((java.lang.Object)o);
        }
        if (this.cbObject.getItems().size() == 2) {
            this.cbObject.getSelectionModel().select(1);
        } else {
            this.cbObject.getSelectionModel().select((java.lang.Object)this.sviObjekti);
        }
        this.dpDateFrom.setValue((java.lang.Object)LocalDate.now());
        this.dpDateTo.setValue((java.lang.Object)LocalDate.now());
        this.loadDocumentList();
    }

    public void setParameter(java.lang.Object parameter) {
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                NivelacijaControllerTrgovina.this.loadDepartment();
            }
        });
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                NivelacijaControllerTrgovina.this.loadDocumentList();
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Nivelacija>(){

            public void changed(ObservableValue<? extends Nivelacija> observable, Nivelacija oldValue, Nivelacija newValue) {
                if (newValue == null) {
                    NivelacijaControllerTrgovina.this.btnPrint.setDisable(true);
                } else {
                    NivelacijaControllerTrgovina.this.btnPrint.setDisable(false);
                }
            }
        });
        this.tcBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcNapomena.setCellValueFactory((Callback)new PropertyValueFactory("Note"));
        this.tcDate.setCellFactory(column -> new TableCell<Nivelacija, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcStatus.setCellValueFactory((Callback)new PropertyValueFactory("Status"));
        this.tcProdajnoMesto.setCellValueFactory((Callback)new PropertyValueFactory("ProdajnoMesto"));
    }

    @FXML
    public void actionPrint(ActionEvent event) {
        final String reportFileName = "rs/petcom/backoffice/jasper/Nivelacija.jasper";
        final HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        Document document = Document.getByID((long)((Nivelacija)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        CompanyConfig companyConfig = CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller);
        for (Images images : Images.getImagesList((ScreensController)this.controller)) {
            if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", "null");
        }
        try {
            hm.put("address", Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID((long)companyConfig.getAddressID(), (Connection)this.controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        CompanyConfig company = CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller);
        hm.put("objekat", this.cbObject.getSelectionModel().getSelectedItem());
        hm.put("documentId", document.getDocumentID());
        hm.put("document", document);
        hm.put("company", company);
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<JasperPrint> creatingReport = new Task<JasperPrint>(){

            protected JasperPrint call() {
                try {
                    JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(0);
                    hm.put("REPORT_VIRTUALIZER", virtualizer);
                    JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                    JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)NivelacijaControllerTrgovina.this.controller.getSettings().getConnection());
                    virtualizer.setReadOnly(true);
                    return jprint;
                }
                catch (JRException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        creatingReport.setOnSucceeded(arg_0 -> this.lambda$actionPrint$1(taskUpdateStage, event, (Task)creatingReport, arg_0));
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no kreiranje nivelacije.", this.rootPane.getScene().getWindow());
        });
        creatingReport.exceptionProperty().addListener((obs, old, newValue) -> {
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        new Thread((Runnable)creatingReport).start();
    }

    @FXML
    public void actionDelete(ActionEvent event) {
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((Object)((Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)d);
        }
        if (this.cbDepartment.getItems().size() == 1) {
            this.cbDepartment.getSelectionModel().select(0);
        }
    }

    @FXML
    private void loadDocumentList() {
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
                ObservableList niveltaionList = Nivelacija.getList((Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue())), (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection());
                this.table.setItems(niveltaionList);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    private void actionExport() {
    }

    private /* synthetic */ void lambda$actionPrint$1(Stage taskUpdateStage, ActionEvent event, Task creatingReport, WorkerStateEvent eventValue) {
        taskUpdateStage.hide();
        if (((Button)event.getSource()).getText().equals("PDF")) {
            this.controller.printFileFromPDF(this.controller.getPdfFromJasper((JasperPrint)creatingReport.getValue(), "Nivelacija", "Nivelacija"));
        }
        if (((Button)event.getSource()).getText().equals("EXCEL")) {
            this.controller.getXlsxFromJasper((JasperPrint)creatingReport.getValue(), "Nivelacija");
        } else {
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld((JasperPrint)creatingReport.getValue());
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Nivelacija", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
    }
}

