/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.time.LocalDate;
import java.time.Month;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.backoffice.controller.document.DocumentLocker;
import rs.petcom.backoffice.controller.reports.ReportMapModel;
import rs.petcom.backoffice.salesreportnew.reportmodels.JasperStarter;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Kep;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.PocetnoStanje;
import rs.petcom.master.utility.FormaterUtil;
import rs.petcom.master.utility.KepUtility;

public class KepController
implements ControlledScreen {
    ScreensController controller;
    Connection connection;
    KepUtility kepUtility;
    DocumentLocker docLocker;
    LocalDate lastLockedDocumentDate;
    @FXML
    BorderPane rootPane;
    @FXML
    private ComboBox<String> cbKepYear;
    @FXML
    private TableView<Kep> tblKep;
    @FXML
    private TableColumn<Kep, LocalDate> colKepDate;
    @FXML
    private TableColumn<Kep, String> colKepDescription;
    @FXML
    private TableColumn<Kep, Double> colKepDebit;
    @FXML
    private TableColumn<Kep, Double> colKepDebtRelief;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private Label labSum_debit;
    @FXML
    private Label labSum_debitReleaf;
    @FXML
    private Label labKep_value;
    @FXML
    private Button btnDocumentLock;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
        this.connection = this.controller.getSettings().getConnection();
        this.kepUtility = new KepUtility(this.controller);
        this.docLocker = new DocumentLocker(this.controller);
        this.lastLockedDocumentDate = this.docLocker.getLastLockedDocumentDate();
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbKepYear.setItems(this.kepUtility.KepYears());
        this.cbKepYear.getSelectionModel().select(0);
        this.setColumns();
        this.setKepDates();
    }

    @FXML
    void actionShowKep() {
        boolean unlockDocumentsExsists = this.docLocker.unlockDocumentsExsistsForPeriod((LocalDate)this.dpFrom.getValue(), (LocalDate)this.dpTo.getValue());
        if (unlockDocumentsExsists) {
            this.showUnlockDocumentExsitsMesssage();
            this.dpTo.setValue((Object)this.lastLockedDocumentDate);
            return;
        }
        this.loadTable();
    }

    @FXML
    void setKepDates() {
        String year = (String)this.cbKepYear.getSelectionModel().getSelectedItem();
        this.dpFrom.setValue((Object)this.getFirstKepDate(year));
        if (this.isActualYear(year)) {
            this.dpTo.setValue((Object)LocalDate.now());
            this.btnDocumentLock.setVisible(true);
        } else {
            this.dpTo.setValue((Object)this.lastDayInTheYear(year));
            this.btnDocumentLock.setVisible(false);
        }
    }

    @FXML
    void actionPrint() {
        Map<String, Object> parameterMap = ReportMapModel.getReportMap(this.controller);
        String path = "rs/petcom/backoffice/jasper/Kep.jasper";
        ObservableList kepList = this.tblKep.getItems();
        parameterMap.put("datas", kepList);
        parameterMap.put("year", this.cbKepYear.getSelectionModel().getSelectedItem());
        JasperStarter starter = new JasperStarter(parameterMap, path, this.rootPane);
        starter.createReportCollectionDataSource();
    }

    @FXML
    private void actionDocumentLock() {
        final LocalDate lockDocumentDateTo = this.openDateChooser();
        if (this.isActualDay(lockDocumentDateTo)) {
            this.showActualDayForbiddenLockMessage();
            return;
        }
        if (!this.youChooseToLockDocuments()) {
            return;
        }
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Zaklju\u010davanje dokumenata i kreiranje nivelacija u toku", this.rootPane.getScene().getWindow());
        Task<Void> lockTask = new Task<Void>(){

            protected Void call() throws Exception {
                if (KepController.this.lastLockedDocumentDate.isBefore(lockDocumentDateTo)) {
                    KepController.this.docLocker.lockDocumntsForPeriod(KepController.this.lastLockedDocumentDate, lockDocumentDateTo);
                } else {
                    KepController.this.docLocker.lockDocumntsForPeriod(KepController.this.docLocker.getLastLockedDocumentDateRecalculation(), lockDocumentDateTo);
                }
                KepController.this.dpTo.setValue((Object)lockDocumentDateTo);
                KepController.this.lastLockedDocumentDate = lockDocumentDateTo;
                return null;
            }
        };
        lockTask.setOnSucceeded(eventValue -> {
            taskUpdateStage.close();
            this.showDocumetnLockSuccessMessage();
        });
        new Thread((Runnable)lockTask).start();
    }

    private void setColumns() {
        this.colKepDate.setCellValueFactory((Callback)new PropertyValueFactory("documentDate"));
        this.colKepDescription.setCellValueFactory((Callback)new PropertyValueFactory("documentDescription"));
        this.colKepDebit.setCellValueFactory((Callback)new PropertyValueFactory("debit"));
        this.colKepDebtRelief.setCellValueFactory((Callback)new PropertyValueFactory("debitReleaf"));
    }

    private void loadTable() {
        String year = (String)this.cbKepYear.getSelectionModel().getSelectedItem();
        if (!this.initialStockExsitsOnFirstDayInTheYear(year) && !this.isTheFirstYear(year)) {
            this.showInitialStockNotExsitsMessage();
        }
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje detalja u toku.", this.rootPane.getScene().getWindow());
        final HashMap sumarizedValues = new HashMap();
        Task<Void> kepTask = new Task<Void>(){

            protected Void call() throws Exception {
                LocalDate dateFrom = (LocalDate)KepController.this.dpFrom.getValue();
                LocalDate dateTo = (LocalDate)KepController.this.dpTo.getValue();
                WorkDay wdFrom = WorkDay.getFromDbByDate((LocalDate)dateFrom, (Connection)KepController.this.connection);
                WorkDay wdTo = WorkDay.getDateToByDate((LocalDate)dateTo, (Connection)KepController.this.connection);
                long wdIdFrom = wdFrom.getWorkDayID();
                long wdIdTo = wdTo != null ? wdTo.getWorkDayID() : WorkDay.getLastOpenWD((ScreensController)KepController.this.controller).getWorkDayID();
                ObservableList kepList = KepController.this.kepUtility.getKep(dateFrom, dateTo, wdIdFrom, wdIdTo, sumarizedValues);
                KepController.this.tblKep.setItems(kepList);
                return null;
            }
        };
        kepTask.setOnSucceeded(eventValue -> {
            taskUpdateStage.close();
            String pattern = "###,###.###";
            String sum_debit = FormaterUtil.decimalFormater((String)pattern, (double)((Double)sumarizedValues.get("sum_debit")));
            String sum_debitReleaf = FormaterUtil.decimalFormater((String)pattern, (double)((Double)sumarizedValues.get("sum_debitReleaf")));
            String kepValue = FormaterUtil.decimalFormater((String)pattern, (double)((Double)sumarizedValues.get("kepValue")));
            this.labSum_debit.setText(sum_debit);
            this.labSum_debitReleaf.setText(sum_debitReleaf);
            this.labKep_value.setText(kepValue);
        });
        new Thread((Runnable)kepTask).start();
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    public LocalDate getFirstKepDate(String kepYear) {
        if (this.isTheFirstYear(kepYear)) {
            return this.startDateForTheFirstYear(kepYear);
        }
        return this.firstDayInTheYear(kepYear);
    }

    private boolean isTheFirstYear(String kepYear) {
        String firstYear = this.kepUtility.firstKepYear();
        return kepYear.equals(firstYear);
    }

    private boolean isActualYear(String kepYear) {
        String lastYear = this.kepUtility.lastKepYear();
        return kepYear.equals(lastYear);
    }

    private LocalDate startDateForTheFirstYear(String kepYear) {
        WorkDay wd = WorkDay.getFistWarkDayEver((Connection)this.connection);
        LocalDate firstKepDate = Settings.fromDate((Date)wd.getDate());
        return firstKepDate;
    }

    private LocalDate firstDayInTheYear(String kepYear) {
        int year = Integer.parseInt(kepYear);
        return LocalDate.of(year, Month.JANUARY, 1);
    }

    private LocalDate lastDayInTheYear(String kepYear) {
        int year = Integer.parseInt(kepYear);
        return LocalDate.of(year, Month.DECEMBER, 31);
    }

    private boolean initialStockExsitsOnFirstDayInTheYear(String kepYear) {
        LocalDate firstDayInTheYear = this.firstDayInTheYear(kepYear);
        return PocetnoStanje.initialStockExsistsOnDate((LocalDate)firstDayInTheYear, (Connection)this.connection);
    }

    private boolean isActualDay(LocalDate lockDate) {
        WorkDay actualWorkDay = WorkDay.getLastOpenWD((ScreensController)this.controller);
        LocalDate actualDay = Settings.fromDate((Date)actualWorkDay.getDate());
        return lockDate.equals(actualDay);
    }

    private LocalDate openDateChooser() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("message", "Izaberite datum do kojeg zelite da zakljucate dokumente");
        int res = this.controller.showModalDialog("Izbor datuma zakljucvanja dokumenta", ScreensController.SCREEN_BACKOFFICE_FIXED_DATE, hm, this.rootPane.getScene().getWindow());
        if (res == ScreensController.MODAL_RESULT_CANCEL) {
            return this.lastLockedDocumentDate;
        }
        return (LocalDate)hm.get("documentDate");
    }

    private boolean youChooseToLockDocuments() {
        int res = this.controller.yesNoDialog("Upozorenje", "Nakon zaklju\u010davanja, dokumente mo\u017eete  pregledavati ili \u0161tampati.  Izmena i brisanje nisu dozvoljeni. Da li ste sigurni da \u017eelite da nastavite?", this.rootPane.getScene().getWindow());
        return res != ScreensController.MODAL_RESULT_NO;
    }

    private void showUnlockDocumentExsitsMesssage() {
        this.controller.alert("Upozorenja", "Za izabrani period postoje dokumenti koji nisu zakljucani. Kep knjigu mo\u017eete kreirati do " + this.lastLockedDocumentDate, this.rootPane.getScene().getWindow());
    }

    private void showDocumetnLockSuccessMessage() {
        this.controller.alert("Obave\u0161tenje", "Sva dokumenta su zaklju\u010dana do " + this.lastLockedDocumentDate, this.rootPane.getScene().getWindow());
    }

    private void showActualDayForbiddenLockMessage() {
        this.controller.alert("Obave\u0161tenje", "Zaklju\u010davanje dokumenata za aktuelni dan nije dozvoljeno", this.rootPane.getScene().getWindow());
    }

    private void showInitialStockNotExsitsMessage() {
        this.controller.alert("Upozorenje", "Nije pronadjeno po\u010detno stanje na 01.01.Morate uneti po\u010detno stanje na 01.01. teku\u0107e godine kako bi iznosi u Kep  bili ta\u010dni", this.rootPane.getScene().getWindow());
    }
}

