/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.TilePane;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.control.PropertySheet;
import rs.petcom.backoffice.gui.CustomPropertyEditorFactory;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.SviArtikli;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.ProductCategory;
import rs.petcom.master.dal.product.ProductType;

public class FilterProductController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameters;
    private ObservableList<CheckBoxTreeItem<Object>> aditionalFieldList = FXCollections.observableArrayList();
    private ObservableList<CheckBoxTreeItem<Object>> aditionalFieldDetailsList = FXCollections.observableArrayList();
    @FXML
    private BorderPane rootPane;
    @FXML
    private TilePane tilePane;
    @FXML
    private CheckComboBox<rs.petcom.master.dal.Object> cbObject;
    @FXML
    private CheckComboBox<Department> cbDepartment;
    @FXML
    private CheckComboBox<PointOfSale> cbPointOfSale;
    @FXML
    private CheckComboBox<ProductType> cbProductType;
    @FXML
    private CheckComboBox<ProductCategory> cbProductCategory;
    @FXML
    private CheckComboBox<Vat> cbVat;
    @FXML
    private TreeView<Object> ctvAditionalField;
    @FXML
    private ComboBox<SviArtikli> cbIsWeight;
    @FXML
    private ComboBox<SviArtikli> cbMeasurable;
    @FXML
    private ComboBox<SviArtikli> cbDiscountAllowed;
    @FXML
    private CheckBox cbActive;

    @FXML
    public void initialize() {
        this.cbObject.getCheckModel().getCheckedItems().addListener((ListChangeListener)new ListChangeListener<rs.petcom.master.dal.Object>(){

            public void onChanged(ListChangeListener.Change<? extends rs.petcom.master.dal.Object> change) {
                if (FilterProductController.this.cbObject.getCheckModel().getCheckedItems().isEmpty()) {
                    FilterProductController.this.cbDepartment.setVisible(false);
                } else {
                    FilterProductController.this.cbDepartment.setVisible(true);
                    FilterProductController.this.fillComboBoxDepartment();
                }
            }
        });
        this.cbDepartment.getCheckModel().getCheckedItems().addListener((ListChangeListener)new ListChangeListener<Department>(){

            public void onChanged(ListChangeListener.Change<? extends Department> change) {
                if (FilterProductController.this.cbDepartment.getCheckModel().getCheckedItems().isEmpty()) {
                    FilterProductController.this.cbPointOfSale.setVisible(false);
                } else {
                    FilterProductController.this.cbPointOfSale.setVisible(true);
                    FilterProductController.this.fillComboBoxPointOfSale();
                }
            }
        });
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbDepartment.setVisible(false);
        this.cbPointOfSale.setVisible(false);
        this.fillComboBoxObject();
        this.fillComboBox();
        this.fillComboBoxProductType();
        this.fillComboBoxProductCategory();
        this.fillComboBoxVat();
        this.fillCheckTreevView();
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    private void fillComboBoxObject() {
        PropertySheet propertySheet = new PropertySheet();
        CustomPropertyEditorFactory customPropertyEditorFactory = new CustomPropertyEditorFactory();
        customPropertyEditorFactory.setContriller(this.controller);
        propertySheet.setPropertyEditorFactory((Callback)customPropertyEditorFactory);
        ObservableList list = rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection());
        for (rs.petcom.master.dal.Object object : list) {
            this.cbObject.getItems().add((Object)object);
        }
        if (this.cbObject.getItems().size() > 0) {
            this.cbObject.getCheckModel().check(0);
        }
    }

    private void fillComboBoxDepartment() {
        this.cbDepartment.getItems().clear();
        PropertySheet propertySheet = new PropertySheet();
        CustomPropertyEditorFactory customPropertyEditorFactory = new CustomPropertyEditorFactory();
        customPropertyEditorFactory.setContriller(this.controller);
        propertySheet.setPropertyEditorFactory((Callback)customPropertyEditorFactory);
        String ids = "";
        for (rs.petcom.master.dal.Object object : this.cbObject.getCheckModel().getCheckedItems()) {
            ids = ids + object.getObjectID() + ",";
        }
        ObservableList list = Department.getListByObjects((String)ids.substring(0, ids.length() - 1), (Connection)this.controller.getSettings().getConnection());
        for (Department department : list) {
            this.cbDepartment.getItems().add((Object)department);
        }
        if (this.cbDepartment.getItems().size() > 0) {
            this.cbDepartment.getCheckModel().check(0);
        }
    }

    private void fillComboBoxPointOfSale() {
        this.cbPointOfSale.getItems().removeAll((Collection)this.cbPointOfSale.getItems());
        PropertySheet propertySheet = new PropertySheet();
        CustomPropertyEditorFactory customPropertyEditorFactory = new CustomPropertyEditorFactory();
        customPropertyEditorFactory.setContriller(this.controller);
        propertySheet.setPropertyEditorFactory((Callback)customPropertyEditorFactory);
        String ids = "";
        for (Department department : this.cbDepartment.getCheckModel().getCheckedItems()) {
            ids = ids + department.getDepartmentID() + ",";
        }
        PointOfSale posOfSale = new PointOfSale();
        posOfSale.setPointOfSaleID(-1);
        posOfSale.setName("Sva prodajna mesta");
        this.cbPointOfSale.getItems().add((Object)posOfSale);
        if (ids.length() > 1) {
            ObservableList list = PointOfSale.getPOSListByDeparments((String)ids.substring(0, ids.length() - 1), (Connection)this.controller.getSettings().getConnection());
            for (PointOfSale pointOfSale : list) {
                this.cbPointOfSale.getItems().add((Object)pointOfSale);
            }
            if (this.cbPointOfSale.getItems().size() > 0) {
                this.cbPointOfSale.getCheckModel().check(0);
            }
        }
    }

    private void fillComboBoxProductType() {
        PropertySheet propertySheet = new PropertySheet();
        CustomPropertyEditorFactory customPropertyEditorFactory = new CustomPropertyEditorFactory();
        customPropertyEditorFactory.setContriller(this.controller);
        propertySheet.setPropertyEditorFactory((Callback)customPropertyEditorFactory);
        ObservableList list = ProductType.getList((Connection)this.controller.getSettings().getConnection());
        ProductType pType = new ProductType();
        pType.setProductTypeID(-1);
        pType.setName("Svi tipovi");
        this.cbProductType.getItems().add((Object)pType);
        for (ProductType productType : list) {
            this.cbProductType.getItems().add((Object)productType);
        }
        if (this.cbProductType.getItems().size() > 0) {
            this.cbProductType.getCheckModel().check(0);
        }
    }

    private void fillComboBoxProductCategory() {
        PropertySheet propertySheet = new PropertySheet();
        CustomPropertyEditorFactory customPropertyEditorFactory = new CustomPropertyEditorFactory();
        customPropertyEditorFactory.setContriller(this.controller);
        propertySheet.setPropertyEditorFactory((Callback)customPropertyEditorFactory);
        ObservableList list = ProductCategory.getObeservableList((Connection)this.controller.getSettings().getConnection());
        ProductCategory pCategory = new ProductCategory(-1, "Sve kategorije");
        this.cbProductCategory.getItems().add((Object)pCategory);
        for (ProductCategory productCategory : list) {
            this.cbProductCategory.getItems().add((Object)productCategory);
        }
        if (this.cbProductCategory.getItems().size() > 0) {
            this.cbProductCategory.getCheckModel().check(0);
        }
    }

    private void fillComboBoxVat() {
        PropertySheet propertySheet = new PropertySheet();
        CustomPropertyEditorFactory customPropertyEditorFactory = new CustomPropertyEditorFactory();
        customPropertyEditorFactory.setContriller(this.controller);
        propertySheet.setPropertyEditorFactory((Callback)customPropertyEditorFactory);
        Vat vatSvi = new Vat();
        vatSvi.setVatID(-1);
        vatSvi.setName("Svi porezi");
        this.cbVat.getItems().add((Object)vatSvi);
        ObservableList list = Vat.getObeservableList((Connection)this.controller.getSettings().getConnection());
        for (Vat vat : list) {
            this.cbVat.getItems().add((Object)vat);
        }
        if (this.cbVat.getItems().size() > 0) {
            this.cbVat.getCheckModel().check(0);
        }
    }

    private void fillCheckTreevView() {
        CheckBoxTreeItem pos = new CheckBoxTreeItem();
        AditionalField aditionalField = new AditionalField();
        aditionalField.setName("Selektuj grupe");
        pos.setValue((Object)aditionalField);
        pos.setSelected(true);
        pos.setExpanded(true);
        this.ctvAditionalField.setCellFactory(p -> new CheckBoxTreeCell<Object>(){

            public void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                if (item != null) {
                    this.setText(item.toString());
                }
            }
        });
        for (AditionalField menu : AditionalField.getList((Connection)this.controller.getSettings().getConnection())) {
            CheckBoxTreeItem posMenuGroup = new CheckBoxTreeItem();
            posMenuGroup.setValue((Object)menu);
            posMenuGroup.setSelected(true);
            pos.getChildren().add((Object)posMenuGroup);
            this.aditionalFieldList.add((Object)posMenuGroup);
            for (AditionalFieldDetails aditionalFieldDetails : AditionalFieldDetails.getListByAditionalFieldID((long)menu.getAditionalFieldID(), (Connection)this.controller.getSettings().getConnection())) {
                CheckBoxTreeItem menuItem = new CheckBoxTreeItem();
                menuItem.setValue((Object)aditionalFieldDetails);
                menuItem.setSelected(true);
                posMenuGroup.getChildren().add((Object)menuItem);
                this.aditionalFieldDetailsList.add((Object)menuItem);
            }
        }
        this.ctvAditionalField.setRoot((TreeItem)pos);
        this.ctvAditionalField.setShowRoot(true);
    }

    @FXML
    private void subGroupAction() {
        this.tilePane.getChildren().clear();
    }

    @FXML
    private void showProductAction() {
        ArrayList<AditionalFieldDetails> currentPOSSelectionList = new ArrayList<AditionalFieldDetails>();
        for (CheckBoxTreeItem ps : this.aditionalFieldDetailsList) {
            if (ps.isSelected()) {
                ((AditionalFieldDetails)ps.getValue()).setSelected(true);
            } else {
                ((AditionalFieldDetails)ps.getValue()).setSelected(false);
            }
            currentPOSSelectionList.add((AditionalFieldDetails)ps.getValue());
        }
        for (Object aditionalFieldDetails : currentPOSSelectionList) {
            if (!aditionalFieldDetails.isSelected()) continue;
            System.out.println(aditionalFieldDetails.getName());
        }
        String departmentIDS = "";
        for (Object department : this.cbDepartment.getCheckModel().getCheckedItems()) {
            departmentIDS = departmentIDS + department.getDepartmentID() + ",";
        }
        String pointOfSaleIDS = "";
        for (Object pointOfSale : this.cbPointOfSale.getCheckModel().getCheckedItems()) {
            pointOfSaleIDS = pointOfSaleIDS + pointOfSale.getPointOfSaleID() + ",";
        }
        String productTypeIDS = "";
        for (Object productType : this.cbProductType.getCheckModel().getCheckedItems()) {
            productTypeIDS = productTypeIDS + productType.getProductTypeID() + ",";
        }
        String productCategoryIDS = "";
        for (ProductCategory productCategory : this.cbProductCategory.getCheckModel().getCheckedItems()) {
            productCategoryIDS = productCategoryIDS + productCategory.getProductCategoryID() + ",";
        }
        String aditionalFiledIDS = "";
        String aditionalFiledDetailsIDS = "";
        for (AditionalFieldDetails aditionalFieldDetails : currentPOSSelectionList) {
            if (!aditionalFieldDetails.isSelected()) continue;
            try {
                aditionalFiledDetailsIDS = aditionalFiledDetailsIDS + AditionalFieldDetails.getByName((String)aditionalFieldDetails.getName(), (Connection)this.controller.getSettings().getConnection()).getAditionalFieldDetailsID() + ",";
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        String vatIDS = "";
        for (Vat vat : this.cbVat.getCheckModel().getCheckedItems()) {
            vatIDS = vatIDS + vat.getVatID() + ",";
        }
        this.parameters.put("departmentIDS", departmentIDS);
        this.parameters.put("pointOfSaleIDS", pointOfSaleIDS);
        this.parameters.put("productTypeIDS", productTypeIDS);
        this.parameters.put("productCategoryIDS", productCategoryIDS);
        this.parameters.put("aditionalFiledIDS", aditionalFiledIDS);
        this.parameters.put("aditionalFiledDetailsIDS", aditionalFiledDetailsIDS);
        this.parameters.put("vatIDS", vatIDS);
        this.parameters.put("active", this.cbActive.isSelected());
        this.parameters.put("popustDozvoljen", ((SviArtikli)this.cbDiscountAllowed.getSelectionModel().getSelectedItem()).getId());
        this.parameters.put("merljiv", ((SviArtikli)this.cbMeasurable.getSelectionModel().getSelectedItem()).getId());
        this.parameters.put("tezinski", ((SviArtikli)this.cbIsWeight.getSelectionModel().getSelectedItem()).getId());
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void fillComboBox() {
        SviArtikli sviArtikli = new SviArtikli();
        sviArtikli.setId("-1");
        sviArtikli.setName("SviArtikli");
        SviArtikli ne = new SviArtikli();
        ne.setId("0");
        ne.setName("Ne");
        SviArtikli da = new SviArtikli();
        da.setId("1");
        da.setName("Da");
        this.cbIsWeight.getItems().addAll((Object[])new SviArtikli[]{sviArtikli, ne, da});
        this.cbMeasurable.getItems().addAll((Object[])new SviArtikli[]{sviArtikli, ne, da});
        this.cbDiscountAllowed.getItems().addAll((Object[])new SviArtikli[]{sviArtikli, ne, da});
        this.cbIsWeight.getSelectionModel().selectFirst();
        this.cbMeasurable.getSelectionModel().selectFirst();
        this.cbDiscountAllowed.getSelectionModel().selectFirst();
    }
}

