/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.trgovina;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.product.Product;

public class DetaljiRezervacijePregledTrgovinaController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private Document selectedDocument;
    private Person selectedPerson;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfNumber;
    @FXML
    private TextField tfAvans;
    @FXML
    private Label lblValue;
    @FXML
    private Label lblSelectedPerson;
    @FXML
    private TableView<DocumentDetails> tableDocument;
    @FXML
    private TableColumn<DocumentDetails, String> columnProduct;
    @FXML
    private TableColumn<Object, Double> columnQuantity;
    @FXML
    private TableColumn<Object, Double> columnPrice;
    @FXML
    private TableColumn<Object, Double> columnValue;
    @FXML
    private TableColumn<DocumentDetails, Boolean> columnStatus;
    @FXML
    private TableColumn<DocumentDetails, String> columnBarcode;
    @FXML
    private DatePicker dpDeliveryDate;
    @FXML
    private TextArea taNote;

    @FXML
    private void initialize() {
        this.tfAvans.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.columnProduct.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DocumentDetails, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DocumentDetails, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Product.getByID((long)((DocumentDetails)param.getValue()).getProductID(), (ScreensController)DetaljiRezervacijePregledTrgovinaController.this.controller)).name("ShortName").build();
                }
                catch (NoSuchMethodException | NullPointerException e) {
                    return null;
                }
            }
        });
        this.columnQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.columnPrice.setCellValueFactory((Callback)new PropertyValueFactory("PriceWithDiscount"));
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("Value"));
        this.columnBarcode.setCellValueFactory((Callback)new PropertyValueFactory("Barcode"));
        this.columnStatus.setCellValueFactory((Callback)new PropertyValueFactory("Closed"));
        this.columnStatus.setCellFactory(column -> new TableCell<DocumentDetails, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Aktivna");
                    } else {
                        this.setText("Realizovana");
                    }
                }
            }
        });
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedDocument = (Document)parameter.get("selectedDocument");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.tfNumber.setDisable(true);
        if (this.selectedDocument != null) {
            this.tfNumber.setText(String.valueOf(this.selectedDocument.getNumber()));
            this.tableDocument.setItems(DocumentDetails.getObeservableList((long)this.selectedDocument.getDocumentID(), (Connection)this.controller.getSettings().getConnection()));
            this.dpDeliveryDate.setValue((Object)Settings.fromDate((Date)this.selectedDocument.getDeliveryDate()));
            this.dpDeliveryDate.setDisable(true);
            this.taNote.setText(this.selectedDocument.getNote());
            this.tfAvans.setText(String.valueOf(this.selectedDocument.getNote2()));
            this.selectedPerson = Person.getById((long)this.selectedDocument.getPersonID(), (ScreensController)this.controller);
            this.lblSelectedPerson.setText("");
            this.lblSelectedPerson.setText(!this.selectedPerson.getName().equals("") ? this.selectedPerson.getName() : this.selectedPerson.getFirstLastName());
            this.fillLabelValue();
        } else {
            this.tfNumber.setText(String.valueOf(Document.getNextNumber((int)DocumentType.getByCode((String)"RE", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID(), (long)this.controller.getPointOfSale().getPointOfSaleID(), (ScreensController)this.controller)));
            this.dpDeliveryDate.setValue((Object)LocalDate.now());
        }
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void actionClose() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void fillLabelValue() {
        double sum = 0.0;
        for (DocumentDetails documentDetails : this.tableDocument.getItems()) {
            sum += documentDetails.getQuantity() * documentDetails.getPriceWithDiscount();
        }
        this.lblValue.setText("\t" + String.valueOf(Settings.round((double)sum, (int)2)));
    }
}

