/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.setup;

import java.util.HashMap;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Synchronization;

public class SynchronizationController
implements ControlledScreen {
    private ScreensController controller;
    private Synchronization selectedSynchronisation;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<Synchronization> tvSynchronization;
    @FXML
    private TableColumn<Synchronization, String> tcDatabase;
    @FXML
    private TableColumn<Synchronization, String> tcIpAddress;
    @FXML
    private TableColumn<Synchronization, Boolean> tcActive;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void initialize() {
        this.tvSynchronization.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Synchronization>(){

            public void onChanged(ListChangeListener.Change<? extends Synchronization> c) {
                SynchronizationController.this.selectedSynchronisation = (Synchronization)SynchronizationController.this.tvSynchronization.getSelectionModel().getSelectedItem();
            }
        });
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
        }
        this.loadSynchronizationTable();
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void addAction() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        hm.put("synchronisation", null);
        this.controller.showModalDialog("Podesavanje poklona i popusta - kreiranje", ScreensController.SCREEN_BACKOFFICE_DODAVANJE_SINHRONIZACIJE, hm, this.rootPane.getScene().getWindow());
        this.loadSynchronizationTable();
    }

    @FXML
    private void editAction() {
        if (this.selectedSynchronisation != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("synchronisation", this.selectedSynchronisation);
            this.controller.showModalDialog("Podesavanje poklona i popusta - kreiranje", ScreensController.SCREEN_BACKOFFICE_DODAVANJE_SINHRONIZACIJE, hm, this.rootPane.getScene().getWindow());
            this.loadSynchronizationTable();
        }
    }

    @FXML
    private void deleteAction() {
    }

    private void loadSynchronizationTable() {
        this.tcDatabase.setCellValueFactory((Callback)new PropertyValueFactory("databaseName"));
        this.tcIpAddress.setCellValueFactory((Callback)new PropertyValueFactory("ipAddress"));
        this.tcActive.setCellValueFactory((Callback)new PropertyValueFactory("active"));
        this.tcActive.setCellFactory(column -> new TableCell<Synchronization, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                } else {
                    this.setText("");
                }
            }
        });
        this.tvSynchronization.setItems(Synchronization.getList((ScreensController)this.controller));
        this.selectedSynchronisation = null;
    }
}

