/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.setup;

import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Present;

public class PresentAddController
implements DialogController {
    private ScreensController controller;
    private Present selectedPresent;
    private int modalResult;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfBillSumFrom;
    @FXML
    private TextField tfBillSumTo;
    @FXML
    private TextField tfDiscount;
    @FXML
    private TextField tfMoney;
    @FXML
    private CheckBox cbActivePresent;
    @FXML
    private CheckBox cbActiveDiscount;
    @FXML
    private TextArea taMessage;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.selectedPresent = (Present)parameter.get("present");
        this.loadPresent();
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void saveAction() {
        if (this.selectedPresent == null) {
            this.selectedPresent = new Present();
            if (this.cbActivePresent.isSelected() || this.cbActiveDiscount.isSelected()) {
                if (this.tfBillSumFrom.getText().equals("") || this.tfBillSumTo.getText().equals("")) {
                    this.controller.alert("Obavestenje", "Obavezno popunite izmedju kojih vrednost da poroverava racun", this.rootPane.getScene().getWindow());
                    return;
                }
                this.selectedPresent.setBillSumFrom(Double.parseDouble(this.tfBillSumFrom.getText()));
                this.selectedPresent.setBillSumTo(Double.parseDouble(this.tfBillSumTo.getText()));
                this.selectedPresent.setMessage(this.taMessage.getText().trim());
                if (this.cbActiveDiscount.isSelected()) {
                    if (!this.tfDiscount.getText().trim().equals("") || !this.tfMoney.getText().trim().equals("")) {
                        if (this.cbActiveDiscount.isSelected()) {
                            this.selectedPresent.setDiscountPercent(this.tfDiscount.getText().equals("") ? 0.0 : Double.parseDouble(this.tfDiscount.getText()));
                            if (this.selectedPresent.getDiscountPercent() == 0.0) {
                                this.selectedPresent.setDiscountMonay(this.tfMoney.getText().equals("") ? 0.0 : Double.parseDouble(this.tfMoney.getText()));
                            }
                        }
                    } else {
                        this.controller.alert("Obavestenje", "Popunite jedno od polja za popust", this.rootPane.getScene().getWindow());
                        return;
                    }
                }
                this.selectedPresent.setActivePresent(this.cbActivePresent.isSelected());
                this.selectedPresent.setActiveDiscount(this.cbActiveDiscount.isSelected());
                this.selectedPresent.insert(this.controller);
                this.modalResult = ScreensController.MODAL_RESULT_YES;
                ((Stage)this.rootPane.getScene().getWindow()).close();
            }
        }
    }

    @FXML
    private void editAction() {
        if (this.selectedPresent != null && (this.cbActivePresent.isSelected() || this.cbActiveDiscount.isSelected())) {
            if (this.tfBillSumFrom.getText().equals("") || this.tfBillSumTo.getText().equals("")) {
                this.controller.alert("Obavestenje", "Obavezno popunite izmedju kojih vrednost da poroverava racun", this.rootPane.getScene().getWindow());
                return;
            }
            this.selectedPresent.setBillSumFrom(Double.parseDouble(this.tfBillSumFrom.getText()));
            this.selectedPresent.setBillSumTo(Double.parseDouble(this.tfBillSumTo.getText()));
            this.selectedPresent.setMessage(this.taMessage.getText().trim());
            if (!this.tfDiscount.getText().trim().equals("") || !this.tfMoney.getText().trim().equals("")) {
                if (this.cbActiveDiscount.isSelected()) {
                    this.selectedPresent.setDiscountPercent(this.tfDiscount.getText().equals("") ? 0.0 : Double.parseDouble(this.tfDiscount.getText()));
                    if (this.selectedPresent.getDiscountPercent() == 0.0) {
                        this.selectedPresent.setDiscountMonay(this.tfMoney.getText().equals("") ? 0.0 : Double.parseDouble(this.tfMoney.getText()));
                    }
                }
            } else {
                this.controller.alert("Obavestenje", "Popunite jedno od polja za popust", this.rootPane.getScene().getWindow());
                return;
            }
            this.selectedPresent.setActivePresent(this.cbActivePresent.isSelected());
            this.selectedPresent.setActiveDiscount(this.cbActiveDiscount.isSelected());
            this.selectedPresent.update(this.controller);
            this.modalResult = ScreensController.MODAL_RESULT_YES;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
    }

    @FXML
    public void closeAction(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void loadPresent() {
        this.tfBillSumFrom.requestFocus();
        if (this.selectedPresent != null) {
            this.tfBillSumFrom.setText(String.valueOf(this.selectedPresent.getBillSumFrom()));
            this.tfBillSumTo.setText(String.valueOf(this.selectedPresent.getBillSumTo()));
            this.tfDiscount.setText(String.valueOf(this.selectedPresent.getDiscountPercent()));
            this.tfMoney.setText(String.valueOf(this.selectedPresent.getDiscountMonay()));
            this.taMessage.setText(String.valueOf(this.selectedPresent.getMessage()));
            this.cbActivePresent.setSelected(this.selectedPresent.isActivePresent());
            this.cbActiveDiscount.setSelected(this.selectedPresent.isActiveDiscount());
        } else {
            this.tfBillSumFrom.setText("");
            this.tfBillSumTo.setText("");
            this.tfDiscount.setText("");
            this.tfMoney.setText("");
            this.taMessage.setText("");
            this.cbActivePresent.setSelected(false);
            this.cbActiveDiscount.setSelected(false);
        }
    }
}

