/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.io.File;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WarehouseCentral;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.Product;

public class StockReportBaseWarehouseTableController
implements ControlledScreen {
    ScreensController controller;
    ObservableList<AditionalField> aditionlFieldFilter = FXCollections.observableArrayList();
    String aditionlFieldDetailsFilter = "";
    ObservableList<Product> list;
    ObservableList<TableColumn<Product, String>> columnList = FXCollections.observableArrayList();
    private ObservableList<VBox> listTreeItem = FXCollections.observableArrayList();
    private List<CheckBoxTreeItem<AditionalFieldDetails>> listAditionalFieldDetailsCheckBox = new ArrayList<CheckBoxTreeItem<AditionalFieldDetails>>();
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<WarehouseCentral> cbWarehouse;
    @FXML
    private TableView<Product> table;
    @FXML
    private TableColumn<Product, String> cKod;
    @FXML
    private TableColumn<Product, String> cBarKod;
    @FXML
    private TableColumn<Product, String> cArtikal;
    @FXML
    private TableColumn<Product, String> cJM;
    @FXML
    private TableColumn<Product, String> cCena;
    @FXML
    private TableColumn<Product, String> cStanje;
    @FXML
    private TableColumn<Product, String> cVrednost;
    @FXML
    private TextField tfFilter;
    @FXML
    private Label lblFinansijskaVrednost;
    @FXML
    private Label lblKolicinaSum;
    @FXML
    private HBox hBoxAditionalField;
    @FXML
    private TilePane tilePane;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void initialize() {
        this.table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    HashMap<String, Object> hm = new HashMap<String, Object>();
                    hm.put("controller", this.controller);
                    hm.put("product", this.table.getSelectionModel().getSelectedItem());
                    int yesOrNo = this.controller.showModalDialog("Pregled robne kartice", ScreensController.DIALOG_ROBNA_KARTICA_SKLADISTA_DETALJI_ARTIKLA, hm, this.rootPane.getScene().getWindow());
                    if (yesOrNo == ScreensController.MODAL_RESULT_OK) {
                        this.table.getSelectionModel().clearSelection();
                    }
                }
            });
            return row;
        });
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        for (WarehouseCentral warehouseCentral : WarehouseCentral.getList((ScreensController)this.controller)) {
            this.cbWarehouse.getItems().add((Object)warehouseCentral);
            if (this.cbWarehouse.getItems().isEmpty()) continue;
            this.cbWarehouse.getSelectionModel().select(0);
        }
        this.createCheckBoxAditionalField();
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void pdfAction() {
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                Product.getReceivingReportToPDF((ScreensController)StockReportBaseWarehouseTableController.this.controller, (ObservableList)StockReportBaseWarehouseTableController.this.table.getItems(), (String)"putanja", (String)"name");
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        taskUpdateStage.hide();
                    }
                });
                return null;
            }
        };
        new Thread((Runnable)creatingReport).start();
        creatingReport.setOnSucceeded(eventValue -> taskUpdateStage.hide());
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja. ", this.rootPane.getScene().getWindow());
        });
    }

    @FXML
    private void excelAction() {
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                Product.getReceivingReportToExcel((ScreensController)StockReportBaseWarehouseTableController.this.controller, (ObservableList)StockReportBaseWarehouseTableController.this.table.getItems(), (String)StockReportBaseWarehouseTableController.this.controller.getSettings().getJasperToPDF(), (String)"Lager");
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        taskUpdateStage.hide();
                        int pitanje = StockReportBaseWarehouseTableController.this.controller.yesNoDialog("Pitanje", "Da li zelite da prikazete lager listu", StockReportBaseWarehouseTableController.this.rootPane.getScene().getWindow());
                        if (pitanje == 1) {
                            FileChooser fileChooser = new FileChooser();
                            fileChooser.setTitle("Open Lager List");
                            fileChooser.setInitialFileName(StockReportBaseWarehouseTableController.this.controller.getSettings().getJasperToPDF() + File.separator + "LagerLista.xlsx");
                            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("XML files (*.xlsx)", new String[]{"*.xlsx", "*.xls"});
                            fileChooser.getExtensionFilters().add((Object)extFilter);
                            File userDirectory = new File(StockReportBaseWarehouseTableController.this.controller.getSettings().getJasperToPDF() + File.separator);
                            if (!userDirectory.canRead()) {
                                userDirectory = new File("c:/");
                            }
                            fileChooser.setInitialDirectory(userDirectory);
                            File chosenFile = fileChooser.showOpenDialog(null);
                            StockReportBaseWarehouseTableController.this.controller.printFileFromPDF(chosenFile);
                        }
                    }
                });
                return null;
            }
        };
        new Thread((Runnable)creatingReport).start();
        creatingReport.setOnSucceeded(eventValue -> taskUpdateStage.hide());
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja. ", this.rootPane.getScene().getWindow());
        });
    }

    private void populateTable(ObservableList<Product> list) {
        this.table.getItems().clear();
        this.cKod.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.cBarKod.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.cArtikal.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.cJM.setCellValueFactory((Callback)new PropertyValueFactory("UnitName"));
        this.cCena.setCellValueFactory((Callback)new PropertyValueFactory("nabavnaCenaBezPopusta"));
        this.cStanje.setCellValueFactory((Callback)new PropertyValueFactory("Stock"));
        this.cVrednost.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        String filter = "";
        if (!this.aditionlFieldFilter.isEmpty()) {
            for (AditionalField str : this.aditionlFieldFilter) {
                filter = filter + str.getAditionalFieldID() + ",";
            }
        }
        try {
            final ObservableList aditionalFieldList = AditionalField.getListWithFilter((String)filter.substring(0, filter.length() - 1), (Connection)this.controller.getSettings().getConnection());
            for (int i = 0; i < aditionalFieldList.size(); ++i) {
                final int num = i;
                TableColumn column = new TableColumn(((AditionalField)aditionalFieldList.get(i)).getName());
                column.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Product, String>, ObservableValue<String>>(){

                    public ObservableValue<String> call(TableColumn.CellDataFeatures<Product, String> param) {
                        try {
                            return new JavaBeanStringPropertyBuilder().bean((Object)AditionalFieldDetails.getByProductID((long)((Product)param.getValue()).getProductID(), (long)((AditionalField)aditionalFieldList.get(num)).getAditionalFieldID(), (Connection)StockReportBaseWarehouseTableController.this.controller.getSettings().getConnection())).name("Name").build();
                        }
                        catch (NoSuchMethodException | NullPointerException e) {
                            return null;
                        }
                    }
                });
                column.setResizable(true);
                column.setMinWidth(80.0);
                column.setPrefWidth(80.0);
                column.setMaxWidth(1000.0);
                column.setEditable(true);
                column.setSortable(true);
                column.setSortType(TableColumn.SortType.ASCENDING);
                this.columnList.add((Object)column);
                this.table.getColumns().add((Object)column);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.table.setItems(list);
        this.tfFilter.setText("");
        this.sumVrednostArtikala();
        this.sumArtikala();
    }

    private void sumVrednostArtikala() {
        double vrednost = 0.0;
        for (Product product : this.table.getItems()) {
            vrednost += product.getPrice();
        }
        this.lblFinansijskaVrednost.setText(Settings.getNumberFormat((int)2, (boolean)false).format(vrednost));
    }

    private void sumArtikala() {
        double vrednost = 0.0;
        for (Product product : this.table.getItems()) {
            vrednost += product.getStock();
        }
        this.lblKolicinaSum.setText(Settings.getNumberFormat((int)2, (boolean)false).format(vrednost));
    }

    private void createCheckBoxAditionalField() {
        final ObservableList aditionalFieldList = AditionalField.getList((Connection)this.controller.getSettings().getConnection());
        for (int i = 0; i < aditionalFieldList.size(); ++i) {
            final int index = i;
            final CheckBox checkBox = new CheckBox(((AditionalField)aditionalFieldList.get(i)).getName());
            checkBox.setPrefWidth(150.0);
            this.hBoxAditionalField.getChildren().add((Object)checkBox);
            checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    AditionalField aField = AditionalField.getByName((String)checkBox.getText(), (Connection)StockReportBaseWarehouseTableController.this.controller.getSettings().getConnection());
                    if (newValue.booleanValue()) {
                        StockReportBaseWarehouseTableController.this.aditionlFieldFilter.add((Object)aField);
                        TreeView treeView = new TreeView();
                        treeView.setId(aField.getName());
                        treeView.setCellFactory(p -> new CheckBoxTreeCell<AditionalFieldDetails>(){

                            public void updateItem(AditionalFieldDetails item, boolean empty) {
                                super.updateItem((Object)item, empty);
                                if (item != null) {
                                    this.setText(item.getName());
                                }
                            }
                        });
                        CheckBoxTreeItem treeItem = new CheckBoxTreeItem();
                        AditionalFieldDetails afd = new AditionalFieldDetails();
                        afd.setName(aField.getName());
                        treeItem.setValue((Object)afd);
                        for (AditionalFieldDetails aditionalFieldDetails : AditionalFieldDetails.getListByAditionalFieldID((long)((AditionalField)aditionalFieldList.get(index)).getAditionalFieldID(), (Connection)StockReportBaseWarehouseTableController.this.controller.getSettings().getConnection())) {
                            CheckBoxTreeItem afdmenu = new CheckBoxTreeItem();
                            afdmenu.setValue((Object)aditionalFieldDetails);
                            afdmenu.setIndependent(true);
                            treeItem.getChildren().add((Object)afdmenu);
                            StockReportBaseWarehouseTableController.this.listAditionalFieldDetailsCheckBox.add(afdmenu);
                        }
                        treeView.setPrefWidth(140.0);
                        treeView.setRoot((TreeItem)treeItem);
                        treeView.setShowRoot(false);
                        Label label = new Label(treeView.getId());
                        VBox vBox = new VBox();
                        vBox.setId(aField.getName());
                        vBox.setPadding(new Insets(0.0, 0.0, 40.0, 0.0));
                        vBox.getChildren().add((Object)label);
                        vBox.getChildren().add((Object)treeView);
                        StockReportBaseWarehouseTableController.this.tilePane.setVisible(true);
                        StockReportBaseWarehouseTableController.this.tilePane.getChildren().add((Object)vBox);
                        StockReportBaseWarehouseTableController.this.listTreeItem.add((Object)vBox);
                    } else {
                        StockReportBaseWarehouseTableController.this.aditionlFieldFilter.remove((Object)aField);
                        if (!StockReportBaseWarehouseTableController.this.listTreeItem.isEmpty()) {
                            for (VBox treeView : StockReportBaseWarehouseTableController.this.listTreeItem) {
                                if (!treeView.getId().equals(aField.getName())) continue;
                                Iterator iterator = StockReportBaseWarehouseTableController.this.listAditionalFieldDetailsCheckBox.iterator();
                                while (iterator.hasNext()) {
                                    CheckBoxTreeItem value = (CheckBoxTreeItem)iterator.next();
                                    if (!treeView.getChildren().contains((Object)value)) continue;
                                    iterator.remove();
                                }
                                StockReportBaseWarehouseTableController.this.tilePane.getChildren().remove((Object)treeView);
                            }
                        }
                    }
                }
            });
            this.hBoxAditionalField.setPadding(new Insets(0.0, 10.0, 10.0, 10.0));
        }
    }

    @FXML
    private void showTable() {
        this.aditionlFieldDetailsFilter = "";
        this.tilePane.setVisible(false);
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje artikala u toku.", this.rootPane.getScene().getWindow());
        for (CheckBoxTreeItem<AditionalFieldDetails> ti : this.listAditionalFieldDetailsCheckBox) {
            if (!ti.isSelected()) continue;
            this.aditionlFieldDetailsFilter = this.aditionlFieldDetailsFilter + ((AditionalFieldDetails)ti.getValue()).getAditionalFieldDetailsID() + ",";
        }
        Task<ObservableList<Product>> loadingCsvTask = new Task<ObservableList<Product>>(){

            protected ObservableList<Product> call() throws Exception {
                LocalDate currentDate = LocalDate.now();
                try {
                    StockReportBaseWarehouseTableController.this.list = Product.getNewReceivingReportCentralniMagacin((String)StockReportBaseWarehouseTableController.this.tfFilter.getText(), StockReportBaseWarehouseTableController.this.aditionlFieldFilter, (String)StockReportBaseWarehouseTableController.this.aditionlFieldDetailsFilter.substring(0, StockReportBaseWarehouseTableController.this.aditionlFieldDetailsFilter.length() - 1), (ScreensController)StockReportBaseWarehouseTableController.this.controller, (int)((WarehouseCentral)StockReportBaseWarehouseTableController.this.cbWarehouse.getSelectionModel().getSelectedItem()).getWarehouseId());
                }
                catch (StringIndexOutOfBoundsException ex) {
                    StockReportBaseWarehouseTableController.this.list = Product.getNewReceivingReportCentralniMagacin((String)StockReportBaseWarehouseTableController.this.tfFilter.getText(), StockReportBaseWarehouseTableController.this.aditionlFieldFilter, (String)StockReportBaseWarehouseTableController.this.aditionlFieldDetailsFilter, (ScreensController)StockReportBaseWarehouseTableController.this.controller, (int)((WarehouseCentral)StockReportBaseWarehouseTableController.this.cbWarehouse.getSelectionModel().getSelectedItem()).getWarehouseId());
                }
                return StockReportBaseWarehouseTableController.this.list;
            }
        };
        loadingCsvTask.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            if (!this.columnList.isEmpty()) {
                for (TableColumn column : this.columnList) {
                    this.table.getColumns().remove((Object)column);
                }
            }
            this.populateTable(this.list);
            this.table.setVisible(true);
            this.filter();
        });
        loadingCsvTask.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje", this.rootPane.getScene().getWindow());
        });
        loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        new Thread((Runnable)loadingCsvTask).start();
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.list, p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> {
            filteredData.setPredicate(product -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                try {
                    if (product.getCode().toLowerCase().contains(lowerCaseFilter)) {
                        return true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    if (product.getBarcode().toLowerCase().contains(lowerCaseFilter)) {
                        return true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return false;
            });
            this.sumVrednostArtikala();
            this.sumArtikala();
        });
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
        this.table.setItems((ObservableList)sortedData);
    }
}

