/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.io.InputStream;
import java.sql.Connection;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JasperViewer;
import rs.petcom.backoffice.controller.reports.ReportMapModel;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.SalesReportByDays;

public class SalesReportByDaysController
implements ControlledScreen {
    private ScreensController controller;
    private WorkDay wd;
    private Connection connection;
    private ObservableList<SalesReportByDays> revenuesList;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label title;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private Button btnPrint;
    @FXML
    private TableView<SalesReportByDays> tblReportData;
    @FXML
    private TableColumn<SalesReportByDays, LocalDate> colDate;
    @FXML
    private TableColumn<SalesReportByDays, Double> colRevenue;
    @FXML
    private TableColumn<SalesReportByDays, Double> colFromCash;
    @FXML
    private TableColumn<SalesReportByDays, Double> colFromCard;
    @FXML
    private TableColumn<SalesReportByDays, Double> colFromCheck;
    @FXML
    private TableColumn<SalesReportByDays, Double> colFromInvoice;
    @FXML
    private TableColumn<SalesReportByDays, Double> colFromCombined;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.connection = this.controller.getSettings().getConnection();
    }

    public void setParameter(Object parameter) {
        this.wd = WorkDay.getLastOpenWD((ScreensController)this.controller);
        this.dpFrom.setValue((Object)this.fromDateToLocalDate(this.wd.getDate()));
        this.dpTo.setValue((Object)this.fromDateToLocalDate(this.wd.getDate()));
        this.colDate.setCellValueFactory((Callback)new PropertyValueFactory("revenueDate"));
        this.colRevenue.setCellValueFactory((Callback)new PropertyValueFactory("Revenue"));
        this.colFromCard.setCellValueFactory((Callback)new PropertyValueFactory("fromCard"));
        this.colFromCash.setCellValueFactory((Callback)new PropertyValueFactory("fromCash"));
        this.colFromCheck.setCellValueFactory((Callback)new PropertyValueFactory("fromDocCheck"));
        this.colFromInvoice.setCellValueFactory((Callback)new PropertyValueFactory("fromInvoice"));
        this.colFromCombined.setCellValueFactory((Callback)new PropertyValueFactory("fromCombined"));
        this.dpFrom.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (SalesReportByDaysController.this.validateDate()) {
                    SalesReportByDaysController.this.populateTable();
                }
            }
        });
        this.dpTo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (SalesReportByDaysController.this.validateDate()) {
                    SalesReportByDaysController.this.populateTable();
                }
            }
        });
        this.populateTable();
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    public void printAction() {
        Date from = Settings.fromLocalDate((LocalDate)((LocalDate)this.dpFrom.getValue()));
        Date to = Settings.fromLocalDate((LocalDate)((LocalDate)this.dpTo.getValue()));
        boolean isCombined = false;
        String source = "rs/petcom/backoffice/jasper/salesByDaysReport.jasper";
        JRBeanCollectionDataSource datasource = new JRBeanCollectionDataSource(this.revenuesList);
        Map<String, Double> summaryMap = this.makeSummary();
        isCombined = summaryMap.get("combined") > 0.0;
        Map<String, Object> parametersMap = ReportMapModel.getReportMap(this.controller);
        parametersMap.put("datasource", datasource);
        parametersMap.put("dateFrom", from);
        parametersMap.put("dateTo", to);
        parametersMap.put("summary", summaryMap);
        parametersMap.put("isCombined", isCombined);
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)source));
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)report, parametersMap, (JRDataSource)datasource);
            JasperViewer.viewReport((JasperPrint)jp, (boolean)false);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void populateTable() {
        Date from = Settings.fromLocalDate((LocalDate)((LocalDate)this.dpFrom.getValue()));
        Date to = Settings.fromLocalDate((LocalDate)((LocalDate)this.dpTo.getValue()));
        this.tblReportData.getItems().clear();
        this.revenuesList = SalesReportByDays.getRevenues((ScreensController)this.controller, (Date)from, (Date)to);
        this.tblReportData.setItems(this.revenuesList);
    }

    private LocalDate fromDateToLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private boolean validateDate() {
        Date firstWdDate = WorkDay.getFirstStart((Connection)this.connection);
        Date lastWDate = this.wd.getDate();
        if (((LocalDate)this.dpFrom.getValue()).isBefore(this.fromDateToLocalDate(firstWdDate))) {
            this.controller.alert("Nepostoje\u0107i Datum", "Izabrali ste datum pre otvaranja prvog radnog dana", this.rootPane.getScene().getWindow());
            this.dpFrom.setValue((Object)this.fromDateToLocalDate(this.wd.getDate()));
            return false;
        }
        if (((LocalDate)this.dpTo.getValue()).isAfter(this.fromDateToLocalDate(lastWDate))) {
            this.controller.alert("Nepostoje\u0107i Datum", "Izabrali ste datum koji je ve\u0107i od datuma otvorenog dana", this.rootPane.getScene().getWindow());
            this.dpTo.setValue((Object)this.fromDateToLocalDate(this.wd.getDate()));
            return false;
        }
        return true;
    }

    private Map<String, Double> makeSummary() {
        double cash = 0.0;
        double card = 0.0;
        double check = 0.0;
        double invoice = 0.0;
        double combined = 0.0;
        double combinedFromCash = 0.0;
        double combinedFromCard = 0.0;
        double combinedFromCheck = 0.0;
        double NI = 0.0;
        double sumRevenue = 0.0;
        HashMap<String, Double> summaryMap = new HashMap<String, Double>();
        for (SalesReportByDays sbd : this.revenuesList) {
            cash += sbd.getFromCash();
            card += sbd.getFromCard();
            check += sbd.getFromDocCheck();
            invoice += sbd.getFromInvoice();
            combined += sbd.getFromCombined();
            combinedFromCash += sbd.getCashCombined();
            combinedFromCard += sbd.getCardCombined();
            combinedFromCheck += sbd.getCheckCombined();
            NI += sbd.getNI();
        }
        sumRevenue = cash + card + check + invoice;
        summaryMap.put("cash", cash);
        summaryMap.put("card", card);
        summaryMap.put("check", check);
        summaryMap.put("invoice", invoice);
        summaryMap.put("combined", combined);
        summaryMap.put("combinedFromCash", combinedFromCash);
        summaryMap.put("combinedFromCard", combinedFromCard);
        summaryMap.put("CombinedFromCheck", combinedFromCheck);
        summaryMap.put("NI", NI);
        summaryMap.put("sumRevenue", sumRevenue);
        return summaryMap;
    }
}

