/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategoryEnum;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class LoyalityBillController
implements ControlledScreen {
    ScreensController controller;
    ObservableList<Person> stalniList = FXCollections.observableArrayList();
    ObservableList<Person> list = FXCollections.observableArrayList();
    ObservableList<Document> listRacuna = FXCollections.observableArrayList();
    PersonCategoryEnum pce;
    HashMap<String, PersonCategoryEnum> mapa;
    StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String toString(LocalDate date) {
            if (date != null) {
                return this.dateFormatter.format(date);
            }
            return "";
        }

        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalDate.parse(string, this.dateFormatter);
            }
            return null;
        }
    };
    @FXML
    BorderPane rootPane;
    @FXML
    ComboBox<Object> cbObjekat;
    @FXML
    ComboBox<PaymentMethod> cbNacinPlacanja;
    @FXML
    DatePicker dpDanOd;
    @FXML
    DatePicker dpDanDo;
    @FXML
    Button btnPrint;
    @FXML
    TextField tfFilter;
    @FXML
    private TableView<Person> tvTable1;
    @FXML
    private TableColumn<Person, String> tcName;
    @FXML
    private TableColumn<Person, String> tcFirstName;
    @FXML
    private TableColumn<Person, String> tcLastName;
    @FXML
    private TableColumn<Person, String> tcCity;
    @FXML
    private TableView<Document> tvTable2;
    @FXML
    private TableColumn<Document, Integer> tcDocumentID;
    @FXML
    private TableColumn<Document, java.util.Date> tcDate;
    @FXML
    private TableColumn<Document, Double> tcSum;
    @FXML
    private TableColumn<Document, Double> tcDiscount;
    @FXML
    private TableColumn<Document, Double> tcSumWithDiscount;
    @FXML
    private TableColumn<Document, String> tcPaymentMethodName;
    @FXML
    private TableColumn<Document, String> tcFullNumber;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.dpDanOd.setConverter(this.converter);
        this.dpDanDo.setConverter(this.converter);
        this.dpDanOd.setValue((java.lang.Object)Settings.fromDate((java.util.Date)WorkDay.getFirstStart((Connection)this.controller.getSettings().getConnection())));
        this.dpDanDo.setValue((java.lang.Object)LocalDate.now());
        Object sviObjekti = new Object();
        sviObjekti.setObjectID(-1);
        sviObjekti.setName("Svi objekti");
        this.cbObjekat.getItems().add((java.lang.Object)sviObjekti);
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObjekat.getItems().add((java.lang.Object)o);
            if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
            this.cbObjekat.getSelectionModel().select((java.lang.Object)o);
            this.cbObjekat.setDisable(true);
            break;
        }
        this.popuniFilterNacinPlacanja();
    }

    private void popuniFilterNacinPlacanja() {
        this.cbNacinPlacanja.getItems().clear();
        PaymentMethod pm = new PaymentMethod();
        pm.setPaymentMethodID(-1);
        pm.setName("Sva placanja");
        this.cbNacinPlacanja.getItems().add((java.lang.Object)pm);
        for (PaymentMethod pmt : PaymentMethod.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbNacinPlacanja.getItems().add((java.lang.Object)pmt);
        }
        this.cbNacinPlacanja.getSelectionModel().select((java.lang.Object)pm);
    }

    public void setParameter(java.lang.Object parameter) {
        this.mapa = (HashMap)parameter;
        this.pce = this.mapa.get("personCategory");
        this.loadStalniList();
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        this.dpDanOd.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LoyalityBillController.this.loadStalniList();
                LoyalityBillController.this.tvTable2.refresh();
            }
        });
        this.dpDanDo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LoyalityBillController.this.loadStalniList();
                LoyalityBillController.this.tvTable2.refresh();
            }
        });
        this.cbNacinPlacanja.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LoyalityBillController.this.loadStalniList();
                LoyalityBillController.this.tvTable2.refresh();
            }
        });
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                LoyalityBillController.this.loadStalniList();
            }
        });
        this.tfFilter.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (newPropertyValue.booleanValue()) {
                    LoyalityBillController.this.tvTable1.getSelectionModel().clearSelection();
                }
            }
        });
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcFirstName.setCellValueFactory((Callback)new PropertyValueFactory("FirstName"));
        this.tcLastName.setCellValueFactory((Callback)new PropertyValueFactory("LastName"));
        this.tcCity.setCellValueFactory((Callback)new PropertyValueFactory("City"));
        this.tvTable1.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Person>(){

            public void changed(ObservableValue<? extends Person> observable, Person oldValue, Person newValue) {
                LoyalityBillController.this.loadRacuni();
            }
        });
        this.tvTable2.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
                    hm.put("controller", this.controller);
                    hm.put("document", this.tvTable2.getSelectionModel().getSelectedItem());
                    hm.put("person", this.tvTable1.getSelectionModel().getSelectedItem());
                    int yesOrNo = this.controller.showModalDialog("Pregled racuna", ScreensController.DIALOG_DOCUMENT_DETAILES_STALNI_KUPAC, hm, this.rootPane.getScene().getWindow());
                    if (yesOrNo == ScreensController.MODAL_RESULT_OK) {
                        this.tvTable2.getSelectionModel().clearSelection();
                    }
                }
            });
            return row;
        });
    }

    @FXML
    private void changeObjekat() {
    }

    @FXML
    private void commitPrint() {
        this.printJasper();
    }

    private void loadStalniList() {
        this.stalniList = Person.getLoyalityList((Connection)this.controller.getSettings().getConnection(), (int)this.pce.getPersonCategoryId());
        this.tvTable1.setItems(this.stalniList);
    }

    private void loadRacuni() {
        this.tcDocumentID.setCellValueFactory((Callback)new PropertyValueFactory("DocumentID"));
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcSum.setCellValueFactory((Callback)new PropertyValueFactory("Sum"));
        this.tcSum.setCellFactory((Callback)new Callback<TableColumn<Document, Double>, TableCell<Document, Double>>(){

            public TableCell<Document, Double> call(TableColumn<Document, Double> param) {
                return new TableCell<Document, Double>(){

                    protected void updateItem(Double item, boolean empty) {
                        super.updateItem((java.lang.Object)item, empty);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                        }
                    }
                };
            }
        });
        this.tcDiscount.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.tcDiscount.setCellFactory((Callback)new Callback<TableColumn<Document, Double>, TableCell<Document, Double>>(){

            public TableCell<Document, Double> call(TableColumn<Document, Double> param) {
                return new TableCell<Document, Double>(){

                    protected void updateItem(Double item, boolean empty) {
                        super.updateItem((java.lang.Object)item, empty);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                        }
                    }
                };
            }
        });
        this.tcSumWithDiscount.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.tcSumWithDiscount.setCellFactory((Callback)new Callback<TableColumn<Document, Double>, TableCell<Document, Double>>(){

            public TableCell<Document, Double> call(TableColumn<Document, Double> param) {
                return new TableCell<Document, Double>(){

                    protected void updateItem(Double item, boolean empty) {
                        super.updateItem((java.lang.Object)item, empty);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                        }
                    }
                };
            }
        });
        this.tcPaymentMethodName.setCellValueFactory((Callback)new PropertyValueFactory("PaymentMethodName"));
        this.tcFullNumber.setCellValueFactory((Callback)new PropertyValueFactory("FullNumber"));
        try {
            this.listRacuna = Document.getStalniGostRacun((int)((Object)this.cbObjekat.getSelectionModel().getSelectedItem()).getObjectID(), (java.util.Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDanOd.getValue())), (java.util.Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDanDo.getValue())), (int)((PaymentMethod)this.cbNacinPlacanja.getSelectionModel().getSelectedItem()).getPaymentMethodID(), (long)((Person)this.tvTable1.getSelectionModel().getSelectedItem()).getPersonID(), (Connection)this.controller.getSettings().getConnection());
            this.tvTable2.setItems(this.listRacuna);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void printJasper() {
        String reportFileName = "rs/petcom/backoffice/jasper/RacunStalniKupacSvi.jasper";
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        if (file.exists() && file.isFile()) {
            hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        } else {
            hm.put("memorandum", "");
        }
        hm.put("objekatIme", this.controller.getObject());
        hm.put("objectID", this.controller.getObject().getObjectID());
        hm.put("datumOD", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDanOd.getValue())).getTime()));
        hm.put("datumDo", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDanDo.getValue())).getTime()));
        hm.put("paymentMethodID", ((PaymentMethod)this.cbNacinPlacanja.getSelectionModel().getSelectedItem()).getPaymentMethodID());
        hm.put("personID", Person.getById((long)((Person)this.tvTable1.getSelectionModel().getSelectedItem()).getPersonID(), (ScreensController)this.controller));
        if (this.tvTable2.getSelectionModel().getSelectedItem() != null) {
            hm.put("documentID", ((Document)this.tvTable2.getSelectionModel().getSelectedItem()).getDocumentID());
        } else {
            String documents = "";
            for (Document doc : this.tvTable2.getItems()) {
                documents = documents + Long.toString(doc.getDocumentID());
                documents = documents + ",";
            }
            hm.put("documentID", documents.substring(0, documents.length() - 1));
        }
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Svi racuni", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void printAction() {
        String reportFileName = "rs/petcom/backoffice/jasper/RacunStalniKupacSviNew.jasper";
        JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource((Collection)this.tvTable2.getItems());
        HashMap<String, String> hm = new HashMap<String, String>();
        File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        if (file.exists() && file.isFile()) {
            hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        } else {
            hm.put("memorandum", "");
        }
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (JRDataSource)beanColDataSource);
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Povrat", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

