/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.io.File;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.swing.filechooser.FileSystemView;
import rs.petcom.backoffice.reports.models.ListOfSaleAndReservationsModel;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;

public class ListOfSaleAndReservationsController
implements ControlledScreen {
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private TableColumn<ListOfSaleAndReservationsModel, Double> colQuantity;
    @FXML
    private TableColumn<ListOfSaleAndReservationsModel, Double> colPrice;
    @FXML
    private TableColumn<ListOfSaleAndReservationsModel, Double> colDiscount;
    @FXML
    private TableColumn<ListOfSaleAndReservationsModel, Double> colRabat;
    @FXML
    private TableColumn<ListOfSaleAndReservationsModel, Double> colValueWithRabat;
    @FXML
    private TableColumn<ListOfSaleAndReservationsModel, String> colDocNumber;
    @FXML
    private TableColumn<ListOfSaleAndReservationsModel, String> colPerson;
    @FXML
    private TableColumn<ListOfSaleAndReservationsModel, String> colBarCode;
    @FXML
    private TableColumn<ListOfSaleAndReservationsModel, String> colProductName;
    @FXML
    private TableView<ListOfSaleAndReservationsModel> tblSalesList;
    @FXML
    private TableColumn<ListOfSaleAndReservationsModel, Integer> colNumber;
    @FXML
    private Button btnExportExcel;
    @FXML
    private Label title;
    private ScreensController controller;
    @FXML
    private Label labSellValue;
    @FXML
    private Label labRabat;
    @FXML
    private Label labSellValueWithoutRabat;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    public void setParameter(Object parameter) {
        WorkDay wd = WorkDay.getLastOpenWD((ScreensController)this.controller);
        Date firstDayInMonth = Settings.getFirstDateOfMonth((Date)wd.getDate());
        this.dpDateFrom.setValue((Object)Settings.fromDate((Date)firstDayInMonth));
        this.dpDateTo.setValue((Object)Settings.fromDate((Date)wd.getDate()));
        this.dpDateFrom.valueProperty().addListener((ov, oldValue, newValue) -> this.loadTableData());
        this.dpDateTo.valueProperty().addListener((ov, oldValue, newValue) -> this.loadTableData());
        this.colNumber.setCellValueFactory((Callback)new PropertyValueFactory("number"));
        this.colDocNumber.setCellValueFactory((Callback)new PropertyValueFactory("docNumber"));
        this.colPerson.setCellValueFactory((Callback)new PropertyValueFactory("person"));
        this.colBarCode.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.colProductName.setCellValueFactory((Callback)new PropertyValueFactory("productName"));
        this.colQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("priceWithvat"));
        this.colDiscount.setCellValueFactory((Callback)new PropertyValueFactory("discount"));
        this.colRabat.setCellValueFactory((Callback)new PropertyValueFactory("rabat"));
        this.colValueWithRabat.setCellValueFactory((Callback)new PropertyValueFactory("selValueWithRabat"));
        this.loadTableData();
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    void excelExport(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(FileSystemView.getFileSystemView().getHomeDirectory().getAbsoluteFile());
        fileChooser.setTitle(this.controller.getBundle().getString("selectFileForExport"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("XLS files (*.xls)", new String[]{"*.xlsx"}));
        final File file = fileChooser.showSaveDialog(this.controller.getRoot().getScene().getWindow());
        if (fileChooser.getSelectedExtensionFilter() != null && fileChooser.getSelectedExtensionFilter().getExtensions() != null) {
            String filePath;
            List selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
            int extensionLength = 0;
            if (selectedExtension.contains("*.PDF") || selectedExtension.contains("*.CSV")) {
                extensionLength = 4;
            }
            if (selectedExtension.contains("*.XLSX") || selectedExtension.contains("*.DOCX")) {
                extensionLength = 5;
            }
            String nameWithoutExt = file.getName().substring(0, file.getName().length() - extensionLength);
            String pathWithoutExt = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - extensionLength);
            String pathWithoutName = pathWithoutExt.substring(0, pathWithoutExt.lastIndexOf(nameWithoutExt) - 1);
            if (file != null && !(filePath = file.getAbsolutePath()).toUpperCase().endsWith(".CSV")) {
                filePath = filePath + ".xml";
            }
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
            Task<Void> creatingReport = new Task<Void>(){

                protected Void call() throws Exception {
                    ListOfSaleAndReservationsModel.listOfsaleToExcel(file, (ObservableList<ListOfSaleAndReservationsModel>)ListOfSaleAndReservationsController.this.tblSalesList.getItems());
                    return null;
                }
            };
            creatingReport.setOnSucceeded(eventValue -> taskUpdateStage.hide());
            creatingReport.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Greska prilikom Export-a", "Export nije uspeo", this.rootPane.getScene().getWindow());
            });
            creatingReport.exceptionProperty().addListener((obsValue, oldValue, newValue) -> {
                if (newValue != null) {
                    newValue.printStackTrace();
                }
            });
            new Thread((Runnable)creatingReport).start();
        }
    }

    private void loadTableData() {
        double sellValue = 0.0;
        double rabat = 0.0;
        double sellValueWithRabat = 0.0;
        Date from = Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue()));
        Date to = Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue()));
        ObservableList<ListOfSaleAndReservationsModel> tableDatas = ListOfSaleAndReservationsModel.getListOfSaleDatas(this.controller, from, to);
        for (ListOfSaleAndReservationsModel model : tableDatas) {
            sellValue += model.getSelValue();
            rabat += model.getRabat();
            sellValueWithRabat += model.getSelValueWithRabat();
        }
        DecimalFormat decimalFormatter = new DecimalFormat("##.############");
        decimalFormatter.setMinimumFractionDigits(2);
        decimalFormatter.setMaximumFractionDigits(2);
        this.labSellValue.setText(decimalFormatter.format(sellValue));
        this.labRabat.setText(decimalFormatter.format(rabat));
        this.labSellValueWithoutRabat.setText(decimalFormatter.format(sellValueWithRabat));
        this.tblSalesList.getItems().clear();
        this.tblSalesList.setItems(tableDatas);
    }
}

