/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.reports;

import java.io.InputStream;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.DPULIstData;
import rs.petcom.master.dal.DPUList;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.gui.EditingTableCellDouble;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class DPUDetailesController
implements DialogController {
    private ScreensController controller;
    private HashMap<String, Object> parameter;
    private int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    private rs.petcom.master.dal.Object object;
    private DPUList dpuList;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObject;
    @FXML
    private DatePicker dpDatum;
    @FXML
    private TableView<DPULIstData> tableDI;
    @FXML
    private TableColumn<DPULIstData, String> tcDiNumber;
    @FXML
    private TableColumn<Object, Double> tcDiSum;
    @FXML
    private TableColumn<Object, Double> tcDiCash;
    @FXML
    private TableColumn<Object, Double> tcDiCard;
    @FXML
    private TableColumn<Object, Double> tcDiRest;
    @FXML
    private TableView<DPULIstData> tableNI;
    @FXML
    private TableColumn<DPULIstData, String> tcNiNumber;
    @FXML
    private TableColumn<Object, Double> tcNiSum;
    @FXML
    private TableColumn<Object, Double> tcNiCash;
    @FXML
    private TableColumn<Object, Double> tcNiCard;
    @FXML
    private TableColumn<Object, Double> tcNiRest;
    @FXML
    private TableView<DPULIstData> tableSF;
    @FXML
    private TableColumn<DPULIstData, String> tcSfNumber;
    @FXML
    private TableColumn<Object, Double> tcSfSum;
    @FXML
    private TableColumn<Object, Double> tcSfCash;
    @FXML
    private TableColumn<Object, Double> tcSfCard;
    @FXML
    private TableColumn<Object, Double> tcSfRest;
    @FXML
    private Button btnClose;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnPrint;

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.dpuList = (DPUList)parameter.get("dpuList");
        this.object = (rs.petcom.master.dal.Object)parameter.get("object");
        if (this.dpuList == null) {
            this.dpuList = new DPUList();
            this.dpuList.setDate(new Date());
            this.dpuList.setObjectID(((rs.petcom.master.dal.Object)parameter.get("object")).getObjectID());
            this.loadTables();
        } else {
            this.loadTables();
        }
        this.dpDatum.setValue((Object)Settings.fromDate((Date)this.dpuList.getDate()));
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        EventHandler<TableColumn.CellEditEvent<DPULIstData, String>> stringHandler = new EventHandler<TableColumn.CellEditEvent<DPULIstData, String>>(){

            public void handle(TableColumn.CellEditEvent<DPULIstData, String> event) {
                ((DPULIstData)event.getTableView().getItems().get(event.getTablePosition().getRow())).setNumber((String)event.getNewValue());
            }
        };
        Callback<TableColumn<Object, Double>, TableCell<Object, Double>> doubleCellFactory = new Callback<TableColumn<Object, Double>, TableCell<Object, Double>>(){

            public TableCell<Object, Double> call(TableColumn<Object, Double> p) {
                return new EditingTableCellDouble(2, true);
            }
        };
        this.tcDiNumber.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDiNumber.setCellFactory(TextFieldTableCell.forTableColumn());
        this.tcDiNumber.setOnEditCommit((EventHandler)stringHandler);
        this.tcDiSum.setCellValueFactory((Callback)new PropertyValueFactory("Sum"));
        this.tcDiSum.setCellFactory((Callback)doubleCellFactory);
        this.tcDiCash.setCellValueFactory((Callback)new PropertyValueFactory("Cash"));
        this.tcDiCash.setCellFactory((Callback)doubleCellFactory);
        this.tcDiCash.setOnEditCommit(t -> {
            DPULIstData dd = (DPULIstData)this.tableDI.getItems().get(t.getTablePosition().getRow());
            dd.setCash(((Double)t.getNewValue()).doubleValue());
            dd.setSum(dd.getCash() + dd.getCard() + dd.getNonFiscal());
            this.tableDI.getItems().set(t.getTablePosition().getRow(), (Object)dd);
        });
        this.tcDiCard.setCellValueFactory((Callback)new PropertyValueFactory("Card"));
        this.tcDiCard.setCellFactory((Callback)doubleCellFactory);
        this.tcDiCard.setOnEditCommit(t -> {
            DPULIstData dd = (DPULIstData)this.tableDI.getItems().get(t.getTablePosition().getRow());
            dd.setCard(((Double)t.getNewValue()).doubleValue());
            dd.setSum(dd.getCash() + dd.getCard() + dd.getNonFiscal());
            this.tableDI.getItems().set(t.getTablePosition().getRow(), (Object)dd);
        });
        this.tcDiRest.setCellValueFactory((Callback)new PropertyValueFactory("NonFiscal"));
        this.tcDiRest.setCellFactory((Callback)doubleCellFactory);
        this.tcDiRest.setOnEditCommit(t -> {
            DPULIstData dd = (DPULIstData)this.tableDI.getItems().get(t.getTablePosition().getRow());
            dd.setNonFiscal(((Double)t.getNewValue()).doubleValue());
            dd.setSum(dd.getCash() + dd.getCard() + dd.getNonFiscal());
            this.tableDI.getItems().set(t.getTablePosition().getRow(), (Object)dd);
        });
        this.tcNiNumber.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcNiSum.setCellValueFactory((Callback)new PropertyValueFactory("Sum"));
        this.tcNiCash.setCellValueFactory((Callback)new PropertyValueFactory("Cash"));
        this.tcNiCard.setCellValueFactory((Callback)new PropertyValueFactory("Card"));
        this.tcNiRest.setCellValueFactory((Callback)new PropertyValueFactory("NonFiscal"));
        this.tcSfNumber.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcSfNumber.setCellFactory(TextFieldTableCell.forTableColumn());
        this.tcSfNumber.setOnEditCommit((EventHandler)stringHandler);
        this.tcSfSum.setCellValueFactory((Callback)new PropertyValueFactory("Sum"));
        this.tcSfCash.setCellValueFactory((Callback)new PropertyValueFactory("Cash"));
        this.tcSfCash.setCellFactory((Callback)doubleCellFactory);
        this.tcSfCash.setOnEditCommit(t -> {
            DPULIstData dd = (DPULIstData)this.tableSF.getItems().get(t.getTablePosition().getRow());
            dd.setCash(((Double)t.getNewValue()).doubleValue());
            dd.setSum(dd.getCash() + dd.getCard() + dd.getNonFiscal());
            this.tableSF.getItems().set(t.getTablePosition().getRow(), (Object)dd);
        });
        this.tcSfCard.setCellValueFactory((Callback)new PropertyValueFactory("Card"));
        this.tcSfCard.setCellFactory((Callback)doubleCellFactory);
        this.tcSfCard.setOnEditCommit(t -> {
            DPULIstData dd = (DPULIstData)this.tableSF.getItems().get(t.getTablePosition().getRow());
            dd.setCard(((Double)t.getNewValue()).doubleValue());
            dd.setSum(dd.getCash() + dd.getCard() + dd.getNonFiscal());
            this.tableSF.getItems().set(t.getTablePosition().getRow(), (Object)dd);
        });
        this.tcSfRest.setCellValueFactory((Callback)new PropertyValueFactory("NonFiscal"));
        this.tcSfRest.setCellFactory((Callback)doubleCellFactory);
        this.tcSfRest.setOnEditCommit(t -> {
            DPULIstData dd = (DPULIstData)this.tableSF.getItems().get(t.getTablePosition().getRow());
            dd.setNonFiscal(((Double)t.getNewValue()).doubleValue());
            dd.setSum(dd.getCash() + dd.getCard() + dd.getNonFiscal());
            this.tableSF.getItems().set(t.getTablePosition().getRow(), (Object)dd);
        });
    }

    @FXML
    private void dpDatumChange() {
        if (this.dpuList.getDPUListID() == 0) {
            this.dpuList.setDate(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDatum.getValue())));
        }
        this.loadNiTable();
    }

    @FXML
    public void diAddClick(ActionEvent event) {
        DPULIstData dud = new DPULIstData();
        dud.setDPUListID(this.dpuList.getDPUListID());
        dud.setNumber("");
        dud.setCash(0.0);
        dud.setCard(0.0);
        dud.setNonFiscal(0.0);
        this.tableDI.getItems().add((Object)dud);
    }

    @FXML
    public void diRemoveClick(ActionEvent event) {
        try {
            this.tableDI.getItems().remove(this.tableDI.getSelectionModel().getSelectedIndex());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @FXML
    public void sfAddClick(ActionEvent event) {
        DPULIstData dud = new DPULIstData();
        dud.setDPUListID(this.dpuList.getDPUListID());
        dud.setNumber("");
        dud.setCash(0.0);
        dud.setCard(0.0);
        dud.setNonFiscal(0.0);
        this.tableSF.getItems().add((Object)dud);
    }

    @FXML
    public void sfRemoveClick(ActionEvent event) {
        try {
            this.tableSF.getItems().remove(this.tableSF.getSelectionModel().getSelectedIndex());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @FXML
    public void cancelClick(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void saveClick(ActionEvent event) {
        this.dpuList.setDate(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDatum.getValue())));
        if (this.dpuList.getDPUListID() == 0) {
            int dpuListId = this.dpuList.insert(this.controller.getSettings().getConnection());
            this.dpuList.setDPUListID(dpuListId);
        } else {
            this.dpuList.update(this.controller.getSettings().getConnection());
            DPULIstData.delete((int)this.dpuList.getDPUListID(), (Connection)this.controller.getSettings().getConnection());
        }
        for (DPULIstData dd : this.tableDI.getItems()) {
            dd.setType(0);
            dd.setDPUListID(this.dpuList.getDPUListID());
            dd.insert(this.controller.getSettings().getConnection());
        }
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void printClick(ActionEvent event) {
        if (this.tableDI.getItems().size() >= this.object.getPosCount(this.controller.getSettings().getConnection())) {
            this.btnClose.setDisable(true);
            this.btnSave.setDisable(true);
            this.btnPrint.setDisable(true);
            this.saveClick(null);
            String reportFileName = "rs/petcom/backoffice/jasper/DPUv2.jasper";
            try {
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put("datum", this.dpuList.getDate());
                hm.put("dpuListId", this.dpuList.getDPUListID());
                hm.put("nazivFirme", this.object.getName());
                hm.put("adresaFirme", "");
                hm.put("objekatId", this.object.getObjectID());
                hm.put("objekat", this.object);
                JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
                JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
                hm2.put("report", printViewPane);
                this.controller.showModalDialog("DPU lista", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
                printViewPane = null;
            }
            catch (JRException e) {
                this.controller.alert("Gre\u0161ka", e.getMessage(), this.rootPane.getScene().getWindow());
                e.printStackTrace();
            }
            this.btnClose.setDisable(false);
            this.btnSave.setDisable(false);
            this.btnPrint.setDisable(false);
        } else {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("title", this.controller.getBundle().getObject("alert.minimalNumberOfDailyReports.title").toString());
            hm.put("text", this.controller.getBundle().getObject("alert.minimalNumberOfDailyReports.text").toString());
            this.controller.showModalDialog(this.controller.getBundle().getObject("alert.minimalNumberOfDailyReports.title").toString(), ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        }
    }

    private void loadTables() {
        this.tableDI.getItems().clear();
        this.tableDI.setItems(DPULIstData.getList((DPUList)this.dpuList, (int)0, (Connection)this.controller.getSettings().getConnection()));
        this.loadNiTable();
        this.tableSF.getItems().clear();
        this.tableSF.setItems(DPULIstData.getRfList((Date)this.dpuList.getDate(), (rs.petcom.master.dal.Object)this.object, (Connection)this.controller.getSettings().getConnection()));
    }

    private void loadNiTable() {
        try {
            this.tableNI.setItems(DPULIstData.getNiList((Date)this.dpuList.getDate(), (int)this.object.getObjectID(), (Connection)this.controller.getSettings().getConnection()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

