/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.products;

import com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Excise;
import rs.petcom.master.dal.ExciseProduct;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.NetAmountType;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.AditionalFieldDetailsProduct;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductCategory;
import rs.petcom.master.dal.product.ProductDepartment;
import rs.petcom.master.dal.product.ProductType;
import rs.petcom.master.tablemodels.AditionalFieldTableModel;

public class ProductInsertDialogController
implements DialogController {
    private ScreensController controller;
    Connection connection;
    private int modalResult;
    private Product selectedProduct;
    private Barcode selectedBarcode;
    private ObservableList<Barcode> barCodeList = FXCollections.observableArrayList();
    private ObservableList<CheckBoxTreeItem<java.lang.Object>> departmentsList = FXCollections.observableArrayList();
    ObservableList<AditionalFieldTableModel> tableDatas;
    ComboBox<AditionalFieldDetails> combo;
    @FXML
    private Label labelInfoAditionalField;
    @FXML
    private Label lblBarcodeExsists;
    @FXML
    private Label lblCodeExsists;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfCode;
    @FXML
    private TextField tfNetAmount;
    @FXML
    private TextField tfWriteOff;
    @FXML
    private TextField tfPrice;
    @FXML
    private TextField tfJedinicaMere;
    @FXML
    private TextField tfBarCode;
    @FXML
    private TextField tfBarCodeSecend;
    @FXML
    private Label lblExciseValue;
    @FXML
    private Label lblExciseValueByJM;
    @FXML
    private Button btnAfChange;
    @FXML
    private Button btnAfAdmin;
    @FXML
    private ComboBox<Vat> cbVat;
    @FXML
    private ComboBox<Unit> cbUnit;
    @FXML
    private ComboBox<ProductCategory> cbCategory;
    @FXML
    private ComboBox<ProductType> cbProductType;
    @FXML
    private ComboBox<NetAmountType> cbNetAmountType;
    @FXML
    private ComboBox<Excise> cbExcise;
    @FXML
    private Tab tabOsnovniPodaci;
    @FXML
    private Tab tabDodatniPodaci;
    @FXML
    private Tab tabGrupe;
    @FXML
    private Tab tabProdajnaMesta;
    @FXML
    private Tab tabDodatniBarkodovi;
    @FXML
    private Tab tabAkcize;
    @FXML
    private TableView<Barcode> tableBarcode;
    @FXML
    private TableColumn<Barcode, String> colBarcode;
    @FXML
    private TableColumn<Barcode, String> colTezinski;
    @FXML
    private CheckBox cbMeasurable;
    @FXML
    private CheckBox cbActive;
    @FXML
    private CheckBox cbDiscountAllowed;
    @FXML
    private CheckBox cbIsWeight;
    @FXML
    private CheckBox cbIsWeightSecend;
    @FXML
    private TableView<AditionalFieldTableModel> tableAditionalFields;
    @FXML
    private TableColumn<AditionalFieldTableModel, String> tcNameAditionalField;
    @FXML
    private TableColumn<AditionalFieldTableModel, String> tcDetailsAditionalField;
    @FXML
    private TreeView<java.lang.Object> treePointOfSale;
    private boolean fromInvoice;

    public void initialize() {
        this.rootPane.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                switch (event.getCode()) {
                    case F5: {
                        ProductInsertDialogController.this.confirmAction();
                        break;
                    }
                    case ESCAPE: {
                        ProductInsertDialogController.this.cancelAction();
                        break;
                    }
                }
            }
        });
        this.tabOsnovniPodaci.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                if (ProductInsertDialogController.this.tabOsnovniPodaci.isSelected()) {
                    System.out.println("da l ovde ulazi");
                    ProductInsertDialogController.this.disableFocus();
                    ProductInsertDialogController.this.tfCode.setFocusTraversable(true);
                    ProductInsertDialogController.this.tfBarCode.setFocusTraversable(true);
                    ProductInsertDialogController.this.tfName.setFocusTraversable(true);
                    ProductInsertDialogController.this.tfPrice.setFocusTraversable(true);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProductInsertDialogController.this.tfCode.requestFocus();
                        }
                    });
                }
            }
        });
        this.tabDodatniPodaci.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                if (ProductInsertDialogController.this.tabDodatniPodaci.isSelected()) {
                    ProductInsertDialogController.this.disableFocus();
                    ProductInsertDialogController.this.tfNetAmount.setFocusTraversable(true);
                    ProductInsertDialogController.this.tfWriteOff.setFocusTraversable(true);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProductInsertDialogController.this.tfNetAmount.requestFocus();
                        }
                    });
                }
            }
        });
        this.tabAkcize.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                if (ProductInsertDialogController.this.tabAkcize.isSelected()) {
                    ProductInsertDialogController.this.disableFocus();
                    ProductInsertDialogController.this.tfJedinicaMere.setFocusTraversable(true);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProductInsertDialogController.this.tfJedinicaMere.requestFocus();
                        }
                    });
                }
            }
        });
        this.tabGrupe.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                if (ProductInsertDialogController.this.tabGrupe.isSelected()) {
                    ProductInsertDialogController.this.disableFocus();
                    ProductInsertDialogController.this.tableAditionalFields.setFocusTraversable(true);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProductInsertDialogController.this.tableAditionalFields.requestFocus();
                        }
                    });
                }
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ProductInsertDialogController.this.tfCode.requestFocus();
            }
        });
        this.colBarcode.setCellValueFactory((Callback)new PropertyValueFactory("BarCode"));
        this.colTezinski.setCellValueFactory((Callback)new PropertyValueFactory("isWeight"));
        this.colTezinski.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Barcode, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Barcode, String> param) {
                return new SimpleObjectProperty((java.lang.Object)(((Barcode)param.getValue()).getIsWeight() != false ? "DA" : "NE"));
            }
        });
        this.tfJedinicaMere.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("|[-\\+]?|[-\\+]?\\d+\\.?|[-\\+]?\\d+\\.?\\d+")) {
                    ProductInsertDialogController.this.tfJedinicaMere.setText(oldValue);
                }
                if (!newValue.equals("")) {
                    ProductInsertDialogController.this.lblExciseValueByJM.setText(String.valueOf(Settings.round((double)(Double.parseDouble(ProductInsertDialogController.this.lblExciseValue.getText()) * Double.parseDouble(newValue) / 1.0), (int)2)));
                }
            }
        });
        this.tfBarCodeSecend.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.trim().length() <= 13) {
                    if (newValue.trim().length() == 5) {
                        ProductInsertDialogController.this.cbIsWeight.setDisable(false);
                        ProductInsertDialogController.this.cbIsWeight.setSelected(true);
                    } else {
                        ProductInsertDialogController.this.cbIsWeight.setDisable(true);
                        ProductInsertDialogController.this.cbIsWeight.setSelected(false);
                    }
                    if (newValue.trim().length() == 5) {
                        ProductInsertDialogController.this.cbIsWeightSecend.setDisable(false);
                        ProductInsertDialogController.this.cbIsWeightSecend.setSelected(true);
                    } else {
                        ProductInsertDialogController.this.cbIsWeightSecend.setDisable(true);
                        ProductInsertDialogController.this.cbIsWeightSecend.setSelected(false);
                    }
                } else {
                    ProductInsertDialogController.this.tfBarCodeSecend.setText(oldValue);
                }
                ProductInsertDialogController.this.tfBarCode.setText(ProductInsertDialogController.this.tfBarCodeSecend.getText().trim());
            }
        });
        this.tfBarCode.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.trim().length() <= 13) {
                    if (newValue.trim().length() == 5) {
                        ProductInsertDialogController.this.cbIsWeight.setDisable(false);
                        ProductInsertDialogController.this.cbIsWeight.setSelected(true);
                    } else {
                        ProductInsertDialogController.this.cbIsWeight.setDisable(true);
                        ProductInsertDialogController.this.cbIsWeight.setSelected(false);
                    }
                    if (newValue.trim().length() == 5) {
                        ProductInsertDialogController.this.cbIsWeightSecend.setDisable(false);
                        ProductInsertDialogController.this.cbIsWeightSecend.setSelected(true);
                    } else {
                        ProductInsertDialogController.this.cbIsWeightSecend.setDisable(true);
                        ProductInsertDialogController.this.cbIsWeightSecend.setSelected(false);
                    }
                } else {
                    ProductInsertDialogController.this.tfBarCode.setText(oldValue);
                }
                ProductInsertDialogController.this.tfBarCodeSecend.setText(ProductInsertDialogController.this.tfBarCode.getText().trim());
            }
        });
        this.cbUnit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ProductInsertDialogController.this.cbMeasurable.setSelected(((Unit)ProductInsertDialogController.this.cbUnit.getSelectionModel().getSelectedItem()).isMeasurable());
                ProductInsertDialogController.this.cbMeasurable.setDisable(!((Unit)ProductInsertDialogController.this.cbUnit.getSelectionModel().getSelectedItem()).isMeasurable());
            }
        });
        this.tableAditionalFields.setOnKeyPressed(k -> {
            if (k.getCode() == KeyCode.ENTER) {
                this.addChangeAction();
            }
        });
    }

    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.fromInvoice = (Boolean)parameter.get("fromInvoice");
        this.connection = this.controller.getSettings().getConnection();
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.selectedProduct = (Product)parameter.get("selectedProduct");
        this.tfBarCode.focusedProperty().addListener((val, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.getErrorMessageBcExsists();
            } else {
                this.lblBarcodeExsists.setVisible(false);
            }
        });
        this.tfCode.focusedProperty().addListener((val, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.getErrorMessageCodeExsists();
            } else {
                this.lblCodeExsists.setVisible(false);
            }
        });
        this.fillVatComboBox();
        this.fillUnitComboBox();
        this.fillProductTypeComboBox();
        this.fillNetAmountTypeComboBox();
        this.fillCategoryComboBox();
        this.fillProductData();
        this.fillProdajnaMesta();
        this.loadAditionalFields();
        this.loadExciseField();
        this.disableFocus();
        if (this.tabOsnovniPodaci.isSelected()) {
            this.disableFocus();
            this.tfCode.setFocusTraversable(true);
            this.tfBarCode.setFocusTraversable(true);
            this.tfName.setFocusTraversable(true);
            this.tfPrice.setFocusTraversable(true);
        }
        this.tableDatas = this.tableAditionalFields.getItems();
    }

    public HashMap<String, java.lang.Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    private void confirmAction() {
        if (this.selectedProduct != null) {
            this.selectedProduct.setCode(this.tfCode.getText().trim());
            this.selectedProduct.setName(this.tfName.getText().trim());
            this.selectedProduct.setShortName(this.tfName.getText().trim());
            this.selectedProduct.setUnitID(((Unit)this.cbUnit.getSelectionModel().getSelectedItem()).getUnitID());
            this.selectedProduct.setProductCategoryID(((ProductCategory)this.cbCategory.getSelectionModel().getSelectedItem()).getProductCategoryID());
            this.selectedProduct.setVatID(((Vat)this.cbVat.getSelectionModel().getSelectedItem()).getVatID());
            this.selectedProduct.setSysDTEdit(new Date());
            this.selectedProduct.setMeasurable(this.cbMeasurable.isSelected());
            this.selectedProduct.setActive(this.cbActive.isSelected());
            this.selectedProduct.setWriteOff(Double.parseDouble(this.tfWriteOff.getText().trim()));
            this.selectedProduct.setDiscountAllowed(this.cbDiscountAllowed.isSelected());
            this.selectedProduct.setSysUserEditID(this.controller.getUser().getUserID());
            this.selectedProduct.setNetAmount(Double.parseDouble(this.tfNetAmount.getText().trim()));
            this.selectedProduct.setNetAmountTypeID(((NetAmountType)this.cbNetAmountType.getSelectionModel().getSelectedItem()).getNetAmountTypeID());
            this.selectedProduct.setProductTypeID(((ProductType)this.cbProductType.getSelectionModel().getSelectedItem()).getProductTypeID());
            Barcode bcBarcode = Barcode.getBarCodeObject((long)this.selectedProduct.getProductID(), (Connection)this.controller.getSettings().getConnection());
            if (!this.barCodeList.isEmpty()) {
                for (Barcode barcode : this.tableBarcode.getItems()) {
                    if (barcode.getBarCodeID() == -1L) {
                        try {
                            barcode.insertNewBarCode(this.controller.getSettings().getConnection());
                        }
                        catch (MySQLIntegrityConstraintViolationException e) {
                            this.controller.alert("Obave\u0161tenje", "Barkod " + barcode.getBarCode() + " ve\u0107 postoji u bazi", this.rootPane.getScene().getWindow());
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    try {
                        barcode.update(this.controller);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            for (CheckBoxTreeItem ps : this.departmentsList) {
                ProductDepartment productDepartment = ProductDepartment.getByProductAndDepartment((long)this.selectedProduct.getProductID(), (int)((Department)ps.getValue()).getDepartmentID(), (ScreensController)this.controller);
                productDepartment.setActive(ps.isSelected());
                productDepartment.updateAction(this.controller.getSettings().getConnection());
            }
            if (this.selectedProduct.getPrice() != Settings.round((double)Double.valueOf(this.tfPrice.getText().trim()), (int)2)) {
                try {
                    PriceListDetailes.insertProductPriceTrgovina((PriceList)PriceList.getActive((LocalDateTime)LocalDateTime.now(), (int)this.controller.getObject().getObjectID(), (Connection)this.controller.getSettings().getConnection()), (long)this.selectedProduct.getProductID(), (double)Settings.round((double)Double.valueOf(this.tfPrice.getText().trim()), (int)2), (Connection)this.controller.getSettings().getConnection());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.controller.getSettings().getConnection().setAutoCommit(false);
                this.selectedProduct.update(this.controller);
                if (bcBarcode == null && !this.tfBarCode.getText().trim().equals("")) {
                    Barcode barcode = new Barcode();
                    barcode.setBarCode(this.tfBarCode.getText().trim());
                    barcode.setIsWeight(Boolean.valueOf(this.cbIsWeight.isSelected()));
                    barcode.setProductID(this.selectedProduct.getProductID());
                    try {
                        barcode.insertNewBarCode(this.controller.getSettings().getConnection());
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else {
                    if (this.tfBarCode.getText().equals("")) {
                        this.controller.alert("Obavestenje", "Barkod naziv artikla je obavezno polje, ne moze biti prazno.", this.rootPane.getScene().getWindow());
                        return;
                    }
                    bcBarcode.setBarCode(this.tfBarCode.getText().trim());
                    bcBarcode.setIsWeight(Boolean.valueOf(this.cbIsWeight.isSelected()));
                    bcBarcode.updateClient(this.controller.getSettings().getConnection());
                }
                this.controller.getSettings().getConnection().commit();
                AditionalFieldDetailsProduct afdProduct = new AditionalFieldDetailsProduct();
                afdProduct.setProductID(this.selectedProduct.getProductID());
                afdProduct.deleteByProductId(this.controller.getSettings().getConnection());
                for (AditionalFieldTableModel afdModel : this.tableDatas) {
                    afdProduct.setAditionalFieldDetailsID(afdModel.getAditionalFieldDetailId());
                    afdProduct.setAditionalFieldID(afdModel.getAditionalFieldId());
                    afdProduct.insert(this.controller.getSettings().getConnection());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.controller.alert("Obavestenje", "Neuspesno ubacivanje proizvoda" + e.getMessage(), this.rootPane.getScene().getWindow());
                try {
                    this.controller.getSettings().getConnection().rollback();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                return;
            }
            finally {
                try {
                    this.controller.getSettings().getConnection().setAutoCommit(true);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            this.saveExcise(this.selectedProduct);
            Log.writeLog((User)this.controller.getUser(), (String)("Izmenjen artikal " + this.selectedProduct.getName() + ", trenutna cena " + this.tfPrice.getText()), (Connection)this.controller.getSettings().getConnection());
        } else {
            try {
                this.controller.getSettings().getConnection().setAutoCommit(false);
                if (this.validacijaPolja()) {
                    ObservableList aditionalBarcodes;
                    long productId = 0L;
                    Product p = new Product();
                    p.setNetAmountTypeID(((NetAmountType)this.cbNetAmountType.getSelectionModel().getSelectedItem()).getNetAmountTypeID());
                    p.setProductTypeID(((ProductType)this.cbProductType.getSelectionModel().getSelectedItem()).getProductTypeID());
                    p.setProductCategoryID(((ProductCategory)this.cbCategory.getSelectionModel().getSelectedItem()).getProductCategoryID());
                    p.setVatID(((Vat)this.cbVat.getSelectionModel().getSelectedItem()).getVatID());
                    p.setUnitID(((Unit)this.cbUnit.getSelectionModel().getSelectedItem()).getUnitID());
                    p.setActive(true);
                    p.setSysDTCreated(new Date());
                    p.setCode(this.tfCode.getText());
                    p.setName(this.tfName.getText());
                    p.setShortName(this.tfName.getText());
                    p.setSysUserAddID(this.controller.getUser().getUserID());
                    p.setNetAmount(Double.parseDouble(this.tfNetAmount.getText().trim()));
                    p.setMeasurable(this.cbMeasurable.isSelected() ? this.cbMeasurable.isSelected() : Unit.getUnitById((int)p.getUnitID(), (Connection)this.controller.getSettings().getConnection()).isMeasurable());
                    p.setDiscountAllowed(this.cbDiscountAllowed.isSelected());
                    p.setWriteOff(Double.parseDouble(this.tfWriteOff.getText()));
                    if (this.tfBarCode.getText().trim().equals("")) {
                        this.controller.alert("Obavestenje", "Barkod naziv artikla je obavezno polje, ne moze biti prazno.", this.rootPane.getScene().getWindow());
                        return;
                    }
                    productId = p.insert(this.controller.getUser(), this.controller.getSettings().getConnection());
                    if (!this.tfBarCode.getText().trim().equals("")) {
                        Barcode barcode = new Barcode();
                        barcode.setBarCode(this.tfBarCode.getText().trim());
                        barcode.setIsWeight(Boolean.valueOf(this.cbIsWeight.isSelected()));
                        barcode.setProductID(productId);
                        barcode.insertNewBarCode(this.controller.getSettings().getConnection());
                    }
                    if (!(aditionalBarcodes = this.tableBarcode.getItems()).isEmpty()) {
                        for (Barcode bc : aditionalBarcodes) {
                            bc.setProductID(productId);
                            try {
                                bc.insertNewBarCode(this.controller.getSettings().getConnection());
                            }
                            catch (MySQLIntegrityConstraintViolationException e) {
                                this.controller.alert("Obavestenje", "Barkod " + bc.getBarCode() + " vec postoji u bazi.", this.rootPane.getScene().getWindow());
                            }
                        }
                    }
                    try {
                        if (Double.parseDouble(this.tfPrice.getText()) > 0.0) {
                            PriceListDetailes.insertProductPriceTrgovinaFirst((PriceList)PriceList.getRegular((LocalDateTime)LocalDateTime.now(), (int)this.controller.getObject().getObjectID(), (Connection)this.controller.getSettings().getConnection()), (long)productId, (double)Double.parseDouble(this.tfPrice.getText()), (Connection)this.controller.getSettings().getConnection());
                        }
                    }
                    catch (NumberFormatException e) {
                        this.controller.alert("Obave\u0161tenje", "Nije upisana cena: " + e.getMessage(), this.rootPane.getScene().getWindow());
                    }
                    p.setProductID(productId);
                    for (CheckBoxTreeItem ps : this.departmentsList) {
                        try {
                            ProductDepartment pd = new ProductDepartment();
                            pd.setProductID(p.getProductID());
                            pd.setSort(0);
                            pd.setActive(ps.isSelected());
                            pd.setFavorite(false);
                            pd.setDepartmentID(((Department)ps.getValue()).getDepartmentID());
                            pd.insert(this.controller.getSettings().getConnection());
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (p != null) {
                        try {
                            AditionalFieldDetailsProduct afp = new AditionalFieldDetailsProduct();
                            afp.setProductID(p.getProductID());
                            for (AditionalFieldTableModel afdModel : this.tableDatas) {
                                if (afdModel.getAditionalFieldDetailId() < 1L) continue;
                                afp.setAditionalFieldID(afdModel.getAditionalFieldId());
                                afp.setAditionalFieldDetailsID(afdModel.getAditionalFieldDetailId());
                                afp.insert(this.controller.getSettings().getConnection());
                            }
                        }
                        catch (NullPointerException e) {
                            e.printStackTrace();
                        }
                    }
                    this.saveExcise(p);
                    if (this.fromInvoice) {
                        Log.writeLog((User)this.controller.getUser(), (String)("Ubacen artikal kroz prijemnicu " + this.tfName.getText() + ", trenutna cena " + this.tfPrice.getText()), (Connection)this.controller.getSettings().getConnection());
                    } else {
                        Log.writeLog((User)this.controller.getUser(), (String)("Ubacen artikal " + this.tfName.getText() + ", trenutna cena " + this.tfPrice.getText()), (Connection)this.controller.getSettings().getConnection());
                    }
                } else {
                    this.controller.alert("Obavestenje", "Morate popuniti sva polja", this.rootPane.getScene().getWindow());
                    return;
                }
                this.controller.getSettings().getConnection().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.controller.alert("Obavestenje", "Neuspesno ubacivanje proizvoda" + e.getMessage(), this.rootPane.getScene().getWindow());
                try {
                    this.controller.getSettings().getConnection().rollback();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                return;
            }
            finally {
                try {
                    this.controller.getSettings().getConnection().setAutoCommit(true);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void cancelAction() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void barcodeNew() {
        ObservableList bcList = this.tableBarcode.getItems();
        HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
        hm2.put("controller", this.controller);
        hm2.put("bcList", bcList);
        int modalResult = this.controller.showModalDialog("Unos dodatnog barkod-a", ScreensController.SCREEN_BACKOFFICE_NEW_BARCODE_INSERT, hm2, this.rootPane.getScene().getWindow());
        if (modalResult == ScreensController.MODAL_RESULT_OK) {
            this.selectedBarcode = (Barcode)hm2.get("barcode");
            if (this.selectedProduct != null) {
                this.selectedBarcode.setProductID(this.selectedProduct.getProductID());
            } else {
                this.selectedBarcode.setProductID(-1L);
            }
            if (this.barCodeList.isEmpty()) {
                this.tableBarcode.getItems().add((java.lang.Object)this.selectedBarcode);
            } else {
                boolean provera = false;
                for (Barcode bcBarcode : this.barCodeList) {
                    if (!bcBarcode.getBarCode().equals("")) {
                        provera = true;
                        continue;
                    }
                    provera = false;
                }
                if (provera) {
                    this.tableBarcode.getItems().add((java.lang.Object)this.selectedBarcode);
                }
            }
            this.tableBarcode.refresh();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProductInsertDialogController.this.tableBarcode.requestFocus();
                    ProductInsertDialogController.this.tableBarcode.getSelectionModel().select((java.lang.Object)ProductInsertDialogController.this.selectedBarcode);
                    ProductInsertDialogController.this.tableBarcode.scrollTo((java.lang.Object)ProductInsertDialogController.this.selectedBarcode);
                }
            });
        }
    }

    @FXML
    void barcodeEdit(ActionEvent event) {
        HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
        Barcode editedBarcode = (Barcode)this.tableBarcode.getSelectionModel().getSelectedItem();
        ObservableList bcList = this.tableBarcode.getItems();
        if (editedBarcode != null) {
            hm2.put("controller", this.controller);
            hm2.put("selectedBarcode", editedBarcode);
            hm2.put("bcList", bcList);
            int modalResult = this.controller.showModalDialog("Izmena dodatnog barkod-a", ScreensController.SCREEN_BACKOFFICE_NEW_BARCODE_INSERT, hm2, this.rootPane.getScene().getWindow());
            this.selectedBarcode = (Barcode)hm2.get("barcode");
            if (modalResult == ScreensController.MODAL_RESULT_OK) {
                editedBarcode.setBarCode(this.selectedBarcode.getBarCode());
                editedBarcode.setIsWeight(this.selectedBarcode.getIsWeight());
                this.tableBarcode.refresh();
            }
        } else {
            this.controller.alert("Obavestenje", "Morate izabrati barkod sa liste", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void barcodeDelete() {
        if (this.tableBarcode.getSelectionModel().getSelectedItem() != null) {
            Barcode barcode = (Barcode)this.tableBarcode.getSelectionModel().getSelectedItem();
            if (((Barcode)this.tableBarcode.getSelectionModel().getSelectedItem()).getBarCodeID() != -1L) {
                try {
                    ((Barcode)this.tableBarcode.getSelectionModel().getSelectedItem()).delete1(this.controller);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            this.tableBarcode.getItems().remove((java.lang.Object)barcode);
            this.tableBarcode.getSelectionModel().clearSelection();
            this.tableBarcode.refresh();
        }
    }

    @FXML
    public void importAction(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import artikala");
        fileChooser.getExtensionFilters().add((java.lang.Object)new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"}));
        File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            try {
                BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                hm2.put("controller", this.controller);
                hm2.put("bufferedReader", bf);
                this.controller.showModalDialog("Import artikala", ScreensController.DIALOG_BACKOFFICE_IMPORT_PRODUCT, hm2, this.rootPane.getScene().getWindow());
            }
            catch (FileNotFoundException | UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void fillProductData() {
        if (this.selectedProduct != null) {
            Barcode barcode = Barcode.getBarCodeObject((long)this.selectedProduct.getProductID(), (Connection)this.controller.getSettings().getConnection());
            this.barCodeList = Barcode.getBarCodes((Product)this.selectedProduct, (Connection)this.controller.getSettings().getConnection());
            this.tableBarcode.setItems(this.barCodeList);
            this.tfCode.setText(this.selectedProduct.getCode() != null ? this.selectedProduct.getCode() : "");
            this.tfName.setText(this.selectedProduct.getName() != null ? this.selectedProduct.getName() : "");
            this.tfWriteOff.setText(String.valueOf(this.selectedProduct.getWriteOff()));
            this.tfNetAmount.setText(String.valueOf(this.selectedProduct.getNetAmount()));
            this.tfBarCode.setText(barcode != null ? barcode.getBarCode() : "");
            this.cbActive.setSelected(this.selectedProduct.isActive());
            this.cbMeasurable.setSelected(this.selectedProduct.isMeasurable());
            this.cbDiscountAllowed.setSelected(this.selectedProduct.isDiscountAllowed());
            this.cbIsWeight.setSelected(barcode != null ? barcode.getIsWeight() : false);
            this.tfPrice.setText(String.valueOf(this.selectedProduct.getPrice()));
            for (Vat vat : this.cbVat.getItems()) {
                if (vat.getVatID() != this.selectedProduct.getVatID()) continue;
                this.cbVat.getSelectionModel().select((java.lang.Object)vat);
            }
            for (ProductCategory pCategory : this.cbCategory.getItems()) {
                if (pCategory.getProductCategoryID() != this.selectedProduct.getProductCategoryID()) continue;
                this.cbCategory.getSelectionModel().select((java.lang.Object)pCategory);
            }
            for (ProductType pType : this.cbProductType.getItems()) {
                if (pType.getProductTypeID() != this.selectedProduct.getProductTypeID()) continue;
                this.cbProductType.getSelectionModel().select((java.lang.Object)pType);
            }
            for (NetAmountType nAmountType : this.cbNetAmountType.getItems()) {
                if (nAmountType.getNetAmountTypeID() != this.selectedProduct.getNetAmountTypeID()) continue;
                this.cbNetAmountType.getSelectionModel().select((java.lang.Object)nAmountType);
            }
            for (Unit unit : this.cbUnit.getItems()) {
                if (unit.getUnitID() != this.selectedProduct.getUnitID()) continue;
                this.cbUnit.getSelectionModel().select((java.lang.Object)unit);
            }
        } else {
            if (this.controller.getSettings().isPonudiSledeciKod()) {
                this.tfCode.setText(String.valueOf(Product.getLastCode((Connection)this.controller.getSettings().getConnection())));
            } else {
                this.tfCode.setText("");
            }
            this.tfName.setText("");
            this.tfWriteOff.setText("0.00");
            this.tfNetAmount.setText("1.00");
            this.tfPrice.setText("");
            this.tfBarCode.setText("");
            this.cbMeasurable.setSelected(((Unit)this.cbUnit.getSelectionModel().getSelectedItem()).isMeasurable());
            this.cbIsWeight.setSelected(false);
        }
    }

    private void fillVatComboBox() {
        this.cbVat.setItems(Vat.getObeservableList((Connection)this.controller.getSettings().getConnection()));
        this.cbVat.getSelectionModel().selectFirst();
    }

    private void fillUnitComboBox() {
        this.cbUnit.setItems(Unit.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbUnit.getSelectionModel().selectFirst();
    }

    private void fillCategoryComboBox() {
        this.cbCategory.setItems(ProductCategory.getObeservableList((Connection)this.controller.getSettings().getConnection()));
        this.cbCategory.getSelectionModel().selectFirst();
    }

    private void fillProductTypeComboBox() {
        this.cbProductType.setItems(ProductType.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbProductType.getSelectionModel().selectFirst();
    }

    private void fillNetAmountTypeComboBox() {
        this.cbNetAmountType.setItems(NetAmountType.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbNetAmountType.getSelectionModel().selectFirst();
    }

    private void loadAditionalFields() {
        Connection connection = this.controller.getSettings().getConnection();
        ObservableList fields = AditionalField.getList((Connection)connection);
        ObservableList fieldsForTable = FXCollections.observableArrayList();
        for (AditionalField field : fields) {
            AditionalFieldDetails afd = new AditionalFieldDetails();
            afd.setName("Nije izabrano");
            if (this.selectedProduct != null) {
                afd = AditionalFieldDetails.getByProductID((long)this.selectedProduct.getProductID(), (long)field.getAditionalFieldID(), (Connection)connection);
            }
            AditionalFieldTableModel afdModel = new AditionalFieldTableModel();
            if (afd != null) {
                afdModel.setAditionalFieldDetailId(afd.getAditionalFieldDetailsID());
                afdModel.setAditionalFieldId(field.getAditionalFieldID());
                afdModel.setAditionalFieldDetailName(afd.getName());
                afdModel.setAditionalFieldName(field.getName());
            } else {
                afdModel.setAditionalFieldId(field.getAditionalFieldID());
                afdModel.setAditionalFieldName(field.getName());
                afdModel.setAditionalFieldDetailId(-1L);
                afdModel.setAditionalFieldDetailName("Nije izabrano");
            }
            fieldsForTable.add((java.lang.Object)afdModel);
        }
        this.tcNameAditionalField.setCellValueFactory((Callback)new PropertyValueFactory("aditionalFieldName"));
        this.tcDetailsAditionalField.setCellValueFactory((Callback)new PropertyValueFactory("aditionalFieldDetailName"));
        this.tableAditionalFields.setItems(fieldsForTable);
    }

    private void fillProdajnaMesta() {
        CheckBoxTreeItem objekat = new CheckBoxTreeItem();
        objekat.setValue((java.lang.Object)this.controller.getObject().getName());
        objekat.setExpanded(true);
        this.treePointOfSale.setCellFactory(p -> new CheckBoxTreeCell<java.lang.Object>(){

            public void updateItem(java.lang.Object item, boolean empty) {
                super.updateItem(item, empty);
                if (item != null) {
                    this.setText(item.toString());
                }
            }
        });
        for (Department department : Department.getList((Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection())) {
            CheckBoxTreeItem depBoxTreeItem = new CheckBoxTreeItem();
            depBoxTreeItem.setValue((java.lang.Object)department);
            depBoxTreeItem.setSelected(true);
            if (this.selectedProduct != null) {
                depBoxTreeItem.setSelected(ProductDepartment.getByProductAndDepartment((long)this.selectedProduct.getProductID(), (int)department.getDepartmentID(), (ScreensController)this.controller).isActive());
            }
            objekat.getChildren().add((java.lang.Object)depBoxTreeItem);
            this.departmentsList.add((java.lang.Object)depBoxTreeItem);
        }
        this.treePointOfSale.setRoot((TreeItem)objekat);
        this.treePointOfSale.setShowRoot(true);
    }

    private void loadExciseField() {
        this.clearExciseField();
        if (this.selectedProduct != null) {
            ExciseProduct exciseProduct = this.controller.getSettings().isSinhorinizacija() ? ExciseProduct.getByProductId((Connection)this.controller.getServerConnection(), (long)this.selectedProduct.getProductID()) : ExciseProduct.getByProductId((Connection)this.controller.getSettings().getConnection(), (long)this.selectedProduct.getProductID());
            if (exciseProduct != null && !Excise.getList((ScreensController)this.controller, (String)"").isEmpty()) {
                for (Excise excise : this.cbExcise.getItems()) {
                    if (exciseProduct.getExciseId() != excise.getExciseId()) continue;
                    this.cbExcise.getSelectionModel().select((java.lang.Object)excise);
                    this.lblExciseValue.setText(String.valueOf(excise.getValue()));
                    this.tfJedinicaMere.setText(String.valueOf(exciseProduct.getValue()));
                    this.lblExciseValueByJM.setText(String.valueOf(Settings.round((double)(excise.getValue() * exciseProduct.getValue() / 1.0), (int)2)));
                }
            }
        } else {
            this.fillExciseComboBox();
        }
    }

    @FXML
    private void administrationAction() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        this.controller.showModalDialog("Dodavanje - Izmena artikla", ScreensController.SCREEN_BACKOFFICE_SIFRARNICI_ADITIONAL_FIELDS_FRONT, hm, this.rootPane.getScene().getWindow());
    }

    @FXML
    private void addChangeAction() {
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        AditionalFieldTableModel field = (AditionalFieldTableModel)this.tableAditionalFields.getSelectionModel().getSelectedItem();
        this.tableDatas = this.tableAditionalFields.getItems();
        if (field == null) {
            this.controller.alert("Obavestenje", "Morate izabrati dodatno polje", this.rootPane.getScene().getWindow());
            return;
        }
        hm.put("controller", this.controller);
        hm.put("AditionalField", field);
        hm.put("fields", this.tableDatas);
        this.controller.showModalDialog("Dodavanje - Izmena artikla", ScreensController.DIALOG_BACKOFFICE_ADITIONAL_FIELDS_SELECT, hm, this.rootPane.getScene().getWindow());
        this.tableDatas = (ObservableList)hm.get("currentFields");
        this.tableAditionalFields.setItems(this.tableDatas);
    }

    private void saveExcise(Product product) {
        if (this.controller.getSettings().isSinhorinizacija()) {
            if (this.cbExcise.getSelectionModel().getSelectedItem() != null && ((Excise)this.cbExcise.getSelectionModel().getSelectedItem()).getExciseId() != -1L) {
                if (product != null) {
                    ExciseProduct exciseProduct = ExciseProduct.getByProductId((Connection)this.controller.getServerConnection(), (long)product.getProductID());
                    if (exciseProduct != null) {
                        if (((Excise)this.cbExcise.getSelectionModel().getSelectedItem()).getExciseId() == -1L) {
                            exciseProduct.delete(this.controller.getServerConnection());
                        } else {
                            exciseProduct.setExciseId(((Excise)this.cbExcise.getSelectionModel().getSelectedItem()).getExciseId());
                            exciseProduct.setValue(Double.parseDouble(this.tfJedinicaMere.getText().trim()));
                            exciseProduct.update(this.controller.getServerConnection());
                        }
                    } else {
                        exciseProduct = new ExciseProduct();
                        exciseProduct.setExciseId(((Excise)this.cbExcise.getSelectionModel().getSelectedItem()).getExciseId());
                        exciseProduct.setValue(Double.parseDouble(this.tfJedinicaMere.getText().trim()));
                        exciseProduct.setProductId(product.getProductID());
                        exciseProduct.insert(this.controller.getServerConnection());
                    }
                }
                this.clearExciseField();
            }
        } else if (this.cbExcise.getSelectionModel().getSelectedItem() != null && ((Excise)this.cbExcise.getSelectionModel().getSelectedItem()).getExciseId() != -1L) {
            if (product != null) {
                ExciseProduct exciseProduct = ExciseProduct.getByProductId((Connection)this.controller.getSettings().getConnection(), (long)product.getProductID());
                if (exciseProduct != null) {
                    if (((Excise)this.cbExcise.getSelectionModel().getSelectedItem()).getExciseId() == -1L) {
                        exciseProduct.delete(this.controller.getSettings().getConnection());
                    } else {
                        exciseProduct.setExciseId(((Excise)this.cbExcise.getSelectionModel().getSelectedItem()).getExciseId());
                        exciseProduct.setValue(Double.parseDouble(this.tfJedinicaMere.getText().trim()));
                        exciseProduct.update(this.controller.getSettings().getConnection());
                    }
                } else {
                    exciseProduct = new ExciseProduct();
                    exciseProduct.setExciseId(((Excise)this.cbExcise.getSelectionModel().getSelectedItem()).getExciseId());
                    exciseProduct.setValue(Double.parseDouble(this.tfJedinicaMere.getText().trim()));
                    exciseProduct.setProductId(product.getProductID());
                    exciseProduct.insert(this.controller.getSettings().getConnection());
                }
            }
            this.clearExciseField();
        }
    }

    private void clearExciseField() {
        this.cbExcise.getSelectionModel().select(0);
        this.lblExciseValue.setText("");
        this.tfJedinicaMere.setText("");
        this.lblExciseValueByJM.setText("");
    }

    private void fillExciseComboBox() {
        this.cbExcise.getItems().clear();
        Excise excise = new Excise();
        excise.setExciseId(-1L);
        excise.setName("Bez akcize");
        this.cbExcise.getItems().add((java.lang.Object)excise);
        for (Excise exc : Excise.getList((ScreensController)this.controller, (String)"")) {
            this.cbExcise.getItems().add((java.lang.Object)exc);
        }
        this.cbExcise.getSelectionModel().select((java.lang.Object)excise);
    }

    public boolean validacijaPolja() {
        return this.tfCode.getText() != null && !this.tfName.getText().equals("") && this.tfName.getText() != null;
    }

    private void disableFocus() {
        this.tfName.setFocusTraversable(false);
        this.tfCode.setFocusTraversable(false);
        this.tfNetAmount.setFocusTraversable(false);
        this.tfWriteOff.setFocusTraversable(false);
        this.tfPrice.setFocusTraversable(false);
        this.tfJedinicaMere.setFocusTraversable(false);
        this.tfBarCode.setFocusTraversable(false);
        this.tfBarCodeSecend.setFocusTraversable(false);
    }

    private void getErrorMessageBcExsists() {
        String barcode = this.tfBarCode.getText().trim();
        String filter = "";
        if (this.selectedProduct != null) {
            filter = "AND bc.ProductID NOT IN (" + this.selectedProduct.getProductID() + ")";
        }
        try {
            if (Barcode.barcodeExsists((String)barcode, (String)filter, (Connection)this.connection)) {
                this.lblBarcodeExsists.setVisible(true);
                this.tfBarCode.setText("");
            } else {
                this.lblBarcodeExsists.setVisible(false);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void getErrorMessageCodeExsists() {
        String barcode = this.tfCode.getText().trim();
        String filter = "";
        if (this.selectedProduct != null) {
            filter = " AND p.ProductID NOT IN (" + this.selectedProduct.getProductID() + ")";
        }
        try {
            if (Product.codeExsists((String)barcode, (String)filter, (Connection)this.connection)) {
                this.lblCodeExsists.setVisible(true);
                this.tfCode.setText("");
            } else {
                this.lblCodeExsists.setVisible(false);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    class EditingCell
    extends TableCell<Barcode, String> {
        private TextField textField;

        private EditingCell() {
        }

        public void startEdit() {
            if (!this.isEmpty()) {
                super.startEdit();
                this.createTextField();
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.textField.selectAll();
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((java.lang.Object)item, empty);
            if (empty) {
                this.setText(item);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        private void createTextField() {
            this.textField = new TextField(this.getString());
            this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
            this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (!newValue.matches("|[-\\+]?|[-\\+]?\\d+\\.?|[-\\+]?\\d+\\.?\\d+")) {
                        EditingCell.this.textField.setText(oldValue);
                    }
                    if (newValue.length() > 13) {
                        EditingCell.this.textField.setText(oldValue);
                    }
                    if (newValue.trim().length() == 5) {
                        ((Barcode)ProductInsertDialogController.this.tableBarcode.getSelectionModel().getSelectedItem()).setIsWeight(Boolean.valueOf(true));
                    } else {
                        ((Barcode)ProductInsertDialogController.this.tableBarcode.getSelectionModel().getSelectedItem()).setIsWeight(Boolean.valueOf(false));
                    }
                }
            });
            this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.commitEdit(this.textField.getText());
                }
            });
        }

        private String getString() {
            return this.getItem() == null ? "" : (String)this.getItem();
        }
    }
}

