/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.products;

import java.sql.Connection;
import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.tablemodels.AditionalFieldTableModel;

public class AditionalFieldsSelectController
implements DialogController {
    private ScreensController controller;
    private HashMap<String, Object> parameters;
    private Connection connection;
    private int modalResult;
    private AditionalFieldTableModel selectedField;
    private ObservableList<AditionalFieldDetails> fieldDetails;
    private ObservableList<AditionalFieldTableModel> currentFields;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableColumn<AditionalFieldDetails, String> colAdFields;
    @FXML
    private Button btnCancel;
    @FXML
    private TextField tfAdFieldSearch;
    @FXML
    private TableView<AditionalFieldDetails> tblAdFields;
    @FXML
    private Button btnConfirm;

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.controller = (ScreensController)this.parameters.get("controller");
        this.selectedField = (AditionalFieldTableModel)this.parameters.get("AditionalField");
        this.currentFields = (ObservableList)this.parameters.get("fields");
        this.connection = this.controller.getSettings().getConnection();
        this.fieldDetails = AditionalFieldDetails.getListByAditionalFieldID((long)this.selectedField.getAditionalFieldId(), (Connection)this.connection);
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.colAdFields.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tblAdFields.setItems(this.fieldDetails);
        this.tfAdFieldSearch.requestFocus();
        this.filter();
        this.tblAdFields.setOnKeyPressed(k -> {
            if (k.getCode() == KeyCode.ENTER) {
                this.confirm();
            }
        });
        this.tfAdFieldSearch.setOnKeyPressed(k -> {
            if (k.getCode() == KeyCode.DOWN) {
                this.tblAdFields.requestFocus();
            } else if (k.getCode() == KeyCode.ENTER) {
                this.confirm();
            }
        });
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.fieldDetails, af -> true);
        this.tfAdFieldSearch.textProperty().addListener((observable, oldValue, newValue) -> {
            filteredData.setPredicate(af -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                try {
                    if (af.getName().toLowerCase().contains(lowerCaseFilter)) {
                        return true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return false;
            });
            this.tblAdFields.getSelectionModel().select(0);
        });
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tblAdFields.comparatorProperty());
        this.tblAdFields.setItems((ObservableList)sortedData);
    }

    @FXML
    void confirm() {
        AditionalFieldDetails afd = (AditionalFieldDetails)this.tblAdFields.getSelectionModel().getSelectedItem();
        if (afd == null) {
            this.controller.alert("Obavestenje", "Morate izabrati dodatno polje", this.rootPane.getScene().getWindow());
            return;
        }
        AditionalFieldTableModel afdModel = new AditionalFieldTableModel();
        afdModel.setAditionalFieldId(this.selectedField.getAditionalFieldId());
        afdModel.setAditionalFieldDetailId(afd.getAditionalFieldDetailsID());
        afdModel.setAditionalFieldName(this.selectedField.getAditionalFieldName());
        afdModel.setAditionalFieldDetailName(afd.getName());
        this.currentFields.remove((Object)this.selectedField);
        this.currentFields.add((Object)afdModel);
        this.parameters.put("currentFields", this.currentFields);
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    void cancel(ActionEvent event) {
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }
}

