/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.pricelist;

import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.product.Product;

public class PriceListRedovanController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private PriceList selectedPriceList;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<Product> tablePriceListDetails;
    @FXML
    private TableColumn<Product, String> columnProduct;
    @FXML
    private TableColumn<Product, String> columnCode;
    @FXML
    private TableColumn<Product, String> columnBarCode;
    @FXML
    private TableColumn<Product, Double> columnQuantity;
    @FXML
    private TableColumn<Product, Double> columnPrice;
    @FXML
    private TableColumn<Product, Date> columnDate;
    @FXML
    private TextField tfFilter;
    private ObservableList<Product> products;

    public void initialize() {
        this.columnCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.columnProduct.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.columnBarCode.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.columnQuantity.setCellValueFactory((Callback)new PropertyValueFactory("stock"));
        this.columnDate.setCellValueFactory((Callback)new PropertyValueFactory("priceListDate"));
        this.columnDate.setCellFactory(column -> new TableCell<Product, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedPriceList = (PriceList)parameter.get("selectedPriceList");
        this.products = FXCollections.observableArrayList();
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        System.out.println(PriceListDetailes.getRedovanList((PriceList)this.selectedPriceList, (ScreensController)this.controller).size());
        for (PriceListDetailes priceListDetailes : PriceListDetailes.getRedovanList((PriceList)this.selectedPriceList, (ScreensController)this.controller)) {
            Product product = priceListDetailes.getProduct();
            this.products.add((Object)product);
        }
        this.tablePriceListDetails.setItems(this.products);
        this.filter();
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void commit(ActionEvent event) {
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.tablePriceListDetails.getItems(), p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(product -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            if (product.getName() != null && product.getName().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            if (product.getBarcode() != null && product.getBarcode().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return product.getCode() != null && product.getCode().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tablePriceListDetails.comparatorProperty());
        this.tablePriceListDetails.setItems((ObservableList)sortedData);
    }

    @FXML
    private void priceListDetailChange() {
        System.out.println("Izmena");
        Connection connection = this.controller.getSettings().getConnection();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        Product selectedProduct = (Product)this.tablePriceListDetails.getSelectionModel().getSelectedItem();
        if (selectedProduct != null) {
            hm.put("controller", this.controller);
            hm.put("selectedProduct", selectedProduct);
            this.controller.showModalDialog("Izmena redovnog cenovnika", ScreensController.SCREEN_PRICE_LISTS_REDOVAN_EDIT, hm, this.rootPane.getScene().getWindow());
            PriceListDetailes pldEdit = (PriceListDetailes)hm.get("priceListDetail");
            pldEdit.update(connection);
            this.products.clear();
            for (PriceListDetailes priceListDetailes : PriceListDetailes.getRedovanList((PriceList)this.selectedPriceList, (ScreensController)this.controller)) {
                Product product = priceListDetailes.getProduct();
                this.products.add((Object)product);
            }
        } else {
            String message = "Odaberite detalj cenovnika koji \u017eelite da izmenite";
            this.controller.alert("Upozorenje", message, this.rootPane.getScene().getWindow());
            return;
        }
        this.tablePriceListDetails.setItems(this.products);
        this.filter();
    }

    @FXML
    private void priceListDetailDelete() {
        System.out.println("Brisanje");
        Connection connection = this.controller.getSettings().getConnection();
        Product selectedProduct = (Product)this.tablePriceListDetails.getSelectionModel().getSelectedItem();
        if (selectedProduct != null) {
            PriceListDetailes pld = PriceListDetailes.getByID((long)selectedProduct.getPriceListDetailsId(), (Connection)connection);
            pld.delete(connection);
            this.products.clear();
            for (PriceListDetailes priceListDetailes : PriceListDetailes.getRedovanList((PriceList)this.selectedPriceList, (ScreensController)this.controller)) {
                Product product = priceListDetailes.getProduct();
                this.products.add((Object)product);
            }
        } else {
            String message = "Odaberite detalj cenovnika koji \u017eelite da obri\u0161ete";
            this.controller.alert("Upozorenje", message, this.rootPane.getScene().getWindow());
            return;
        }
        this.tablePriceListDetails.setItems(this.products);
        this.filter();
    }
}

