/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.pricelist;

import java.sql.Connection;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.product.Product;

public class PriceListEditController
implements DialogController {
    private HashMap<String, Object> parameters;
    private ScreensController controller;
    private Product selectedProduct;
    private PriceListDetailes pld;
    private Connection connection;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfProductCode;
    @FXML
    private TextField tfProductBarcode;
    @FXML
    private TextField tfProductName;
    @FXML
    private DatePicker datePickerPldDate;
    @FXML
    private TextField tfProductPrice;

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return 0;
    }

    public void setModalResult(int modalResult) {
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.controller = (ScreensController)this.parameters.get("controller");
        this.selectedProduct = (Product)this.parameters.get("selectedProduct");
        this.connection = this.controller.getSettings().getConnection();
        this.pld = PriceListDetailes.getByID((long)this.selectedProduct.getPriceListDetailsId(), (Connection)this.connection);
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.populateFields();
    }

    @FXML
    void confirm(ActionEvent event) {
        LocalDate ld = (LocalDate)this.datePickerPldDate.getValue();
        try {
            this.pld.setPrice(Double.valueOf(Double.parseDouble(this.tfProductPrice.getText())));
            this.pld.setDate(Date.from(ld.atStartOfDay(ZoneId.systemDefault()).toInstant()));
            this.parameters.put("priceListDetail", this.pld);
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
        catch (Exception e) {
            String message = "Molim Vas unesite ispravnu cenu";
            this.controller.alert("Upozorenje", message, this.rootPane.getScene().getWindow());
            e.printStackTrace();
            return;
        }
    }

    @FXML
    void cancel(ActionEvent event) {
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void populateFields() {
        this.tfProductName.setText(this.selectedProduct.getName());
        this.tfProductCode.setText(this.selectedProduct.getCode());
        this.tfProductBarcode.setText(this.selectedProduct.getBarcode());
        this.tfProductPrice.setText(String.valueOf(this.selectedProduct.getPrice()));
        this.datePickerPldDate.setValue((Object)Settings.fromDate((Date)this.pld.getDate()));
    }
}

