/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.pricelist;

import java.awt.Toolkit;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.OfferPrice;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.PriceListType;
import rs.petcom.master.dal.Settings;

public class PriceListController
implements ControlledScreen {
    private ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private VBox vBox;
    @FXML
    private MenuButton menuButton;
    @FXML
    private MenuItem menuCenovnik;
    @FXML
    private MenuItem menuAkcija;
    @FXML
    private MenuItem menuRedovanCenovnik;
    @FXML
    private TableView<PriceList> tablePriceList;
    @FXML
    private TableColumn<PriceList, String> columnName;
    @FXML
    private TableColumn<PriceList, Date> columnDateFrom;
    @FXML
    private TableColumn<PriceList, Date> columnDateTo;
    @FXML
    private TableColumn<PriceList, Boolean> columnActive;
    @FXML
    private TableColumn<PriceList, String> columnType;
    @FXML
    private Button btnChange;
    @FXML
    private Button btnSrediCenovnik;

    public void initialize() {
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("Title"));
        this.columnDateFrom.setCellValueFactory((Callback)new PropertyValueFactory("DateFrom"));
        this.columnDateFrom.setCellFactory(column -> new TableCell<PriceList, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnDateTo.setCellValueFactory((Callback)new PropertyValueFactory("DateTo"));
        this.columnDateTo.setCellFactory(column -> new TableCell<PriceList, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnActive.setCellValueFactory((Callback)new PropertyValueFactory("Active"));
        this.columnActive.setCellFactory(column -> new TableCell<PriceList, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                }
            }
        });
        this.columnType.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<PriceList, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<PriceList, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)PriceListType.getById((ScreensController)PriceListController.this.controller, (int)((PriceList)param.getValue()).getPriceListTypeID())).name("Name").build();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        this.tablePriceList.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<PriceList>(){

            public void onChanged(ListChangeListener.Change<? extends PriceList> c) {
                if (PriceListController.this.tablePriceList.getSelectionModel().getSelectedItem() != null) {
                    if (((PriceList)PriceListController.this.tablePriceList.getSelectionModel().getSelectedItem()).getPriceListTypeID() == 1) {
                        PriceListController.this.btnChange.setText("Detalji redovnog");
                    } else {
                        PriceListController.this.btnChange.setText("Izmeni");
                    }
                }
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        if (!this.controller.getSettings().isFullscreen()) {
            this.vBox.setMinWidth(this.rootPane.getPrefWidth() * 12.0 / 100.0);
        } else {
            this.vBox.setMinWidth(Toolkit.getDefaultToolkit().getScreenSize().getWidth() * 12.0 / 100.0);
        }
        this.tablePriceList.setItems(PriceList.getNewList((ScreensController)this.controller));
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void newAction() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("selectedOfferPrice", null);
        hm.put("priceListType", PriceListType.getByName((ScreensController)this.controller, (String)"Akcija"));
        this.controller.showModalDialog("Akcijski Cenovnik - Detalji", ScreensController.SCREEN_PRICE_LISTS_REDOVAN, hm, this.rootPane.getScene().getWindow());
        this.tablePriceList.setItems(PriceList.getNewList((ScreensController)this.controller));
    }

    @FXML
    private void newCenovnik() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("selectedBOP", null);
        hm.put("priceListType", PriceListType.getByName((ScreensController)this.controller, (String)"Cenovnik"));
        this.controller.showModalDialog("", ScreensController.SCREEN_PRICE_LISTS_NEW, hm, this.rootPane.getScene().getWindow());
        this.tablePriceList.setItems(PriceList.getNewList((ScreensController)this.controller));
    }

    @FXML
    private void newRedovanCenovnik() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("selectedBOP", null);
        hm.put("priceListType", PriceListType.getByName((ScreensController)this.controller, (String)"Redovan"));
        this.controller.showModalDialog("", ScreensController.SCREEN_PRICE_LISTS_NEW, hm, this.rootPane.getScene().getWindow());
        this.tablePriceList.setItems(PriceList.getNewList((ScreensController)this.controller));
    }

    @FXML
    private void updatePricelist() {
        if (this.tablePriceList.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("priceListType", PriceListType.getById((ScreensController)this.controller, (int)((PriceList)this.tablePriceList.getSelectionModel().getSelectedItem()).getPriceListTypeID()));
            if (((PriceList)this.tablePriceList.getSelectionModel().getSelectedItem()).getPriceListTypeID() == 1) {
                hm.put("selectedPriceList", PriceList.getRegular((LocalDateTime)LocalDateTime.now(), (int)this.controller.getObject().getObjectID(), (Connection)this.controller.getSettings().getConnection()));
                this.controller.showModalDialog("", ScreensController.SCREEN_PRICE_LISTS_REDOVAN, hm, this.rootPane.getScene().getWindow());
            }
            if (((PriceList)this.tablePriceList.getSelectionModel().getSelectedItem()).getPriceListTypeID() == 5) {
                hm.put("selectedBOP", BuyerOfferPrice.getOfferPrice((long)((PriceList)this.tablePriceList.getSelectionModel().getSelectedItem()).getBuyerOfferPriceID(), (Connection)this.controller.getSettings().getConnection()));
                this.controller.showModalDialog("", ScreensController.SCREEN_PRICE_LISTS_NEW, hm, this.rootPane.getScene().getWindow());
            }
            if (((PriceList)this.tablePriceList.getSelectionModel().getSelectedItem()).getPriceListTypeID() == 6) {
                hm.put("selectedOfferPrice", OfferPrice.getOfferPrice((long)((PriceList)this.tablePriceList.getSelectionModel().getSelectedItem()).getOfferPriceID(), (Connection)this.controller.getSettings().getConnection()));
                this.controller.showModalDialog("Akcijski Cenovnik - Detalji", ScreensController.SCREEN_PRICE_LISTS_NEW, hm, this.rootPane.getScene().getWindow());
            }
            this.tablePriceList.setItems(PriceList.getNewList((ScreensController)this.controller));
        }
    }

    @FXML
    private void deletePricelist() {
        if (((PriceList)this.tablePriceList.getSelectionModel().getSelectedItem()).getPriceListTypeID() == 5) {
            BuyerOfferPrice buyerOfferPrice = BuyerOfferPrice.getOfferPrice((long)((PriceList)this.tablePriceList.getSelectionModel().getSelectedItem()).getBuyerOfferPriceID(), (Connection)this.controller.getSettings().getConnection());
            buyerOfferPrice.delete(this.controller.getSettings().getConnection());
        }
        if (((PriceList)this.tablePriceList.getSelectionModel().getSelectedItem()).getPriceListTypeID() == 6) {
            OfferPrice offerPrice = OfferPrice.getOfferPrice((long)((PriceList)this.tablePriceList.getSelectionModel().getSelectedItem()).getOfferPriceID(), (Connection)this.controller.getSettings().getConnection());
            try {
                offerPrice.delete(this.controller.getSettings().getConnection());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.tablePriceList.setItems(PriceList.getNewList((ScreensController)this.controller));
    }

    @FXML
    public void srediPricelist(ActionEvent actionEvent) {
        PriceList.srediPricelist((Connection)this.controller.getSettings().getConnection());
    }
}

