/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.popis;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.ControllData;
import rs.petcom.master.dal.Department;
import rs.petcom.master.gui.EditingTableCellDouble;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class PresekSmeneController
implements DialogController {
    ScreensController controller;
    HashMap<String, Object> parameter;
    Timestamp date;
    ObservableList<ControllData> controllList;
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<ControllData> table;
    @FXML
    private TableColumn<ControllData, Integer> tcKontrola;
    @FXML
    private TableColumn<ControllData, String> tcArtikal;
    @FXML
    private TableColumn<Object, Double> tcLager;
    @FXML
    private TableColumn<Object, Double> tcPopisano;
    @FXML
    private TableColumn<Object, Double> tcRazlika;
    @FXML
    private TableColumn<ControllData, String> tcComment;

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)this.parameter.get("controller");
        this.date = (Timestamp)this.parameter.get("date");
        rs.petcom.master.dal.Object object = (rs.petcom.master.dal.Object)this.parameter.get("object");
        Department department = (Department)parameter.get("department");
        try {
            this.controllList = ControllData.createNewControll((Timestamp)this.date, (Department)department, (rs.petcom.master.dal.Object)object, (ScreensController)this.controller);
            this.table.setItems(this.controllList);
        }
        catch (SQLException e) {
            this.controller.alert("Gre\u0161ka pri upisu u bazu!", e.getMessage(), this.rootPane.getScene().getWindow());
        }
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void post(ActionEvent event) {
        for (ControllData cd : this.controllList) {
            cd.insert(this.date, this.controller.getSettings().getConnection(), (rs.petcom.master.dal.Object)this.parameter.get("object"));
        }
        String reportFileName = "rs/petcom/backoffice/jasper/PresekSmene.jasper";
        try {
            HashMap<String, Timestamp> hm = new HashMap<String, Timestamp>();
            hm.put("time", this.date);
            hm.put("object", (Timestamp)this.controller.getObject());
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Presek smene", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void initialize() {
        this.table.addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                TablePosition focusedCellPosition = PresekSmeneController.this.table.getFocusModel().getFocusedCell();
                PresekSmeneController.this.table.edit(focusedCellPosition.getRow(), focusedCellPosition.getTableColumn());
            }
        });
        this.tcKontrola.setCellValueFactory((Callback)new PropertyValueFactory("Group"));
        this.tcArtikal.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        Callback<TableColumn<Object, Double>, TableCell<Object, Double>> doubleCellFactory = new Callback<TableColumn<Object, Double>, TableCell<Object, Double>>(){

            public TableCell<Object, Double> call(TableColumn<Object, Double> p) {
                return new EditingTableCellDouble(2, true);
            }
        };
        this.tcLager.setCellValueFactory((Callback)new PropertyValueFactory("CalculatedValue"));
        this.tcLager.setCellFactory((Callback)doubleCellFactory);
        this.tcLager.setOnEditCommit(t -> {
            ControllData cd = (ControllData)this.controllList.get(t.getTablePosition().getRow());
            cd.setCalculatedValue(((Double)t.getNewValue()).doubleValue());
            cd.setDifference(cd.getEnteredValue() - cd.getCalculatedValue());
            this.controllList.set(t.getTablePosition().getRow(), (Object)cd);
        });
        this.tcPopisano.setCellValueFactory((Callback)new PropertyValueFactory("EnteredValue"));
        this.tcPopisano.setCellFactory((Callback)doubleCellFactory);
        this.tcPopisano.setOnEditCommit(t -> {
            ControllData cd = (ControllData)this.controllList.get(t.getTablePosition().getRow());
            cd.setEnteredValue(((Double)t.getNewValue()).doubleValue());
            cd.setDifference(cd.getEnteredValue() - cd.getCalculatedValue());
            this.controllList.set(t.getTablePosition().getRow(), (Object)cd);
        });
        this.tcRazlika.setCellValueFactory((Callback)new PropertyValueFactory("Difference"));
        this.tcRazlika.setCellFactory((Callback)doubleCellFactory);
        this.tcComment.setCellValueFactory((Callback)new PropertyValueFactory("Comment"));
        this.tcComment.setCellFactory(TextFieldTableCell.forTableColumn());
        this.tcComment.setOnEditCommit(t -> ((ControllData)t.getTableView().getItems().get(t.getTablePosition().getRow())).setComment((String)t.getNewValue()));
    }
}

