/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.popis;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.ControllData;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class ControllListController
implements ControlledScreen {
    ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private DatePicker dcDateFrom;
    @FXML
    private DatePicker dcDateTo;
    @FXML
    private Button btnPrint;
    @FXML
    private TableView<ControllData> tbTime;
    @FXML
    private TableColumn<ControllData, Date> tcTime;

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<rs.petcom.master.dal.Object>(){

            public void changed(ObservableValue<? extends rs.petcom.master.dal.Object> observable, rs.petcom.master.dal.Object oldValue, rs.petcom.master.dal.Object newValue) {
                ControllListController.this.loadDepartment();
                ControllListController.this.loadList();
            }
        });
        this.dcDateFrom.valueProperty().addListener((ChangeListener)new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                ControllListController.this.loadList();
            }
        });
        this.dcDateTo.valueProperty().addListener((ChangeListener)new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                ControllListController.this.loadList();
            }
        });
        this.tcTime.setCellValueFactory((Callback)new PropertyValueFactory("ControllTime"));
        this.tcTime.setCellFactory(column -> new TableCell<ControllData, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbObject.setItems(rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection()));
        if (this.controller.getPointOfSale() == null) {
            this.cbObject.getSelectionModel().select(0);
        } else {
            for (rs.petcom.master.dal.Object object : this.cbObject.getItems()) {
                if (object.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)object);
                break;
            }
        }
        this.dcDateFrom.setValue((Object)LocalDate.ofYearDay(LocalDate.now().getYear(), 1));
        this.dcDateTo.setValue((Object)LocalDate.now());
    }

    public void setParameter(Object parameter) {
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    public void createNew(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("title", "Presek smene");
        hm.put("text", "Da li ste sigurni da \u017eelite da uradite presek smene?");
        int result = this.controller.showModalDialog("Presek smene", ScreensController.DIALOG_YES_NO, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_YES) {
            Timestamp controllDate = new Timestamp(new Date().getTime());
            hm = new HashMap();
            hm.put("date", controllDate);
            hm.put("controller", this.controller);
            hm.put("object", this.cbObject.getSelectionModel().getSelectedItem());
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            int result2 = this.controller.showModalDialog("Presek smene", ScreensController.SCREEN_BACKOFFICE_POPIS_PRESEK_SMENE, hm, this.rootPane.getScene().getWindow());
            if (result2 == ScreensController.MODAL_RESULT_OK) {
                this.loadList();
            }
        }
    }

    @FXML
    public void print(ActionEvent event) {
        String reportFileName = "rs/petcom/backoffice/jasper/PresekSmene.jasper";
        try {
            HashMap<String, Timestamp> hm = new HashMap<String, Timestamp>();
            Timestamp controllDate = new Timestamp(((ControllData)this.tbTime.getSelectionModel().getSelectedItem()).getControllTime().getTime());
            hm.put("time", controllDate);
            hm.put("object", (Timestamp)this.controller.getObject());
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void loadList() {
        try {
            if (this.dcDateFrom.getValue() != null && this.dcDateTo.getValue() != null && this.cbObject.getSelectionModel().getSelectedItem() != null) {
                this.tbTime.setItems(ControllData.getControllList((LocalDate)((LocalDate)this.dcDateFrom.getValue()), (LocalDate)((LocalDate)this.dcDateTo.getValue()), (int)((rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID(), (Connection)this.controller.getSettings().getConnection()));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void dateFromChange() {
        this.loadList();
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((rs.petcom.master.dal.Object)((rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((Object)d);
        }
        if (this.cbDepartment.getItems().size() == 1) {
            this.cbDepartment.getSelectionModel().select(0);
        }
    }
}

