/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.izvestaji;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import rs.petcom.backoffice.controller.reports.ReportMapModel;
import rs.petcom.backoffice.reports.models.SalesOfArticleReportModel;
import rs.petcom.backoffice.salesreportnew.reportmodels.JasperStarter;
import rs.petcom.enums.SortingValue;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.product.ProductCategory;

public class ProdatiArtikliController
implements ControlledScreen {
    private ScreensController controller;
    private ArrayList<PointOfSale> posList;
    private ObservableList<ProductCategory> productCategoryList;
    private Connection connection;
    @FXML
    private BorderPane rootPane;
    @FXML
    private GridPane gridPane;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private ComboBox<PointOfSale> cbPos;
    @FXML
    private ComboBox<ProductCategory> cbProductCategory;
    @FXML
    private ComboBox<SortingValue> cbSortBy;
    @FXML
    private TableView<SalesOfArticleReportModel> tvReportTable;
    @FXML
    private TableColumn<SalesOfArticleReportModel, String> colBarCode;
    @FXML
    private TableColumn<SalesOfArticleReportModel, String> colCode;
    @FXML
    private TableColumn<SalesOfArticleReportModel, String> colArticleName;
    @FXML
    private TableColumn<SalesOfArticleReportModel, Double> colQuantity;
    @FXML
    private TableColumn<SalesOfArticleReportModel, Double> colPrice;
    @FXML
    private TableColumn<SalesOfArticleReportModel, Double> colValue;

    public void initialize() {
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.connection = this.controller.getSettings().getConnection();
        this.posList = PointOfSale.getPosList((rs.petcom.master.dal.Object)this.controller.getObject(), (Connection)this.connection);
        this.productCategoryList = ProductCategory.getObeservableList((Connection)this.connection);
        this.fillData();
    }

    public void setParameter(Object parameter) {
        this.colBarCode.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.colCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.colArticleName.setCellValueFactory((Callback)new PropertyValueFactory("articleName"));
        this.colQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.colValue.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.colBarCode.prefWidthProperty().bind((ObservableValue)this.tvReportTable.widthProperty().multiply(0.1));
        this.colCode.prefWidthProperty().bind((ObservableValue)this.tvReportTable.widthProperty().multiply(0.1));
        this.colArticleName.prefWidthProperty().bind((ObservableValue)this.tvReportTable.widthProperty().multiply(0.45));
        this.colQuantity.prefWidthProperty().bind((ObservableValue)this.tvReportTable.widthProperty().multiply(0.1));
        this.colPrice.prefWidthProperty().bind((ObservableValue)this.tvReportTable.widthProperty().multiply(0.1));
        this.colValue.prefWidthProperty().bind((ObservableValue)this.tvReportTable.widthProperty().multiply(0.1));
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void printReport() {
        String path = "rs/petcom/backoffice/jasper/salesreportnew/SalesOfArticles.jasper";
        LocalDate dateFrom = (LocalDate)this.dpFrom.getValue();
        LocalDate dateTo = (LocalDate)this.dpTo.getValue();
        Map<String, Object> reportResources = ReportMapModel.getReportMap(this.controller);
        reportResources.put("datas", this.tvReportTable.getItems());
        reportResources.put("controller", this.controller);
        reportResources.put("dateFrom", dateFrom);
        reportResources.put("dateTo", dateTo);
        JasperStarter starter = new JasperStarter(reportResources, path, this.rootPane);
        starter.createReportCollectionDataSource();
    }

    private void fillData() {
        this.cbPos.getItems().clear();
        PointOfSale svaProdajnaMesta = new PointOfSale();
        svaProdajnaMesta.setPointOfSaleID(-1);
        svaProdajnaMesta.setName("Sva prodajna mesta");
        this.cbPos.getItems().add((Object)svaProdajnaMesta);
        for (PointOfSale pos : this.posList) {
            this.cbPos.getItems().add((Object)pos);
        }
        this.cbPos.getSelectionModel().select((Object)svaProdajnaMesta);
        final LocalDate lastWorkDay = Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDateFrom());
        this.dpFrom.setDayCellFactory(d -> new DateCell(){

            public void updateItem(LocalDate item, boolean empty) {
                super.updateItem(item, empty);
                this.setDisable(item.isAfter(lastWorkDay));
            }
        });
        this.dpTo.setDayCellFactory(d -> new DateCell(){

            public void updateItem(LocalDate item, boolean empty) {
                super.updateItem(item, empty);
                this.setDisable(item.isAfter(lastWorkDay));
            }
        });
        this.fillProductCategoryCombo();
        this.fillSortByCombo();
        this.dpFrom.setValue((Object)lastWorkDay);
        this.dpTo.setValue((Object)lastWorkDay);
        this.dpFrom.valueProperty().addListener((ob, oldValue, newValue) -> this.fillTheTable());
        this.dpTo.valueProperty().addListener((ob, oldValue, newValue) -> this.fillTheTable());
        this.cbPos.valueProperty().addListener((ob, oldValue, newValue) -> this.fillTheTable());
        this.cbProductCategory.valueProperty().addListener((ob, oldValue, newValue) -> this.fillTheTable());
        this.cbSortBy.valueProperty().addListener((ob, oldValue, newValue) -> this.fillTheTable());
        this.fillTheTable();
    }

    private void fillTheTable() {
        WorkDay wdFrom = WorkDay.getFromDbByDate((LocalDate)((LocalDate)this.dpFrom.getValue()), (Connection)this.connection);
        WorkDay wdTo = WorkDay.getFromDbByDate((LocalDate)((LocalDate)this.dpTo.getValue()), (Connection)this.connection);
        long wdFromId = wdFrom.getWorkDayID();
        long wdToId = wdTo.getWorkDayID();
        String pointsOfSale = this.getPointsOfSale();
        String productCategories = this.getProductCategories();
        String sortParameter = this.getSortParameter();
        ObservableList<SalesOfArticleReportModel> salesList = SalesOfArticleReportModel.getSaleReportDatas(this.connection, wdFromId, wdToId, pointsOfSale, productCategories, sortParameter);
        this.tvReportTable.setItems(salesList);
    }

    private String getPointsOfSale() {
        PointOfSale pos = (PointOfSale)this.cbPos.getSelectionModel().getSelectedItem();
        if (pos.getPointOfSaleID() == -1) {
            return this.allPosIdsFromDb();
        }
        return this.posIdAsString(pos);
    }

    private String allPosIdsFromDb() {
        StringBuilder sb = new StringBuilder();
        int numberOfPointsOfSale = this.posList.size();
        for (int i = 0; i < numberOfPointsOfSale; ++i) {
            sb.append(this.posIdAsString(this.posList.get(i)));
            sb.append(",");
        }
        return this.removeLastCharFromString(sb.toString());
    }

    private String posIdAsString(PointOfSale pos) {
        return String.valueOf(pos.getPointOfSaleID());
    }

    private void fillSortByCombo() {
        SortingValue[] sortValues;
        for (SortingValue sv : sortValues = SortingValue.values()) {
            this.cbSortBy.getItems().add((Object)sv);
            this.cbSortBy.getSelectionModel().select(0);
        }
    }

    private void fillProductCategoryCombo() {
        this.cbProductCategory.getItems().clear();
        ProductCategory allCategoriesInput = this.makeAllProductCategoryInput();
        this.addProductCategoryToCombo(allCategoriesInput);
        this.addCategoriesFromDb();
        this.cbProductCategory.getSelectionModel().select((Object)allCategoriesInput);
    }

    private ProductCategory makeAllProductCategoryInput() {
        ProductCategory prodCategory = new ProductCategory();
        prodCategory.setProductCategoryID(-1);
        prodCategory.setName("Sve kategorije");
        prodCategory.setUtrosciPrikaz(true);
        return prodCategory;
    }

    private void addCategoriesFromDb() {
        for (ProductCategory productCategory : this.productCategoryList) {
            this.addProductCategoryToCombo(productCategory);
        }
    }

    private void addProductCategoryToCombo(ProductCategory productCategory) {
        this.cbProductCategory.getItems().add((Object)productCategory);
    }

    private String getProductCategories() {
        ProductCategory productCategory = (ProductCategory)this.cbProductCategory.getSelectionModel().getSelectedItem();
        if (productCategory.getProductCategoryID() == -1) {
            return this.allProductCategoriesIdsFromDb();
        }
        return this.productCategoriesIdAsString(productCategory);
    }

    private String allProductCategoriesIdsFromDb() {
        StringBuilder sb = new StringBuilder();
        int numberProductCategories = this.productCategoryList.size();
        for (int i = 0; i < numberProductCategories; ++i) {
            sb.append(this.productCategoriesIdAsString((ProductCategory)this.productCategoryList.get(i)));
            sb.append(",");
        }
        return this.removeLastCharFromString(sb.toString());
    }

    private String productCategoriesIdAsString(ProductCategory productCategory) {
        return String.valueOf(productCategory.getProductCategoryID());
    }

    private String removeLastCharFromString(String posIds) {
        return posIds.substring(0, posIds.length() - 1);
    }

    public String getSortParameter() {
        SortingValue sortValue = (SortingValue)this.cbSortBy.getSelectionModel().getSelectedItem();
        switch (sortValue) {
            case Naziv: {
                return "p.Name";
            }
            case \u0160ifra: {
                return "CAST(p.Code AS DECIMAL(20,2))";
            }
            case Barkod: {
                return "CAST(bCode AS DECIMAL(20,2))";
            }
            case Koli\u010dina: {
                return "quantity";
            }
            case Cena: {
                return "dd.PriceWithDiscount ";
            }
        }
        return "p.Name";
    }
}

