/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.financialdiscount;

import java.util.HashMap;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.FinancialDiscount;

public class FinancialDiscountDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private FinancialDiscount selectedFinancialDiscount;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfValue;
    @FXML
    private TextField tfDiscount;
    @FXML
    private CheckBox cbActive;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedFinancialDiscount = (FinancialDiscount)parameter.get("selectedFinancialDiscount");
        this.fillAditionalField();
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void actionSave() {
        if (!this.tfName.getText().trim().equals("")) {
            if (this.selectedFinancialDiscount == null) {
                this.selectedFinancialDiscount = new FinancialDiscount();
                this.selectedFinancialDiscount.setName(this.tfName.getText().trim());
                this.selectedFinancialDiscount.setValue(Double.parseDouble(this.tfValue.getText().trim()));
                this.selectedFinancialDiscount.setDiscount(Double.parseDouble(this.tfDiscount.getText().trim()));
                this.selectedFinancialDiscount.setActive(this.cbActive.isSelected());
                this.selectedFinancialDiscount.insert(this.controller);
            } else {
                this.selectedFinancialDiscount.setName(this.tfName.getText().trim());
                this.selectedFinancialDiscount.setValue(Double.parseDouble(this.tfValue.getText().trim()));
                this.selectedFinancialDiscount.setDiscount(Double.parseDouble(this.tfDiscount.getText().trim()));
                this.selectedFinancialDiscount.setActive(this.cbActive.isSelected());
                this.selectedFinancialDiscount.update(this.controller);
            }
        } else {
            this.controller.alert("Obavestenje", "Polje za naziv finansijskog popusta ne moze biti prazno", this.rootPane.getScene().getWindow());
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void actionClose() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void fillAditionalField() {
        if (this.selectedFinancialDiscount != null) {
            this.tfName.setText(this.selectedFinancialDiscount.getName().trim());
            this.tfValue.setText(String.valueOf(this.selectedFinancialDiscount.getValue()));
            this.tfDiscount.setText(String.valueOf(this.selectedFinancialDiscount.getDiscount()));
            this.cbActive.setSelected(this.selectedFinancialDiscount.isActive());
        } else {
            this.tfName.setText("");
            this.tfValue.setText("");
            this.tfDiscount.setText("");
            this.cbActive.setSelected(false);
        }
    }
}

