/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.SravnjenjePoPopisu;
import rs.petcom.master.dal.person.Person;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class SravnjenjePoPopisuController
implements ControlledScreen {
    ScreensController controller;
    rs.petcom.master.dal.Object sviObjekti = new rs.petcom.master.dal.Object(-1, "Svi objekti");
    Department svaOdeljenja = new Department(-1, "Sva odeljenja");
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private TableView<SravnjenjePoPopisu> table;
    @FXML
    private TableColumn<SravnjenjePoPopisu, Integer> tcBroj;
    @FXML
    private TableColumn<SravnjenjePoPopisu, Date> tcDate;
    @FXML
    private TableColumn<SravnjenjePoPopisu, String> tcNapomena;
    @FXML
    private Button btnNew;
    @FXML
    private Button btnEdit;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnDelete;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbObject.getItems().add((Object)this.sviObjekti);
        for (rs.petcom.master.dal.Object o : rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((Object)o);
        }
        if (this.cbObject.getItems().size() == 2) {
            this.cbObject.getSelectionModel().select(1);
        } else {
            this.cbObject.getSelectionModel().select((Object)this.sviObjekti);
        }
    }

    public void setParameter(Object parameter) {
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<rs.petcom.master.dal.Object>(){

            public void changed(ObservableValue<? extends rs.petcom.master.dal.Object> observable, rs.petcom.master.dal.Object oldValue, rs.petcom.master.dal.Object newValue) {
                SravnjenjePoPopisuController.this.loadDepartment();
            }
        });
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                SravnjenjePoPopisuController.this.loadDocumentList();
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<SravnjenjePoPopisu>(){

            public void changed(ObservableValue<? extends SravnjenjePoPopisu> observable, SravnjenjePoPopisu oldValue, SravnjenjePoPopisu newValue) {
                if (newValue == null) {
                    SravnjenjePoPopisuController.this.btnDelete.setDisable(true);
                    SravnjenjePoPopisuController.this.btnPrint.setDisable(true);
                    SravnjenjePoPopisuController.this.btnEdit.setDisable(true);
                } else {
                    SravnjenjePoPopisuController.this.btnDelete.setDisable(false);
                    SravnjenjePoPopisuController.this.btnPrint.setDisable(false);
                    SravnjenjePoPopisuController.this.btnEdit.setDisable(false);
                }
            }
        });
        this.tcBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDate.setCellFactory(column -> new TableCell<SravnjenjePoPopisu, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcNapomena.setCellValueFactory((Callback)new PropertyValueFactory("Note"));
    }

    @FXML
    public void actionNew(ActionEvent event) {
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            if (this.cbDepartment.getSelectionModel().getSelectedIndex() > 0) {
                hm.put("controller", this.controller);
                hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
                SravnjenjePoPopisu s = new SravnjenjePoPopisu(-1L, -1, new Date(), ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), "");
                hm.put("sravnjenjePoPopisu", s);
                int result = this.controller.showModalDialog("Sravnjenje po popisu - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_SRAVNJENJE_PO_POPISU_DETAILES, hm, this.rootPane.getScene().getWindow());
                if (result == ScreensController.MODAL_RESULT_OK) {
                    this.loadDocumentList();
                }
            } else {
                this.controller.alert("Obave\u0161tenje", "Morate odabrati odeljenje.", this.rootPane.getScene().getWindow());
            }
        }
        catch (Exception e) {
            this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom upisa u bazu", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionEdit(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            if (this.cbDepartment.getSelectionModel().getSelectedIndex() > 0) {
                hm.put("controller", this.controller);
                hm.put("sravnjenjePoPopisu", this.table.getSelectionModel().getSelectedItem());
                hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
                hm.put("selectAllProducts", true);
                this.controller.showModalDialog("Po\u010detno stanje - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_SRAVNJENJE_PO_POPISU_DETAILES, hm, this.rootPane.getScene().getWindow());
            } else {
                this.controller.alert("Obave\u0161tenje", "Morate odabrati odeljenje.", this.rootPane.getScene().getWindow());
            }
        }
    }

    @FXML
    public void actionPrint(ActionEvent event) {
        String reportFileName = "rs/petcom/backoffice/jasper/SravnjenjePoPopisu.jasper";
        HashMap<String, Object> hm = new HashMap<String, Object>();
        Document document = Document.getByID((long)((SravnjenjePoPopisu)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        if (file.exists() && file.isFile()) {
            hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        } else {
            hm.put("memorandum", "");
        }
        hm.put("person", Person.getByCode((String)"1", (Connection)this.controller.getSettings().getConnection()));
        hm.put("documentId", document.getDocumentID());
        hm.put("document", document);
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Sravnjenje po popisu", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        try {
            ((SravnjenjePoPopisu)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
        catch (SQLException e) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("title", "Brisanje po\u010detnog stanja nije mogu\u0107e!");
            hm.put("text", "\nPoruka o gre\u0161ci:\n\n" + e.getLocalizedMessage());
            this.controller.showModalDialog("Brisanje po\u010detnog stanja nije mogu\u0107e!", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        }
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        this.cbDepartment.getItems().add((Object)this.svaOdeljenja);
        for (Department d : Department.getList((rs.petcom.master.dal.Object)((rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((Object)d);
        }
        if (this.cbDepartment.getItems().size() == 2) {
            this.cbDepartment.getSelectionModel().select(1);
        } else {
            this.cbDepartment.getSelectionModel().select((Object)this.svaOdeljenja);
        }
    }

    private void loadDocumentList() {
        this.table.getItems().clear();
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
                this.table.setItems(SravnjenjePoPopisu.getlist((Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection()));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

