/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.backoffice.gui.ComboBoxCellFactory;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.Faktura;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.product.Product;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class RobnaKarticaController
implements ControlledScreen {
    private ScreensController controller;
    private Product filteredProduct;
    private ArrayList<Product> productList;
    private ComboBoxCellFactory cbCellFactory;
    private AutoCompleteCBWithoutProducts<Product> cbProductAutoComplete;
    String pathWithoutName = null;
    @FXML
    private BorderPane rootPane;
    @FXML
    private GridPane gridPane;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private TableView<Document> robnaKarticaTable;
    @FXML
    private TableColumn<Document, String> datumColumnRK;
    @FXML
    private TableColumn<Document, String> nazivDokumentaColumnRK;
    @FXML
    private TableColumn<Document, Double> ulazColumnRK;
    @FXML
    private TableColumn<Document, Double> izlazColumnRK;
    @FXML
    private TableColumn<Document, Double> stanjeColumnRK;
    @FXML
    private TableColumn<Document, Double> nabavnaCenaColumnRK;
    @FXML
    private TableColumn<Document, Double> nabavnaVrednostColumnRK;
    @FXML
    private TableColumn<Document, Double> prodajnaCenaColumnRK;
    @FXML
    private TableColumn<Document, Double> prodajnaVrednostColumnRK;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private Label lblProduct;
    @FXML
    private Label lblUlaz;
    @FXML
    private Label lblIzlaz;
    @FXML
    private Label lblStanje;
    @FXML
    private DatePicker datePickerOdRobnaKartica;
    @FXML
    private DatePicker datePickerDoRobnaKartica;
    EventHandler<KeyEvent> eventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            if (RobnaKarticaController.this.cbProduct.isFocused()) {
                switch (event.getCode()) {
                    case ENTER: {
                        event.consume();
                        if (RobnaKarticaController.this.cbProduct.getSelectionModel().getSelectedItem() == null) break;
                        RobnaKarticaController.this.robnaKarticaTable.setVisible(true);
                        RobnaKarticaController.this.robnaKarticaTable.getItems().clear();
                        RobnaKarticaController.this.popuniTableRobnaKartica();
                        break;
                    }
                }
            }
        }
    };

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @FXML
    public void initialize() {
        this.robnaKarticaTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Document document = Document.getByID((long)((Document)row.getItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
                    switch (document.getDocumentTypeID()) {
                        case 1: {
                            final String reportFileName = "rs/petcom/backoffice/jasper/PrijemnicaTrgovina.jasper";
                            final HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
                            File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
                            if (file.exists() && file.isFile()) {
                                hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
                            } else {
                                hm.put("memorandum", "");
                            }
                            hm.put("person", Person.getByCode((String)"1", (Connection)this.controller.getSettings().getConnection()));
                            hm.put("documentId", document.getDocumentID());
                            hm.put("document", document);
                            hm.put("prijemnica", true);
                            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
                            hm.put("dobavljac", Person.getById((long)document.getPersonID(), (ScreensController)this.controller));
                            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje kalkulacije u toku.", this.rootPane.getScene().getWindow());
                            Task<JasperPrint> creatingReport = new Task<JasperPrint>(){

                                protected JasperPrint call() throws Exception {
                                    try {
                                        JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(0);
                                        hm.put("REPORT_VIRTUALIZER", virtualizer);
                                        JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                                        JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)RobnaKarticaController.this.controller.getSettings().getConnection());
                                        virtualizer.setReadOnly(true);
                                        return jprint;
                                    }
                                    catch (JRException e) {
                                        e.printStackTrace();
                                        return null;
                                    }
                                }
                            };
                            creatingReport.setOnSucceeded(arg_0 -> this.lambda$null$0(taskUpdateStage, (Task)creatingReport, arg_0));
                            creatingReport.setOnFailed(eventValue -> {
                                taskUpdateStage.hide();
                                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no kreiranje kalkulacije", this.rootPane.getScene().getWindow());
                            });
                            creatingReport.exceptionProperty().addListener((obs, old, newValue) -> {
                                if (newValue != null) {
                                    Exception ex = (Exception)newValue;
                                    ex.printStackTrace();
                                }
                            });
                            new Thread((Runnable)creatingReport).start();
                            break;
                        }
                        case 6: {
                            Faktura f = new Faktura();
                            f.setDocument(document);
                            f.printProfaktura(this.controller, this.rootPane.getScene().getWindow());
                            break;
                        }
                        case 22: {
                            String reportFileName = "rs/petcom/backoffice/jasper/NalogZaIspravku.jasper";
                            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
                            Address address = Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection());
                            try {
                                File file1 = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
                                if (file1.exists() && file1.isFile()) {
                                    hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
                                } else {
                                    hm.put("memorandum", "");
                                }
                                hm.put("person", Person.getByCode((String)"1", (Connection)this.controller.getSettings().getConnection()));
                                hm.put("documentId", document.getDocumentID());
                                hm.put("document", document);
                                hm.put("object", this.controller.getObject());
                                hm.put("company", CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller));
                                hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
                                hm.put("address", address);
                                hm.put("parentDocumentId", document.getDocumentID());
                                hm.put("ImePrezime", document.getName());
                                hm.put("JMBG", document.getJmbg());
                                hm.put("BI", document.getFullNumber());
                                hm.put("documentNI", true);
                                hm.put("datumNaloga", document.getDate());
                                JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                                JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
                                JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                                HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
                                hm2.put("report", printViewPane);
                                this.controller.showModalDialog("Po\u010detno stanje", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
                            }
                            catch (JRException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                    }
                }
            });
            return row;
        });
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.fillDepartment();
        try {
            this.datePickerOdRobnaKartica.setValue((java.lang.Object)Settings.fromDate((java.util.Date)Document.Poslednji_popis_department_pre_datuma_v4((int)1, (java.util.Date)new java.util.Date(), (Connection)this.controller.getSettings().getConnection())));
        }
        catch (NullPointerException e) {
            this.datePickerOdRobnaKartica.setValue((java.lang.Object)Settings.fromDate((java.util.Date)new java.util.Date()));
        }
        this.datePickerDoRobnaKartica.setValue((java.lang.Object)Settings.fromDate((java.util.Date)new java.util.Date()));
        this.gridPane.addEventHandler(KeyEvent.KEY_PRESSED, this.eventHandler);
    }

    public void setParameter(java.lang.Object parameter) {
        this.productList = new ArrayList();
        this.cbCellFactory = new ComboBoxCellFactory((ObservableList<Product>)FXCollections.observableArrayList(this.productList), this.controller, (Department)this.cbDepartment.getSelectionModel().getSelectedItem(), ScreensController.FILTER_ALL);
        this.cbProduct.valueProperty().addListener((ov, oldValue, newValue) -> {
            if (this.cbProduct.getSelectionModel().getSelectedItem() != null) {
                this.filteredProduct = (Product)this.cbProduct.getSelectionModel().getSelectedItem();
            }
        });
        this.cbProductAutoComplete = new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), ScreensController.FILTER_ALL, new TextField());
        this.cbProductAutoComplete.setFilterType(ScreensController.FILTER_ALL);
        this.cbCellFactory.setFilterType(ScreensController.FILTER_ALL);
        this.cbProduct.valueProperty().addListener((ov, oldValue, newValue) -> {
            if (this.cbProduct.getSelectionModel().getSelectedItem() != null) {
                this.filteredProduct = (Product)this.cbProduct.getSelectionModel().getSelectedItem();
            }
        });
    }

    public java.lang.Object getParameter() {
        return null;
    }

    @FXML
    private void prikaziRobnuKarticu() {
        this.robnaKarticaTable.setVisible(true);
        this.robnaKarticaTable.getItems().clear();
        this.popuniTableRobnaKartica();
    }

    private void popuniTableRobnaKartica() {
        this.lblProduct.setText(this.filteredProduct.getName());
        try {
            java.util.Date dateOd = Settings.fromLocalDate((LocalDate)((LocalDate)this.datePickerOdRobnaKartica.getValue()));
            java.util.Date dateDo = Settings.fromLocalDate((LocalDate)((LocalDate)this.datePickerDoRobnaKartica.getValue()));
            this.robnaKarticaTable.setItems(Document.CALL_productCard_get((long)this.filteredProduct.getProductID(), (java.util.Date)new Date(dateOd.getTime()), (java.util.Date)new Date(dateDo.getTime()), (int)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), (Connection)this.controller.getSettings().getConnection()));
            this.datumColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
            this.makeHeaderWrappable(this.datumColumnRK);
            this.ulazColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("Ulaz"));
            this.makeHeaderWrappable(this.ulazColumnRK);
            this.izlazColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("Izlaz"));
            this.makeHeaderWrappable(this.izlazColumnRK);
            this.stanjeColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("Stanje"));
            this.makeHeaderWrappable(this.stanjeColumnRK);
            this.nabavnaCenaColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("NabavnaCena"));
            this.makeHeaderWrappable(this.nabavnaCenaColumnRK);
            this.nabavnaVrednostColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("NabavnaVrednost"));
            this.makeHeaderWrappable(this.nabavnaVrednostColumnRK);
            this.prodajnaCenaColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("ProdajnaCena"));
            this.makeHeaderWrappable(this.prodajnaCenaColumnRK);
            this.prodajnaVrednostColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("ProdajnaVrednost"));
            this.makeHeaderWrappable(this.prodajnaVrednostColumnRK);
            this.nazivDokumentaColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("NazivDokumenta"));
            this.makeHeaderWrappable(this.nazivDokumentaColumnRK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ulazIzlazStanje();
        this.cbProduct.getSelectionModel().clearSelection();
    }

    private void fillDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)d);
        }
        if (this.cbDepartment.getItems().size() > 0) {
            this.cbDepartment.getSelectionModel().selectFirst();
        }
    }

    private void makeHeaderWrappable(TableColumn<?, ?> col) {
        Label label = new Label(col.getText());
        label.setWrapText(true);
        label.setAlignment(Pos.CENTER);
        label.setTextAlignment(TextAlignment.CENTER);
        StackPane stack = new StackPane();
        stack.getChildren().add((java.lang.Object)label);
        stack.prefWidthProperty().bind((ObservableValue)col.widthProperty().subtract(1));
        label.prefWidthProperty().bind((ObservableValue)stack.prefWidthProperty());
        col.setGraphic((Node)stack);
    }

    private void ulazIzlazStanje() {
        double ulaz = 0.0;
        double izlaz = 0.0;
        double stanje = 0.0;
        for (Document document : this.robnaKarticaTable.getItems()) {
            ulaz += document.getUlaz();
            izlaz += document.getIzlaz();
        }
        stanje = ulaz - izlaz;
        this.lblUlaz.setText(String.valueOf(ulaz));
        this.lblIzlaz.setText(String.valueOf(izlaz));
        this.lblStanje.setText(String.valueOf(stanje));
    }

    @FXML
    private void excelAction() {
        this.printJasper();
    }

    private void printJasper() {
        String reportFileName = "rs/petcom/backoffice/jasper/RobnaKaricaDetaljiArtikla.jasper";
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("productName", this.filteredProduct.getName());
        hm.put("productID", this.filteredProduct.getProductID());
        hm.put("department", ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
        hm.put("dateOd", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.datePickerOdRobnaKartica.getValue())).getTime()));
        hm.put("dateDo", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.datePickerDoRobnaKartica.getValue())).getTime()));
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Robna kartica artikla", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$null$0(Stage taskUpdateStage, Task creatingReport, WorkerStateEvent eventValue) {
        taskUpdateStage.hide();
        JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld((JasperPrint)creatingReport.getValue());
        HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
        hm2.put("report", printViewPane);
        this.controller.showModalDialog("Prijemnica", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
    }
}

