/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.util.HashMap;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.enums.BuyerCostCenter;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;

public class RefactionBuyerInsertController
implements DialogController {
    private ScreensController controller;
    private HashMap<String, Object> parameter;
    private Map<String, String> buyerCenterId;
    private int modalResult;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfSerialNumber;
    @FXML
    private TextField tfBuyerCostCenter;
    @FXML
    private Label labInputHeadLine;
    @FXML
    private ComboBox<String> cbBuyerIdentification;

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        String headLine = (String)parameter.get("headLine");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.labInputHeadLine.setText(headLine);
        this.buyerCenterId = this.loadBuyerIdentificationCombo();
        ((Stage)this.rootPane.getScene().getWindow()).setResizable(false);
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
    }

    @FXML
    void cancelAction(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    void confirmAction(ActionEvent event) {
        if (this.tfSerialNumber.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Broj paso\u0161a ne sme biti prazan", this.rootPane.getScene().getWindow());
            return;
        }
        if (this.tfBuyerCostCenter.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Identifikacija kupca ne sme biti prazna", this.rootPane.getScene().getWindow());
            return;
        }
        String code = this.buyerCenterId.get(this.cbBuyerIdentification.getValue());
        String passport = "30:" + this.tfSerialNumber.getText().trim();
        String identification = code + ":" + this.tfBuyerCostCenter.getText().trim();
        this.parameter.put("passport", passport);
        this.parameter.put("identification", identification);
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private Map<String, String> loadBuyerIdentificationCombo() {
        BuyerCostCenter[] costCenters;
        HashMap<String, String> buyerIdsMap = new HashMap<String, String>();
        for (BuyerCostCenter center : costCenters = BuyerCostCenter.values()) {
            this.cbBuyerIdentification.getItems().add((Object)center.getDescription());
            buyerIdsMap.put(center.getDescription(), center.getCode());
        }
        this.cbBuyerIdentification.getSelectionModel().select(0);
        return buyerIdsMap;
    }
}

