/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.DoubleTableCellFactory;

public class ProfakturaDetailesController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private Document selectedDocument;
    private ObservableList<DocumentDetails> deleteFromTableList = FXCollections.observableArrayList();
    private Person selectedPerson;
    private DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(4, true);
    private DoubleTableCellFactory cellFactoryPrice = new DoubleTableCellFactory(2, true);
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfNumber;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfPrice;
    @FXML
    private Label lblValue;
    @FXML
    private Label lblSelectedPerson;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private TableView<DocumentDetails> tableDocument;
    @FXML
    private TableColumn<DocumentDetails, Long> columnProduct;
    @FXML
    private TableColumn<Object, Double> columnQuantity;
    @FXML
    private TableColumn<Object, Double> columnPrice;
    @FXML
    private TableColumn<Object, Double> columnValue;
    @FXML
    private TableColumn<DocumentDetails, Boolean> columnStatus;
    @FXML
    private TextArea taNote;
    @FXML
    private TextArea taNote2;
    @FXML
    DatePicker dpDateOf;

    @FXML
    private void initialize() {
        this.columnProduct.setCellValueFactory((Callback)new PropertyValueFactory("ProductID"));
        this.columnProduct.setCellFactory(column -> new TableCell<DocumentDetails, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(Product.getByID((long)item, (ScreensController)ProfakturaDetailesController.this.controller).getName());
                }
            }
        });
        this.columnQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.columnQuantity.setCellFactory((Callback)this.cellFactory);
        this.columnQuantity.setOnEditCommit(cellEditEvent -> {
            DocumentDetails selectedTablePrij = (DocumentDetails)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setQuantity(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setValue(Settings.round((double)(selectedTablePrij.getQuantity() * selectedTablePrij.getPriceWithDiscount()), (int)2));
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.fillLabelValue();
        });
        this.columnPrice.setCellValueFactory((Callback)new PropertyValueFactory("PriceWithDiscount"));
        this.columnPrice.setCellFactory((Callback)this.cellFactoryPrice);
        this.columnPrice.setOnEditCommit(cellEditEvent -> {
            DocumentDetails selectedTablePrij = (DocumentDetails)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow());
            selectedTablePrij.setPriceWithDiscount(((Double)cellEditEvent.getNewValue()).doubleValue());
            selectedTablePrij.setValue(Settings.round((double)(selectedTablePrij.getQuantity() * selectedTablePrij.getPriceWithDiscount()), (int)2));
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.fillLabelValue();
        });
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("Value"));
        this.tfQuantity.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER) || event.getCode().equals((Object)KeyCode.TAB)) {
                    ProfakturaDetailesController.this.tfPrice.requestFocus();
                }
            }
        });
        this.tfPrice.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER) || event.getCode().equals((Object)KeyCode.TAB)) {
                    ProfakturaDetailesController.this.actionAdd();
                }
            }
        });
        this.cbProduct.valueProperty().addListener((ov, oldValue, newValue) -> {
            if (this.cbProduct.getSelectionModel().getSelectedItem() != null) {
                this.tfPrice.setText(String.valueOf(Product.getCurrentPrice((long)((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getProductID(), (long)1L, (boolean)false, (Connection)this.controller.getSettings().getConnection())));
            }
        });
        this.tableDocument.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<DocumentDetails>(){

            public void changed(ObservableValue<? extends DocumentDetails> observable, DocumentDetails oldValue, DocumentDetails newValue) {
                if (ProfakturaDetailesController.this.tableDocument.getSelectionModel().getSelectedItem() != null) {
                    ProfakturaDetailesController.this.tfQuantity.requestFocus();
                }
            }
        });
        this.tableDocument.setRowFactory(param -> new TableRow<DocumentDetails>(){

            protected void updateItem(final DocumentDetails item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    this.disableProperty().bind((ObservableValue)new BooleanBinding(){

                        protected boolean computeValue() {
                            return item.isClosed();
                        }
                    });
                }
            }
        });
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedDocument = (Document)parameter.get("profaktura");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.tfNumber.setDisable(true);
        if (this.selectedDocument != null) {
            this.tfNumber.setText(String.valueOf(this.selectedDocument.getNumber()));
            this.tableDocument.setItems(DocumentDetails.getObeservableList((long)this.selectedDocument.getDocumentID(), (Connection)this.controller.getSettings().getConnection()));
            this.taNote.setText(this.selectedDocument.getNote());
            this.taNote2.setText(this.selectedDocument.getNote2());
            this.selectedPerson = Person.getById((long)this.selectedDocument.getPersonID(), (ScreensController)this.controller);
            this.lblSelectedPerson.setText(!this.selectedPerson.getName().equals("") ? this.selectedPerson.getName() : this.selectedPerson.getFirstLastName());
            this.dpDateOf.setValue((Object)Settings.fromDate((Date)this.selectedDocument.getDate()));
            this.fillLabelValue();
        } else {
            this.tfNumber.setText(String.valueOf(Document.getNextNumber((int)DocumentType.getByCode((String)"PROF", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID(), (long)this.controller.getPointOfSale().getPointOfSaleID(), (ScreensController)this.controller)));
            this.dpDateOf.setValue((Object)LocalDate.now());
        }
        new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, Department.getByPOS((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()).getDepartmentID(), ScreensController.FILTER_ALL, this.tfQuantity);
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void actionAdd() {
        if (this.cbProduct.getSelectionModel().getSelectedItem() != null) {
            DocumentDetails ddDetails = new DocumentDetails();
            ddDetails.setDocumentDetailsID(-1L);
            ddDetails.setProductID(((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getProductID());
            ddDetails.setQuantity(Double.parseDouble(this.tfQuantity.getText().trim()));
            ddDetails.setPriceWithDiscount(Double.parseDouble(this.tfPrice.getText().trim()));
            ddDetails.setDiscount(0.0);
            ddDetails.setPrice(ddDetails.getPriceWithDiscount());
            ddDetails.setUnitID(((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getUnitID());
            ddDetails.setVatID(((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getVatID());
            ddDetails.setSysDTCreated(new Date());
            ddDetails.setSysUserAddID(this.controller.getUser().getUserID());
            ddDetails.setValue(ddDetails.getQuantity() * ddDetails.getPriceWithDiscount());
            this.tableDocument.getItems().add((Object)ddDetails);
        }
        if (this.tableDocument.getSelectionModel().getSelectedItem() != null) {
            ((DocumentDetails)this.tableDocument.getSelectionModel().getSelectedItem()).setQuantity(Double.parseDouble(this.tfQuantity.getText().trim()));
            ((DocumentDetails)this.tableDocument.getSelectionModel().getSelectedItem()).setPriceWithDiscount(Double.parseDouble(this.tfPrice.getText().trim()));
            ((DocumentDetails)this.tableDocument.getSelectionModel().getSelectedItem()).setPrice(((DocumentDetails)this.tableDocument.getSelectionModel().getSelectedItem()).getPriceWithDiscount());
            this.tableDocument.getSelectionModel().clearSelection();
        }
        this.tableDocument.refresh();
        this.fillLabelValue();
        this.cbProduct.getSelectionModel().clearSelection();
        this.tfQuantity.setText("");
        this.tfPrice.setText("");
        this.cbProduct.requestFocus();
    }

    @FXML
    private void actionRemove() {
        if (this.tableDocument.getSelectionModel().getSelectedItem() != null) {
            this.deleteFromTableList.add(this.tableDocument.getSelectionModel().getSelectedItem());
            this.tableDocument.getItems().remove(this.tableDocument.getSelectionModel().getSelectedIndex());
            this.tableDocument.refresh();
        }
    }

    @FXML
    private void actionCommit() {
        if (this.selectedDocument != null) {
            this.selectedDocument.setSysDTEdit(new Date());
            this.selectedDocument.setNote(this.taNote.getText().trim());
            this.selectedDocument.setSysUserEditID(this.controller.getUser().getUserID());
            this.selectedDocument.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
            this.selectedDocument.setDate(Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateOf.getValue())));
            double sum = 0.0;
            try {
                DocumentDetails.deleteDetailes((Document)this.selectedDocument, (Connection)this.controller.getSettings().getConnection());
                for (DocumentDetails documentDetails : this.tableDocument.getItems()) {
                    documentDetails.setDocumentID(this.selectedDocument.getDocumentID());
                    documentDetails.insert(this.controller.getSettings().getConnection());
                    sum += documentDetails.getQuantity() * documentDetails.getPriceWithDiscount();
                }
                this.selectedDocument.setSum(sum);
                this.selectedDocument.setSumWithDiscount(sum);
                this.selectedDocument.update(this.controller);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            if (this.selectedPerson == null) {
                this.controller.alert("Obavestenje", "Morate odabrati kupca pre kreiranja profakture", this.rootPane.getScene().getWindow());
                return;
            }
            this.selectedDocument = new Document();
            this.selectedDocument.setPersonID(this.selectedPerson.getPersonID());
            this.selectedDocument.setSysDTCreated(new Date());
            this.selectedDocument.setNote(this.taNote.getText().trim());
            this.selectedDocument.setNumber(Integer.parseInt(this.tfNumber.getText().trim()));
            this.selectedDocument.setDocumentStatusID(DocumentStatus.getStatusByName((ScreensController)this.controller, (String)"U izradi").getDocumentStatusID());
            this.selectedDocument.setDocumentTypeID(DocumentType.getByCode((String)"PROF", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
            this.selectedDocument.setSysUserAddID(this.controller.getUser().getUserID());
            this.selectedDocument.setDate(new Date());
            this.selectedDocument.setYear(Calendar.getInstance().get(1));
            this.selectedDocument.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
            double sum = 0.0;
            for (DocumentDetails documentDetails : this.tableDocument.getItems()) {
                sum += documentDetails.getQuantity() * documentDetails.getPriceWithDiscount();
            }
            this.selectedDocument.setSum(sum);
            this.selectedDocument.setSumWithDiscount(sum);
            long id = this.selectedDocument.insert(this.controller);
            for (DocumentDetails documentDetails : this.tableDocument.getItems()) {
                documentDetails.setDocumentID(id);
                documentDetails.insert(this.controller.getSettings().getConnection());
            }
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void actionBuyer() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        this.controller.showModalDialog("Izbor komitenta", ScreensController.DIALOG_SELECT_RESERVE_PERSON_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        this.selectedPerson = (Person)hm.get("selectedPerson");
        if (this.selectedPerson != null) {
            this.lblSelectedPerson.setText(!this.selectedPerson.getName().equals("") ? this.selectedPerson.getName() : this.selectedPerson.getFirstLastName());
        }
    }

    @FXML
    private void actionClose() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void fillLabelValue() {
        double sum = 0.0;
        for (DocumentDetails documentDetails : this.tableDocument.getItems()) {
            sum += documentDetails.getQuantity() * documentDetails.getPriceWithDiscount();
        }
        this.lblValue.setText("\t" + String.valueOf(Settings.round((double)sum, (int)2)));
    }
}

