/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Presifriranje;
import rs.petcom.master.dal.document.PresifriranjeDetailes;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class PresifriranjeDetailesController
implements DialogController {
    ScreensController controller;
    Presifriranje presifriranje;
    int modalResult;
    AutoCompleteCBWithoutProducts<Product> cbProductAutoComplete;
    ArrayList<PresifriranjeDetailes> deletedItems = new ArrayList();
    Department department;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DateTimePicker dcDate;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnRemove;
    @FXML
    private TableView<PresifriranjeDetailes> table;
    @FXML
    private TableColumn<PresifriranjeDetailes, String> tcCode;
    @FXML
    private TableColumn<PresifriranjeDetailes, String> tcName;
    @FXML
    private TableColumn<Object, Double> tcQuantity;
    @FXML
    private TextField tfNapomena;
    @FXML
    private TextField tfQuantity;
    @FXML
    private ComboBox<String> cbFilterType;
    @FXML
    private ComboBox<Product> cbProduct;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.presifriranje = (Presifriranje)parameter.get("presifriranje");
        this.department = (Department)parameter.get("department");
        this.dcDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.presifriranje.getDate()));
        this.table.setItems(PresifriranjeDetailes.getList((Presifriranje)this.presifriranje, (Connection)this.controller.getSettings().getConnection()));
        this.deletedItems.clear();
        this.tfNapomena.setText(this.presifriranje.getNote());
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbFilterType.getItems().addAll((Object[])new String[]{ScreensController.FILTER_ALL, ScreensController.FILTER_CODE, ScreensController.FILTER_BARCODE});
        this.cbFilterType.getSelectionModel().selectFirst();
        this.cbProductAutoComplete = new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, this.department.getDepartmentID(), ScreensController.FILTER_ALL, this.tfQuantity);
        this.cbFilterType.setOnAction(actionEvent -> this.cbProductAutoComplete.setFilterType((String)this.cbFilterType.getSelectionModel().getSelectedItem()));
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(4, true);
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("ProductCode"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                PresifriranjeDetailes data = (PresifriranjeDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow());
                data.setQuantity(((Double)t.getNewValue()).doubleValue());
            }
        });
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void actionSave(ActionEvent event) {
        try {
            int i;
            this.presifriranje.setNote(this.tfNapomena.getText());
            this.presifriranje.setDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dcDate.getDateTimeValue()));
            if (this.presifriranje.getDocumentID() > 0L) {
                this.presifriranje.update(this.controller);
            } else {
                this.presifriranje.insert(this.controller);
            }
            for (i = 0; i < this.deletedItems.size(); ++i) {
                this.deletedItems.get(i).delete(this.controller.getSettings().getConnection());
            }
            for (i = 0; i < this.table.getItems().size(); ++i) {
                if (((PresifriranjeDetailes)this.table.getItems().get(i)).getPresifriranjeDetailesID() > 0L) {
                    ((PresifriranjeDetailes)this.table.getItems().get(i)).update(this.controller);
                    continue;
                }
                ((PresifriranjeDetailes)this.table.getItems().get(i)).setPresifriranjeID(this.presifriranje.getDocumentID());
                Long id = ((PresifriranjeDetailes)this.table.getItems().get(i)).insert(this.controller);
                ((PresifriranjeDetailes)this.table.getItems().get(i)).setSravnjenjePoPopisuDetailesID(id.longValue());
            }
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
        catch (SQLException e) {
            this.controller.alert("Gre\u0161ka pri snimanju u bazu!", "Do\u0161lo je do gre\u0161ke prilikom snimanja u bazu!\n" + e.getMessage(), this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionAdd(ActionEvent event) {
        if (this.cbProduct.getSelectionModel().getSelectedItem() != null) {
            PresifriranjeDetailes pd = new PresifriranjeDetailes(-1L, this.presifriranje.getDocumentID(), ((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getProductID(), ((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getCode(), ((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getName(), Double.parseDouble(this.tfQuantity.getText()));
            this.table.getItems().add((Object)pd);
            this.table.getSelectionModel().select((Object)pd);
            this.table.scrollTo((Object)pd);
            this.table.requestFocus();
            this.clearFields();
        } else {
            this.controller.alert("Morate odabrati artikal!", "Morate odabrati artikal!", this.rootPane.getScene().getWindow());
        }
    }

    private void clearFields() {
        this.cbProduct.getSelectionModel().clearSelection();
        this.cbProduct.getEditor().setText("");
        this.tfQuantity.setText("");
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
    }
}

