/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.Presifriranje;
import rs.petcom.master.dal.person.Person;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class PresifriranjeController
implements ControlledScreen {
    ScreensController controller;
    rs.petcom.master.dal.Object sviObjekti = new rs.petcom.master.dal.Object(-1, "Svi objekti");
    Department svaOdeljenja = new Department(-1, "Sva odeljenja");
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private TableView<Presifriranje> table;
    @FXML
    private TableColumn<Presifriranje, Integer> tcBroj;
    @FXML
    private TableColumn<Presifriranje, Date> tcDate;
    @FXML
    private TableColumn<Presifriranje, String> tcNapomena;
    @FXML
    private Button btnNew;
    @FXML
    private Button btnEdit;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnExport;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbObject.getItems().add((Object)this.sviObjekti);
        for (rs.petcom.master.dal.Object o : rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((Object)o);
        }
        if (this.cbObject.getItems().size() == 2) {
            this.cbObject.getSelectionModel().select(1);
        } else {
            this.cbObject.getSelectionModel().select((Object)this.sviObjekti);
        }
    }

    public void setParameter(Object parameter) {
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (rs.petcom.master.dal.Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
    }

    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<rs.petcom.master.dal.Object>(){

            public void changed(ObservableValue<? extends rs.petcom.master.dal.Object> observable, rs.petcom.master.dal.Object oldValue, rs.petcom.master.dal.Object newValue) {
                PresifriranjeController.this.loadDepartment();
            }
        });
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                PresifriranjeController.this.loadDocumentList();
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Presifriranje>(){

            public void changed(ObservableValue<? extends Presifriranje> observable, Presifriranje oldValue, Presifriranje newValue) {
                if (newValue == null) {
                    PresifriranjeController.this.btnDelete.setDisable(true);
                    PresifriranjeController.this.btnPrint.setDisable(true);
                    PresifriranjeController.this.btnEdit.setDisable(true);
                    PresifriranjeController.this.btnExport.setDisable(true);
                } else {
                    PresifriranjeController.this.btnDelete.setDisable(false);
                    PresifriranjeController.this.btnPrint.setDisable(false);
                    PresifriranjeController.this.btnEdit.setDisable(false);
                    PresifriranjeController.this.btnExport.setDisable(false);
                }
            }
        });
        this.tcBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDate.setCellFactory(column -> new TableCell<Presifriranje, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcNapomena.setCellValueFactory((Callback)new PropertyValueFactory("Note"));
    }

    @FXML
    public void actionNew(ActionEvent event) {
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put("controller", this.controller);
                hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
                hm.put("presifriranje", new Presifriranje(-1L, -1, new Date(), ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), ""));
                int result = this.controller.showModalDialog("Pre\u0161ifriranje - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_PRESIFRIRANJE_DETAILES, hm, this.rootPane.getScene().getWindow());
                if (result == ScreensController.MODAL_RESULT_OK) {
                    this.loadDocumentList();
                }
            } else {
                this.controller.alert("Odaberite odeljenje", "Izaberite odeljenje", this.rootPane.getScene().getWindow());
            }
        }
        catch (Exception e) {
            this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom upisa u bazu", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionEdit(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null && this.cbDepartment.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("presifriranje", this.table.getSelectionModel().getSelectedItem());
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Pre\u0161ifriranje - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_PRESIFRIRANJE_DETAILES, hm, this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionPrint(ActionEvent event) {
        String reportFileName = "rs/petcom/backoffice/jasper/Presifriranje.jasper";
        HashMap<String, Object> hm = new HashMap<String, Object>();
        Document document = Document.getByID((long)((Presifriranje)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        if (file.exists() && file.isFile()) {
            hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        } else {
            hm.put("memorandum", "");
        }
        hm.put("person", Person.getByCode((String)"1", (Connection)this.controller.getSettings().getConnection()));
        hm.put("documentId", document.getDocumentID());
        hm.put("document", document);
        hm.put("object", this.cbObject.getSelectionModel().getSelectedItem());
        hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Po\u010detno stanje", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        try {
            ((Presifriranje)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
        catch (SQLException e) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("title", "Brisanje po\u010detnog stanja nije mogu\u0107e!");
            hm.put("text", "\nPoruka o gre\u0161ci:\n\n" + e.getLocalizedMessage());
            this.controller.showModalDialog("Brisanje po\u010detnog stanja nije mogu\u0107e!", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        }
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        this.cbDepartment.getItems().add((Object)this.svaOdeljenja);
        for (Department d : Department.getList((rs.petcom.master.dal.Object)((rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((Object)d);
        }
        if (this.cbDepartment.getItems().size() == 2) {
            this.cbDepartment.getSelectionModel().select(1);
        } else {
            this.cbDepartment.getSelectionModel().select((Object)this.svaOdeljenja);
        }
    }

    private void loadDocumentList() {
        this.table.getItems().clear();
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
                this.table.setItems(Presifriranje.getlist((Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection()));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    private void actionExport() {
        Presifriranje p = (Presifriranje)this.table.getSelectionModel().getSelectedItem();
        Department d = (Department)this.cbDepartment.getSelectionModel().getSelectedItem();
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Export Pre\u0161ifravanja");
        fileChooser.setInitialFileName("Presifravanje-" + d.getCode() + "-" + p.getNumber() + ".xml");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("XML files (*.xml)", new String[]{"*.xml"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            try {
                if (file.getAbsolutePath().toUpperCase().endsWith(".XML")) {
                    p.exportToXml(file.getAbsolutePath(), this.controller.getSettings().getConnection());
                } else {
                    p.exportToXml(file.getAbsolutePath() + ".xml", this.controller.getSettings().getConnection());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }
}

