/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.backoffice.controller.document.DocumentLocker;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.PocetnoStanje;
import rs.petcom.master.dal.person.Address;
import rs.petcom.print.JRPrintPreviewPaneOld;
import rs.petcom.renameconnection.ChangeConnection;

public class PocetnoStanjeController
implements ControlledScreen {
    ScreensController controller;
    Object sviObjekti = new Object(-1, "Svi objekti");
    Department svaOdeljenja = new Department(-1, "Sva odeljenja");
    private PocetnoStanje selectedPocetnoStanje;
    private DocumentLocker docLocker;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private TableView<PocetnoStanje> table;
    @FXML
    private TableColumn<PocetnoStanje, Integer> tcBroj;
    @FXML
    private TableColumn<PocetnoStanje, Date> tcDate;
    @FXML
    private TableColumn<PocetnoStanje, String> tcNapomena;
    @FXML
    private TableColumn<PocetnoStanje, String> tcStatus;
    @FXML
    private TableColumn<PocetnoStanje, String> tcZakljucan;
    @FXML
    private Button btnNew;
    @FXML
    private Button btnEdit;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnPrintPDF;
    @FXML
    private Button btnDelete;
    @FXML
    private Label lblZakljucaniDokumentiUpozorenje;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        this.cbObject.getItems().add((java.lang.Object)this.sviObjekti);
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((java.lang.Object)o);
        }
        if (this.cbObject.getItems().size() == 2) {
            this.cbObject.getSelectionModel().select(1);
        } else {
            this.cbObject.getSelectionModel().select((java.lang.Object)this.sviObjekti);
        }
    }

    public void setParameter(java.lang.Object parameter) {
        this.docLocker = new DocumentLocker(this.controller);
        this.lastDocumentLockDate = this.docLocker.getLastLockedDocumentDate();
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                PocetnoStanjeController.this.loadDepartment();
            }
        });
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                PocetnoStanjeController.this.loadDocumentList();
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PocetnoStanje>(){

            public void changed(ObservableValue<? extends PocetnoStanje> observable, PocetnoStanje oldValue, PocetnoStanje newValue) {
                PocetnoStanjeController.this.selectedPocetnoStanje = newValue;
                if (newValue == null) {
                    PocetnoStanjeController.this.btnDelete.setDisable(true);
                    PocetnoStanjeController.this.btnPrint.setDisable(true);
                    PocetnoStanjeController.this.btnPrintPDF.setDisable(true);
                    PocetnoStanjeController.this.btnEdit.setDisable(true);
                } else if (PocetnoStanjeController.this.documentLockIsActive && newValue.isLocked()) {
                    PocetnoStanjeController.this.btnDelete.setDisable(true);
                    PocetnoStanjeController.this.btnEdit.setDisable(true);
                    PocetnoStanjeController.this.btnPrint.setDisable(false);
                    PocetnoStanjeController.this.btnPrintPDF.setDisable(false);
                    PocetnoStanjeController.this.lblZakljucaniDokumentiUpozorenje.setVisible(true);
                } else {
                    PocetnoStanjeController.this.btnDelete.setDisable(false);
                    PocetnoStanjeController.this.btnPrint.setDisable(false);
                    PocetnoStanjeController.this.btnPrintPDF.setDisable(false);
                    PocetnoStanjeController.this.btnEdit.setDisable(false);
                    PocetnoStanjeController.this.lblZakljucaniDokumentiUpozorenje.setVisible(false);
                }
            }
        });
        this.tcBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDate.setCellFactory(column -> new TableCell<PocetnoStanje, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcNapomena.setCellValueFactory((Callback)new PropertyValueFactory("Note"));
        this.tcStatus.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.tcZakljucan.setCellValueFactory(cellValue -> {
            boolean isLocked = ((PocetnoStanje)cellValue.getValue()).isLocked();
            String locked = isLocked ? "DA" : "NE";
            return new ReadOnlyStringWrapper(locked);
        });
    }

    @FXML
    public void actionNew(ActionEvent event) {
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        boolean kep = false;
        hm.put("controller", this.controller);
        PocetnoStanje pocSt = new PocetnoStanje(-1L, -1, new Date(), ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), "", "U izmeni", false);
        hm.put("pocetnoStanje", pocSt);
        hm.put("kep", kep);
        hm.put("lastDocumentLockDate", this.lastDocumentLockDate);
        this.controller.showModalDialog("Po\u010detno stanje - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_POCETNO_STANJE_DETAILES, hm, this.rootPane.getScene().getWindow());
        this.loadDocumentList();
    }

    @FXML
    public void actionEdit(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            boolean kep = false;
            hm.put("controller", this.controller);
            hm.put("pocetnoStanje", this.selectedPocetnoStanje);
            hm.put("kep", kep);
            hm.put("selectAllProducts", true);
            this.controller.showModalDialog("Po\u010detno stanje - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_POCETNO_STANJE_DETAILES, hm, this.rootPane.getScene().getWindow());
        }
        Log.writeLog((User)this.controller.getUser(), (String)"Izmena po\u010detnog stanje", (Connection)this.controller.getSettings().getConnection());
        this.loadDocumentList();
    }

    @FXML
    private void actionInitalStockKEP(ActionEvent event) {
        int continueAction = this.controller.yesNoDialog("Po\u010detno stanje za KEP", "Po\u010detno stanje preuzima vrednosti iz lagera na 31.01. pro\u0161le godine i importuje ga kao po\u010detno na 01.01. teku\u0107e godine. Da li \u017eelite da nastavite?", this.rootPane.getScene().getWindow());
        if (continueAction == ScreensController.MODAL_RESULT_NO) {
            return;
        }
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        boolean kep = true;
        hm.put("controller", this.controller);
        PocetnoStanje pocSt = new PocetnoStanje(-1L, -1, new Date(), ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), "", "U izmeni", false);
        hm.put("pocetnoStanje", pocSt);
        hm.put("kep", kep);
        this.controller.showModalDialog("Po\u010detno stanje - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_POCETNO_STANJE_DETAILES, hm, this.rootPane.getScene().getWindow());
        this.loadDocumentList();
    }

    @FXML
    public void actionPrint(final ActionEvent event) {
        final String reportFileName = "rs/petcom/backoffice/jasper/PocetnoStanje.jasper";
        final HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        Document document = Document.getByID((long)((PocetnoStanje)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        for (Images images : Images.getImagesList((ScreensController)this.controller)) {
            if (Boolean.parseBoolean(this.controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", "null");
        }
        hm.put("objekat", Object.get((Connection)this.controller.getSettings().getConnection()));
        hm.put("address", Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()));
        hm.put("documentId", document.getDocumentID());
        hm.put("document", document);
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("\u010citanje po\u010detnog stanja u toku...", this.rootPane.getScene().getWindow());
        new Thread(){

            @Override
            public void run() {
                try {
                    JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                    JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)PocetnoStanjeController.this.controller.getSettings().getConnection());
                    JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(0);
                    final HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                    hm2.put("REPORT_VIRTUALIZER", virtualizer);
                    virtualizer.setReadOnly(true);
                    if (((Button)event.getSource()).getText().equals("PDF")) {
                        PocetnoStanjeController.this.controller.printFileFromPDF(PocetnoStanjeController.this.controller.getPdfFromJasper(jprint, "Po\u010detno stanje", "PocetnoStanje"));
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                taskUpdateStage.hide();
                            }
                        });
                    } else {
                        JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                        hm2.put("report", printViewPane);
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                taskUpdateStage.hide();
                                PocetnoStanjeController.this.controller.showModalDialog("Po\u010detno stanje", ScreensController.DIALOG_PRINT_PREVIEW, hm2, PocetnoStanjeController.this.rootPane.getScene().getWindow());
                            }
                        });
                    }
                }
                catch (JRException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            taskUpdateStage.hide();
                        }
                    });
                    e.printStackTrace();
                }
            }
        }.start();
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Brisanje po\u010detnog stanja u toku...", this.rootPane.getScene().getWindow());
        new Thread(){

            @Override
            public void run() {
                try {
                    ChangeConnection.getConnectionAdmin((ScreensController)PocetnoStanjeController.this.controller);
                    ((PocetnoStanje)PocetnoStanjeController.this.table.getSelectionModel().getSelectedItem()).delete(PocetnoStanjeController.this.controller.getSettings().getConnection());
                    ChangeConnection.getConnectionUser((ScreensController)PocetnoStanjeController.this.controller);
                    PocetnoStanjeController.this.table.getItems().remove(PocetnoStanjeController.this.table.getSelectionModel().getSelectedItem());
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            taskUpdateStage.hide();
                        }
                    });
                }
                catch (SQLException e) {
                    final HashMap<String, String> hm = new HashMap<String, String>();
                    hm.put("title", "Brisanje po\u010detnog stanja nije mogu\u0107e!");
                    hm.put("text", "\nPoruka o gre\u0161ci:\n\n" + e.getLocalizedMessage());
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            taskUpdateStage.hide();
                            PocetnoStanjeController.this.controller.showModalDialog("Brisanje po\u010detnog stanja nije mogu\u0107e!", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, PocetnoStanjeController.this.rootPane.getScene().getWindow());
                        }
                    });
                }
            }
        }.start();
        Log.writeLog((User)this.controller.getUser(), (String)"Brisanje po\u010detnog stanje", (Connection)this.controller.getSettings().getConnection());
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        this.cbDepartment.getItems().add((java.lang.Object)this.svaOdeljenja);
        for (Department d : Department.getList((Object)((Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)d);
        }
        if (this.cbDepartment.getItems().size() == 2) {
            this.cbDepartment.getSelectionModel().select(1);
        } else {
            this.cbDepartment.getSelectionModel().select((java.lang.Object)this.svaOdeljenja);
        }
    }

    private void loadDocumentList() {
        this.table.getItems().clear();
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
                this.table.setItems(PocetnoStanje.getlist((Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection()));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

