/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.io.IOException;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.newFiscalization.pin.PinRequest;

public class PinInsertController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfSerialNumber;
    @FXML
    private Label labInputHeadLine;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        String headLine = (String)parameter.get("headLine");
        this.labInputHeadLine.setText(headLine);
        ((Stage)this.rootPane.getScene().getWindow()).setResizable(false);
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
    }

    @FXML
    void cancelAction(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    void confirmAction(ActionEvent event) {
        String pin = this.tfSerialNumber.getText().trim();
        PinRequest request = new PinRequest(this.controller);
        String responseLine = "";
        try {
            responseLine = request.getResponseLine(pin);
            if (this.pinOk(responseLine)) {
                this.controller.alert("Obave\u0161tenje", "PIN je u redu. Mo\u017eete nastaviti sa radom", this.rootPane.getScene().getWindow());
            }
            if (this.pinIsNotOK(responseLine)) {
                this.controller.alert("Obavestenje", "Pogre\u0161an PIN. Ukoliko unesete pogre\u0161an PIN vi\u0161e od 5 puta kartica \u0107e biti blokirana", this.rootPane.getScene().getWindow());
                return;
            }
            if (this.cardLocked(responseLine)) {
                this.controller.alert("Obavestenje", "Kartica zaklju\u010dana, obratite se tehni\u010dkoj podr\u0161ci", this.rootPane.getScene().getWindow());
            }
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean pinIsNotOK(String responseLine) {
        return responseLine.contains("2100");
    }

    private boolean pinOk(String responseLine) {
        return responseLine.contains("0100");
    }

    private boolean cardLocked(String responseLine) {
        return responseLine.contains("2110") || responseLine.contains("2210");
    }
}

