/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.backoffice.controller.document.DocumentLocker;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.NalogZaIspravku;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class NalogZaIspravkuController
implements ControlledScreen {
    ScreensController controller;
    private DocumentLocker docLocker;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private ComboBox<User> cbUser;
    @FXML
    private ComboBox<String> cbRefundationType;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private TableView<NalogZaIspravku> table;
    @FXML
    private TableColumn<NalogZaIspravku, Integer> tcBroj;
    @FXML
    private TableColumn<NalogZaIspravku, Date> tcDate;
    @FXML
    private TableColumn<NalogZaIspravku, String> tcNapomena;
    @FXML
    private TableColumn<NalogZaIspravku, String> tcUser;
    @FXML
    private TableColumn<NalogZaIspravku, String> tcZakljucan;
    @FXML
    private Button btnNew;
    @FXML
    private Button btnEdit;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnDelete;
    @FXML
    private Label lblZakljucaniDokumentiUpozorenje;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    public void setParameter(java.lang.Object parameter) {
        this.loadDepartment();
        this.loadUser();
        this.docLocker = new DocumentLocker(this.controller);
        this.lastDocumentLockDate = this.docLocker.getLastLockedDocumentDate();
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        this.dpFrom.setValue((java.lang.Object)LocalDate.now());
        this.dpTo.setValue((java.lang.Object)LocalDate.now());
        this.cbRefundationType.setVisible(false);
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                NalogZaIspravkuController.this.loadDocumentList();
            }
        });
        this.cbUser.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<User>(){

            public void changed(ObservableValue<? extends User> observable, User oldValue, User newValue) {
                NalogZaIspravkuController.this.loadDocumentList();
            }
        });
        this.dpFrom.valueProperty().addListener((obs, oldDate, newDate) -> this.loadDocumentList());
        this.dpTo.valueProperty().addListener((obs, oldDate, newDate) -> this.loadDocumentList());
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NalogZaIspravku>(){

            public void changed(ObservableValue<? extends NalogZaIspravku> observable, NalogZaIspravku oldValue, NalogZaIspravku newValue) {
                if (newValue == null) {
                    NalogZaIspravkuController.this.btnDelete.setDisable(true);
                    NalogZaIspravkuController.this.btnPrint.setDisable(true);
                    NalogZaIspravkuController.this.btnEdit.setDisable(true);
                } else if (NalogZaIspravkuController.this.documentLockIsActive && newValue.isLocked()) {
                    NalogZaIspravkuController.this.btnDelete.setDisable(true);
                    NalogZaIspravkuController.this.btnPrint.setDisable(false);
                    NalogZaIspravkuController.this.btnEdit.setDisable(true);
                    NalogZaIspravkuController.this.lblZakljucaniDokumentiUpozorenje.setVisible(true);
                } else {
                    NalogZaIspravkuController.this.btnDelete.setDisable(false);
                    NalogZaIspravkuController.this.btnPrint.setDisable(false);
                    NalogZaIspravkuController.this.btnEdit.setDisable(false);
                    NalogZaIspravkuController.this.lblZakljucaniDokumentiUpozorenje.setVisible(false);
                }
            }
        });
        this.tcBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDate.setCellFactory(column -> new TableCell<NalogZaIspravku, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcUser.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NalogZaIspravku, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NalogZaIspravku, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((java.lang.Object)((NalogZaIspravku)param.getValue()).getUser()).name("username").build();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        this.tcNapomena.setCellValueFactory((Callback)new PropertyValueFactory("Note"));
        this.tcZakljucan.setCellValueFactory(cellValue -> {
            boolean isLocked = ((NalogZaIspravku)cellValue.getValue()).isLocked();
            String locked = isLocked ? "DA" : "NE";
            return new ReadOnlyStringWrapper(locked);
        });
    }

    @FXML
    public void actionNew(ActionEvent event) {
        if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            hm.put("nalogZaIspravku", new NalogZaIspravku(-1L, -1, new Date(), 1, "", "", "", new Date(), "", "", null, false));
            hm.put("lastDocumentLockDate", this.lastDocumentLockDate);
            int result = this.controller.showModalDialog("Nalog za ispravku - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_NALOG_ZA_ISPRAVKU_DETAILES, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadDocumentList();
                Log.writeLog((User)this.controller.getUser(), (String)"Unos naloga za ispravku", (Connection)this.controller.getSettings().getConnection());
            }
        } else {
            this.controller.alert("Odaberite odeljenje", "Izaberite odeljenje", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionEdit(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null && this.cbDepartment.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            hm.put("nalogZaIspravku", this.table.getSelectionModel().getSelectedItem());
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Nalog za ispravku - Detalji", ScreensController.SCREEN_BACKOFFICE_DOC_NALOG_ZA_ISPRAVKU_DETAILES, hm, this.rootPane.getScene().getWindow());
        }
        Log.writeLog((User)this.controller.getUser(), (String)"Izmena naloga za ispravku", (Connection)this.controller.getSettings().getConnection());
    }

    @FXML
    public void actionPrint(ActionEvent event) {
        String reportFileName = "rs/petcom/backoffice/jasper/NalogZaIspravku.jasper";
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        Document document = Document.getByID((long)((NalogZaIspravku)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        Address address = Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection());
        try {
            File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
            if (file.exists() && file.isFile()) {
                hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
            } else {
                hm.put("memorandum", "");
            }
            hm.put("person", Person.getByCode((String)"1", (Connection)this.controller.getSettings().getConnection()));
            hm.put("documentId", document.getDocumentID());
            hm.put("document", document);
            hm.put("object", this.controller.getObject());
            hm.put("company", CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller));
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            hm.put("address", address);
            hm.put("parentDocumentId", document.getDocumentID());
            hm.put("ImePrezime", document.getName());
            hm.put("JMBG", document.getJmbg());
            hm.put("BI", document.getFullNumber());
            hm.put("documentNI", true);
            hm.put("datumNaloga", ((NalogZaIspravku)this.table.getSelectionModel().getSelectedItem()).getDate());
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Po\u010detno stanje", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        try {
            ((NalogZaIspravku)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
        catch (SQLException e) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("title", "Brisanje naloga za ispravku nije mogu\u0107e!");
            hm.put("text", "\nPoruka o gre\u0161ci:\n\n" + e.getLocalizedMessage());
            this.controller.showModalDialog("Brisanje po\u010detnog stanja nije mogu\u0107e!", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        }
        Log.writeLog((User)this.controller.getUser(), (String)"Brisanje naloga za ispravku", (Connection)this.controller.getSettings().getConnection());
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)d);
        }
        this.cbDepartment.getSelectionModel().select(0);
    }

    private void loadUser() {
        this.cbUser.getItems().clear();
        User sviOperateri = new User();
        sviOperateri.setUserID(-1L);
        sviOperateri.setUserName("Operateri");
        this.cbUser.getItems().add((java.lang.Object)sviOperateri);
        for (User user : User.getUserList((Connection)this.controller.getSettings().getConnection())) {
            this.cbUser.getItems().add((java.lang.Object)user);
        }
        this.cbUser.getSelectionModel().select((java.lang.Object)sviOperateri);
    }

    private void loadDocumentList() {
        this.table.getItems().clear();
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
                this.table.setItems(NalogZaIspravku.getlist((Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpFrom.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpTo.getValue())), (long)((User)this.cbUser.getSelectionModel().getSelectedItem()).getUserID(), (Connection)this.controller.getSettings().getConnection()));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    void RefundationTypeChanged(ActionEvent event) {
    }

    @FXML
    private void actionExport() {
    }
}

