/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.Year;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.ListIterator;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentRelationship;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class InternaPrijemnicaDetailesController
implements DialogController {
    private ScreensController controller;
    private Document otpremnica;
    private Document prijemnica;
    private int modalResult;
    private ArrayList<DocumentDetails> deletedItems = new ArrayList();
    private ListView<DocumentDetails> list;
    private ObservableList<Department> departmentList = FXCollections.observableArrayList();
    private ObservableList<DocumentDetails> getPrijemnicaList;
    private DocumentDetails psd;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DateTimePicker dtpDate;
    @FXML
    private Button btnRemove;
    @FXML
    private TableView<DocumentDetails> table;
    @FXML
    private TableColumn<DocumentDetails, String> tcCode;
    @FXML
    private TableColumn<DocumentDetails, String> tcName;
    @FXML
    private TableColumn<DocumentDetails, String> tcBarCode;
    @FXML
    private TableColumn<java.lang.Object, Double> tcQuantity;
    @FXML
    private GridPane gpContainer;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfQuantityForTable;
    @FXML
    private TextField tfNapomena;
    @FXML
    private TextField tfQuantity;
    @FXML
    private ComboBox<Department> cbOtpremnoOdeljenje;
    @FXML
    private ComboBox<Department> cbPrijemnoOdeljenje;

    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.lastDocumentLockDate = (LocalDate)parameter.get("lastDocumentLockDate");
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        try {
            this.prijemnica = (Document)parameter.get("prijemnica");
            this.dtpDate.setValue((java.lang.Object)Settings.fromDate((Date)this.prijemnica.getDate()));
            this.tfNapomena.setText(this.prijemnica.getNote());
            this.getPrijemnicaList = DocumentDetails.getFilteredList((String)"", (Document)this.prijemnica, (Department)((Department)this.cbOtpremnoOdeljenje.getSelectionModel().getSelectedItem()), (ScreensController)this.controller);
            this.loadTable();
        }
        catch (NullPointerException e) {
            this.otpremnica = new Document();
            this.otpremnica.setDocumentID(new Long(-1L).longValue());
            this.dtpDate.setValue((java.lang.Object)Settings.fromDate((Date)new Date()));
            this.tfNapomena.setText("");
            this.prijemnica = new Document();
            this.prijemnica.setDocumentID(new Long(-1L).longValue());
            this.dtpDate.setValue((java.lang.Object)Settings.fromDate((Date)new Date()));
            this.dtpDate.valueProperty().addListener((observable, oldDate, newDate) -> {
                if (this.documentLockIsActive && (newDate.isEqual(this.lastDocumentLockDate) || newDate.isBefore(this.lastDocumentLockDate))) {
                    this.dtpDate.setValue((java.lang.Object)this.lastDocumentLockDate.plusDays(1L));
                    this.controller.alert("Upozorenje", "Ne mo\u017eete izabrati datum za koji su zaklju\u010dani dokumenti ", this.rootPane.getScene().getWindow());
                }
            });
            this.tfNapomena.setText("");
        }
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.gpContainer.getChildren().size() > 1) {
                this.gpContainer.getChildren().remove(1);
            }
            this.gpContainer.add(this.populateFilterList((String)newValue), 0, 0);
        });
        this.loadOtpremniDepartmentComboBox();
        this.cbOtpremnoOdeljenje.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                InternaPrijemnicaDetailesController.this.loadPrijemniDepartmentComboBox(newValue);
            }
        });
        this.tfFilter.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.DOWN & InternaPrijemnicaDetailesController.this.list != null && !InternaPrijemnicaDetailesController.this.list.getItems().isEmpty()) {
                    InternaPrijemnicaDetailesController.this.list.requestFocus();
                    InternaPrijemnicaDetailesController.this.list.getSelectionModel().select(0);
                }
            }
        });
        this.deletedItems.clear();
        this.tfFilter.requestFocus();
        this.tfQuantity.setOnKeyPressed(keyValue -> {
            switch (keyValue.getCode()) {
                case UP: {
                    this.tfQuantity.setText(String.valueOf(Double.parseDouble(this.tfQuantity.getText()) + 1.0));
                    break;
                }
                case DOWN: {
                    this.tfQuantity.setText(String.valueOf(Double.parseDouble(this.tfQuantity.getText()) - 1.0));
                    break;
                }
                case ENTER: {
                    if (this.table.getSelectionModel().getSelectedItem() == null) break;
                    this.editQuantity(this.tfQuantity.getText());
                    this.tfQuantity.setText("");
                    this.tfFilter.setText("");
                    this.tfFilter.requestFocus();
                    this.table.getSelectionModel().clearSelection();
                    keyValue.consume();
                    break;
                }
            }
        });
        this.table.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER & InternaPrijemnicaDetailesController.this.table.getSelectionModel().getSelectedItem() != null) {
                    InternaPrijemnicaDetailesController.this.tfQuantity.setVisible(false);
                    InternaPrijemnicaDetailesController.this.tfQuantityForTable.setVisible(true);
                    InternaPrijemnicaDetailesController.this.tfQuantityForTable.requestFocus();
                }
            }
        });
        this.tfQuantityForTable.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER & InternaPrijemnicaDetailesController.this.table.getSelectionModel().getSelectedItem() != null) {
                    InternaPrijemnicaDetailesController.this.editQuantity(InternaPrijemnicaDetailesController.this.tfQuantityForTable.getText());
                    InternaPrijemnicaDetailesController.this.tfQuantityForTable.setText("");
                }
                if (t.getCode() == KeyCode.UP || t.getCode() == KeyCode.DOWN) {
                    InternaPrijemnicaDetailesController.this.table.requestFocus();
                }
            }
        });
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
    }

    public HashMap<String, java.lang.Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(2, true);
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("ProductCode"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcBarCode.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DocumentDetails, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DocumentDetails, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((java.lang.Object)Barcode.getBarCodeObject((long)((DocumentDetails)param.getValue()).getProductID(), (Connection)InternaPrijemnicaDetailesController.this.controller.getSettings().getConnection())).name("BarCode").build();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<java.lang.Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<java.lang.Object, Double> t) {
                ((DocumentDetails)t.getTableView().getItems().get(t.getTablePosition().getRow())).setQuantity(((Double)t.getNewValue()).doubleValue());
            }
        });
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void actionSave(ActionEvent event) {
        try {
            double sum;
            if (this.prijemnica.getDocumentID() > 0L) {
                sum = 0.0;
                for (DocumentDetails documentDetails : this.table.getItems()) {
                    sum += documentDetails.getQuantity() * documentDetails.getPrice();
                }
                this.prijemnica.setSysDTEdit(new Date());
                this.prijemnica.setNote(this.tfNapomena.getText());
                this.prijemnica.setSum(sum);
                this.prijemnica.setSumWithDiscount(sum);
                this.prijemnica.update(this.controller);
                this.otpremnica = Document.getByID((long)DocumentRelationship.getParentID((long)this.prijemnica.getDocumentID(), (ScreensController)this.controller), (Connection)this.controller.getSettings().getConnection());
                this.otpremnica.setNote(this.tfNapomena.getText());
                this.otpremnica.setSum(sum);
                this.otpremnica.setSumWithDiscount(sum);
                this.otpremnica.update(this.controller);
            } else {
                this.prijemnica.setDocumentTypeID(DocumentType.getByCode((String)"IP", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
                this.prijemnica.setDocumentStatusID(1);
                this.prijemnica.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
                if (((Department)this.cbOtpremnoOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID() == -1) {
                    this.controller.alert("Obavestenje", "Morate odabrati odeljenje", this.rootPane.getScene().getWindow());
                    return;
                }
                this.prijemnica.setDepartmentID(((Department)this.cbOtpremnoOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID());
                this.prijemnica.setNumber(Document.getNextNumber((int)this.prijemnica.getDocumentTypeID(), (long)this.prijemnica.getPointOfSaleID(), (ScreensController)this.controller));
                sum = 0.0;
                for (DocumentDetails documentDetails : this.table.getItems()) {
                    sum += documentDetails.getQuantity() * documentDetails.getPrice();
                }
                this.prijemnica.setSum(sum);
                this.prijemnica.setSumWithDiscount(sum);
                this.prijemnica.setYear(Year.now().getValue());
                this.prijemnica.setDate(new Date());
                this.prijemnica.setDeliveryDate(new Date());
                this.prijemnica.setCurrencyDate(new Date());
                this.prijemnica.setNote(this.tfNapomena.getText());
                this.prijemnica.setPlace(Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()).getCity());
                this.prijemnica.setWorkDayID(WorkDay.getFromDb((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()).getWorkDayID());
                this.prijemnica.setSysDTCreated(new Date());
                this.prijemnica.setSysUserAddID(this.controller.getUser().getUserID());
                this.otpremnica.setDocumentTypeID(DocumentType.getByCode((String)"IO", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
                this.otpremnica.setDocumentStatusID(1);
                this.otpremnica.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
                if (((Department)this.cbPrijemnoOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID() == -1) {
                    this.controller.alert("Obavestenje", "Morate odabrati odeljenje", this.rootPane.getScene().getWindow());
                    return;
                }
                this.otpremnica.setDepartmentID(((Department)this.cbPrijemnoOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID());
                this.otpremnica.setNumber(Document.getNextNumber((int)this.prijemnica.getDocumentTypeID(), (long)this.prijemnica.getPointOfSaleID(), (ScreensController)this.controller));
                this.otpremnica.setSum(sum);
                this.otpremnica.setSumWithDiscount(sum);
                this.otpremnica.setYear(Year.now().getValue());
                this.otpremnica.setDate(new Date());
                this.otpremnica.setDeliveryDate(new Date());
                this.otpremnica.setCurrencyDate(new Date());
                this.otpremnica.setNote(this.tfNapomena.getText());
                this.otpremnica.setPlace(Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()).getCity());
                this.otpremnica.setWorkDayID(WorkDay.getFromDb((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()).getWorkDayID());
                this.otpremnica.setSysDTCreated(new Date());
                this.otpremnica.setSysUserAddID(this.controller.getUser().getUserID());
                long otp = this.otpremnica.insert(this.controller);
                long pri = this.prijemnica.insert(this.controller);
                DocumentRelationship documentRelationship = new DocumentRelationship();
                documentRelationship.setDocumentParentID(otp);
                documentRelationship.setDocumentChildID(pri);
                documentRelationship.setActive(true);
                documentRelationship.setRelationshipTypeID(4);
                documentRelationship.setSysDTCreated(new Date());
                documentRelationship.setSysUserAddID(this.controller.getUser().getUserID());
                documentRelationship.insert(this.controller.getSettings().getConnection());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.deletedItems.size(); ++i) {
            this.deletedItems.get(i).delete(this.controller.getSettings().getConnection());
        }
        for (DocumentDetails documentDetails : this.table.getItems()) {
            if (documentDetails.getDocumentID() > 0L) {
                documentDetails.update(this.controller);
                if (this.otpremnica == null) continue;
                for (DocumentDetails dd : DocumentDetails.getObeservableList((long)this.otpremnica.getDocumentID(), (Connection)this.controller.getSettings().getConnection())) {
                    if (documentDetails.getProductID() != dd.getProductID()) continue;
                    dd.setQuantity(documentDetails.getQuantity());
                    dd.update(this.controller);
                }
                continue;
            }
            if (this.otpremnica != null) {
                documentDetails.setDocumentID(this.otpremnica.getDocumentID());
                documentDetails.setPriceWithDiscount(documentDetails.getPrice());
                documentDetails.setPrice(documentDetails.getPrice());
                documentDetails.setSysDTCreated(new Date());
                documentDetails.setSysUserAddID(this.otpremnica.getSysUserAddID());
                documentDetails.setUnitID(1);
                documentDetails.setVatID(1);
                documentDetails.insert(this.controller.getSettings().getConnection());
            }
            if (this.prijemnica == null) continue;
            documentDetails.setDocumentID(this.prijemnica.getDocumentID());
            documentDetails.setPriceWithDiscount(documentDetails.getPrice());
            documentDetails.setPrice(documentDetails.getPrice());
            documentDetails.setSysDTCreated(new Date());
            documentDetails.setSysUserAddID(this.prijemnica.getSysUserAddID());
            documentDetails.setUnitID(1);
            documentDetails.setVatID(1);
            documentDetails.insert(this.controller.getSettings().getConnection());
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            if (((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).getDocumentID() > 0L) {
                this.deletedItems.add((DocumentDetails)this.table.getSelectionModel().getSelectedItem());
            }
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
    }

    private ListView<DocumentDetails> populateFilterList(String filterText) {
        this.gpContainer.getChildren().clear();
        this.list = new ListView();
        final ObservableList listFromDb = DocumentDetails.getFilteredListInternaOtpremnica((String)filterText, (Document)this.prijemnica, (ScreensController)this.controller);
        if (!this.table.getItems().isEmpty()) {
            for (DocumentDetails ddTable : this.table.getItems()) {
                ListIterator iter = listFromDb.listIterator();
                while (iter.hasNext()) {
                    DocumentDetails a = (DocumentDetails)iter.next();
                    if (!ddTable.getProductCode().equals(a.getProductCode())) continue;
                    iter.remove();
                }
            }
        }
        if (listFromDb.isEmpty()) {
            this.gpContainer.setVisible(false);
            return this.list;
        }
        this.list.getItems().addAll((Collection)listFromDb);
        this.gpContainer.setVisible(true);
        this.list.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){
            MultipleSelectionModel<DocumentDetails> selected;
            {
                this.selected = InternaPrijemnicaDetailesController.this.list.getSelectionModel();
            }

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    if (((Department)InternaPrijemnicaDetailesController.this.cbOtpremnoOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID() != -1) {
                        InternaPrijemnicaDetailesController.this.psd = (DocumentDetails)InternaPrijemnicaDetailesController.this.list.getSelectionModel().getSelectedItem();
                        InternaPrijemnicaDetailesController.this.tfQuantity.setText("" + Product.getCurrentStock((long)InternaPrijemnicaDetailesController.this.psd.getProductID(), (int)((Department)InternaPrijemnicaDetailesController.this.cbOtpremnoOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID(), (Connection)InternaPrijemnicaDetailesController.this.controller.getSettings().getConnection()));
                        InternaPrijemnicaDetailesController.this.psd.setPrice(Product.getCurrentPrice((long)InternaPrijemnicaDetailesController.this.psd.getProductID(), (long)((Department)InternaPrijemnicaDetailesController.this.cbOtpremnoOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID(), (boolean)false, (Connection)InternaPrijemnicaDetailesController.this.controller.getSettings().getConnection()));
                        InternaPrijemnicaDetailesController.this.psd.setPriceWithDiscount(InternaPrijemnicaDetailesController.this.psd.getPrice());
                        if (!InternaPrijemnicaDetailesController.this.table.getItems().contains((java.lang.Object)InternaPrijemnicaDetailesController.this.psd)) {
                            InternaPrijemnicaDetailesController.this.table.getItems().add((java.lang.Object)InternaPrijemnicaDetailesController.this.psd);
                        }
                    } else {
                        InternaPrijemnicaDetailesController.this.controller.alert("Obavestenje", "Morate odabrati odeljenje", InternaPrijemnicaDetailesController.this.rootPane.getScene().getWindow());
                        InternaPrijemnicaDetailesController.this.tfFilter.setText("");
                        InternaPrijemnicaDetailesController.this.gpContainer.setVisible(false);
                        return;
                    }
                    InternaPrijemnicaDetailesController.this.table.getSelectionModel().select((java.lang.Object)InternaPrijemnicaDetailesController.this.psd);
                    int index = InternaPrijemnicaDetailesController.this.table.getItems().indexOf((java.lang.Object)InternaPrijemnicaDetailesController.this.psd);
                    InternaPrijemnicaDetailesController.this.table.getFocusModel().focus(index);
                    listFromDb.remove((java.lang.Object)InternaPrijemnicaDetailesController.this.psd);
                    InternaPrijemnicaDetailesController.this.tfQuantity.requestFocus();
                    InternaPrijemnicaDetailesController.this.gpContainer.setVisible(false);
                    InternaPrijemnicaDetailesController.this.tfFilter.setText("");
                }
                if (event.getCode() == KeyCode.UP & this.selected.getSelectedIndex() == 0) {
                    InternaPrijemnicaDetailesController.this.tfFilter.requestFocus();
                }
            }
        });
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    if (((Department)InternaPrijemnicaDetailesController.this.cbOtpremnoOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID() != -1) {
                        InternaPrijemnicaDetailesController.this.psd = (DocumentDetails)InternaPrijemnicaDetailesController.this.list.getSelectionModel().getSelectedItem();
                        InternaPrijemnicaDetailesController.this.tfQuantity.setText("" + Product.getCurrentStock((long)InternaPrijemnicaDetailesController.this.psd.getProductID(), (int)((Department)InternaPrijemnicaDetailesController.this.cbOtpremnoOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID(), (Connection)InternaPrijemnicaDetailesController.this.controller.getSettings().getConnection()));
                        InternaPrijemnicaDetailesController.this.psd.setPrice(Product.getCurrentPrice((long)InternaPrijemnicaDetailesController.this.psd.getProductID(), (long)((Department)InternaPrijemnicaDetailesController.this.cbOtpremnoOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID(), (boolean)false, (Connection)InternaPrijemnicaDetailesController.this.controller.getSettings().getConnection()));
                        InternaPrijemnicaDetailesController.this.psd.setPriceWithDiscount(InternaPrijemnicaDetailesController.this.psd.getPrice());
                        if (!InternaPrijemnicaDetailesController.this.table.getItems().contains((java.lang.Object)InternaPrijemnicaDetailesController.this.psd)) {
                            InternaPrijemnicaDetailesController.this.table.getItems().add((java.lang.Object)InternaPrijemnicaDetailesController.this.psd);
                        }
                    } else {
                        InternaPrijemnicaDetailesController.this.controller.alert("Obavestenje", "Morate odabrati odeljenje", InternaPrijemnicaDetailesController.this.rootPane.getScene().getWindow());
                        InternaPrijemnicaDetailesController.this.tfFilter.setText("");
                        InternaPrijemnicaDetailesController.this.gpContainer.setVisible(false);
                        return;
                    }
                    InternaPrijemnicaDetailesController.this.table.getSelectionModel().select((java.lang.Object)InternaPrijemnicaDetailesController.this.psd);
                    int index = InternaPrijemnicaDetailesController.this.table.getItems().indexOf((java.lang.Object)InternaPrijemnicaDetailesController.this.psd);
                    InternaPrijemnicaDetailesController.this.table.getFocusModel().focus(index);
                    InternaPrijemnicaDetailesController.this.tfQuantity.requestFocus();
                    InternaPrijemnicaDetailesController.this.gpContainer.setVisible(false);
                    InternaPrijemnicaDetailesController.this.tfFilter.setText("");
                }
            }
        });
        return this.list;
    }

    private void editQuantity(String number) {
        try {
            ((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).setQuantity(Double.parseDouble(number));
            this.table.getSelectionModel().select(this.table.getSelectionModel().getSelectedIndex() + 1);
        }
        catch (NumberFormatException e) {
            ((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).setQuantity(0.0);
        }
        this.table.refresh();
    }

    private void loadOtpremniDepartmentComboBox() {
        this.cbOtpremnoOdeljenje.getItems().clear();
        this.cbPrijemnoOdeljenje.getItems().clear();
        Department department = new Department();
        department.setDepartmentID(-1);
        department.setName("Sva odeljenja");
        this.cbOtpremnoOdeljenje.getItems().add((java.lang.Object)department);
        this.cbPrijemnoOdeljenje.getItems().add((java.lang.Object)department);
        this.departmentList = Department.getList((Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection());
        for (Department depart : this.departmentList) {
            this.cbOtpremnoOdeljenje.getItems().add((java.lang.Object)depart);
            this.cbPrijemnoOdeljenje.getItems().add((java.lang.Object)depart);
        }
        this.cbOtpremnoOdeljenje.getSelectionModel().select((java.lang.Object)department);
        this.cbPrijemnoOdeljenje.getSelectionModel().select((java.lang.Object)department);
    }

    private void loadPrijemniDepartmentComboBox(Department dep) {
        this.cbPrijemnoOdeljenje.getItems().clear();
        Department department = new Department();
        department.setDepartmentID(-1);
        department.setName("Sva odeljenja");
        this.cbPrijemnoOdeljenje.getItems().add((java.lang.Object)department);
        for (Department depart : this.departmentList) {
            if (dep.getDepartmentID() == -1) {
                this.cbPrijemnoOdeljenje.getItems().add((java.lang.Object)depart);
            } else if (dep.getDepartmentID() != depart.getDepartmentID()) {
                this.cbPrijemnoOdeljenje.getItems().add((java.lang.Object)depart);
            }
            this.cbPrijemnoOdeljenje.getSelectionModel().select((java.lang.Object)department);
        }
    }

    private void loadTable() {
        this.table.getItems().clear();
        this.table.setItems(this.getPrijemnicaList);
    }
}

