/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.backoffice.gui.ComboBoxCellFactory;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.document.Otpis;
import rs.petcom.master.dal.document.OtpisDetailes;
import rs.petcom.master.dal.document.Prijemnica;
import rs.petcom.master.dal.document.PrijemnicaDetailes;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductDepartment;
import rs.petcom.master.gui.AutoCompleteComboBoxListenerNew;
import rs.petcom.master.gui.DoubleTableCellFactory;
import rs.petcom.renameconnection.ChangeConnection;

public class InternaOtpremnicaDetailesController
implements DialogController {
    ScreensController controller;
    int modalResult;
    boolean napomenaVidljiva;
    ObservableList<PrijemnicaDetailes> prijemniceDetailsList;
    ObservableList<OtpisDetailes> prijemniceDetailsOtpisList = FXCollections.observableArrayList();
    ArrayList<Product> productList;
    ArrayList<PrijemnicaDetailes> deletedItems;
    Object objekat;
    Department department;
    AutoCompleteCBWithoutProducts<Product> cbProductAutoComplete;
    ComboBoxCellFactory cbCellFactory;
    double ukupno = 0.0;
    @FXML
    private BorderPane rootPane;
    @FXML
    private GridPane gpNapomena;
    @FXML
    private TextField tfNumber;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfNabavnaCena;
    @FXML
    private TextField tfNabavnaCenaSaPDVom;
    @FXML
    private TextField tfUkupnaNabavnaCena;
    @FXML
    private TextField tfUkupnaNabavnaCenaSaPDVom;
    @FXML
    private TextField tfRabat;
    @FXML
    private TextField tfSellPrice;
    @FXML
    private TextField tfMargin;
    @FXML
    private Label labelNapomena;
    @FXML
    private Label lblSumQuantity;
    @FXML
    private Label lblSum;
    @FXML
    private Label lblSumWithDiscount;
    @FXML
    private Label lblSumWithVat;
    @FXML
    private Label lblSumSellPrice;
    @FXML
    private ComboBox<Person> cbPerson;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private ComboBox<String> cbFilter;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnNapomena;
    @FXML
    private Button btnRemove;
    @FXML
    private Button btnSacuvaj;
    @FXML
    private Button btnOdustani;
    @FXML
    private Button btnNoviProizvod;
    @FXML
    private TextArea taNapomena;
    @FXML
    private TableView<PrijemnicaDetailes> tablePrijemniceDetails;
    @FXML
    private TableColumn<java.lang.Object, Product> tcProduct;
    @FXML
    private TableColumn<java.lang.Object, Double> tcQuantity;
    @FXML
    private TableColumn<java.lang.Object, Double> tcPurchasePriceWithoutRabat;
    @FXML
    private TableColumn<java.lang.Object, Double> tcDiscount;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumWithDiscount;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSumWithVat;
    @FXML
    private TableColumn<java.lang.Object, Double> tcSellPrice;
    @FXML
    private TableColumn<java.lang.Object, Double> tcMargin;
    @FXML
    private TableColumn<PrijemnicaDetailes, String> tcJedinicaMere;
    @FXML
    private TableColumn<PrijemnicaDetailes, Product> tcVat;
    @FXML
    private DatePicker dpDeliveryDate;
    private String oldValuePurchasePrice;
    private String oldValuePurchaseValueWithPdv;
    private SimpleDateFormat sdf;
    private Date date2;
    private LocalDate currentDataDate;
    private Document otpremnica;
    private Connection connection;
    private Product selectedProduct;
    private PrijemnicaDetailes pd;
    private Prijemnica pr;
    private Person person;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;

    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.otpremnica = (Document)parameter.get("otpremnica");
        this.connection = this.controller.getSettings().getConnection();
        this.lastDocumentLockDate = (LocalDate)parameter.get("lastDocumentLockDate");
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        this.prijemniceDetailsList = FXCollections.observableArrayList();
        this.deletedItems = new ArrayList();
        this.btnRemove.setDisable(false);
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbPerson.setItems(Person.getListByCategory((String)PersonCategory.INTERN_BUYER, (boolean)true, (Connection)this.controller.getSettings().getConnection()));
        new AutoCompleteComboBoxListenerNew(this.cbPerson);
        this.pd = new PrijemnicaDetailes();
        this.cbFilter.getItems().addAll((java.lang.Object[])new String[]{ScreensController.FILTER_ALL, ScreensController.FILTER_CODE, ScreensController.FILTER_BARCODE});
        this.cbFilter.getSelectionModel().selectFirst();
        this.cbFilter.setOnAction(actionEvent -> {
            this.cbProductAutoComplete.setFilterType((String)this.cbFilter.getSelectionModel().getSelectedItem());
            this.cbCellFactory.setFilterType((String)this.cbFilter.getSelectionModel().getSelectedItem());
        });
        this.objekat = (Object)parameter.get("object");
        try {
            this.department = Department.getById((int)1, (Connection)this.connection);
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        this.currentDataDate = LocalDate.now();
        this.date2 = new Date();
        if (this.otpremnica == null) {
            this.otpremnica = new Document();
            this.currentDataDate = LocalDate.now();
            this.dpDeliveryDate.setValue((java.lang.Object)this.currentDataDate);
            this.tfNumber.setText(String.valueOf(Document.getNextNumber((int)DocumentType.getByCode((String)"IO", (Connection)this.connection).getDocumentTypeID(), (Department)this.department, (ScreensController)this.controller, (LocalDate)((LocalDate)this.dpDeliveryDate.getValue()))));
            this.dpDeliveryDate.valueProperty().addListener((observable, oldDate, newDate) -> {
                if (this.documentLockIsActive && (newDate.isEqual(this.lastDocumentLockDate) || newDate.isBefore(this.lastDocumentLockDate))) {
                    this.dpDeliveryDate.setValue((java.lang.Object)this.lastDocumentLockDate.plusDays(1L));
                    this.controller.alert("Upozorenje", "Ne mo\u017eete izabrati datum za koji su zaklju\u010dani dokumenti ", this.rootPane.getScene().getWindow());
                }
                this.tfNumber.setText(String.valueOf(Document.getNextNumber((int)14, (Department)this.department, (ScreensController)this.controller, (LocalDate)((LocalDate)this.dpDeliveryDate.getValue()))));
            });
        } else {
            this.pr = new Prijemnica();
            this.pr.setDocumentID(this.otpremnica.getDocumentID());
            this.tfNumber.setText(String.valueOf(this.otpremnica.getNumber()));
            this.dpDeliveryDate.setValue((java.lang.Object)Settings.fromDate((Date)this.otpremnica.getDate()));
            this.person = Person.getById((long)this.otpremnica.getPersonID(), (ScreensController)this.controller);
            this.cbPerson.getSelectionModel().select((java.lang.Object)this.person);
            this.prijemniceDetailsList = PrijemnicaDetailes.getlist((Prijemnica)this.pr, (long)this.department.getDepartmentID(), (ScreensController)this.controller);
            for (PrijemnicaDetailes pDetailes : this.prijemniceDetailsList) {
                this.tablePrijemniceDetails.getItems().add((java.lang.Object)pDetailes);
            }
            this.cbProduct.setDisable(false);
        }
        this.sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String dateDDString = this.sdf.format(this.date2);
            this.date2 = this.sdf.parse(dateDDString);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        this.productList = new ArrayList();
        this.cbCellFactory = new ComboBoxCellFactory((ObservableList<Product>)FXCollections.observableArrayList(this.productList), this.controller, this.department, (String)this.cbFilter.getSelectionModel().getSelectedItem());
        this.tcProduct.setCellValueFactory((Callback)new PropertyValueFactory("Product"));
        this.tcProduct.setCellFactory((Callback)this.cbCellFactory);
        this.tcProduct.setOnEditCommit(cellEditEvent -> {
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.cbPerson.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (InternaOtpremnicaDetailesController.this.cbPerson.getSelectionModel().getSelectedIndex() != -1) {
                    InternaOtpremnicaDetailesController.this.cbProduct.setDisable(false);
                } else {
                    InternaOtpremnicaDetailesController.this.cbProduct.setDisable(true);
                }
            }
        });
        this.cbProduct.valueProperty().addListener((ov, oldValue, newValue) -> {
            if (this.cbProduct.getSelectionModel().getSelectedItem() != null) {
                this.selectedProduct = Product.getByID((long)((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getProductID(), (ScreensController)this.controller);
            }
            try {
                LocalDateTime dateTime = WorkDay.getKrajaDanaZaDatum((Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDeliveryDate.getValue())), (int)1, (ScreensController)this.controller);
                this.selectedProduct.setPrice(PriceListDetailes.getPreviousPrice((long)1L, (long)this.selectedProduct.getProductID(), (Date)(dateTime != null ? Settings.DatefromLocalDateTime((LocalDateTime)dateTime) : new Date()), (Connection)this.controller.getSettings().getConnection()));
                this.selectedProduct.getPurchacePricePrijemnica(this.controller.getSettings().getConnection());
                this.pd.setProduct(Product.getByID((long)this.selectedProduct.getProductID(), (ScreensController)this.controller));
                this.pd.setProductID(this.selectedProduct.getProductID());
                this.pd.setProductCode(this.pd.getProduct().getCode());
                this.pd.setProductName(this.pd.getProduct().getName());
                this.pd.setSellPrice(this.selectedProduct.getPrice());
                this.pd.setNewSellPrice(this.selectedProduct.getPrice());
                int index = this.cbPerson.getSelectionModel().getSelectedIndex();
                if (this.person == null) {
                    this.person = (Person)this.cbPerson.getItems().get(index);
                }
                if (this.person.getPersonVatTypeID() == 2) {
                    this.pd.getProduct().setVatID(3);
                    this.pd.setVat(1.0);
                } else {
                    this.pd.setVat(this.selectedProduct.getVatValue() == 0.0 ? 1.0 : this.selectedProduct.getVatValue());
                }
                this.pd.setJedinicaMere(Unit.getUnitById((int)this.selectedProduct.getUnitID(), (Connection)this.controller.getSettings().getConnection()).getCode());
                if (this.selectedProduct.getPurchacePrice() != 0.0) {
                    this.pd.setPurchasePriceWithoutRabat(this.selectedProduct.getPurchacePrice());
                    this.pd.setPurchasePrice(this.selectedProduct.getPurchacePrice());
                    this.pd.setPrice(this.selectedProduct.getPurchacePrice() * this.pd.getVat());
                    this.pd.setPriceWithDiscount(this.pd.getPrice() - this.pd.getPrice() * this.pd.getDiscount() / 100.0);
                }
                this.pd.setMargin(this.pd.getPriceWithDiscount() > 0.0 ? (this.pd.getNewSellPrice() - this.pd.getPriceWithDiscount()) / this.pd.getPriceWithDiscount() * 100.0 : (this.pd.getNewSellPrice() - this.selectedProduct.getNabavnaCena()) / this.selectedProduct.getNabavnaCena() * 100.0);
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePriceWithoutRabat()));
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPriceWithDiscount()));
                this.tfSellPrice.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.selectedProduct.getPrice()));
                this.tfMargin.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getMargin()));
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        });
        this.cbProductAutoComplete = new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, this.department.getDepartmentID(), (String)this.cbFilter.getSelectionModel().getSelectedItem(), this.tfQuantity);
        this.calculateSum();
        this.tfQuantity.setText("");
        this.tfQuantity.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && InternaOtpremnicaDetailesController.this.tfQuantity.getText().equals("")) {
                    event.consume();
                    InternaOtpremnicaDetailesController.this.cbProduct.requestFocus();
                }
                if (event.getCode().equals((java.lang.Object)KeyCode.ENTER)) {
                    event.consume();
                    try {
                        InternaOtpremnicaDetailesController.this.actionAddPrijemnicaDetails(null);
                        InternaOtpremnicaDetailesController.this.tfQuantity.setText("");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.tfQuantity.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                // empty if block
            }
        });
        this.tfQuantity.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (this.tfQuantity.isFocused()) {
                    this.pd.setQuantity(Settings.getNumberFormat((int)4, (boolean)true).parse(this.tfQuantity.getText().trim()).doubleValue());
                }
                if (newValue.length() > 0) {
                    if (newValue.substring(newValue.length() - 1).equals(".")) {
                        this.tfQuantity.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                    }
                    if (!this.tfNabavnaCena.getText().equals("0,0000")) {
                        this.pd.setSumPurchasePrice(this.pd.getQuantity() * this.pd.getPurchasePrice());
                        this.pd.setSumWithVat(this.pd.getQuantity() * this.pd.getPrice());
                        this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
                        this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumWithVat()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.izracunajUkupno();
        });
        this.tfNabavnaCena.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfNabavnaCena.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfNabavnaCena.getText().equals("")) {
                keyEvent.consume();
                this.tfQuantity.requestFocus();
            }
        });
        this.tfNabavnaCena.focusedProperty().addListener((observable, oldValue, newValue) -> {
            this.getOldValuesForFields(this.tfNabavnaCenaSaPDVom.getText(), this.tfNabavnaCena.getText(), this.tfUkupnaNabavnaCenaSaPDVom.getText(), this.tfUkupnaNabavnaCena.getText());
            System.out.println(this.oldValuePurchasePrice + "Nesaaa");
            if (oldValue.booleanValue()) {
                try {
                    this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePrice()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfNabavnaCena.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfNabavnaCena.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (this.tfNabavnaCena.isFocused()) {
                this.getOldValuesForFields(this.tfNabavnaCenaSaPDVom.getText(), this.tfNabavnaCena.getText(), this.tfUkupnaNabavnaCenaSaPDVom.getText(), this.tfUkupnaNabavnaCena.getText());
                this.pd.setPurchasePriceWithoutRabat(Double.parseDouble(newValue.replace(",", ".")));
                this.pd.setPurchasePrice(this.pd.getPurchasePriceWithoutRabat());
                this.pd.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setPriceWithDiscount(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setSumPurchasePrice(this.pd.getQuantity() * this.pd.getPurchasePrice());
                this.pd.setSumWithVat(this.pd.getQuantity() * this.pd.getPrice());
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPrice()));
                this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
                this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumWithVat()));
            }
            this.izracunajUkupno();
        });
        this.tfNabavnaCenaSaPDVom.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfNabavnaCenaSaPDVom.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfNabavnaCenaSaPDVom.getText().equals("")) {
                keyEvent.consume();
                this.tfNabavnaCena.requestFocus();
            }
        });
        this.tfNabavnaCenaSaPDVom.focusedProperty().addListener((observable, oldValue, newValue) -> {
            this.getOldValuesForFields(this.tfNabavnaCenaSaPDVom.getText(), this.tfNabavnaCena.getText(), this.tfUkupnaNabavnaCenaSaPDVom.getText(), this.tfUkupnaNabavnaCena.getText());
            if (oldValue.booleanValue()) {
                try {
                    this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePriceWithoutRabat() * this.pd.getVat()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfNabavnaCenaSaPDVom.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.substring(newValue.length() - 1).equals(".")) {
                this.tfNabavnaCenaSaPDVom.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
            }
            if (this.tfNabavnaCenaSaPDVom.isFocused()) {
                this.pd.setPrice(Double.parseDouble(newValue.replace(",", ".")));
                this.pd.setPriceWithDiscount(Double.parseDouble(newValue.replace(",", ".")));
                this.pd.setPurchasePriceWithoutRabat(this.pd.getPrice() / this.pd.getVat());
                this.pd.setPurchasePrice(this.pd.getPrice() / this.pd.getVat());
                this.pd.setSumPurchasePrice(this.pd.getQuantity() * this.pd.getPurchasePrice());
                this.pd.setSumWithVat(this.pd.getQuantity() * this.pd.getPrice());
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePrice()));
                this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
                this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumWithVat()));
            }
            this.izracunajUkupno();
        });
        this.tfUkupnaNabavnaCena.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfUkupnaNabavnaCena.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfUkupnaNabavnaCena.getText().equals("")) {
                keyEvent.consume();
                this.tfNabavnaCenaSaPDVom.requestFocus();
            }
        });
        this.tfUkupnaNabavnaCena.focusedProperty().addListener((observable, oldValue, newValue) -> {
            this.getOldValuesForFields(this.tfNabavnaCenaSaPDVom.getText(), this.tfNabavnaCena.getText(), this.tfUkupnaNabavnaCenaSaPDVom.getText(), this.tfUkupnaNabavnaCena.getText());
            if (oldValue.booleanValue()) {
                try {
                    this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfUkupnaNabavnaCena.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.substring(newValue.length() - 1).equals(".")) {
                this.tfUkupnaNabavnaCena.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
            }
            if (this.tfUkupnaNabavnaCena.isFocused()) {
                this.pd.setSumPurchasePrice(Double.parseDouble(newValue.replace(",", ".")));
                this.pd.setPurchasePriceWithoutRabat(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPurchasePrice(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setPriceWithDiscount(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setSumWithVat(this.pd.getSumPurchasePrice() * this.pd.getVat());
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePrice()));
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPrice()));
                this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumWithVat()));
            }
            this.izracunajUkupno();
        });
        this.tfUkupnaNabavnaCenaSaPDVom.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfUkupnaNabavnaCenaSaPDVom.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfUkupnaNabavnaCenaSaPDVom.getText().equals("")) {
                keyEvent.consume();
                this.tfNabavnaCenaSaPDVom.requestFocus();
            }
        });
        this.tfUkupnaNabavnaCenaSaPDVom.focusedProperty().addListener((observable, oldValue, newValue) -> {
            this.getOldValuesForFields(this.tfNabavnaCenaSaPDVom.getText(), this.tfNabavnaCena.getText(), this.tfUkupnaNabavnaCenaSaPDVom.getText(), this.tfUkupnaNabavnaCena.getText());
            if (oldValue.booleanValue()) {
                try {
                    this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumWithVat()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfUkupnaNabavnaCenaSaPDVom.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfUkupnaNabavnaCenaSaPDVom.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (this.tfUkupnaNabavnaCenaSaPDVom.isFocused()) {
                this.pd.setSumWithVat(Double.parseDouble(newValue.replace(",", ".")));
                this.pd.setSumPurchasePrice(this.pd.getSumWithVat() / this.pd.getVat());
                this.pd.setPurchasePriceWithoutRabat(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPurchasePrice(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setPriceWithDiscount(this.pd.getPurchasePrice() * this.pd.getVat());
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePrice()));
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPrice()));
                this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
            }
            this.izracunajUkupno();
        });
        this.tfRabat.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfRabat.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.BACK_SPACE) && this.tfRabat.getText().equals("")) {
                keyEvent.consume();
                this.tfUkupnaNabavnaCenaSaPDVom.requestFocus();
            }
        });
        this.tfRabat.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfRabat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getDiscount()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfRabat.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfRabat.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (this.tfRabat.isFocused()) {
                this.pd.setSumWithVat(Double.parseDouble(this.oldValuePurchaseValueWithPdv));
                this.pd.setSumPurchasePrice(this.pd.getSumWithVat() / this.pd.getVat());
                this.pd.setPurchasePriceWithoutRabat(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPurchasePrice(this.pd.getSumPurchasePrice() / this.pd.getQuantity());
                this.pd.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
                this.pd.setPriceWithDiscount(this.pd.getPurchasePrice() * this.pd.getVat());
                this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePrice()));
                this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPrice()));
                this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
                this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumWithVat()));
                this.pd.setDiscount(Double.parseDouble(newValue.replace(",", ".")));
            }
            this.izracunajUkupno();
        });
        this.tfSellPrice.setTextFormatter(new TextFormatter(Settings.getDoubleFilterWithDecimal()));
        this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(0L));
        this.tfSellPrice.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.length() >= 2 && newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfSellPrice.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
                if (this.tfSellPrice.isFocused()) {
                    this.pd.setNewSellPrice(Settings.getNumberFormat((int)2, (boolean)true).parse((String)newValue).doubleValue());
                    this.izracunajMarzu();
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfSellPrice.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getNewSellPrice()) + "");
                    if (this.pd.getDiscount() != 0.0) {
                        this.pd.setPurchasePrice(this.pd.getPurchasePrice() - this.pd.getPurchasePrice() * this.pd.getDiscount() / 100.0);
                        this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPurchasePrice()));
                        this.pd.setSumPurchasePrice(this.pd.getQuantity() * this.pd.getPurchasePrice());
                        this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumPurchasePrice()));
                        this.pd.setSumWithVat(this.pd.getSumPurchasePrice() * this.pd.getVat());
                        this.pd.setPrice(this.pd.getPurchasePrice() * this.pd.getVat());
                        this.pd.setPriceWithDiscount(this.pd.getPrice() - this.pd.getPrice() * this.pd.getDiscount() / 100.0);
                        this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getPrice()));
                        this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getSumWithVat()));
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfMargin.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue.substring(newValue.length() - 1).equals(".")) {
                    this.tfMargin.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
                }
                if (this.tfMargin.isFocused()) {
                    this.pd.setMargin(Settings.getNumberFormat((int)2, (boolean)true).parse((String)newValue).doubleValue());
                    this.izracunajProdajnuCenu();
                }
            }
            catch (StringIndexOutOfBoundsException | ParseException e) {
                e.printStackTrace();
            }
        });
        this.tfMargin.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.booleanValue()) {
                try {
                    this.tfMargin.setText(Settings.getNumberFormat((int)2, (boolean)true).format(this.pd.getMargin()) + "");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.tfMargin.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((java.lang.Object)KeyCode.TAB)) {
                this.cbProduct.requestFocus();
                this.actionAddPrijemnicaDetails(null);
                keyEvent.consume();
            }
        });
        this.taNapomena.setFocusTraversable(false);
        this.btnSacuvaj.setFocusTraversable(false);
        this.btnOdustani.setFocusTraversable(false);
        this.btnAdd.setFocusTraversable(false);
        this.btnRemove.setFocusTraversable(false);
        this.btnNoviProizvod.setFocusTraversable(false);
        this.tablePrijemniceDetails.setFocusTraversable(false);
        this.tfMargin.setEditable(false);
    }

    public HashMap<String, java.lang.Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void actionNewPerson(ActionEvent event) {
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("controller", this.controller);
        hm.put("personCategory", PersonCategory.INTERN_BUYER);
        String title = "Kreiranje novog internog dobavlja\u010da";
        this.controller.showModalDialog(title, ScreensController.DIALOG_ADD_PERSON, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.loadDetails();
        this.cbPerson.setItems(Person.getListByCategory((String)PersonCategory.INTERN_BUYER, (boolean)true, (Connection)this.controller.getSettings().getConnection()));
    }

    public void initialize() {
        this.napomenaVidljiva = true;
        this.toggleNapomena(null);
        this.calculateSum();
        Platform.runLater(() -> this.btnSacuvaj.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnSacuvaj.fire()));
        Platform.runLater(() -> this.btnNoviProizvod.getScene().getAccelerators().put((java.lang.Object)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN}), () -> this.btnNoviProizvod.fire()));
        this.tfFilter.textProperty().addListener((obs, oldValue, newValue) -> this.loadDetails());
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(4, true);
        DoubleTableCellFactory cellFactory2 = new DoubleTableCellFactory(2, true);
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit(cellEditEvent -> {
            cellEditEvent.getTableColumn().getTableView().refresh();
            this.calculateSum();
        });
        this.makeHeaderWrappable(this.tcQuantity);
        this.tcPurchasePriceWithoutRabat.setCellValueFactory((Callback)new PropertyValueFactory("PurchasePriceWithoutRabat"));
        this.tcPurchasePriceWithoutRabat.setCellFactory((Callback)cellFactory2);
        this.tcPurchasePriceWithoutRabat.setOnEditCommit(cellEditEvent -> {});
        this.makeHeaderWrappable(this.tcPurchasePriceWithoutRabat);
        this.tcDiscount.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.tcDiscount.setCellFactory((Callback)cellFactory2);
        this.tcDiscount.setOnEditCommit(cellEditEvent -> {});
        this.makeHeaderWrappable(this.tcDiscount);
        this.tcSumWithDiscount.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.tcSumWithDiscount.setCellFactory((Callback)cellFactory2);
        this.makeHeaderWrappable(this.tcSumWithDiscount);
        this.tcVat.setCellValueFactory((Callback)new PropertyValueFactory("Product"));
        this.tcVat.setCellFactory((Callback)new Callback<TableColumn<PrijemnicaDetailes, Product>, TableCell<PrijemnicaDetailes, Product>>(){

            public TableCell<PrijemnicaDetailes, Product> call(TableColumn<PrijemnicaDetailes, Product> param) {
                return new TableCell<PrijemnicaDetailes, Product>(){

                    protected void updateItem(Product item, boolean arg1) {
                        super.updateItem((java.lang.Object)item, arg1);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(Vat.getById((int)item.getVatID(), (Connection)InternaOtpremnicaDetailesController.this.controller.getSettings().getConnection()).getName());
                        }
                    }
                };
            }
        });
        this.makeHeaderWrappable(this.tcVat);
        this.tcSumWithVat.setCellValueFactory((Callback)new PropertyValueFactory("SumWithVat"));
        this.tcSumWithVat.setCellFactory((Callback)cellFactory2);
        this.makeHeaderWrappable(this.tcSumWithVat);
        this.tcSellPrice.setCellValueFactory((Callback)new PropertyValueFactory("NewSellPrice"));
        this.tcSellPrice.setCellFactory((Callback)cellFactory2);
        this.tcSellPrice.setOnEditCommit(cellEditEvent -> this.calculateSum());
        this.makeHeaderWrappable(this.tcSellPrice);
        this.tcMargin.setCellValueFactory((Callback)new PropertyValueFactory("Margin"));
        this.tcMargin.setCellFactory((Callback)cellFactory2);
        this.tcMargin.setOnEditCommit(cellEditEvent -> this.calculateSum());
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void actionSave(ActionEvent event) {
        if (this.person == null) {
            this.person = (Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex());
        }
        try {
            if (this.otpremnica.getDocumentID() == -1L && Prijemnica.exists((String)this.tfNumber.getText(), (Person)((Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex())), (Connection)this.controller.getSettings().getConnection())) {
                this.controller.alert("Prijemnica ve\u0107 postoji", "Prijemnica sa unetim brojem i odabranim komitentom ve\u0107 postoji", this.rootPane.getScene().getWindow());
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.controller.alert("Obavestenje", "Morate odabrati komitenta", this.rootPane.getScene().getWindow());
            return;
        }
        try {
            int i;
            this.calculateSum();
            ChangeConnection.getConnectionAdmin((ScreensController)this.controller);
            this.controller.getSettings().getConnection().setAutoCommit(false);
            LocalDateTime dateTime = WorkDay.getKrajaDanaZaDatum((Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDeliveryDate.getValue())), (int)1, (ScreensController)this.controller);
            this.otpremnica.setSysUserAddID(this.controller.getUser().getUserID());
            this.otpremnica.setSysUserEditID(this.controller.getUser().getUserID());
            this.otpremnica.setDeliveryDate(Settings.DatefromLocalDateTime((LocalDateTime)dateTime));
            try {
                this.otpremnica.setPerson(this.person);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.controller.alert("Obavestenje", "Morate odabrati dobavljaca", this.rootPane.getScene().getWindow());
            }
            this.otpremnica.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
            this.otpremnica.setNumber(Integer.parseInt(this.tfNumber.getText()));
            this.otpremnica.setDocumentStatusID(1);
            this.otpremnica.setNote(this.taNapomena.getText());
            this.otpremnica.setExternalNumber(this.tfNumber.getText());
            this.otpremnica.setDocumentTypeID(14);
            this.otpremnica.setPersonID(this.person.getPersonID());
            this.otpremnica.setPersonName(this.person.getName());
            this.otpremnica.setYear(dateTime.getYear());
            this.otpremnica.setDepartmentID(this.department.getDepartmentID());
            this.otpremnica.setDate(Settings.DatefromLocalDateTime((LocalDateTime)dateTime));
            if (this.otpremnica.getDocumentID() > 0L) {
                this.otpremnica.update(this.controller);
            } else {
                this.otpremnica.insert(this.controller);
            }
            for (i = 0; i < this.deletedItems.size(); ++i) {
                if (this.deletedItems.get(i).getDocumentDetailsID() > 0L) {
                    this.deletedItems.get(i).delete(this.controller.getSettings().getConnection());
                    continue;
                }
                this.deletedItems.remove(i);
            }
            for (i = 0; i < this.prijemniceDetailsList.size(); ++i) {
                PrijemnicaDetailes tableItem = (PrijemnicaDetailes)this.prijemniceDetailsList.get(i);
                if (tableItem.getDocumentDetailsID() > 0L) {
                    if (tableItem.getProduct() != null) {
                        tableItem.updateWithDiscount(this.controller);
                    }
                } else if (tableItem.getProduct() != null) {
                    tableItem.setDocumentID(this.otpremnica.getDocumentID());
                    Long id = tableItem.insertWithDiscount(this.controller);
                    tableItem.setDocumentDetailsID(id.longValue());
                }
                if (!Boolean.parseBoolean(this.controller.getSettings().getActualByName("fifo_nabavna_cena"))) continue;
                ProductDepartment productDepartment = ProductDepartment.getByProductAndDepartment((long)tableItem.getProduct().getProductID(), (int)this.department.getDepartmentID(), (ScreensController)this.controller);
                productDepartment.setAverageValue(Settings.test((Product)productDepartment.getProduct(), (Department)this.department, (LocalDate)LocalDate.now(), (ScreensController)this.controller));
                productDepartment.updateAverageValue(this.controller);
            }
            if (!this.prijemniceDetailsOtpisList.isEmpty()) {
                Otpis otpis = new Otpis();
                otpis.setDepartmentID(this.department.getDepartmentID());
                otpis.setNumber(Document.getNextNumber((int)7, (Department)this.department, (ScreensController)this.controller, (LocalDate)((LocalDate)this.dpDeliveryDate.getValue())));
                otpis.setComment("Otpis pri prijemu");
                Long id = otpis.insert(this.controller);
                for (OtpisDetailes otpisDetailes : this.prijemniceDetailsOtpisList) {
                    otpisDetailes.setDocumentID(id.longValue());
                    otpisDetailes.insert(this.controller);
                }
            }
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
            this.controller.getSettings().getConnection().commit();
        }
        catch (SQLException e) {
            try {
                this.controller.getSettings().getConnection().rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        finally {
            try {
                ChangeConnection.getConnectionUser((ScreensController)this.controller);
                this.controller.getSettings().getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void actionAdd(ActionEvent event) {
        System.out.println("from add");
    }

    public void actionAddPrijemnicaDetails(ActionEvent event) {
        PrijemnicaDetailes prijemnicaDetails = new PrijemnicaDetailes();
        prijemnicaDetails.setDocumentDetailsID(-1L);
        prijemnicaDetails.setProduct(this.pd.getProduct());
        prijemnicaDetails.setJedinicaMere(this.pd.getJedinicaMere());
        prijemnicaDetails.setProductID(this.pd.getProductID());
        prijemnicaDetails.setProductCode(this.pd.getProductCode());
        prijemnicaDetails.setProductName(this.pd.getProductName());
        if (this.pd.getProduct().getWriteOff() != 0.0) {
            prijemnicaDetails.setQuantity(this.pd.getQuantity() - this.pd.getQuantity() * this.pd.getProduct().getWriteOff() / 100.0);
        } else {
            prijemnicaDetails.setQuantity(this.pd.getQuantity());
        }
        if (prijemnicaDetails.getQuantity() == 0.0) {
            this.controller.alert("Obavestenje", "Uneta kolicina ne moze biti 0 ili manja od 0", this.rootPane.getScene().getWindow());
            this.tfQuantity.requestFocus();
            return;
        }
        prijemnicaDetails.setPrice(this.pd.getPrice() * 100.0 / (100.0 - this.pd.getDiscount()));
        prijemnicaDetails.setPriceWithDiscount(this.pd.getPrice());
        prijemnicaDetails.setSum(this.pd.getPrice() * this.pd.getQuantity());
        prijemnicaDetails.setSumWithDiscount(this.pd.getPurchasePrice() * this.pd.getQuantity());
        prijemnicaDetails.setDiscount(this.pd.getDiscount());
        prijemnicaDetails.setVat(this.pd.getVat());
        prijemnicaDetails.setSumWithVat(this.pd.getSumWithVat());
        prijemnicaDetails.setNewSellPrice(this.pd.getNewSellPrice());
        prijemnicaDetails.setSellPrice(this.pd.getSellPrice());
        prijemnicaDetails.setMargin(this.pd.getMargin());
        prijemnicaDetails.setPurchasePrice(this.pd.getPurchasePrice());
        prijemnicaDetails.setPurchasePriceWithoutRabat(this.pd.getPurchasePriceWithoutRabat());
        if (this.pd.getProduct().getWriteOff() != 0.0) {
            OtpisDetailes otpisDetailes = new OtpisDetailes();
            otpisDetailes.setProduct(this.pd.getProduct());
            otpisDetailes.setPurchasePriceWithVat(prijemnicaDetails.getPrice());
            otpisDetailes.setQuantity(this.pd.getQuantity() * this.pd.getProduct().getWriteOff() / 100.0);
            otpisDetailes.setCurrentPrice(prijemnicaDetails.getSellPrice());
            otpisDetailes.setPurchasePriceWithoutVat(prijemnicaDetails.getPriceWithoutVatAndDiscount());
            this.prijemniceDetailsOtpisList.add((java.lang.Object)otpisDetailes);
        }
        this.prijemniceDetailsList.add((java.lang.Object)prijemnicaDetails);
        this.tfFilter.setText("");
        this.loadDetails();
        this.tablePrijemniceDetails.scrollTo(this.tablePrijemniceDetails.getItems().size() - 1);
        this.calculateSum();
        this.cbProduct.getSelectionModel().clearSelection();
        this.tfQuantity.setText("");
        this.tfNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfUkupnaNabavnaCena.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfUkupnaNabavnaCenaSaPDVom.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfRabat.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfSellPrice.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.tfMargin.setText(Settings.getNumberFormat((int)4, (boolean)true).format(0L));
        this.cbProduct.requestFocus();
    }

    @FXML
    public void actionNewProduct(ActionEvent event) {
        if (this.department != null) {
            HashMap<String, ScreensController> hm2 = new HashMap<String, ScreensController>();
            hm2.put("controller", this.controller);
            int result = this.controller.showModalDialog("Dodavanje artikla", ScreensController.DIALOG_BACKOFFICE_ADD_PRODUCT, hm2, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                // empty if block
            }
        }
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.tablePrijemniceDetails.getSelectionModel().getSelectedItem() != null) {
            this.deletedItems.add((PrijemnicaDetailes)this.tablePrijemniceDetails.getSelectionModel().getSelectedItem());
            this.prijemniceDetailsList.remove(this.tablePrijemniceDetails.getSelectionModel().getSelectedItem());
            this.tablePrijemniceDetails.getItems().remove(this.tablePrijemniceDetails.getSelectionModel().getSelectedItem());
        }
        this.tfFilter.setText("");
        this.loadDetails();
        this.calculateSum();
    }

    @FXML
    public void toggleNapomena(ActionEvent event) {
        boolean bl = this.napomenaVidljiva = !this.napomenaVidljiva;
        if (this.napomenaVidljiva) {
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(1)).setMaxHeight(100.0);
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(2)).setMaxHeight(10.0);
            this.tablePrijemniceDetails.setPrefHeight(200.0);
            this.taNapomena.setVisible(true);
            this.labelNapomena.setVisible(true);
        } else {
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(1)).setMaxHeight(0.0);
            ((RowConstraints)this.gpNapomena.getRowConstraints().get(2)).setMaxHeight(0.0);
            this.tablePrijemniceDetails.setPrefHeight(300.0);
            this.taNapomena.setVisible(false);
            this.labelNapomena.setVisible(false);
        }
    }

    private void calculateSum() {
        double sumKolicina = 0.0;
        double sumUkupnaNabavnaCena = 0.0;
        double sumUkupnaNabavnaCenaSaRabatom = 0.0;
        double sumUkupnaCenaSaPDVom = 0.0;
        double sumProdajnaCena = 0.0;
        double sum = 0.0;
        if (this.prijemniceDetailsList != null) {
            for (PrijemnicaDetailes prijemnicaDetailes : this.prijemniceDetailsList) {
                sumKolicina += prijemnicaDetailes.getQuantity();
                sumUkupnaNabavnaCena += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getPurchasePrice();
                sumUkupnaNabavnaCenaSaRabatom += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getPurchasePrice();
                sumUkupnaCenaSaPDVom += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getPurchasePrice() * prijemnicaDetailes.getVat();
                sumProdajnaCena += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getNewSellPrice();
                sum += prijemnicaDetailes.getQuantity() * prijemnicaDetailes.getPurchasePriceWithoutRabat() * prijemnicaDetailes.getVat();
            }
        }
        try {
            this.otpremnica.setSum(sumProdajnaCena);
            this.otpremnica.setSumWithDiscount(sumProdajnaCena);
            this.otpremnica.setDiscount(Settings.round((double)(100.0 - this.otpremnica.getSumWithDiscount() * 100.0 / this.otpremnica.getSum()), (int)2));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.lblSumQuantity.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sumKolicina));
        this.lblSum.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sumUkupnaNabavnaCena));
        this.lblSumWithDiscount.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sumUkupnaNabavnaCenaSaRabatom));
        this.lblSumWithVat.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sumUkupnaCenaSaPDVom));
        this.lblSumSellPrice.setText(Settings.getNumberFormat((int)2, (boolean)true).format(sumProdajnaCena));
    }

    private void loadDetails() {
        System.out.println(this.prijemniceDetailsList.size());
        this.tablePrijemniceDetails.getItems().clear();
        for (int i = 0; i < this.prijemniceDetailsList.size(); ++i) {
            System.out.println((String)this.cbFilter.getSelectionModel().getSelectedItem());
            if (((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_ALL)) {
                if (!(((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getName().toLowerCase().contains(this.tfFilter.getText().toLowerCase()) || ((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getBarcodeLast() != null && ((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getBarcodeLast().contains(this.tfFilter.getText()) || ((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getCode() != null && ((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getCode().toLowerCase().contains(this.tfFilter.getText().toLowerCase())) && !this.tfFilter.getText().equals("")) continue;
                this.tablePrijemniceDetails.getItems().add(this.prijemniceDetailsList.get(i));
                continue;
            }
            if (((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_BARCODE)) {
                if ((((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getBarcodeLast() == null || !((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getBarcodeLast().equals(this.tfFilter.getText())) && !this.tfFilter.getText().equals("")) continue;
                this.tablePrijemniceDetails.getItems().add(this.prijemniceDetailsList.get(i));
                continue;
            }
            if (!((String)this.cbFilter.getSelectionModel().getSelectedItem()).equals(ScreensController.FILTER_CODE) || (((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getCode() == null || !((PrijemnicaDetailes)this.prijemniceDetailsList.get(i)).getProduct().getCode().toLowerCase().equals(this.tfFilter.getText().toLowerCase())) && !this.tfFilter.getText().equals("")) continue;
            this.tablePrijemniceDetails.getItems().add(this.prijemniceDetailsList.get(i));
        }
    }

    private void izracunajUkupno() {
        double margin = (this.pd.getNewSellPrice() - this.pd.getPrice()) / this.pd.getPrice() * 100.0;
        this.pd.setSum(this.pd.getPrice() * this.pd.getQuantity());
        this.pd.setSumWithDiscount(this.pd.getPurchasePrice() * this.pd.getQuantity());
        this.pd.setMargin(margin);
        this.izracunajMarzu();
        this.izracunajMarzu();
    }

    private void izracunajProdajnuCenu() {
        this.pd.setNewSellPrice(Settings.round((double)(this.pd.getPrice() / 100.0 * this.pd.getMargin() + this.pd.getPrice()), (int)2));
        this.tfSellPrice.setText("" + Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getNewSellPrice()));
    }

    private void izracunajMarzu() {
        this.pd.setMargin((this.pd.getNewSellPrice() - this.pd.getPrice()) / this.pd.getPrice() * 100.0);
        this.tfMargin.setText("" + Settings.getNumberFormat((int)4, (boolean)true).format(this.pd.getMargin()));
    }

    private void makeHeaderWrappable(TableColumn<?, ?> col) {
        Label label = new Label(col.getText());
        label.setWrapText(true);
        label.setAlignment(Pos.TOP_LEFT);
        label.setTextAlignment(TextAlignment.LEFT);
        StackPane stack = new StackPane();
        stack.getChildren().add((java.lang.Object)label);
        stack.prefWidthProperty().bind((ObservableValue)col.widthProperty().subtract(1));
        label.prefWidthProperty().bind((ObservableValue)stack.prefWidthProperty());
        col.setGraphic((Node)stack);
    }

    private void getOldValuesForFields(String purcahsePriceWithPdv, String purcahsePrice, String purcahseValueWithPdv, String purchaseValue) {
        this.oldValuePurchasePrice = purcahsePrice.replace(".", "").replace(",", ".");
        this.oldValuePurchaseValueWithPdv = purcahseValueWithPdv.replace(".", "").replace(",", ".");
    }
}

