/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.renameconnection.ChangeConnection;

public class DocumentLocker {
    ScreensController controller;
    Connection connection;

    public DocumentLocker(ScreensController controller) {
        this.controller = controller;
        this.connection = controller.getSettings().getConnection();
    }

    public void lockDocumntsForPeriod(LocalDate dateFrom, LocalDate dateTo) {
        Date from = Settings.sqlDateFromLocalDate((LocalDate)dateFrom);
        Date to = Settings.sqlDateFromLocalDate((LocalDate)dateTo);
        String query = "UPDATE document d SET d.documentLocked = 1 \r\nWHERE CAST(d.Date AS DATE) BETWEEN ? AND ? ";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(query);
            System.out.println("Od " + from);
            System.out.println("Do " + to);
            ps.setDate(1, from);
            ps.setDate(2, to);
            ps.executeUpdate();
            this.connection.commit();
            this.connection.setAutoCommit(true);
            this.createNivelationForLockedDocuments(dateFrom.plusDays(1L), dateTo);
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNivelationForLockedDocuments(LocalDate dateFrom, LocalDate dateTo) {
        try {
            ChangeConnection.getConnectionAdmin((ScreensController)this.controller);
            for (WorkDay wd : WorkDay.getWorkDayFroNivelation((LocalDate)dateFrom, (LocalDate)dateTo, (ScreensController)this.controller)) {
                wd.deleteNivelacijaForWD(this.controller);
            }
            for (WorkDay wd : WorkDay.getWorkDayFroNivelation((LocalDate)dateFrom, (LocalDate)dateTo, (ScreensController)this.controller)) {
                try {
                    wd.createNivelation(this.controller);
                    wd.createNivelationSellingChangePrice(this.controller);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ChangeConnection.getConnectionUser((ScreensController)this.controller);
        }
        catch (Exception exception) {
        }
        finally {
            ChangeConnection.getConnectionUser((ScreensController)this.controller);
        }
    }

    public LocalDate getLastLockedDocumentDate() {
        String query = "SELECT COALESCE(\r\n\r\n(SELECT CAST(d.Date AS DATE)  FROM document d \r\nWHERE d.documentLocked = 1 order BY d.Date DESC LIMIT 1),\r\n\r\n(SELECT DATE_SUB(wd.Date,INTERVAL 1 DAY)  FROM workday wd\r\norder BY wd.WorkDayID LIMIT 1)\r\n) as lastLockDate\r\n";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getDate("lastLockDate").toLocalDate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public LocalDate getLastLockedDocumentDateRecalculation() {
        String query = "select d.Date as lastLockDate from document d where d.documentLocked = 0 order by d.DocumentID asc limit 1";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getDate("lastLockDate").toLocalDate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private int numberOfUnlockDocumentsForPeriod(LocalDate dateFrom, LocalDate dateTo) {
        Date from = Settings.sqlDateFromLocalDate((LocalDate)dateFrom);
        Date to = Settings.sqlDateFromLocalDate((LocalDate)dateTo);
        String query = "SELECT COUNT(d.DocumentID) AS unlockDocumentsNum FROM document d\r\nWHERE d.documentLocked = 0 AND\r\nCAST(d.Date AS DATE) BETWEEN ? AND ?";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setDate(1, from);
            ps.setDate(2, to);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getInt("unlockDocumentsNum");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean unlockDocumentsExsistsForPeriod(LocalDate dateFrom, LocalDate dateTo) {
        return this.numberOfUnlockDocumentsForPeriod(dateFrom, dateTo) > 0;
    }
}

