/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.analise;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.ProductGroup;
import rs.petcom.master.gui.TreeProductGroupCell;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class AnalizaIStatistikaPoDanimaController
implements ControlledScreen {
    ScreensController controller;
    TreeItem<ProductGroup> treeRootGroups;
    TreeItem<AditionalFieldDetails> treeRootAF;
    ArrayList<CheckBoxTreeItem<AditionalFieldDetails>> aditionalFildList = new ArrayList();
    ArrayList<CheckBoxTreeItem<AditionalFieldDetails>> aditionalFildDetailsList = new ArrayList();
    StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String toString(LocalDate date) {
            if (date != null) {
                return this.dateFormatter.format(date);
            }
            return "";
        }

        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalDate.parse(string, this.dateFormatter);
            }
            return null;
        }
    };
    StringConverter<LocalTime> converterTime = new StringConverter<LocalTime>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("hh:MM:ss");

        public String toString(LocalTime time) {
            if (time != null) {
                return this.dateFormatter.format(time);
            }
            return "";
        }

        public LocalTime fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalTime.parse(string, this.dateFormatter);
            }
            return null;
        }
    };
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dateFrom;
    @FXML
    private DatePicker dateTo;
    @FXML
    private BorderPane reportPane;
    @FXML
    private ComboBox<PointOfSale> cbPos;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    private ComboBox<User> cbOperator;
    @FXML
    private TreeView<ProductGroup> treeGroup;
    @FXML
    private TreeView<AditionalFieldDetails> treeAditionalFieldDetails;
    @FXML
    private CheckBox cbIzborGrupa;
    @FXML
    private CheckBox cbIzborDodatnihPolja;
    @FXML
    private GridPane gridPane;
    @FXML
    private Button btnSalesProducts;
    @FXML
    private Button btnSalesAllOperatorsByDate;
    @FXML
    private Button btnSalesAllOperatorsByCode;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.treeGroup.setCellFactory(g -> new TreeProductGroupCell());
        this.treeGroup.setShowRoot(false);
    }

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                AnalizaIStatistikaPoDanimaController.this.ucitajPOS();
            }
        });
    }

    public void setParameter(java.lang.Object parameter) {
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getVrstaPrograma() == 0 && this.controller.getObject() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(true);
                break;
            }
        }
        if (this.controller.getUser().hasRole("manager")) {
            this.cbOperator.setDisable(false);
        } else {
            this.cbOperator.setDisable(true);
        }
        for (User u : this.cbOperator.getItems()) {
            if (u.getUserID() != this.controller.getUser().getUserID()) continue;
            this.cbOperator.getSelectionModel().select((java.lang.Object)u);
        }
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
        }
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((java.lang.Object)o);
        }
        if (this.cbObject.getItems().size() > 0) {
            this.cbObject.getSelectionModel().select(0);
        }
        this.dateFrom.setConverter(this.converter);
        this.dateTo.setConverter(this.converter);
        this.dateFrom.setConverter(this.converter);
        this.dateTo.setConverter(this.converter);
        final LocalDate firstWorkDay = Settings.fromDate((java.util.Date)WorkDay.getFistWarkDayEver((Connection)this.controller.getSettings().getConnection()).getDateFrom());
        final LocalDate lastWorkDay = Settings.fromDate((java.util.Date)WorkDay.getLastStartForDep((int)this.controller.getPointOfSale().getPointOfSaleID(), (Connection)this.controller.getSettings().getConnection()).getDateFrom());
        this.dateFrom.setDayCellFactory(d -> new DateCell(){

            public void updateItem(LocalDate item, boolean empty) {
                super.updateItem(item, empty);
                this.setDisable(item.isBefore(firstWorkDay) || item.isAfter(lastWorkDay));
            }
        });
        this.dateTo.setDayCellFactory(d -> new DateCell(){

            public void updateItem(LocalDate item, boolean empty) {
                super.updateItem(item, empty);
                this.setDisable(item.isBefore(firstWorkDay) || item.isAfter(lastWorkDay));
            }
        });
        this.dateFrom.setValue((java.lang.Object)firstWorkDay);
        this.dateTo.setValue((java.lang.Object)lastWorkDay);
        this.cbOperator.setItems(User.getUserList((Connection)this.controller.getSettings().getConnection()));
        if (this.cbOperator.getItems().size() > 0) {
            this.cbOperator.getSelectionModel().select(0);
        }
        this.treeRootGroups = new CheckBoxTreeItem();
        this.treeRootGroups.setValue((java.lang.Object)new ProductGroup(-1, "Grupe", 1));
        for (ProductGroup g : ProductGroup.getList((int)1, (Connection)this.controller.getSettings().getConnection())) {
            TreeItem groupItem = new TreeItem();
            groupItem.setValue((java.lang.Object)g);
            this.treeRootGroups.getChildren().add((java.lang.Object)groupItem);
            groupItem.setExpanded(true);
        }
        this.treeRootGroups.setExpanded(true);
        this.treeGroup.setRoot(this.treeRootGroups);
        this.treeAditionalFieldDetails.setCellFactory(a -> new CheckBoxTreeCell<AditionalFieldDetails>(){

            public void updateItem(AditionalFieldDetails item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item != null) {
                    this.setText(item.getName());
                }
            }
        });
        this.treeAditionalFieldDetails.setShowRoot(false);
        this.treeRootAF = new TreeItem();
        for (AditionalField af : AditionalField.getList((Connection)this.controller.getSettings().getConnection())) {
            CheckBoxTreeItem cbTreeItem = new CheckBoxTreeItem();
            cbTreeItem.setValue((java.lang.Object)new AditionalFieldDetails(af.getAditionalFieldID(), af.getName()));
            for (AditionalFieldDetails afd : AditionalFieldDetails.getListByAditionalFieldID((long)af.getAditionalFieldID(), (Connection)this.controller.getSettings().getConnection())) {
                CheckBoxTreeItem cbTreeSubItem = new CheckBoxTreeItem((java.lang.Object)afd);
                cbTreeSubItem.setSelected(true);
                cbTreeItem.getChildren().add((java.lang.Object)cbTreeSubItem);
                this.aditionalFildDetailsList.add((CheckBoxTreeItem<AditionalFieldDetails>)cbTreeSubItem);
            }
            cbTreeItem.setSelected(true);
            cbTreeItem.setExpanded(true);
            this.treeRootAF.getChildren().add((java.lang.Object)cbTreeItem);
            this.aditionalFildList.add((CheckBoxTreeItem<AditionalFieldDetails>)cbTreeItem);
        }
        this.treeRootAF.setExpanded(false);
        this.treeAditionalFieldDetails.setRoot(this.treeRootAF);
    }

    @FXML
    private void showSales(ActionEvent event) {
        String reportFileName = "";
        if ((Button)event.getSource() == this.btnSalesProducts) {
            reportFileName = "rs/petcom/backoffice/jasper/analiza/AnalizaIStatistikaArtiklaPoDanima.jasper";
        } else if ((Button)event.getSource() == this.btnSalesAllOperatorsByDate) {
            reportFileName = "rs/petcom/backoffice/jasper/analiza/AnalizaIStatistikaAllOperatorsPoDanima.jasper";
        } else if ((Button)event.getSource() == this.btnSalesAllOperatorsByCode) {
            reportFileName = "rs/petcom/backoffice/jasper/analiza/AnalizaIStatistikaPoDanimaBarCode.jasper";
        }
        String uslovi = this.converter.toString(this.dateFrom.getValue()) + " - " + this.converter.toString(this.dateTo.getValue()) + "\n";
        String grupe = "";
        String grupeNazivi = "";
        StringBuilder sbDodatnaPolja = new StringBuilder();
        if (this.cbIzborGrupa.isSelected()) {
            uslovi = "Sve grupe \n" + this.converter.toString(this.dateFrom.getValue()) + " - " + this.converter.toString(this.dateTo.getValue()) + "\n";
        } else {
            for (TreeItem g : this.treeRootGroups.getChildren()) {
                if (!((ProductGroup)g.getValue()).isSelected()) continue;
                if (!grupe.equals("")) {
                    grupe = grupe + ",";
                    grupeNazivi = grupeNazivi + ", ";
                }
                grupe = grupe + String.valueOf(((ProductGroup)g.getValue()).getProductGroupID());
                grupeNazivi = grupeNazivi + String.valueOf(((ProductGroup)g.getValue()).getName());
            }
            uslovi = grupeNazivi + "\n" + this.converter.toString(this.dateFrom.getValue()) + " - " + this.converter.toString(this.dateTo.getValue()) + "\n";
        }
        if (!this.cbIzborDodatnihPolja.isSelected()) {
            for (int i = 0; i < this.aditionalFildDetailsList.size(); ++i) {
                if (!this.aditionalFildDetailsList.get(i).isSelected()) continue;
                sbDodatnaPolja.append(i < this.aditionalFildDetailsList.size() - 1 ? ((AditionalFieldDetails)this.aditionalFildDetailsList.get(i).getValue()).getAditionalFieldDetailsID() + "," : Long.valueOf(((AditionalFieldDetails)this.aditionalFildDetailsList.get(i).getValue()).getAditionalFieldDetailsID()));
            }
        }
        final HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("datumOd", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateFrom.getValue())).getTime()));
        hm.put("datumDo", new Date(Settings.fromLocalDate((LocalDate)((LocalDate)this.dateTo.getValue())).getTime()));
        hm.put("pos", ((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID());
        hm.put("objekat", ((Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID());
        hm.put("uslovi", uslovi);
        hm.put("izborGrupa", !this.cbIzborGrupa.isSelected());
        hm.put("grupe", grupe);
        hm.put("izborDodatnihPolja", !this.cbIzborDodatnihPolja.isSelected());
        hm.put("dodatnaPolja", sbDodatnaPolja.toString());
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        final String reportFileName2 = reportFileName;
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                try {
                    JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName2));
                    JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)AnalizaIStatistikaPoDanimaController.this.controller.getSettings().getConnection());
                    JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                    final HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
                    hm2.put("report", printViewPane);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            taskUpdateStage.hide();
                            AnalizaIStatistikaPoDanimaController.this.controller.showModalDialog("Pregled prodaje", ScreensController.DIALOG_PRINT_PREVIEW, hm2, AnalizaIStatistikaPoDanimaController.this.rootPane.getScene().getWindow());
                        }
                    });
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        creatingReport.setOnSucceeded(eventValue -> taskUpdateStage.hide());
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja. ", this.rootPane.getScene().getWindow());
        });
        creatingReport.exceptionProperty().addListener((obsValue, oldValue, newValue) -> {
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        new Thread((Runnable)creatingReport).start();
    }

    @FXML
    private void izborGrupaAction() {
        this.treeGroup.setDisable(this.cbIzborGrupa.isSelected());
    }

    @FXML
    private void izborDodatnihAction() {
        this.treeAditionalFieldDetails.setDisable(this.cbIzborDodatnihPolja.isSelected());
    }

    private void ucitajPOS() {
        this.cbPos.getItems().clear();
        PointOfSale svaProdajnaMesta = new PointOfSale();
        svaProdajnaMesta.setPointOfSaleID(-1);
        svaProdajnaMesta.setName("Sva prodajna mesta");
        this.cbPos.getItems().add((java.lang.Object)svaProdajnaMesta);
        for (PointOfSale pos : PointOfSale.getPosList((Object)((Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbPos.getItems().add((java.lang.Object)pos);
        }
        this.cbPos.getSelectionModel().select((java.lang.Object)svaProdajnaMesta);
    }
}

