/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;

public class TimeChangeFpController
implements ControlledScreen {
    private ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Button btnSummer;
    @FXML
    private Button btnWinter;

    public void initialize() {
        this.btnSummer.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    TimeChangeFpController.this.writeTimeCorrection(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.btnWinter.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    TimeChangeFpController.this.writeTimeCorrection(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    public void writeTimeCorrection(boolean letnje) throws Exception {
        File billFold = new File("./racuni");
        if (!billFold.exists()) {
            billFold.mkdir();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        String filename = sdf.format(new Date());
        StringBuilder fiscalSb = new StringBuilder();
        fiscalSb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        fiscalSb.append("<KorekcijaSata>");
        fiscalSb.append("\t\t<LetnjeRacunanje>" + letnje + "</LetnjeRacunanje>");
        fiscalSb.append("</KorekcijaSata>");
        try {
            File f = new File(billFold + File.separator + filename + ".xml");
            FileWriter writer = new FileWriter(f.getAbsoluteFile());
            writer.write(fiscalSb.toString());
            writer.flush();
            writer.close();
            f.renameTo(new File(this.controller.getSettings().getFiscalFolder() + filename + ".xml"));
        }
        catch (Exception ee) {
            File f = new File(this.controller.getSettings().getFiscalFolder() + "\\Err\\" + filename + ".xml");
            FileWriter writer = new FileWriter(f.getAbsoluteFile());
            writer.write(fiscalSb.toString());
            writer.flush();
            writer.close();
        }
    }
}

