/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.sql.SQLException;
import java.util.HashMap;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.QuickGroup;

public class QuickGroupProductController
implements ControlledScreen {
    private ScreensController controller;
    private QuickGroup selectedQuickGroup = new QuickGroup();
    private Product selectedProduct;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<QuickGroup> tableGroup;
    @FXML
    private TableView<QuickGroup> tableProducts;
    @FXML
    private TableColumn<QuickGroup, String> columnName;
    @FXML
    private TableColumn<QuickGroup, String> columnProductName;
    @FXML
    private TableColumn<QuickGroup, Integer> columnProductsNumber;
    @FXML
    private TextField tfQuickGroupName;
    @FXML
    private TextField tfQuickGroupProductName;

    public void initialize() {
        this.tableGroup.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<QuickGroup>(){

            public void onChanged(ListChangeListener.Change<? extends QuickGroup> c) {
                if (QuickGroupProductController.this.tableGroup.getSelectionModel().getSelectedItem() != null) {
                    QuickGroupProductController.this.selectedQuickGroup = (QuickGroup)QuickGroupProductController.this.tableGroup.getSelectionModel().getSelectedItem();
                }
                if (QuickGroupProductController.this.selectedQuickGroup.getBrojArtikalaGrupe() > 0) {
                    QuickGroupProductController.this.fillProductTableGroup();
                } else {
                    QuickGroupProductController.this.tableProducts.getItems().clear();
                }
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.selectedQuickGroup.setBrojArtikalaGrupe(0);
    }

    public void setParameter(Object parameter) {
        this.fillTableGroup();
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void addQuckGroupAction() {
        if (!this.tfQuickGroupName.getText().trim().equals("")) {
            QuickGroup quickGroup = new QuickGroup();
            quickGroup.setName(this.tfQuickGroupName.getText().trim());
            quickGroup.insert(this.controller);
            this.tfQuickGroupName.setText("");
            this.fillTableGroup();
        } else {
            this.controller.alert("Obavestenje", "Ime grupe ne moze biti prazno", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void addQuckGroupProductAction() {
        if (this.tableGroup.getSelectionModel().getSelectedItem() != null) {
            QuickGroup quickGroup = new QuickGroup();
            quickGroup.setName(this.tfQuickGroupProductName.getText().toUpperCase().trim());
            quickGroup.setProductId(this.selectedProduct.getProductID());
            quickGroup.setParentId(((QuickGroup)this.tableGroup.getSelectionModel().getSelectedItem()).getQuickGroupId());
            try {
                quickGroup.insertProduct(this.controller);
            }
            catch (SQLException e) {
                this.controller.alert("Obavestenje", "Ovaj artikal vec postoji u ovoj grupi artikala", this.rootPane.getScene().getWindow());
            }
            this.tfQuickGroupProductName.setText("");
            this.fillProductTableGroup();
            this.fillTableGroup();
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati grupu kojoj zelite da dodate artikal", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void getProductAction() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        int mr = this.controller.showModalDialog("Izbor cenovnika", ScreensController.DIALOG_SELECT_PRODUCT, hm, this.rootPane.getScene().getWindow());
        if (mr == ScreensController.MODAL_RESULT_OK) {
            this.selectedProduct = (Product)hm.get("product");
            this.tfQuickGroupProductName.setText(this.selectedProduct.getShortName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FXML
    private void deleteQuckGroupAction() {
        if (this.tableGroup.getSelectionModel().getSelectedItem() == null) return;
        if (((QuickGroup)this.tableGroup.getSelectionModel().getSelectedItem()).getBrojArtikalaGrupe() > 0) {
            int result = this.controller.yesNoDialog("Obavestenje", "Ova grupa ima artikle, koji ce biti automatski obrisani. Da li ste sigurni da zelite da obrisete grupu?", this.rootPane.getScene().getWindow());
            if (result != 1) return;
            ((QuickGroup)this.tableGroup.getSelectionModel().getSelectedItem()).deleteProducts(this.controller);
            ((QuickGroup)this.tableGroup.getSelectionModel().getSelectedItem()).delete(this.controller);
        } else {
            ((QuickGroup)this.tableGroup.getSelectionModel().getSelectedItem()).delete(this.controller);
        }
        this.fillTableGroup();
    }

    @FXML
    private void deleteQuckGroupProductAction() {
    }

    private void fillTableGroup() {
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.columnProductsNumber.setCellValueFactory((Callback)new PropertyValueFactory("brojArtikalaGrupe"));
        this.tableGroup.setItems(QuickGroup.getTableList((ScreensController)this.controller));
    }

    private void fillProductTableGroup() {
        this.columnProductName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tableProducts.setItems(QuickGroup.getProductList((ScreensController)this.controller, (long)this.selectedQuickGroup.getQuickGroupId()));
    }
}

