/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.NetAmountType;
import rs.petcom.master.dal.NormativeItem;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.AditionalFieldDetailsProduct;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductCategory;
import rs.petcom.master.dal.product.ProductDepartment;
import rs.petcom.master.dal.product.ProductType;
import rs.petcom.master.gui.ProductDepartmentCheckBoxCell;
import rs.petcom.master.gui.ProductPointOfSaleCheckBoxCell;

public class ProductNewDialogController
implements DialogController {
    ScreensController controller;
    ProductType productType = new ProductType();
    ObservableList<NormativeItem> normativeList = FXCollections.observableArrayList();
    ObservableList<ProductType> productTypeList = FXCollections.observableArrayList();
    ObservableList<ProductCategory> productCategoryList = FXCollections.observableArrayList();
    ObservableList<Vat> productVatList = FXCollections.observableArrayList();
    ObservableList<Unit> productUnitList = FXCollections.observableArrayList();
    ComboBox<AditionalFieldDetails> combo;
    TreeItem<PointOfSale> treeRootPOS = new TreeItem();
    TreeItem<Department> treeRootDep = new TreeItem();
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    HashMap<String, java.lang.Object> parameter;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfShortName;
    @FXML
    private TextField tfCode;
    @FXML
    private TextField tfBarcode;
    @FXML
    private TextField tfPrice;
    @FXML
    private TextField tfNetAmount;
    @FXML
    private TextField tfWriteOff;
    @FXML
    private ComboBox<Vat> cbVat;
    @FXML
    private ComboBox<ProductCategory> cbCategory;
    @FXML
    private ComboBox<NetAmountType> cbNetAmountType;
    @FXML
    private ComboBox<ProductType> cbProductType;
    @FXML
    private ComboBox<Unit> cbUnit;
    @FXML
    private TableView<AditionalField> tableAditionalFields;
    @FXML
    private TableColumn<AditionalField, Long> tcAditionalFieldID;
    @FXML
    private TableColumn<AditionalField, String> tcNameAditionalField;
    @FXML
    private TableColumn<AditionalField, ComboBox<AditionalFieldDetails>> tcDetailsAditionalField;
    @FXML
    private TableView<NormativeItem> normativTable;
    @FXML
    private TableColumn<NormativeItem, String> ntColCode;
    @FXML
    private TableColumn<NormativeItem, String> ntColName;
    @FXML
    private TableColumn<NormativeItem, String> ntColShortName;
    @FXML
    private TableColumn<NormativeItem, Double> ntColNormative;
    @FXML
    private TableColumn<NormativeItem, Integer> ntColOrder;
    @FXML
    private TextField tfNormative;
    @FXML
    private TextField tfOrder;
    @FXML
    private Button btnCommit;
    @FXML
    private Button btnImport;
    @FXML
    private CheckBox cbIsWeight;
    @FXML
    private CheckBox cbDiscountAllowed;
    @FXML
    private CheckBox cbMeasurable;
    @FXML
    private TreeView<Department> treeDepartment;
    @FXML
    private TreeView<PointOfSale> treePointOfSale;

    public void initialize() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ProductNewDialogController.this.tfCode.requestFocus();
            }
        });
        this.tfName.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ProductNewDialogController.this.tfShortName.setText(newValue);
            }
        });
        this.treePointOfSale.setCellFactory((Callback)new Callback<TreeView<PointOfSale>, TreeCell<PointOfSale>>(){

            public TreeCell<PointOfSale> call(TreeView<PointOfSale> param) {
                return new ProductPointOfSaleCheckBoxCell(Boolean.valueOf(true));
            }
        });
        this.treePointOfSale.setShowRoot(false);
        this.treeDepartment.setCellFactory((Callback)new Callback<TreeView<Department>, TreeCell<Department>>(){

            public TreeCell<Department> call(TreeView<Department> param) {
                return new ProductDepartmentCheckBoxCell(Boolean.valueOf(true));
            }
        });
        this.tfBarcode.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.length() == 5) {
                    ProductNewDialogController.this.cbIsWeight.setDisable(false);
                    ProductNewDialogController.this.cbIsWeight.setSelected(true);
                } else {
                    ProductNewDialogController.this.cbIsWeight.setDisable(true);
                    ProductNewDialogController.this.cbIsWeight.setSelected(false);
                }
            }
        });
        this.treeDepartment.setShowRoot(false);
        this.normativTable.setItems(this.normativeList);
        this.normativTable.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<NormativeItem>(){

            public void onChanged(ListChangeListener.Change<? extends NormativeItem> c) {
                ProductNewDialogController.this.showNormative((NormativeItem)ProductNewDialogController.this.normativTable.getSelectionModel().getSelectedItem());
            }
        });
        this.ntColCode.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.ntColName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.ntColShortName.setCellValueFactory((Callback)new PropertyValueFactory("ShortName"));
        this.ntColNormative.setCellValueFactory((Callback)new PropertyValueFactory("Normative"));
        this.ntColOrder.setCellValueFactory((Callback)new PropertyValueFactory("Order"));
        this.tfNormative.setTextFormatter(new TextFormatter(Settings.getDoubleFilter()));
        this.tfOrder.setTextFormatter(new TextFormatter(Settings.getDoubleFilter()));
        this.cbUnit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ProductNewDialogController.this.cbMeasurable.setSelected(Unit.getUnitById((int)((Unit)ProductNewDialogController.this.cbUnit.getSelectionModel().getSelectedItem()).getUnitID(), (Connection)ProductNewDialogController.this.controller.getSettings().getConnection()).isMeasurable());
            }
        });
    }

    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        TreeItem objekatItem;
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.productTypeList = this.productType.getObeservableList(true, this.controller.getSettings().getConnection());
        this.cbProductType.setItems(ProductType.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbProductType.getSelectionModel().select(0);
        this.cbNetAmountType.setItems(NetAmountType.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbNetAmountType.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode().equals((java.lang.Object)KeyCode.TAB)) {
                this.btnCommit.requestFocus();
            }
        });
        this.tfWriteOff.setText("0");
        if (this.controller.getSettings().isPonudiSledeciKod()) {
            this.tfCode.setText(String.valueOf(Product.getLastCode((Connection)this.controller.getSettings().getConnection())));
        }
        if (this.controller.getSettings().isPonudiSledeciBarKod()) {
            this.tfBarcode.setText(String.valueOf(Product.getLastBarCode((Connection)this.controller.getSettings().getConnection())));
        }
        this.btnCommit.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((java.lang.Object)KeyCode.ENTER)) {
                    ProductNewDialogController.this.commit();
                }
            }
        });
        this.productVatList = Vat.getObeservableList((Connection)this.controller.getSettings().getConnection());
        this.cbVat.setItems(this.productVatList);
        this.productCategoryList = ProductCategory.getObeservableList((Connection)this.controller.getSettings().getConnection());
        this.cbCategory.setItems(this.productCategoryList);
        this.cbCategory.getSelectionModel().select(0);
        this.productUnitList = Unit.getList((Connection)this.controller.getSettings().getConnection());
        this.cbUnit.setItems(this.productUnitList);
        this.treeRootDep = new TreeItem();
        this.treeRootDep.setValue((java.lang.Object)new Department(-1, "Odeljenja"));
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            objekatItem = new TreeItem();
            objekatItem.setValue((java.lang.Object)new Department(o.getObjectID(), o.getName()));
            for (Department d : Department.getList((Object)o, (Connection)this.controller.getSettings().getConnection())) {
                TreeItem departmentItem = new TreeItem();
                departmentItem.setValue((java.lang.Object)d);
                objekatItem.getChildren().add((java.lang.Object)departmentItem);
                objekatItem.setExpanded(true);
            }
            this.treeRootDep.getChildren().add((java.lang.Object)objekatItem);
        }
        this.treeRootDep.setExpanded(true);
        this.treeDepartment.setRoot(this.treeRootDep);
        this.treeRootPOS = new TreeItem();
        this.treeRootPOS.setValue((java.lang.Object)new PointOfSale(-1, "Objekti"));
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            objekatItem = new TreeItem();
            objekatItem.setValue((java.lang.Object)new PointOfSale(o.getObjectID(), o.getName()));
            for (Department d : PointOfSale.getPosList((Object)o, (Connection)this.controller.getSettings().getConnection())) {
                TreeItem pointOfSaleItem = new TreeItem();
                pointOfSaleItem.setValue((java.lang.Object)d);
                objekatItem.getChildren().add((java.lang.Object)pointOfSaleItem);
                objekatItem.setExpanded(true);
            }
            this.treeRootPOS.getChildren().add((java.lang.Object)objekatItem);
        }
        this.treeRootPOS.setExpanded(true);
        this.treePointOfSale.setRoot(this.treeRootPOS);
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
        }
        this.loadAditionalFields();
    }

    public HashMap<String, java.lang.Object> getParameter() {
        return this.parameter;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    private void commit() {
        if (this.controller.getSettings().isSinhorinizacija()) {
            try {
                this.controller.getServerConnection().setAutoCommit(false);
                if (this.validacijaPolja()) {
                    int i;
                    boolean objectExist;
                    long productId = 0L;
                    ArrayList<Integer> izabraniObjekti = new ArrayList<Integer>();
                    ArrayList<java.lang.Object> izabranaOdeljenja = new ArrayList<java.lang.Object>();
                    ArrayList<java.lang.Object> izabraniPosovi = new ArrayList<java.lang.Object>();
                    for (TreeItem dep : this.treeRootDep.getChildren()) {
                        for (TreeItem dep1 : dep.getChildren()) {
                            if (!((Department)dep1.getValue()).isSelected()) continue;
                            izabranaOdeljenja.add(dep1.getValue());
                            objectExist = false;
                            for (i = 0; i < izabraniObjekti.size(); ++i) {
                                if (((Integer)izabraniObjekti.get(i)).intValue() != ((Department)dep1.getValue()).getObjectID()) continue;
                                objectExist = true;
                            }
                            if (objectExist) continue;
                            izabraniObjekti.add(((Department)dep1.getValue()).getObjectID());
                        }
                    }
                    for (TreeItem pos : this.treeRootPOS.getChildren()) {
                        for (TreeItem pos1 : pos.getChildren()) {
                            if (!((PointOfSale)pos1.getValue()).isSelected()) continue;
                            izabraniPosovi.add(pos1.getValue());
                            objectExist = false;
                            for (i = 0; i < izabraniObjekti.size(); ++i) {
                                if (((Integer)izabraniObjekti.get(i)).intValue() != ((PointOfSale)pos1.getValue()).getObjectID()) continue;
                                objectExist = true;
                            }
                            if (objectExist) continue;
                            izabraniObjekti.add(((PointOfSale)pos1.getValue()).getObjectID());
                        }
                    }
                    if (!izabraniPosovi.isEmpty()) {
                        Product p = new Product();
                        try {
                            p.setNetAmountTypeID(((NetAmountType)this.cbNetAmountType.getSelectionModel().getSelectedItem()).getNetAmountTypeID());
                        }
                        catch (NullPointerException pos) {
                            // empty catch block
                        }
                        try {
                            p.setProductTypeID(((ProductType)this.cbProductType.getSelectionModel().getSelectedItem()).getProductTypeID());
                        }
                        catch (NullPointerException pos) {
                            // empty catch block
                        }
                        p.setVatID(((Vat)this.cbVat.getSelectionModel().getSelectedItem()).getVatID());
                        p.setProductCategoryID(((ProductCategory)this.cbCategory.getSelectionModel().getSelectedItem()).getProductCategoryID());
                        p.setUnitID(((Unit)this.cbUnit.getSelectionModel().getSelectedItem()).getUnitID());
                        p.setActive(true);
                        p.setSysDTCreated(new Date());
                        p.setCode(this.tfCode.getText());
                        p.setName(this.tfName.getText());
                        if (this.tfShortName.getText().equals("")) {
                            this.controller.alert("Obavestenje", "Kratak naziv artikla je obavezno polje, ne moze biti prazno.", this.rootPane.getScene().getWindow());
                            return;
                        }
                        p.setShortName(this.tfShortName.getText());
                        p.setSysUserAddID(this.controller.getUser().getUserID());
                        try {
                            p.setNetAmount(Settings.getNumberFormat((int)2, (boolean)true).parse(this.tfNetAmount.getText()).doubleValue());
                        }
                        catch (ParseException e) {
                            p.setNetAmount(0.0);
                        }
                        p.setMeasurable(this.cbMeasurable.isSelected() ? this.cbMeasurable.isSelected() : Unit.getUnitById((int)p.getUnitID(), (Connection)this.controller.getSettings().getConnection()).isMeasurable());
                        p.setDiscountAllowed(this.cbDiscountAllowed.isSelected());
                        p.setWriteOff(Double.parseDouble(this.tfWriteOff.getText()));
                        if (this.tfBarcode.getText().equals("")) {
                            this.controller.alert("Obavestenje", "Polje za bar kod ne sme biti prazno, bar kod MORA  biti unet!", this.rootPane.getScene().getWindow());
                            return;
                        }
                        productId = p.insert(this.controller.getUser(), this.controller.getServerConnection());
                        Barcode b = new Barcode();
                        b.setProductID(productId);
                        b.setBarCode(this.tfBarcode.getText());
                        b.setIsWeight(Boolean.valueOf(this.cbIsWeight.isSelected()));
                        b.insertNewBarCode(this.controller.getServerConnection());
                        try {
                            for (Integer objekatID : izabraniObjekti) {
                                if (!(Double.parseDouble(this.tfPrice.getText()) > 0.0)) continue;
                                PriceListDetailes.insertProductPriceTrgovina((PriceList)PriceList.getRegular((LocalDateTime)LocalDateTime.now(), (int)objekatID, (Connection)this.controller.getServerConnection()), (long)productId, (double)Double.parseDouble(this.tfPrice.getText()), (Connection)this.controller.getServerConnection());
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.controller.alert("Obave\u0161tenje", "Nije upisana cena: " + numberFormatException.getMessage(), this.rootPane.getScene().getWindow());
                        }
                        p.setProductID(productId);
                        if (p != null) {
                            try {
                                for (AditionalField af : this.tableAditionalFields.getItems()) {
                                    AditionalFieldDetailsProduct afp = new AditionalFieldDetailsProduct();
                                    afp.setProductID(p.getProductID());
                                    afp.setAditionalFieldID(af.getAditionalFieldID());
                                    afp.setAditionalFieldDetailsID(af.getAditionalFieldDetails().getAditionalFieldDetailsID());
                                    afp.insert(this.controller.getServerConnection());
                                }
                            }
                            catch (NullPointerException nullPointerException) {}
                        }
                    } else {
                        this.controller.alert("Obavestenje", "Morate izabrati prodajno mesto", this.rootPane.getScene().getWindow());
                        return;
                    }
                    ArrayList<java.lang.Object> dodatiProductDepartment = new ArrayList<java.lang.Object>();
                    if (!izabranaOdeljenja.isEmpty()) {
                        for (Department department : izabranaOdeljenja) {
                            ProductDepartment pd = new ProductDepartment();
                            pd.setProductID(productId);
                            pd.setSort(0);
                            pd.setActive(true);
                            pd.setFavorite(false);
                            pd.setDepartmentID(department.getDepartmentID());
                            pd.insert(this.controller.getServerConnection());
                            dodatiProductDepartment.add(pd);
                        }
                    }
                    for (ProductDepartment productDepartment : dodatiProductDepartment) {
                        for (NormativeItem ni : this.normativTable.getItems()) {
                            ni.setArticleProductDepartmenID(productDepartment.getProductDepartmentID());
                            ni.getProduct().setProductDepartmentID(ProductDepartment.getFromDB((long)ni.getProduct().getProductID(), (long)productDepartment.getDepartmentID(), (ScreensController)this.controller).getProductDepartmentID());
                            ni.setNormative(ni.getNormative());
                            ni.setOrder(ni.getOrder());
                            ni.insert(this.controller.getServerConnection());
                        }
                    }
                } else {
                    this.controller.alert("Obavestenje", "Morate popuniti sva polja", this.rootPane.getScene().getWindow());
                    return;
                }
                this.controller.getServerConnection().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.controller.alert("Obavestenje", "Neuspesno ubacivanje proizvoda" + e.getMessage(), this.rootPane.getScene().getWindow());
                try {
                    this.controller.getServerConnection().rollback();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                return;
            }
            finally {
                try {
                    this.controller.getServerConnection().setAutoCommit(true);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.controller.getSettings().getConnection().setAutoCommit(false);
            if (this.validacijaPolja()) {
                int i;
                boolean objectExist;
                long productId = 0L;
                ArrayList<Integer> izabraniObjekti = new ArrayList<Integer>();
                ArrayList<java.lang.Object> izabranaOdeljenja = new ArrayList<java.lang.Object>();
                ArrayList<java.lang.Object> izabraniPosovi = new ArrayList<java.lang.Object>();
                for (TreeItem dep : this.treeRootDep.getChildren()) {
                    for (TreeItem dep1 : dep.getChildren()) {
                        if (!((Department)dep1.getValue()).isSelected()) continue;
                        izabranaOdeljenja.add(dep1.getValue());
                        objectExist = false;
                        for (i = 0; i < izabraniObjekti.size(); ++i) {
                            if (((Integer)izabraniObjekti.get(i)).intValue() != ((Department)dep1.getValue()).getObjectID()) continue;
                            objectExist = true;
                        }
                        if (objectExist) continue;
                        izabraniObjekti.add(((Department)dep1.getValue()).getObjectID());
                    }
                }
                for (TreeItem pos : this.treeRootPOS.getChildren()) {
                    for (TreeItem pos1 : pos.getChildren()) {
                        if (!((PointOfSale)pos1.getValue()).isSelected()) continue;
                        izabraniPosovi.add(pos1.getValue());
                        objectExist = false;
                        for (i = 0; i < izabraniObjekti.size(); ++i) {
                            if (((Integer)izabraniObjekti.get(i)).intValue() != ((PointOfSale)pos1.getValue()).getObjectID()) continue;
                            objectExist = true;
                        }
                        if (objectExist) continue;
                        izabraniObjekti.add(((PointOfSale)pos1.getValue()).getObjectID());
                    }
                }
                if (!izabraniPosovi.isEmpty()) {
                    Product p = new Product();
                    try {
                        p.setNetAmountTypeID(((NetAmountType)this.cbNetAmountType.getSelectionModel().getSelectedItem()).getNetAmountTypeID());
                    }
                    catch (NullPointerException pos) {
                        // empty catch block
                    }
                    try {
                        p.setProductTypeID(((ProductType)this.cbProductType.getSelectionModel().getSelectedItem()).getProductTypeID());
                    }
                    catch (NullPointerException pos) {
                        // empty catch block
                    }
                    p.setProductCategoryID(((ProductCategory)this.cbCategory.getSelectionModel().getSelectedItem()).getProductCategoryID());
                    p.setVatID(((Vat)this.cbVat.getSelectionModel().getSelectedItem()).getVatID());
                    p.setUnitID(((Unit)this.cbUnit.getSelectionModel().getSelectedItem()).getUnitID());
                    p.setActive(true);
                    p.setSysDTCreated(new Date());
                    p.setCode(this.tfCode.getText());
                    p.setName(this.tfName.getText());
                    if (this.tfShortName.getText().equals("")) {
                        this.controller.alert("Obavestenje", "Kratak naziv artikla je obavezno polje, ne moze biti prazno.", this.rootPane.getScene().getWindow());
                        return;
                    }
                    p.setShortName(this.tfShortName.getText());
                    p.setSysUserAddID(this.controller.getUser().getUserID());
                    try {
                        p.setNetAmount(Settings.getNumberFormat((int)2, (boolean)true).parse(this.tfNetAmount.getText()).doubleValue());
                    }
                    catch (ParseException e) {
                        p.setNetAmount(0.0);
                    }
                    p.setMeasurable(this.cbMeasurable.isSelected() ? this.cbMeasurable.isSelected() : Unit.getUnitById((int)p.getUnitID(), (Connection)this.controller.getSettings().getConnection()).isMeasurable());
                    p.setDiscountAllowed(this.cbDiscountAllowed.isSelected());
                    p.setWriteOff(Double.parseDouble(this.tfWriteOff.getText()));
                    if (this.tfBarcode.getText().equals("")) {
                        this.controller.alert("Obavestenje", "Polje za bar kod ne sme biti prazno, bar kod MORA  biti unet!", this.rootPane.getScene().getWindow());
                        return;
                    }
                    productId = p.insert(this.controller.getUser(), this.controller.getSettings().getConnection());
                    Barcode b = new Barcode();
                    b.setProductID(productId);
                    b.setBarCode(this.tfBarcode.getText());
                    b.setIsWeight(Boolean.valueOf(this.cbIsWeight.isSelected()));
                    b.insertNewBarCode(this.controller.getSettings().getConnection());
                    try {
                        for (Integer objekatID : izabraniObjekti) {
                            if (!(Double.parseDouble(this.tfPrice.getText()) > 0.0)) continue;
                            PriceListDetailes.insertProductPriceTrgovina((PriceList)PriceList.getRegular((LocalDateTime)LocalDateTime.now(), (int)objekatID, (Connection)this.controller.getSettings().getConnection()), (long)productId, (double)Double.parseDouble(this.tfPrice.getText()), (Connection)this.controller.getSettings().getConnection());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.controller.alert("Obave\u0161tenje", "Nije upisana cena: " + numberFormatException.getMessage(), this.rootPane.getScene().getWindow());
                    }
                    p.setProductID(productId);
                    if (p != null) {
                        try {
                            for (AditionalField af : this.tableAditionalFields.getItems()) {
                                AditionalFieldDetailsProduct afp = new AditionalFieldDetailsProduct();
                                afp.setProductID(p.getProductID());
                                afp.setAditionalFieldID(af.getAditionalFieldID());
                                afp.setAditionalFieldDetailsID(af.getAditionalFieldDetails().getAditionalFieldDetailsID());
                                afp.insert(this.controller.getSettings().getConnection());
                            }
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                } else {
                    this.controller.alert("Obavestenje", "Morate izabrati prodajno mesto", this.rootPane.getScene().getWindow());
                    return;
                }
                ArrayList dodatiProductDepartment = new ArrayList();
                if (!izabranaOdeljenja.isEmpty()) {
                    for (Department department : izabranaOdeljenja) {
                        ProductDepartment pd = new ProductDepartment();
                        pd.setProductID(productId);
                        pd.setSort(0);
                        pd.setActive(true);
                        pd.setFavorite(false);
                        pd.setDepartmentID(department.getDepartmentID());
                        pd.insert(this.controller.getSettings().getConnection());
                        dodatiProductDepartment.add(pd);
                    }
                }
                Iterator iterator = dodatiProductDepartment.iterator();
                while (iterator.hasNext()) {
                    ProductDepartment productDepartment = (ProductDepartment)iterator.next();
                    for (NormativeItem ni : this.normativTable.getItems()) {
                        ni.setArticleProductDepartmenID(productDepartment.getProductDepartmentID());
                        ni.getProduct().setProductDepartmentID(ProductDepartment.getFromDB((long)ni.getProduct().getProductID(), (long)productDepartment.getDepartmentID(), (ScreensController)this.controller).getProductDepartmentID());
                        ni.setNormative(ni.getNormative());
                        ni.setOrder(ni.getOrder());
                        ni.insert(this.controller.getSettings().getConnection());
                    }
                }
            } else {
                this.controller.alert("Obavestenje", "Morate popuniti sva polja", this.rootPane.getScene().getWindow());
                return;
            }
            this.controller.getSettings().getConnection().commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.controller.alert("Obavestenje", "Neuspesno ubacivanje proizvoda" + e.getMessage(), this.rootPane.getScene().getWindow());
            try {
                this.controller.getSettings().getConnection().rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            return;
        }
        finally {
            try {
                this.controller.getSettings().getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void normativePost() {
        try {
            NormativeItem ni = (NormativeItem)this.normativTable.getSelectionModel().getSelectedItem();
            ni.setNormative(new BigDecimal(this.tfNormative.getText().replaceAll(",", "")));
            ni.setOrder(Settings.getNumberFormat((int)0, (boolean)true).parse(this.tfOrder.getText()).intValue());
            this.normativeList.set(this.normativTable.getSelectionModel().getSelectedIndex(), (java.lang.Object)ni);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @FXML
    private void normativeNew() {
        HashMap<String, Connection> hm = new HashMap<String, Connection>();
        hm.put("connection", this.controller.getSettings().getConnection());
        hm.put("controller", (Connection)this.controller);
        int result = this.controller.showModalDialog("Izbor proizvoda", ScreensController.DIALOG_SELECT_PRODUCT, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            NormativeItem ni = new NormativeItem();
            ni.setProduct((Product)hm.get("product"));
            ni.setNormative(new BigDecimal(1.0));
            int maxOrder = 0;
            for (int i = 0; i < this.normativeList.size(); ++i) {
                if (maxOrder >= ((NormativeItem)this.normativeList.get(i)).getOrder()) continue;
                maxOrder = ((NormativeItem)this.normativeList.get(i)).getOrder();
            }
            ni.setOrder(maxOrder + 1);
            this.normativeList.add((java.lang.Object)ni);
            this.normativTable.getSelectionModel().select(this.normativeList.size() - 1);
            this.showNormative((NormativeItem)this.normativTable.getSelectionModel().getSelectedItem());
        }
    }

    @FXML
    private void normativeDelete() {
        this.normativeList.remove(this.normativTable.getSelectionModel().getSelectedItem());
    }

    private void showNormative(NormativeItem ni) {
        try {
            this.tfNormative.setText(Settings.getNumberFormat((int)4, (boolean)true).format(ni.getNormative()));
        }
        catch (NullPointerException e) {
            this.tfNormative.setText("");
        }
        try {
            this.tfOrder.setText(Settings.getNumberFormat((int)0, (boolean)true).format(ni.getOrder()));
        }
        catch (NullPointerException e) {
            this.tfOrder.setText("");
        }
    }

    @FXML
    public void importAction(ActionEvent e) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import artikala");
        fileChooser.getExtensionFilters().add((java.lang.Object)new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"}));
        File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            try {
                BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                hm2.put("controller", this.controller);
                hm2.put("bufferedReader", bf);
                this.controller.showModalDialog("Import artikala", ScreensController.DIALOG_BACKOFFICE_IMPORT_PRODUCT, hm2, this.rootPane.getScene().getWindow());
            }
            catch (FileNotFoundException | UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
        }
    }

    public boolean validacijaPolja() {
        return this.tfCode.getText() != null && !this.tfName.getText().equals("") && this.tfName.getText() != null && !this.tfShortName.getText().equals("") && this.tfShortName.getText() != null;
    }

    private void loadAditionalFields() {
        this.tableAditionalFields.getItems().clear();
        this.tcAditionalFieldID.setCellValueFactory((Callback)new PropertyValueFactory("AditionalFieldID"));
        this.tcNameAditionalField.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcDetailsAditionalField.setCellValueFactory(param -> {
            this.combo = new ComboBox();
            AditionalFieldDetails adi = new AditionalFieldDetails();
            adi.setAditionalFieldDetailsID(-1L);
            adi.setName("");
            this.combo.getItems().add((java.lang.Object)adi);
            this.combo.getItems().addAll((Collection)AditionalFieldDetails.getListByAditionalFieldID((long)((AditionalField)param.getValue()).getAditionalFieldID(), (Connection)this.controller.getSettings().getConnection()));
            this.combo.getStyleClass().clear();
            this.combo.setStyle("-fx-border-color: #7CB72A; -fx-border-width: 1px; -fx-border-style: solid;-fx-border-radius: 3px;-fx-text-fill: black;-fx-font-size: 14px;");
            this.combo.setPrefWidth(this.tcDetailsAditionalField.getPrefWidth() - 10.0);
            this.combo.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<AditionalFieldDetails>(){

                public void changed(ObservableValue<? extends AditionalFieldDetails> observable, AditionalFieldDetails oldValue, AditionalFieldDetails newValue) {
                    ((AditionalField)param.getValue()).setAditionalFieldDetails(newValue);
                }
            });
            return new SimpleObjectProperty(this.combo);
        });
        try {
            this.tableAditionalFields.setItems(AditionalField.getList((Connection)this.controller.getSettings().getConnection()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

