/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.OfferPrice;
import rs.petcom.master.dal.Settings;
import tornadofx.control.DateTimePicker;

public class OfferPriceNewController
implements DialogController {
    private ScreensController controller;
    private OfferPrice selectedOfferPrice;
    private int modalResult;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    private TextField tfName;
    @FXML
    private DateTimePicker dpFrom;
    @FXML
    private DateTimePicker dpTo;
    @FXML
    private CheckBox cbActive;
    @FXML
    private CheckBox cbFirstPrice;
    @FXML
    private CheckBox cbRoundActive;

    public void initialize() {
    }

    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedOfferPrice = (OfferPrice)parameter.get("selectedOfferPrice");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.cbObject.setItems(Object.getList((Connection)this.controller.getSettings().getConnection()));
        if (!this.cbObject.getItems().isEmpty()) {
            this.cbObject.getSelectionModel().select(0);
        }
        this.fillOfferPriceDate();
    }

    public HashMap<String, java.lang.Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    private void fillOfferPriceDate() {
        if (this.selectedOfferPrice != null) {
            this.tfName.setText(this.selectedOfferPrice.getName());
            this.dpFrom.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.selectedOfferPrice.getDateFrom()));
            this.dpTo.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.selectedOfferPrice.getDateTo()));
            this.cbActive.setSelected(this.selectedOfferPrice.isActive());
            this.cbFirstPrice.setSelected(this.selectedOfferPrice.isFirstPrice());
            this.cbRoundActive.setSelected(this.selectedOfferPrice.isRoundActive());
        } else {
            this.tfName.setText("");
            this.dpFrom.setDateTimeValue(LocalDateTime.now());
            this.dpTo.setDateTimeValue(LocalDateTime.now());
            this.cbActive.setSelected(false);
            this.cbFirstPrice.setSelected(false);
            this.cbRoundActive.setSelected(false);
        }
    }

    @FXML
    private void addAction() {
        if (this.selectedOfferPrice != null) {
            this.selectedOfferPrice.setObjectID(((Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID());
            this.selectedOfferPrice.setName(this.tfName.getText().trim());
            this.selectedOfferPrice.setDateFrom(Settings.DatefromLocalDateTime((LocalDateTime)this.dpFrom.getDateTimeValue()));
            this.selectedOfferPrice.setDateTo(Settings.DatefromLocalDateTime((LocalDateTime)this.dpTo.getDateTimeValue()));
            this.selectedOfferPrice.setActive(this.cbActive.isSelected());
            this.selectedOfferPrice.setFirstPrice(this.cbFirstPrice.isSelected());
            this.selectedOfferPrice.setRoundActive(this.cbRoundActive.isSelected());
            this.selectedOfferPrice.update(this.controller.getSettings().getConnection());
        } else {
            this.selectedOfferPrice = new OfferPrice();
            this.selectedOfferPrice.setObjectID(((Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID());
            this.selectedOfferPrice.setName(this.tfName.getText().trim());
            this.selectedOfferPrice.setDateFrom(Settings.DatefromLocalDateTime((LocalDateTime)this.dpFrom.getDateTimeValue()));
            this.selectedOfferPrice.setDateTo(Settings.DatefromLocalDateTime((LocalDateTime)this.dpTo.getDateTimeValue()));
            this.selectedOfferPrice.setActive(this.cbActive.isSelected());
            this.selectedOfferPrice.setFirstPrice(this.cbFirstPrice.isSelected());
            this.selectedOfferPrice.setRoundActive(this.cbRoundActive.isSelected());
            this.selectedOfferPrice.insert(this.controller.getSettings().getConnection());
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void cancelAction() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }
}

