/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.OfferPrice;
import rs.petcom.master.dal.Settings;

public class OfferPriceListsController
implements ControlledScreen {
    private ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<OfferPrice> table;
    @FXML
    private TableColumn<OfferPrice, String> tcTitle;
    @FXML
    private TableColumn<OfferPrice, Date> tcDateFrom;
    @FXML
    private TableColumn<OfferPrice, Date> tcDateTo;
    @FXML
    private TableColumn<OfferPrice, Boolean> tcActive;
    @FXML
    private Button btnShowDetails;
    @FXML
    ComboBox<Object> cbObjekat;

    public void initialize() {
        this.table.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<OfferPrice>(){

            public void onChanged(ListChangeListener.Change<? extends OfferPrice> c) {
                OfferPriceListsController.this.btnShowDetails.setDisable(!OfferPriceListsController.this.btnShowDetails.isDisable());
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.cbObjekat.setItems(Object.getList((Connection)this.controller.getSettings().getConnection()));
        if (!this.cbObjekat.getItems().isEmpty()) {
            this.cbObjekat.getSelectionModel().select(0);
        }
        this.loadTable();
    }

    public void setParameter(java.lang.Object parameter) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            this.btnShowDetails.setDisable(false);
        } else {
            this.btnShowDetails.setDisable(true);
        }
    }

    public java.lang.Object getParameter() {
        return null;
    }

    @FXML
    private void objectChange() {
        this.loadTable();
    }

    private void loadTable() {
        this.table.refresh();
        this.table.getItems().clear();
        this.tcTitle.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcDateFrom.setCellValueFactory((Callback)new PropertyValueFactory("DateFrom"));
        this.tcDateFrom.setCellFactory(column -> new TableCell<OfferPrice, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcDateTo.setCellValueFactory((Callback)new PropertyValueFactory("DateTo"));
        this.tcDateTo.setCellFactory(column -> new TableCell<OfferPrice, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcActive.setCellValueFactory((Callback)new PropertyValueFactory("Active"));
        this.tcActive.setCellFactory(column -> new TableCell<OfferPrice, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                } else {
                    this.setText("");
                }
            }
        });
        this.fillTableData();
    }

    @FXML
    private void showDetailes() {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            hm.put("offerPrice", this.table.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Cenovnik - Detalji", ScreensController.DIALOG_OFFER_PRICE_LISTS_DETAILES, hm, this.rootPane.getScene().getWindow());
        }
        this.fillTableData();
    }

    @FXML
    private void newAction() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        hm.put("selectedOfferPrice", null);
        this.controller.showModalDialog("Akcijski Cenovnik - Detalji", ScreensController.DIALOG_OFFER_PRICE_NEW, hm, this.rootPane.getScene().getWindow());
        this.fillTableData();
    }

    @FXML
    private void changeAction() {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            hm.put("selectedOfferPrice", this.table.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Akcijski Cenovnik - Detalji", ScreensController.DIALOG_OFFER_PRICE_NEW, hm, this.rootPane.getScene().getWindow());
        }
        this.fillTableData();
    }

    @FXML
    private void deleteAction() {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            try {
                ((OfferPrice)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.fillTableData();
    }

    private void fillTableData() {
        this.table.setItems(OfferPrice.getList((int)((Object)this.cbObjekat.getSelectionModel().getSelectedItem()).getObjectID(), (Connection)this.controller.getSettings().getConnection()));
    }
}

