/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JasperViewer;
import rs.petcom.backoffice.controller.reports.ReportMapModel;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.person.Person;

public class InactiveDocumentsController
implements ControlledScreen {
    ScreensController controller;
    @FXML
    private TableView<DocumentDetails> docDetailesTable;
    @FXML
    private TableColumn<DocumentDetails, String> tcDocDetProduct;
    @FXML
    private TableColumn<DocumentDetails, String> tcBarCode;
    @FXML
    private TableColumn<DocumentDetails, Double> tcDocDetValue;
    @FXML
    private TableColumn<DocumentDetails, Double> tcDocDetQuantity;
    @FXML
    private TableColumn<DocumentDetails, Double> tcDocDetPrice;
    @FXML
    private TableColumn<DocumentDetails, Double> tcDocDetDiscount;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<Document> tableDocument;
    @FXML
    private TableColumn<Document, Date> tcDocumentDate;
    @FXML
    private TableColumn<Document, Integer> tcDocumentNumber;
    @FXML
    private TableColumn<Document, Double> tcDocumentValue;
    @FXML
    private TableColumn<Document, String> tcDocumentPaymentMethod;
    @FXML
    private TableColumn<Document, String> tcDocumentPerson;
    @FXML
    private TableColumn<Document, String> tcDocumentBI;
    @FXML
    private Label title;
    @FXML
    private Label lDocCount;
    @FXML
    private Label lDocValue;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private GridPane gridPane;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
    }

    public void setParameter(Object parameter) {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.dpDateFrom.setValue((Object)Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDateFrom()));
        this.dpDateTo.setValue((Object)Settings.fromDate((Date)new Date()));
        this.dpDateFrom.valueProperty().addListener((ov, oldValue, newValue) -> this.populateDocumentTable());
        this.dpDateTo.valueProperty().addListener((ov, oldValue, newValue) -> this.populateDocumentTable());
        this.tableDocument.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Document>(){

            public void onChanged(ListChangeListener.Change<? extends Document> c) {
                InactiveDocumentsController.this.loadDocDetTable();
            }
        });
        this.tcDocumentNumber.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDocumentDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDocumentDate.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcDocumentPerson.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Document, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Document, String> param) {
                try {
                    Person person = Person.getById((long)((Document)param.getValue()).getPersonID(), (ScreensController)InactiveDocumentsController.this.controller);
                    if (2 == person.getPersonTypeID()) {
                        return new JavaBeanStringPropertyBuilder().bean((Object)person).name("Name").build();
                    }
                    if (1 == person.getPersonTypeID()) {
                        return new JavaBeanStringPropertyBuilder().bean((Object)person).name("names1").build();
                    }
                    return null;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcDocumentBI.setCellValueFactory((Callback)new PropertyValueFactory("FullNumber"));
        this.tcDocumentPaymentMethod.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Document, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Document, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)PaymentMethod.getByID((int)((Document)param.getValue()).getPaymentMethodID(), (Connection)InactiveDocumentsController.this.controller.getSettings().getConnection())).name("Name").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcDocumentValue.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.tcDocumentValue.setCellFactory(column -> new TableCell<Document, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                }
            }
        });
        this.tcBarCode.setCellValueFactory((Callback)new PropertyValueFactory("Barcode"));
        this.tcDocDetProduct.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcDocDetQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcDocDetQuantity.setCellFactory(column -> new TableCell<DocumentDetails, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)4, (boolean)true).format(item));
                }
            }
        });
        this.tcDocDetPrice.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.tcDocDetPrice.setCellFactory(column -> new TableCell<DocumentDetails, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                }
            }
        });
        this.tcDocDetDiscount.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.tcDocDetDiscount.setCellFactory(column -> new TableCell<DocumentDetails, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                }
            }
        });
        this.tcDocDetValue.setCellValueFactory((Callback)new PropertyValueFactory("Value"));
        this.tcDocDetValue.setCellFactory(column -> new TableCell<DocumentDetails, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                }
            }
        });
        this.populateDocumentTable();
    }

    public Object getParameter() {
        return null;
    }

    public void populateDocumentTable() {
        double documentsValue = 0.0;
        int numberOfDocuments = 0;
        Date from = Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateFrom.getValue()));
        Date to = Settings.fromLocalDate((LocalDate)((LocalDate)this.dpDateTo.getValue()));
        ObservableList canceleddDocuments = Document.getCanceledDocuments((ScreensController)this.controller, (Date)from, (Date)to);
        this.tableDocument.getItems().clear();
        this.tableDocument.setItems(canceleddDocuments);
        for (Document document : canceleddDocuments) {
            documentsValue += document.getSumWithDiscount();
        }
        numberOfDocuments = canceleddDocuments.size();
        this.lDocCount.setText(String.valueOf(numberOfDocuments));
        this.lDocValue.setText(String.valueOf(documentsValue));
    }

    private void loadDocDetTable() {
        ObservableList detailesList;
        try {
            detailesList = DocumentDetails.getObeservableList((long)((Document)this.tableDocument.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        }
        catch (NullPointerException e) {
            detailesList = FXCollections.observableArrayList();
        }
        this.docDetailesTable.setItems(detailesList);
    }

    @FXML
    void returnCanceld(ActionEvent event) {
        Document document = (Document)this.tableDocument.getSelectionModel().getSelectedItem();
        if (document != null) {
            HashMap<String, String> paramererMap = new HashMap<String, String>();
            paramererMap.put("title", "Poni\u0161tenje storna");
            paramererMap.put("text", "Da li ste sigurni da \u017eelite da poni\u0161tite storo izabranog ra\u010duna");
            int resultYesNo = this.controller.showModalDialog("", ScreensController.DIALOG_YES_NO, paramererMap, this.rootPane.getScene().getWindow());
            if (resultYesNo == ScreensController.MODAL_RESULT_YES) {
                document.cancelDocument(this.controller, document.getDocumentID());
                this.populateDocumentTable();
            }
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati dokument iz tabele kako bi poni\u0161tili storno", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    void printCanceled(ActionEvent event) {
        String source = "rs/petcom/backoffice/jasper/canceledDocuments.jasper";
        ObservableList list = this.docDetailesTable.getItems();
        Document document = (Document)this.tableDocument.getSelectionModel().getSelectedItem();
        if (document != null) {
            File file = new File(source);
            JRBeanCollectionDataSource datasource = new JRBeanCollectionDataSource((Collection)list);
            Map<String, Object> parametersMap = ReportMapModel.getReportMap(this.controller);
            parametersMap.put("datasource", datasource);
            parametersMap.put("document", document);
            try {
                JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)source));
                JasperPrint jp = JasperFillManager.fillReport((JasperReport)report, parametersMap, (JRDataSource)datasource);
                JasperViewer.viewReport((JasperPrint)jp, (boolean)false);
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati dokument iz tabele kako bi se \u0161tampa pokrenula", this.rootPane.getScene().getWindow());
        }
    }
}

