/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;

public class FixedDateController
implements DialogController {
    ScreensController controller;
    HashMap<String, Object> params;
    int modalResult;
    String message;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnConfirm;
    @FXML
    private Label labText;
    @FXML
    private DatePicker dpDocumentDate;

    @FXML
    void cancel() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        this.exitScreen();
    }

    @FXML
    void confirm() {
        LocalDate documentDate = (LocalDate)this.dpDocumentDate.getValue();
        this.params.put("documentDate", documentDate);
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        this.exitScreen();
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.params = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.modalResult = 0;
        this.message = (String)parameter.get("message");
        this.dpDocumentDate.setValue((Object)this.lastOpenedDate());
        this.labText.setText(this.message);
        this.addStyleToRootPane();
    }

    public HashMap<String, Object> getParameter() {
        return this.params;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    private void addStyleToRootPane() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    private LocalDate lastOpenedDate() {
        return Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDate());
    }

    private void exitScreen() {
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }
}

