/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import tornadofx.control.DateTimePicker;

public class DateTimePickerDialogController
implements DialogController {
    @FXML
    private BorderPane rootPane;
    @FXML
    private Button dialogNo;
    @FXML
    private Button dialogYes;
    @FXML
    private Label dialogTitle;
    @FXML
    private DateTimePicker dpFrom;
    EventHandler<KeyEvent> handler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            switch (event.getCode()) {
                case RIGHT: {
                    event.consume();
                    DateTimePickerDialogController.this.dialogYes.requestFocus();
                    break;
                }
                case LEFT: {
                    event.consume();
                    DateTimePickerDialogController.this.dialogNo.requestFocus();
                    break;
                }
                case ENTER: {
                    event.consume();
                    DateTimePickerDialogController.this.confirm();
                    break;
                }
            }
        }
    };
    HashMap<String, Object> parameter;
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;

    @FXML
    public void closeAction(ActionEvent event) {
        this.modalResult = event.getSource() == this.dialogNo ? ScreensController.MODAL_RESULT_NO : ScreensController.MODAL_RESULT_YES;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    public void confirm() {
        if (this.dialogNo.isFocused()) {
            this.modalResult = ScreensController.MODAL_RESULT_NO;
        } else {
            this.modalResult = ScreensController.MODAL_RESULT_YES;
            this.parameter.put("datumVazenja", this.dpFrom.getDateTimeValue());
        }
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.rootPane.setOnKeyPressed(this.handler);
        this.dialogTitle.setText(parameter.get("title").toString());
    }

    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

