/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.Settings;

public class BuyerOfferPriceListsController
implements ControlledScreen {
    private ScreensController controller;
    private BuyerOfferPrice selectedBOP;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<BuyerOfferPrice> table;
    @FXML
    private TableColumn<BuyerOfferPrice, String> tcTitle;
    @FXML
    private TableColumn<BuyerOfferPrice, Date> tcDateFrom;
    @FXML
    private TableColumn<BuyerOfferPrice, Date> tcDateTo;
    @FXML
    private TableColumn<BuyerOfferPrice, Boolean> tcActive;
    @FXML
    private Button btnNew;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnUpdate;
    @FXML
    private Button btnDetails;
    @FXML
    private TextField tfTitle;
    @FXML
    private CheckBox cbActive;
    @FXML
    ComboBox<rs.petcom.master.dal.Object> cbObjekat;

    public void initialize() {
        this.table.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<BuyerOfferPrice>(){

            public void onChanged(ListChangeListener.Change<? extends BuyerOfferPrice> c) {
                BuyerOfferPriceListsController.this.selectedBOP = (BuyerOfferPrice)BuyerOfferPriceListsController.this.table.getSelectionModel().getSelectedItem();
                BuyerOfferPriceListsController.this.disabelEnableBtn();
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
        }
        this.tcTitle.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcDateFrom.setCellValueFactory((Callback)new PropertyValueFactory("DateFrom"));
        this.tcDateFrom.setCellFactory(column -> new TableCell<BuyerOfferPrice, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcDateTo.setCellValueFactory((Callback)new PropertyValueFactory("DateTo"));
        this.tcDateTo.setCellFactory(column -> new TableCell<BuyerOfferPrice, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcActive.setCellValueFactory((Callback)new PropertyValueFactory("Active"));
        this.tcActive.setCellFactory(column -> new TableCell<BuyerOfferPrice, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                }
            }
        });
        rs.petcom.master.dal.Object sviObjekti = new rs.petcom.master.dal.Object();
        sviObjekti.setObjectID(-1);
        sviObjekti.setName("Svi objekti");
        this.cbObjekat.getItems().add((Object)sviObjekti);
        for (rs.petcom.master.dal.Object o : rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObjekat.getItems().add((Object)o);
            this.cbObjekat.getSelectionModel().select(1);
        }
        this.loadTable();
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void objectChange() {
        this.loadTable();
    }

    private void loadTable() {
        this.table.refresh();
        this.table.getItems().clear();
        this.table.setItems(BuyerOfferPrice.getList((int)((rs.petcom.master.dal.Object)this.cbObjekat.getSelectionModel().getSelectedItem()).getObjectID(), (Connection)this.controller.getSettings().getConnection()));
    }

    @FXML
    private void showDetailes() {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("buyerOfferPrice", this.table.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Cenovnik - Detalji", ScreensController.DIALOG_BUYER_OFFER_PRICE_LISTS_DETAILES, hm, this.rootPane.getScene().getWindow());
        }
        this.disabelEnableBtn();
    }

    @FXML
    private void updatePricelist() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("selectedBOP", this.selectedBOP);
        this.controller.showModalDialog("", ScreensController.DIALOG_BACKOFFICE_BUYER_OFFER_PRICE_LIST, hm, this.rootPane.getScene().getWindow());
        this.loadTable();
        this.disabelEnableBtn();
    }

    @FXML
    private void newPricelist() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        hm.put("selectedBOP", null);
        this.controller.showModalDialog("", ScreensController.DIALOG_BACKOFFICE_BUYER_OFFER_PRICE_LIST, hm, this.rootPane.getScene().getWindow());
        this.loadTable();
        this.disabelEnableBtn();
    }

    @FXML
    private void deletePricelist() {
        if (this.selectedBOP != null) {
            this.selectedBOP.delete(this.controller.getSettings().getConnection());
        } else {
            this.controller.alert("Pitanje", "Da li ste sigurni da zelite da obrisete cenivnik?", this.rootPane.getScene().getWindow());
        }
        this.loadTable();
        this.disabelEnableBtn();
    }

    private void disabelEnableBtn() {
        if (this.selectedBOP != null) {
            this.btnNew.setDisable(true);
            this.btnDelete.setDisable(false);
            this.btnDetails.setDisable(false);
            this.btnUpdate.setDisable(false);
        } else {
            this.btnNew.setDisable(false);
            this.btnDelete.setDisable(true);
            this.btnDetails.setDisable(true);
            this.btnUpdate.setDisable(true);
        }
    }
}

