/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.Settings;
import tornadofx.control.DateTimePicker;

public class BuyerOfferPriceListDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private BuyerOfferPrice selectedBOP;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfName;
    @FXML
    private DateTimePicker dpFrom;
    @FXML
    private DateTimePicker dpTo;
    @FXML
    private CheckBox cbActive;
    @FXML
    private Label lblObject;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.selectedBOP = (BuyerOfferPrice)parameter.get("selectedBOP");
        this.lblObject.setText(this.controller.getObject().getName());
        this.fillData();
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void commit(ActionEvent event) {
        if (this.selectedBOP != null) {
            this.selectedBOP.setName(this.tfName.getText().trim());
            this.selectedBOP.setDateFrom(Settings.DatefromLocalDateTime((LocalDateTime)this.dpFrom.getDateTimeValue()));
            this.selectedBOP.setDateTo(Settings.DatefromLocalDateTime((LocalDateTime)this.dpTo.getDateTimeValue()));
            this.selectedBOP.setActive(this.cbActive.isSelected());
            this.selectedBOP.update(this.controller.getSettings().getConnection());
        } else {
            this.selectedBOP = new BuyerOfferPrice();
            this.selectedBOP.setObjectID(this.controller.getObject().getObjectID());
            this.selectedBOP.setName(this.tfName.getText().trim());
            this.selectedBOP.setDateFrom(Settings.DatefromLocalDateTime((LocalDateTime)this.dpFrom.getDateTimeValue()));
            this.selectedBOP.setDateTo(Settings.DatefromLocalDateTime((LocalDateTime)this.dpTo.getDateTimeValue()));
            this.selectedBOP.setActive(this.cbActive.isSelected());
            this.selectedBOP.insert(this.controller.getSettings().getConnection());
        }
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    private void fillData() {
        if (this.selectedBOP != null) {
            this.tfName.setText(this.selectedBOP.getName());
            this.dpFrom.setValue((Object)Settings.fromDate((Date)this.selectedBOP.getDateFrom()));
            this.dpTo.setValue((Object)Settings.fromDate((Date)this.selectedBOP.getDateTo()));
            this.cbActive.setSelected(this.selectedBOP.isActive());
        } else {
            this.tfName.setText("");
            this.dpFrom.setValue((Object)LocalDate.now());
            this.dpTo.setValue((Object)LocalDate.now());
            this.cbActive.setSelected(false);
        }
    }
}

