/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProductsBuyers;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.BuyerOfferPriceDetailes;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class BuyerOfferPriceListDetailesController
implements DialogController {
    ScreensController controller;
    BuyerOfferPrice buyerofferPrice;
    int modalResult;
    ObservableList<BuyerOfferPriceDetailes> data;
    ArrayList<BuyerOfferPriceDetailes> deletedItems = new ArrayList();
    ObservableList<BuyerOfferPriceDetailes> insertItems = FXCollections.observableArrayList();
    AutoCompleteCBWithoutProductsBuyers<Product> cbProductAutoComplete;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<BuyerOfferPriceDetailes> table;
    @FXML
    private TableColumn<BuyerOfferPriceDetailes, String> tcCode;
    @FXML
    private TableColumn<BuyerOfferPriceDetailes, String> tcName;
    @FXML
    private TableColumn<BuyerOfferPriceDetailes, String> tcBarCode;
    @FXML
    private TableColumn<Object, Double> tcPrice;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfPrice;
    @FXML
    private TextField tfPriceWithoutVat;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private ComboBox<String> cbFilterType;
    @FXML
    private DateTimePicker dpDate;

    public void initialize() {
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(2, true);
        EventHandler<KeyEvent> eventHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                switch (event.getCode()) {
                    case DELETE: {
                        break;
                    }
                    case INSERT: {
                        break;
                    }
                }
            }
        };
        this.tfPriceWithoutVat.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("|[-\\+]?|[-\\+]?\\d+\\.?|[-\\+]?\\d+\\.?\\d+")) {
                    BuyerOfferPriceListDetailesController.this.tfPriceWithoutVat.setText(oldValue);
                } else if (BuyerOfferPriceListDetailesController.this.cbProduct.getSelectionModel().getSelectedItem() != null) {
                    Vat vat = Vat.getById((int)((Product)BuyerOfferPriceListDetailesController.this.cbProduct.getSelectionModel().getSelectedItem()).getVatID(), (Connection)BuyerOfferPriceListDetailesController.this.controller.getSettings().getConnection());
                    BuyerOfferPriceListDetailesController.this.tfPrice.setText(String.valueOf(Double.parseDouble(BuyerOfferPriceListDetailesController.this.tfPriceWithoutVat.getText()) * vat.getValue()));
                }
            }
        });
        this.dpDate.setDateTimeValue(LocalDateTime.now());
        this.rootPane.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)eventHandler);
        this.tcCode.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<BuyerOfferPriceDetailes, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<BuyerOfferPriceDetailes, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)((BuyerOfferPriceDetailes)param.getValue()).getProduct()).name("Code").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcName.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<BuyerOfferPriceDetailes, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<BuyerOfferPriceDetailes, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)((BuyerOfferPriceDetailes)param.getValue()).getProduct()).name("ShortName").build();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        this.tcBarCode.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<BuyerOfferPriceDetailes, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<BuyerOfferPriceDetailes, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Barcode.getBarCodeObject((long)((BuyerOfferPriceDetailes)param.getValue()).getProductID(), (Connection)BuyerOfferPriceListDetailesController.this.controller.getSettings().getConnection())).name("BarCode").build();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        this.tcPrice.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.tcPrice.setCellFactory((Callback)cellFactory);
        this.tcPrice.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                ((BuyerOfferPriceDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPrice(((Double)t.getNewValue()).doubleValue());
            }
        });
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.buyerofferPrice = (BuyerOfferPrice)parameter.get("buyerOfferPrice");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
        }
        this.tfPrice.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    event.consume();
                    BuyerOfferPriceListDetailesController.this.actionAddPrice(new ActionEvent());
                    BuyerOfferPriceListDetailesController.this.cbProduct.requestFocus();
                }
            }
        });
        this.insertItems = BuyerOfferPriceDetailes.getListByOfferPriceID((long)this.buyerofferPrice.getBuyerOfferPriceID(), (Connection)this.controller.getSettings().getConnection());
        this.table.setItems(this.insertItems);
        this.cbFilterType.getItems().addAll((Object[])new String[]{ScreensController.FILTER_ALL, ScreensController.FILTER_CODE, ScreensController.FILTER_BARCODE});
        this.cbFilterType.getSelectionModel().selectFirst();
        this.cbFilterType.setOnAction(actionEvent -> this.cbProductAutoComplete.setFilterType((String)this.cbFilterType.getSelectionModel().getSelectedItem()));
        this.cbProductAutoComplete = new AutoCompleteCBWithoutProductsBuyers(this.cbProduct, this.controller, -1, ScreensController.FILTER_ALL, this.tfPrice, this.data);
        this.cbProductAutoComplete.setLoadAllProduct(true);
        this.deletedItems.clear();
        this.table.setFocusTraversable(false);
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void productAdd() {
        Product selectedProduct = (Product)this.cbProduct.getSelectionModel().getSelectedItem();
        if (selectedProduct != null) {
            try {
                int existIndex = this.checkIfProductExist(selectedProduct.getProductID());
                if (existIndex >= 0) {
                    ((BuyerOfferPriceDetailes)this.table.getItems().get(existIndex)).setPrice(Double.parseDouble(this.tfPrice.getText()));
                    this.table.getSelectionModel().select(existIndex);
                    this.table.scrollTo(existIndex);
                    this.table.refresh();
                } else {
                    BuyerOfferPriceDetailes opd = new BuyerOfferPriceDetailes();
                    opd.setBuyerOfferPriceDetailsID(new Long(-1L).longValue());
                    opd.setProduct(selectedProduct);
                    opd.setProductID(selectedProduct.getProductID());
                    opd.setPrice(Double.parseDouble(this.tfPrice.getText()));
                    opd.setBuyerOfferPriceID(this.buyerofferPrice.getBuyerOfferPriceID().longValue());
                    this.insertItems.add((Object)opd);
                    this.table.setItems(this.insertItems);
                    this.table.getSelectionModel().select((Object)opd);
                    this.table.scrollTo((Object)opd);
                    this.table.requestFocus();
                }
                this.clearFields();
            }
            catch (NumberFormatException e) {
                this.controller.alert("Upozorenje", "Nepravilan format cene: ", this.rootPane.getScene().getWindow());
            }
        } else {
            this.controller.alert("Upozorenje", "Morate odabrati artikal ", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionAddPrice(ActionEvent event) {
        Product selectedProduct = (Product)this.cbProduct.getSelectionModel().getSelectedItem();
        if (selectedProduct != null) {
            try {
                int existIndex = this.checkIfProductExist(selectedProduct.getProductID());
                if (existIndex >= 0) {
                    ((BuyerOfferPriceDetailes)this.table.getItems().get(existIndex)).setPrice(Double.parseDouble(this.tfPrice.getText()));
                    this.table.getSelectionModel().select(existIndex);
                    this.table.scrollTo(existIndex);
                    this.table.refresh();
                } else {
                    BuyerOfferPriceDetailes opd = new BuyerOfferPriceDetailes();
                    opd.setBuyerOfferPriceDetailsID(new Long(-1L).longValue());
                    opd.setProduct(selectedProduct);
                    opd.setProductID(selectedProduct.getProductID());
                    opd.setPrice(Double.parseDouble(this.tfPrice.getText()));
                    opd.setBuyerOfferPriceID(this.buyerofferPrice.getBuyerOfferPriceID().longValue());
                    this.insertItems.add((Object)opd);
                    this.table.setItems(this.insertItems);
                    this.table.getSelectionModel().select((Object)opd);
                    this.table.scrollTo((Object)opd);
                    this.table.requestFocus();
                    this.filter();
                }
                this.clearFields();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                this.controller.alert("Upozorenje", "Nepravilan format cene: ", this.rootPane.getScene().getWindow());
            }
        } else {
            this.controller.alert("Upozorenje", "Morate odabrati artikal ", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionImport(ActionEvent e) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("title", "Unesite datum od kog \u0107e va\u017eiti cene.");
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import cenovnika");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje stavki u toku.", this.rootPane.getScene().getWindow());
            final ArrayList unexistedProducts = new ArrayList();
            Task<ArrayList<BuyerOfferPriceDetailes>> loadingCsvTask = new Task<ArrayList<BuyerOfferPriceDetailes>>(){

                protected ArrayList<BuyerOfferPriceDetailes> call() throws Exception {
                    String line = "";
                    String[] colNames = null;
                    int colBarcode = -1;
                    int colOfferPrice = -1;
                    int counterRow = 0;
                    ArrayList<BuyerOfferPriceDetailes> importedList = new ArrayList<BuyerOfferPriceDetailes>();
                    try {
                        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        while ((line = bf.readLine()) != null) {
                            colNames = line.split(";");
                            if (counterRow == 0) {
                                for (int i = 0; i < colNames.length; ++i) {
                                    if (colNames[i].trim().toLowerCase().equals("substitutecode") || colNames[i].trim().toLowerCase().toLowerCase().equals("barkod")) {
                                        colBarcode = i;
                                    }
                                    if (!colNames[i].trim().toLowerCase().equals("discount") && !colNames[i].trim().toLowerCase().toLowerCase().equals("akcijska_cena")) continue;
                                    colOfferPrice = i;
                                }
                            } else {
                                Product p = Product.getByBarcode((String)colNames[colBarcode], (Connection)BuyerOfferPriceListDetailesController.this.controller.getSettings().getConnection());
                                if (p != null) {
                                    BuyerOfferPriceDetailes opd = new BuyerOfferPriceDetailes();
                                    opd.setProduct(p);
                                    opd.setBuyerOfferPriceDetailsID(new Long(-1L).longValue());
                                    opd.setProductID(p.getProductID());
                                    opd.setPrice(colOfferPrice > -1 ? Double.parseDouble(colNames[colOfferPrice].replace(",", ".")) : 0.0);
                                    opd.setBuyerOfferPriceID(BuyerOfferPriceListDetailesController.this.buyerofferPrice.getBuyerOfferPriceID().longValue());
                                    importedList.add(opd);
                                } else {
                                    unexistedProducts.add(colNames[colBarcode]);
                                }
                            }
                            ++counterRow;
                        }
                        bf.close();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return importedList;
                }
            };
            loadingCsvTask.setOnSucceeded(arg_0 -> this.lambda$actionImport$1(taskUpdateStage, (Task)loadingCsvTask, unexistedProducts, arg_0));
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        }
    }

    @FXML
    public void productRemove(ActionEvent event) {
        if (((BuyerOfferPriceDetailes)this.table.getSelectionModel().getSelectedItem()).getBuyerOfferPriceDetailsID() != -1L) {
            this.deletedItems.add((BuyerOfferPriceDetailes)this.table.getSelectionModel().getSelectedItem());
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
    }

    @FXML
    public void close(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void save(ActionEvent event) {
        final ObservableList opdList = this.table.getItems();
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Upis detalja je u toku...", this.rootPane.getScene().getWindow());
        Task<Void> savingTask = new Task<Void>(){

            protected Void call() throws Exception {
                for (int i = 0; i < opdList.size(); ++i) {
                    if (((BuyerOfferPriceDetailes)opdList.get(i)).getBuyerOfferPriceDetailsID() < 0L) {
                        Long id = ((BuyerOfferPriceDetailes)opdList.get(i)).insert(BuyerOfferPriceListDetailesController.this.controller.getSettings().getConnection());
                        ((BuyerOfferPriceDetailes)opdList.get(i)).setBuyerOfferPriceDetailsID(id.longValue());
                    }
                    if (((BuyerOfferPriceDetailes)opdList.get(i)).getBuyerOfferPriceDetailsID() <= 0L) continue;
                    ((BuyerOfferPriceDetailes)opdList.get(i)).update(BuyerOfferPriceListDetailesController.this.controller);
                }
                if (!BuyerOfferPriceListDetailesController.this.deletedItems.isEmpty()) {
                    for (BuyerOfferPriceDetailes buyerOfferPriceDetailes : BuyerOfferPriceListDetailesController.this.deletedItems) {
                        buyerOfferPriceDetailes.delete(BuyerOfferPriceListDetailesController.this.controller);
                    }
                }
                return null;
            }
        };
        savingTask.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        });
        savingTask.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no upisivanje u bazu.", this.rootPane.getScene().getWindow());
        });
        savingTask.exceptionProperty().addListener((obs, old, newValue) -> {
            taskUpdateStage.hide();
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        new Thread((Runnable)savingTask).start();
    }

    public int checkIfProductExist(long productID) {
        for (int i = 0; i < this.table.getItems().size(); ++i) {
            if (((BuyerOfferPriceDetailes)this.table.getItems().get(i)).getProductID() != productID) continue;
            return i;
        }
        return -1;
    }

    public void clearFields() {
        this.cbProduct.getSelectionModel().clearSelection();
        this.cbProduct.getEditor().setText("");
        this.tfPrice.setText("");
        this.tfPriceWithoutVat.setText("");
        this.tfFilter.setText("");
    }

    private void filter() {
        this.data = this.insertItems;
        FilteredList filteredData = new FilteredList(this.data, p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(opd -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            if (opd.getProduct().getCode().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            if (opd.getProduct().getBarcode().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return opd.getProduct().getShortName().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
        this.table.setItems((ObservableList)sortedData);
    }

    private /* synthetic */ void lambda$actionImport$1(Stage taskUpdateStage, Task loadingCsvTask, ArrayList unexistedProducts, WorkerStateEvent eventValue) {
        taskUpdateStage.hide();
        for (BuyerOfferPriceDetailes pld : (ArrayList)loadingCsvTask.getValue()) {
            int existIndex = this.checkIfProductExist(pld.getProductID());
            if (existIndex >= 0) {
                ((BuyerOfferPriceDetailes)this.table.getItems().get(existIndex)).setPrice(pld.getPrice());
                this.table.refresh();
                continue;
            }
            this.table.getItems().add((Object)pld);
        }
        this.table.refresh();
        this.table.scrollTo(this.table.getItems().size() - 1);
        if (unexistedProducts.size() > 0) {
            this.controller.alert("Nepostoje\u0107i artikli", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
        }
    }
}

